/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.xmldb.DatabaseInstanceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class DOMTestJUnit
extends TestCase {
    private static String driver = "org.exist.xmldb.DatabaseImpl";
    private static String baseURI = "xmldb:exist:///db";
    private static String username = "admin";
    private static String password = "";
    private static String name = "test.xml";
    private Collection rootColl;
    private Database database;

    public DOMTestJUnit(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        System.out.println("Running setUp ...");
        System.setProperty("exist.initdb", "true");
        Class<?> dbc = Class.forName(driver);
        this.database = (Database)dbc.newInstance();
        DatabaseManager.registerDatabase((Database)this.database);
        this.rootColl = DatabaseManager.getCollection((String)baseURI, (String)"admin", (String)"");
        XMLResource r = (XMLResource)this.rootColl.createResource(name, "XMLResource");
        r.setContent((Object)"<properties><property key=\"type\">Table</property></properties>");
        this.rootColl.storeResource((Resource)r);
    }

    protected void tearDown() throws Exception {
        this.rootColl.removeResource(this.rootColl.getResource(name));
        DatabaseManager.deregisterDatabase((Database)this.database);
        DatabaseInstanceManager dim = (DatabaseInstanceManager)this.rootColl.getService("DatabaseInstanceManager", "1.0");
        dim.shutdown();
        System.out.println("tearDown PASSED");
    }

    public void testDOMUpdate() throws XMLDBException {
        XMLResource index = (XMLResource)this.rootColl.getResource(name);
        System.out.println("Retrieving initial content:");
        String content = (String)index.getContent();
        System.out.println(content);
        Node rootNode = index.getContentAsDOM();
        Document doc = rootNode.getOwnerDocument();
        Element schemaNode = doc.createElement("schema");
        schemaNode.setAttribute("targetNamespace", "targetNamespace");
        schemaNode.setAttribute("resourceName", "filename");
        rootNode.appendChild(schemaNode);
        index.setContentAsDOM(rootNode);
        this.rootColl.storeResource((Resource)index);
        System.out.println("Retrieving modified content:");
        index = (XMLResource)this.rootColl.getResource(name);
        String content2 = (String)index.getContent();
        System.out.println(content2);
        rootNode = index.getContentAsDOM();
        Element rootElem = (Element)rootNode;
        DOMTestJUnit.assertEquals((String)"One more element after update", (int)2, (int)rootElem.getChildNodes().getLength());
    }

    public static void main(String[] args) {
        TestRunner.run((Class)DOMTestJUnit.class);
    }
}

