/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.schema.RemoteSchemaService;
import org.exist.security.Permission;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.RemoteBinaryResource;
import org.exist.xmldb.RemoteCollectionManagementService;
import org.exist.xmldb.RemoteDatabaseInstanceManager;
import org.exist.xmldb.RemoteIndexQueryService;
import org.exist.xmldb.RemoteUserManagementService;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.RemoteXPathQueryService;
import org.exist.xmldb.RemoteXUpdateQueryService;
import org.exist.xmlrpc.RpcServer;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class RemoteCollection
implements CollectionImpl {
    private static final int MAX_CHUNK_LENGTH = 524288;
    private static final int MAX_UPLOAD_CHUNK = 0x100000;
    protected Map childCollections = null;
    protected String name;
    protected Permission permissions = null;
    protected RemoteCollection parent = null;
    protected XmlRpcClient rpcClient = null;
    protected Properties properties = null;

    public RemoteCollection(XmlRpcClient client, String collection) throws XMLDBException {
        this(client, null, collection);
    }

    public RemoteCollection(XmlRpcClient client, RemoteCollection parent, String collection) throws XMLDBException {
        this.parent = parent;
        this.name = collection;
        this.rpcClient = client;
    }

    protected void addChildCollection(Collection child) throws XMLDBException {
        if (this.childCollections == null) {
            this.readCollection();
        }
        this.childCollections.put(child.getName(), child);
    }

    public void close() throws XMLDBException {
        try {
            this.rpcClient.execute("sync", new Vector());
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
    }

    public String createId() throws XMLDBException {
        Vector<String> params = new Vector<String>(1);
        params.addElement(this.getPath());
        try {
            return (String)this.rpcClient.execute("createResourceId", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Resource createResource(String id, String type) throws XMLDBException {
        void var4_4;
        EXistResource r;
        String newId;
        String string = newId = id == null ? this.createId() : id;
        if (type.equals("XMLResource")) {
            r = new RemoteXMLResource(this, -1, -1, newId, null);
        } else if (type.equals("BinaryResource")) {
            r = new RemoteBinaryResource(this, newId);
        } else {
            throw new XMLDBException(302, "unknown resource type: " + type);
        }
        return var4_4;
    }

    public Collection getChildCollection(String name) throws XMLDBException {
        if (this.childCollections == null) {
            this.readCollection();
        }
        if (name.indexOf(47) > -1) {
            return (Collection)this.childCollections.get(name);
        }
        return (Collection)this.childCollections.get(this.getPath() + '/' + name);
    }

    public int getChildCollectionCount() throws XMLDBException {
        if (this.childCollections == null) {
            this.readCollection();
        }
        return this.childCollections.size();
    }

    protected XmlRpcClient getClient() {
        return this.rpcClient;
    }

    public String getName() throws XMLDBException {
        return this.name;
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.parent == null && !this.name.equals("/db")) {
            String parentName = this.name.substring(0, this.name.lastIndexOf(47));
            return new RemoteCollection(this.rpcClient, null, parentName);
        }
        return this.parent;
    }

    public String getPath() throws XMLDBException {
        if (this.parent == null) {
            if (this.name != null) {
                return this.name;
            }
            return "/db";
        }
        return this.name;
    }

    public String getProperty(String property) throws XMLDBException {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(property);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public int getResourceCount() throws XMLDBException {
        Vector<String> params = new Vector<String>(1);
        params.addElement(this.getPath());
        try {
            return (Integer)this.rpcClient.execute("getResourceCount", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, "failed to close collection", (Throwable)e);
        }
    }

    public Service getService(String name, String version) throws XMLDBException {
        if (name.equals("XPathQueryService")) {
            return new RemoteXPathQueryService(this);
        }
        if (name.equals("XQueryService")) {
            return new RemoteXPathQueryService(this);
        }
        if (name.equals("CollectionManagementService") || name.equals("CollectionManager")) {
            return new RemoteCollectionManagementService(this, this.rpcClient);
        }
        if (name.equals("UserManagementService")) {
            return new RemoteUserManagementService(this);
        }
        if (name.equals("DatabaseInstanceManager")) {
            return new RemoteDatabaseInstanceManager(this.rpcClient);
        }
        if (name.equals("IndexQueryService")) {
            return new RemoteIndexQueryService(this.rpcClient, this);
        }
        if (name.equals("XUpdateQueryService")) {
            return new RemoteXUpdateQueryService(this);
        }
        if (name.equals("SchemaService")) {
            return new RemoteSchemaService(this);
        }
        throw new XMLDBException(100);
    }

    public Service[] getServices() throws XMLDBException {
        Service[] services = new Service[]{new RemoteXPathQueryService(this), new RemoteCollectionManagementService(this, this.rpcClient), new RemoteUserManagementService(this), new RemoteDatabaseInstanceManager(this.rpcClient), new RemoteIndexQueryService(this.rpcClient, this), new RemoteXUpdateQueryService(this), new RemoteSchemaService(this)};
        return services;
    }

    protected boolean hasChildCollection(String name) throws XMLDBException {
        if (this.childCollections == null) {
            this.readCollection();
        }
        return this.childCollections.containsKey(name);
    }

    public boolean isOpen() throws XMLDBException {
        return true;
    }

    public String[] listChildCollections() throws XMLDBException {
        if (this.childCollections == null) {
            this.readCollection();
        }
        String[] coll = new String[this.childCollections.size()];
        int j = 0;
        Iterator i = this.childCollections.keySet().iterator();
        while (i.hasNext()) {
            coll[j] = (String)i.next();
            int p = coll[j].lastIndexOf(47);
            if (p > -1) {
                coll[j] = coll[j].substring(p + 1);
            }
            ++j;
        }
        return coll;
    }

    public String[] getChildCollections() throws XMLDBException {
        return this.listChildCollections();
    }

    public String[] listResources() throws XMLDBException {
        Vector<String> params = new Vector<String>();
        params.addElement(this.getPath());
        try {
            Vector vec = (Vector)this.rpcClient.execute("getDocumentListing", params);
            String[] resources = new String[vec.size()];
            return vec.toArray(resources);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(201, "an io error occurred", (Throwable)ioe);
        }
    }

    public String[] getResources() throws XMLDBException {
        return this.listResources();
    }

    public Resource getResource(String name) throws XMLDBException {
        Hashtable hash;
        Vector<String> params = new Vector<String>();
        params.addElement(this.getPath() + '/' + name);
        try {
            hash = (Hashtable)this.rpcClient.execute("describeResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(201, "an io error occurred", (Throwable)ioe);
        }
        String docName = (String)hash.get("name");
        if (docName == null) {
            return null;
        }
        int p = docName.lastIndexOf(47);
        if (p > -1) {
            docName = docName.substring(p + 1);
        }
        Permission perm = new Permission((String)hash.get("owner"), (String)hash.get("group"), (Integer)hash.get("permissions"));
        String type = (String)hash.get("type");
        int contentLen = 0;
        if (hash.containsKey("content-length")) {
            contentLen = (Integer)hash.get("content-length");
        }
        if (type == null || type.equals("XMLResource")) {
            RemoteXMLResource r = new RemoteXMLResource(this, -1, -1, docName, null);
            r.setPermissions(perm);
            r.setContentLength(contentLen);
            return r;
        }
        RemoteBinaryResource r = new RemoteBinaryResource(this, docName);
        r.setContentLength(contentLen);
        r.setPermissions(perm);
        return r;
    }

    private void readCollection() throws XMLDBException {
        Hashtable collection;
        this.childCollections = new HashMap();
        Vector<String> params = new Vector<String>();
        params.addElement(this.getPath());
        try {
            collection = (Hashtable)this.rpcClient.execute("describeCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(201, "an io error occurred", (Throwable)ioe);
        }
        Vector collections = (Vector)collection.get("collections");
        this.permissions = new Permission((String)collection.get("owner"), (String)collection.get("group"), (Integer)collection.get("permissions"));
        for (int i = 0; i < collections.size(); ++i) {
            String childName = (String)collections.elementAt(i);
            try {
                RemoteCollection child = new RemoteCollection(this.rpcClient, this, this.getPath() + '/' + childName);
                this.addChildCollection(child);
                continue;
            }
            catch (XMLDBException e) {
                // empty catch block
            }
        }
    }

    public void registerService(Service serv) throws XMLDBException {
        throw new XMLDBException(2);
    }

    public void removeChildCollection(String name) throws XMLDBException {
        if (this.childCollections == null) {
            this.readCollection();
        }
        this.childCollections.remove(this.getPath() + '/' + name);
    }

    public void removeResource(Resource res) throws XMLDBException {
        Vector<String> params = new Vector<String>();
        params.addElement(this.getPath() + '/' + res.getId());
        System.out.println("Removing " + params.elementAt(0));
        try {
            this.rpcClient.execute("remove", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public Date getCreationTime() throws XMLDBException {
        Vector<String> params = new Vector<String>(1);
        params.addElement(this.getPath());
        try {
            return (Date)this.rpcClient.execute("getCreationDate", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public void setProperty(String property, String value) throws XMLDBException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(property, value);
    }

    public void storeResource(Resource res) throws XMLDBException {
        Object content = res.getContent();
        if (content instanceof File) {
            File file = (File)content;
            if (!file.canRead()) {
                throw new XMLDBException(301, "failed to read resource from file " + file.getAbsolutePath());
            }
            if (file.length() < 524288L) {
                this.store((RemoteXMLResource)res);
            } else {
                this.uploadAndStore(res);
            }
        } else if (res.getResourceType().equals("BinaryResource")) {
            this.store((RemoteBinaryResource)res);
        } else {
            this.store((RemoteXMLResource)res);
        }
    }

    private void store(RemoteXMLResource res) throws XMLDBException {
        byte[] data = res.getData();
        Vector<Object> params = new Vector<Object>();
        params.addElement(data);
        params.addElement(this.getPath() + '/' + res.getId());
        params.addElement(new Integer(1));
        try {
            this.rpcClient.execute("parse", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre == null ? "unknown error" : xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    private void store(RemoteBinaryResource res) throws XMLDBException {
        byte[] data = (byte[])res.getContent();
        Vector<Object> params = new Vector<Object>();
        params.addElement(data);
        params.addElement(this.getPath() + '/' + res.getId());
        params.addElement(Boolean.TRUE);
        try {
            this.rpcClient.execute("storeBinary", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(0, xre == null ? "unknown error" : xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    private void uploadAndStore(Resource res) throws XMLDBException {
        File file = (File)res.getContent();
        byte[] chunk = new byte[0x100000];
        try {
            Vector<Object> params;
            int len;
            FileInputStream is = new FileInputStream(file);
            String fileName = null;
            while ((len = is.read(chunk)) > -1) {
                byte[] compressed = RpcServer.compress(chunk, len);
                params = new Vector();
                if (fileName != null) {
                    params.addElement(fileName);
                }
                params.addElement(compressed);
                params.addElement(new Integer(len));
                fileName = (String)this.rpcClient.execute("uploadCompressed", params);
            }
            params = new Vector<Object>();
            params.addElement(fileName);
            params.addElement(this.getPath() + '/' + res.getId());
            params.addElement(Boolean.TRUE);
            this.rpcClient.execute("parseLocal", params);
        }
        catch (FileNotFoundException e) {
            throw new XMLDBException(301, "could not read resource from file " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(301, "failed to read resource from file " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "networking error", (Throwable)e);
        }
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public boolean isRemoteCollection() throws XMLDBException {
        return true;
    }
}

