/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class MapResourceSet
implements ResourceSet {
    protected Map resources = new HashMap();
    protected Vector resourcesVector = new Vector();

    public MapResourceSet() {
    }

    public MapResourceSet(Map resources) {
        this.resources = resources;
        Iterator iter = resources.values().iterator();
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            this.resourcesVector.add(res);
        }
    }

    public MapResourceSet(ResourceSet rs) throws XMLDBException {
        int i = 0;
        while ((long)i < rs.getSize()) {
            Resource res = rs.getResource((long)i);
            this.resources.put(res.getId(), res);
            this.resourcesVector.add(rs.getResource((long)i));
            ++i;
        }
    }

    public Map getResourcesMap() {
        return this.resources;
    }

    public void addResource(Resource resource) throws XMLDBException {
        this.resources.put(resource.getId(), resource);
        this.resourcesVector.addElement(resource);
    }

    public void clear() throws XMLDBException {
        this.resources.clear();
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        throw new XMLDBException(2);
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos < 0L || pos >= (long)this.resources.size()) {
            return null;
        }
        Object r = this.resourcesVector.get((int)pos);
        if (r instanceof Resource) {
            return (Resource)r;
        }
        return null;
    }

    public long getSize() throws XMLDBException {
        return this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        Resource r = (Resource)this.resourcesVector.get((int)pos);
        this.resourcesVector.removeElementAt((int)pos);
        this.resources.remove(r.getId());
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return this.pos < (long)MapResourceSet.this.resources.size();
        }

        public Resource nextResource() throws XMLDBException {
            return MapResourceSet.this.getResource(this.pos++);
        }
    }
}

