/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.schema.LocalSchemaService;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.LocalBinaryResource;
import org.exist.xmldb.LocalCollectionManagementService;
import org.exist.xmldb.LocalDatabaseInstanceManager;
import org.exist.xmldb.LocalIndexQueryService;
import org.exist.xmldb.LocalUserManagementService;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.LocalXPathQueryService;
import org.exist.xmldb.LocalXUpdateQueryService;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class LocalCollection
extends Observable
implements CollectionImpl {
    private static Logger LOG = Logger.getLogger((String)LocalCollection.class.getName());
    protected static final Properties defaultProperties = new Properties();
    protected String path = null;
    protected BrokerPool brokerPool = null;
    protected Properties properties = new Properties(defaultProperties);
    protected LocalCollection parent = null;
    protected User user = null;
    protected ArrayList observers = new ArrayList(1);
    protected boolean needsSync = false;
    private XMLReader userReader = null;

    public LocalCollection(User user, BrokerPool brokerPool, String collection) throws XMLDBException {
        this(user, brokerPool, null, collection);
    }

    public LocalCollection(User user, BrokerPool brokerPool, LocalCollection parent, String name) throws XMLDBException {
        if (user == null) {
            user = new User("guest", "guest", "guest");
        }
        this.user = user;
        this.parent = parent;
        this.brokerPool = brokerPool;
        this.path = name;
        if (this.path == null) {
            this.path = "/db";
        }
        this.getCollection();
    }

    protected Collection getCollectionWithLock(int lockMode) throws XMLDBException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, lockMode);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            collection.setReader(this.userReader);
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return collection;
    }

    protected void saveCollection() throws XMLDBException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                collection = broker.openCollection(this.path, 1);
                if (collection == null) {
                    throw new XMLDBException(201, "Collection " + this.path + " not found");
                }
                broker.saveCollection(collection);
            }
            catch (EXistException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
            catch (PermissionDeniedException e) {
                throw new XMLDBException(4, e.getMessage(), (Throwable)e);
            }
            Object var5_3 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    protected Collection getCollection() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            Collection collection = broker.getCollection(this.path);
            if (collection == null) {
                throw new XMLDBException(200, "Collection " + this.path + " not found");
            }
            collection.setReader(this.userReader);
            Collection collection2 = collection;
            return collection2;
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    protected boolean checkOwner(Collection collection, User user) throws XMLDBException {
        return user.getName().equals(collection.getPermissions().getOwner());
    }

    protected boolean checkPermissions(Collection collection, int perm) throws XMLDBException {
        return collection.getPermissions().validate(this.user, perm);
    }

    public void close() throws XMLDBException {
        if (this.needsSync) {
            DBBroker broker = null;
            try {
                broker = this.brokerPool.get(this.user);
                broker.sync(1);
            }
            catch (EXistException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
            finally {
                this.brokerPool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            String id;
            boolean ok;
            Random rand = new Random();
            do {
                ok = true;
                id = Integer.toHexString(rand.nextInt()) + ".xml";
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id;
            return string;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    public Resource createResource(String id, String type) throws XMLDBException {
        if (id == null) {
            id = this.createId();
        }
        AbstractEXistResource r = null;
        if (type.equals("XMLResource")) {
            r = new LocalXMLResource(this.user, this.brokerPool, this, id, -1L);
        } else if (type.equals("BinaryResource")) {
            r = new LocalBinaryResource(this.user, this.brokerPool, this, id);
        } else {
            throw new XMLDBException(301, "unknown resource type: " + type);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.xmldb.api.base.Collection getChildCollection(String name) throws XMLDBException {
        String childName = null;
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (!this.checkPermissions(collection, 4)) {
                throw new XMLDBException(4, "You are not allowed to access this collection");
            }
            if (collection.hasChildCollection(name)) {
                childName = this.getPath() + '/' + name;
            }
        }
        finally {
            collection.release();
        }
        if (childName != null) {
            return new LocalCollection(this.user, this.brokerPool, this, childName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCollectionCount() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (this.checkPermissions(collection, 4)) {
                int n = collection.getChildCollectionCount();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            String string = collection.getName();
            return string;
        }
        finally {
            collection.release();
        }
    }

    public org.xmldb.api.base.Collection getParentCollection() throws XMLDBException {
        if (this.getName().equals("/db")) {
            return null;
        }
        if (this.parent == null) {
            DBBroker broker = null;
            Collection collection = null;
            try {
                try {
                    broker = this.brokerPool.get(this.user);
                    collection = broker.openCollection(this.path, 0);
                    if (collection == null) {
                        throw new XMLDBException(201, "Collection " + this.path + " not found");
                    }
                    this.parent = new LocalCollection(this.user, this.brokerPool, null, collection.getParentPath());
                }
                catch (EXistException e) {
                    throw new XMLDBException(0, "error while retrieving parent collection: " + e.getMessage(), (Throwable)e);
                }
                Object var5_3 = null;
                if (collection != null) {
                    collection.getLock().release(0);
                }
                this.brokerPool.release(broker);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (collection != null) {
                    collection.getLock().release(0);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
        return this.parent;
    }

    public String getPath() throws XMLDBException {
        return this.path;
    }

    public String getProperty(String property) throws XMLDBException {
        return this.properties.getProperty(property);
    }

    /*
     * WARNING - void declaration
     */
    public Resource getResource(String id) throws XMLDBException {
        DocumentImpl document;
        DBBroker broker;
        Collection collection;
        block14: {
            collection = null;
            broker = null;
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, 0);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            if (!this.checkPermissions(collection, 4)) {
                throw new XMLDBException(4, "not allowed to read collection");
            }
            document = collection.getDocument(broker, id);
            if (document != null) break block14;
            LOG.warn((Object)("Resource " + id + " not found"));
            Resource resource = null;
            Object var8_8 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return resource;
        }
        try {
            void var5_7;
            AbstractEXistResource r;
            if (document.getResourceType() == 0) {
                r = new LocalXMLResource(this.user, this.brokerPool, this, id, -1L);
            } else if (document.getResourceType() == 1) {
                r = new LocalBinaryResource(this.user, this.brokerPool, this, id);
            } else {
                throw new XMLDBException(301, "unknown resource type");
            }
            void var6_11 = var5_7;
            Object var8_9 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return var6_11;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(0, "error while retrieving resource: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (collection != null) {
                    collection.release();
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceCount() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (!this.checkPermissions(collection, 4)) {
                int n = 0;
                return n;
            }
            int n = collection.getDocumentCount();
            return n;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    public Service getService(String name, String version) throws XMLDBException {
        if (name.equals("XPathQueryService")) {
            return new LocalXPathQueryService(this.user, this.brokerPool, this);
        }
        if (name.equals("XQueryService")) {
            return new LocalXPathQueryService(this.user, this.brokerPool, this);
        }
        if (name.equals("CollectionManagementService") || name.equals("CollectionManager")) {
            return new LocalCollectionManagementService(this.user, this.brokerPool, this);
        }
        if (name.equals("UserManagementService")) {
            return new LocalUserManagementService(this.user, this.brokerPool, this);
        }
        if (name.equals("DatabaseInstanceManager")) {
            return new LocalDatabaseInstanceManager(this.user, this.brokerPool);
        }
        if (name.equals("XUpdateQueryService")) {
            return new LocalXUpdateQueryService(this.user, this.brokerPool, this);
        }
        if (name.equals("IndexQueryService")) {
            return new LocalIndexQueryService(this.user, this.brokerPool, this);
        }
        if (name.equals("SchemaService")) {
            return new LocalSchemaService(this.user, this.brokerPool, this);
        }
        throw new XMLDBException(100);
    }

    public Service[] getServices() throws XMLDBException {
        Service[] services = new Service[]{new LocalXPathQueryService(this.user, this.brokerPool, this), new LocalCollectionManagementService(this.user, this.brokerPool, this), new LocalUserManagementService(this.user, this.brokerPool, this), new LocalDatabaseInstanceManager(this.user, this.brokerPool), new LocalXUpdateQueryService(this.user, this.brokerPool, this), new LocalIndexQueryService(this.user, this.brokerPool, this), new LocalSchemaService(this.user, this.brokerPool, this)};
        return services;
    }

    public boolean isOpen() throws XMLDBException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listChildCollections() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (!this.checkPermissions(collection, 4)) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] collections = new String[collection.getChildCollectionCount()];
            int j = 0;
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                collections[j] = (String)i.next();
                ++j;
            }
            String[] stringArray = collections;
            return stringArray;
        }
        finally {
            collection.release();
        }
    }

    public String[] getChildCollections() throws XMLDBException {
        return this.listChildCollections();
    }

    public String[] listResources() throws XMLDBException {
        DBBroker broker;
        Collection collection;
        block10: {
            collection = null;
            broker = null;
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, 0);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            if (this.checkPermissions(collection, 4)) break block10;
            String[] stringArray = new String[]{};
            Object var10_6 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return stringArray;
        }
        try {
            String[] resources = new String[collection.getDocumentCount()];
            int j = 0;
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                resources[j] = doc.getFileName();
                ++j;
            }
            String[] stringArray = resources;
            Object var10_7 = null;
            if (collection != null) {
                collection.release();
            }
            this.brokerPool.release(broker);
            return stringArray;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(0, "error while retrieving resource: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (collection != null) {
                    collection.release();
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    public String[] getResources() throws XMLDBException {
        return this.listResources();
    }

    public void registerService(Service serv) throws XMLDBException {
        throw new XMLDBException(2);
    }

    public void removeResource(Resource res) throws XMLDBException {
        if (res == null) {
            return;
        }
        Collection collection = null;
        DBBroker broker = null;
        try {
            block13: {
                try {
                    String name = res.getId();
                    LOG.debug((Object)("removing " + name));
                    broker = this.brokerPool.get(this.user);
                    collection = broker.openCollection(this.path, 0);
                    if (collection == null) {
                        throw new XMLDBException(201, "Collection " + this.path + " not found");
                    }
                    DocumentImpl doc = collection.getDocument(broker, name);
                    if (doc == null) {
                        throw new XMLDBException(301, "resource " + name + " not found");
                    }
                    if (res.getResourceType().equals("XMLResource")) {
                        collection.removeDocument(broker, name);
                        break block13;
                    }
                    collection.removeBinaryResource(broker, name);
                }
                catch (EXistException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                catch (PermissionDeniedException e) {
                    throw new XMLDBException(4, e.getMessage(), (Throwable)e);
                }
                catch (TriggerException e) {
                    throw new XMLDBException(301, e.getMessage(), (Throwable)e);
                }
                catch (LockException e) {
                    throw new XMLDBException(1, "Failed to acquire lock on collections.dbx", (Throwable)e);
                }
            }
            Object var7_10 = null;
            if (collection != null) {
                collection.getLock().release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (collection != null) {
                collection.getLock().release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
        this.needsSync = true;
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.properties.setProperty(property, value);
    }

    public void storeResource(Resource resource) throws XMLDBException {
        if (resource.getResourceType().equals("XMLResource")) {
            LOG.debug((Object)("storing document " + resource.getId()));
            this.storeXMLResource((LocalXMLResource)resource);
        } else if (resource.getResourceType().equals("BinaryResource")) {
            LOG.debug((Object)("storing binary resource " + resource.getId()));
            this.storeBinaryResource((LocalBinaryResource)resource);
        } else {
            throw new XMLDBException(302, "unknown resource type: " + resource.getResourceType());
        }
        this.needsSync = true;
    }

    private void storeBinaryResource(LocalBinaryResource res) throws XMLDBException {
        Collection collection = null;
        DBBroker broker = null;
        try {
            try {
                broker = this.brokerPool.get(this.user);
                collection = broker.openCollection(this.path, 1);
                if (collection == null) {
                    throw new XMLDBException(201, "Collection " + this.path + " not found");
                }
                BinaryDocument blob = collection.addBinaryResource(broker, res.getId(), (byte[])res.getContent());
            }
            catch (Exception e) {
                throw new XMLDBException(1, "Exception while storing binary resource: " + e.getMessage(), (Throwable)e);
            }
            Object var6_6 = null;
            if (collection != null) {
                collection.getLock().release();
            }
            this.brokerPool.release(broker);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (collection != null) {
                collection.getLock().release();
            }
            this.brokerPool.release(broker);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeXMLResource(LocalXMLResource res) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            String name = res.getDocumentId();
            String uri = null;
            if (res.file != null) {
                uri = res.file.toURI().toASCIIString();
            }
            Collection collection = broker.openCollection(this.path, 1);
            IndexInfo info = null;
            try {
                if (collection == null) {
                    throw new XMLDBException(201, "Collection " + this.path + " not found");
                }
                Iterator i = this.observers.iterator();
                while (i.hasNext()) {
                    Observer observer = (Observer)i.next();
                    collection.addObserver(observer);
                }
                info = uri != null ? collection.validate(broker, name, new InputSource(uri)) : (res.root != null ? collection.validate(broker, name, res.root) : collection.validate(broker, name, res.content));
            }
            finally {
                collection.release();
            }
            if (uri != null) {
                collection.store(broker, info, new InputSource(uri), false);
            } else if (res.root != null) {
                collection.store(broker, info, res.root, false);
            } else {
                collection.store(broker, info, res.content, false);
            }
            collection.deleteObservers();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreationTime() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            Date date = new Date(collection.getCreationTime());
            return date;
        }
        finally {
            collection.getLock().release();
        }
    }

    public void addObserver(Observer o) {
        if (!this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public boolean isRemoteCollection() throws XMLDBException {
        return false;
    }

    public void setReader(XMLReader reader) {
        this.userReader = reader;
    }

    static {
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("expand-xincludes", "yes");
        defaultProperties.setProperty("process-xsl-pi", "no");
    }
}

