/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import org.exist.dom.QName;

public class AttrList {
    protected QName[] names = new QName[4];
    protected String[] values = new String[4];
    protected int size = 0;

    public void addAttribute(QName name, String value) {
        this.ensureCapacity();
        this.names[this.size] = name;
        this.values[this.size] = value;
        ++this.size;
    }

    public int getLength() {
        return this.size;
    }

    public QName getQName(int pos) {
        return this.names[pos];
    }

    public String getValue(int pos) {
        return this.values[pos];
    }

    public String getValue(QName name) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].equals(name)) continue;
            return this.values[i];
        }
        return null;
    }

    private void ensureCapacity() {
        if (this.size == this.names.length) {
            int newSize = this.names.length * 3 / 2;
            QName[] tnames = new QName[newSize];
            System.arraycopy(this.names, 0, tnames, 0, this.names.length);
            String[] tvalues = new String[newSize];
            System.arraycopy(this.values, 0, tvalues, 0, this.values.length);
            this.names = tnames;
            this.values = tvalues;
        }
    }
}

