/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLReaderObjectFactory
extends BasePoolableObjectFactory {
    private static final int VALIDATION_ENABLED = 0;
    private static final int VALIDATION_AUTO = 1;
    private static final int VALIDATION_DISABLED = 2;
    private BrokerPool pool;

    public XMLReaderObjectFactory(BrokerPool pool) {
        this.pool = pool;
    }

    public Object makeObject() throws Exception {
        Configuration config = this.pool.getConfiguration();
        int validation = 1;
        String option = (String)config.getProperty("indexer.validation");
        if (option != null) {
            validation = option.equals("true") ? 0 : (option.equals("auto") ? 1 : 2);
        }
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        if (validation == 1 || validation == 0) {
            saxFactory.setValidating(true);
        } else {
            saxFactory.setValidating(false);
        }
        saxFactory.setNamespaceAware(true);
        try {
            saxFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            try {
                saxFactory.setFeature("http://apache.org/xml/features/validation/dynamic", validation == 1);
                saxFactory.setFeature("http://apache.org/xml/features/validation/schema", validation == 1 || validation == 0);
            }
            catch (SAXNotRecognizedException e1) {
            }
            catch (SAXNotSupportedException e1) {
                // empty catch block
            }
            SAXParser sax = saxFactory.newSAXParser();
            XMLReader parser = sax.getXMLReader();
            return parser;
        }
        catch (ParserConfigurationException e) {
            throw new EXistException(e);
        }
    }
}

