/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class XMLFilenameFilter
implements FilenameFilter {
    protected static String[] extensions = new String[]{"xml", "xsp", "xsl", "rdf"};
    protected String pathSep;
    protected Pattern pattern;
    protected PatternMatcher matcher = new Perl5Matcher();

    public static void setExtensions(String[] extensionList) {
        extensions = extensionList;
    }

    public XMLFilenameFilter() {
        this.pathSep = System.getProperty("file.separator", "/");
    }

    public XMLFilenameFilter(String regexp) throws MalformedPatternException {
        Perl5Compiler compiler = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        this.pattern = compiler.compile(regexp);
    }

    public boolean accept(File dir, String name) {
        if (this.pattern == null) {
            for (int i = 0; i < extensions.length; ++i) {
                if (!name.endsWith("." + extensions[i])) continue;
                return true;
            }
        } else {
            return this.matcher.matches(name, this.pattern);
        }
        return false;
    }
}

