/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.util.Lock;
import org.exist.util.LockException;

public class MultiReadReentrantLock
implements Lock {
    private static final Logger log = Logger.getLogger((Class)MultiReadReentrantLock.class);
    private int waitingForReadLock = 0;
    private int outstandingReadLocks = 0;
    private Thread writeLockedThread;
    private int outstandingWriteLocks = 0;
    private List waitingForWriteLock = null;

    public boolean acquire() throws LockException {
        return this.acquire(0);
    }

    public boolean acquire(int mode) throws LockException {
        switch (mode) {
            case 1: {
                return this.writeLock();
            }
        }
        return this.readLock();
    }

    public boolean attempt(int mode) {
        throw new RuntimeException("Not implemented");
    }

    private synchronized boolean readLock() throws LockException {
        if (this.writeLockedThread == Thread.currentThread()) {
            ++this.outstandingReadLocks;
            return true;
        }
        ++this.waitingForReadLock;
        while (this.writeLockedThread != null) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                throw new LockException("Interrupted while waiting for read lock");
            }
        }
        --this.waitingForReadLock;
        ++this.outstandingReadLocks;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLock() throws LockException {
        Thread thisThread = Thread.currentThread();
        Object object = this;
        synchronized (object) {
            if (this.writeLockedThread == null && this.outstandingReadLocks == 0) {
                this.writeLockedThread = Thread.currentThread();
                ++this.outstandingWriteLocks;
                return true;
            }
            if (this.waitingForWriteLock == null) {
                this.waitingForWriteLock = new ArrayList(3);
            }
            this.waitingForWriteLock.add(thisThread);
        }
        object = thisThread;
        synchronized (object) {
            while (thisThread != this.writeLockedThread) {
                try {
                    thisThread.wait();
                }
                catch (InterruptedException e) {
                    throw new LockException("Interrupted");
                }
            }
            ++this.outstandingWriteLocks;
        }
        object = this;
        synchronized (object) {
            int i = this.waitingForWriteLock.indexOf(thisThread);
            this.waitingForWriteLock.remove(i);
        }
        return true;
    }

    public void release() {
        this.release(0);
    }

    public void release(int mode) {
        switch (mode) {
            case 1: {
                this.releaseWrite();
                break;
            }
            default: {
                this.releaseRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseWrite() {
        if (Thread.currentThread() == this.writeLockedThread) {
            if (this.outstandingWriteLocks > 0) {
                --this.outstandingWriteLocks;
            }
            if (this.outstandingWriteLocks > 0) {
                return;
            }
            if (this.outstandingReadLocks == 0 && this.waitingForWriteLock != null && this.waitingForWriteLock.size() > 0) {
                Thread thread = this.writeLockedThread = (Thread)this.waitingForWriteLock.get(0);
                synchronized (thread) {
                    this.writeLockedThread.notify();
                }
            } else {
                this.writeLockedThread = null;
                if (this.waitingForReadLock > 0) {
                    this.notifyAll();
                }
            }
        } else {
            log.warn((Object)"Illegal lock usage: thread does not hold the write lock");
            throw new IllegalStateException("Thread does not have lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseRead() {
        if (this.outstandingReadLocks > 0) {
            --this.outstandingReadLocks;
            if (this.outstandingReadLocks == 0 && this.writeLockedThread == null && this.waitingForWriteLock != null && this.waitingForWriteLock.size() > 0) {
                Thread thread = this.writeLockedThread = (Thread)this.waitingForWriteLock.get(0);
                synchronized (thread) {
                    this.writeLockedThread.notifyAll();
                }
            }
            return;
        }
        throw new IllegalStateException("Attempt to release a non-existing read lock.");
    }

    public synchronized boolean isLockedForWrite() {
        return this.writeLockedThread != null || this.waitingForWriteLock != null && this.waitingForWriteLock.size() > 0;
    }
}

