/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.apache.xml.utils.XMLCharacterRecognizer;

public class FastStringBuffer
implements CharSequence {
    static final int DEBUG_FORCE_INIT_BITS = 0;
    static boolean DEBUG_FORCE_FIXED_CHUNKSIZE = true;
    public static final int SUPPRESS_LEADING_WS = 1;
    public static final int SUPPRESS_TRAILING_WS = 2;
    public static final int SUPPRESS_BOTH = 3;
    private static final int CARRY_WS = 4;
    int m_chunkBits = 15;
    int m_maxChunkBits = 15;
    int m_rebundleBits = 2;
    int m_chunkSize;
    int m_chunkMask;
    char[][] m_array;
    int m_lastChunk = 0;
    int m_firstFree = 0;
    FastStringBuffer m_innerFSB = null;
    private StringBuffer tempBuf = new StringBuffer();

    public FastStringBuffer(int initChunkBits, int maxChunkBits, int rebundleBits) {
        if (DEBUG_FORCE_FIXED_CHUNKSIZE) {
            maxChunkBits = initChunkBits;
        }
        this.m_array = new char[16][];
        if (initChunkBits > maxChunkBits) {
            initChunkBits = maxChunkBits;
        }
        this.m_chunkBits = initChunkBits;
        this.m_maxChunkBits = maxChunkBits;
        this.m_rebundleBits = rebundleBits;
        this.m_chunkSize = 1 << initChunkBits;
        this.m_chunkMask = this.m_chunkSize - 1;
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public FastStringBuffer(int initChunkBits, int maxChunkBits) {
        this(initChunkBits, maxChunkBits, 2);
    }

    public FastStringBuffer(int initChunkBits) {
        this(initChunkBits, 15, 2);
    }

    public FastStringBuffer() {
        this(10, 15, 2);
    }

    public final int size() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final int length() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final void reset() {
        this.m_lastChunk = 0;
        this.m_firstFree = 0;
        FastStringBuffer innermost = this;
        while (innermost.m_innerFSB != null) {
            innermost = innermost.m_innerFSB;
        }
        this.m_chunkBits = innermost.m_chunkBits;
        this.m_chunkSize = innermost.m_chunkSize;
        this.m_chunkMask = innermost.m_chunkMask;
        this.m_innerFSB = null;
        this.m_array = new char[16][0];
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public final void setLength(int l) {
        this.m_lastChunk = l >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(l, this);
        } else {
            this.m_firstFree = l & this.m_chunkMask;
            if (this.m_firstFree == 0 && this.m_lastChunk > 0) {
                --this.m_lastChunk;
                this.m_firstFree = this.m_chunkSize;
            }
        }
    }

    private final void setLength(int l, FastStringBuffer rootFSB) {
        this.m_lastChunk = l >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(l, rootFSB);
        } else {
            rootFSB.m_chunkBits = this.m_chunkBits;
            rootFSB.m_maxChunkBits = this.m_maxChunkBits;
            rootFSB.m_rebundleBits = this.m_rebundleBits;
            rootFSB.m_chunkSize = this.m_chunkSize;
            rootFSB.m_chunkMask = this.m_chunkMask;
            rootFSB.m_array = this.m_array;
            rootFSB.m_innerFSB = this.m_innerFSB;
            rootFSB.m_lastChunk = this.m_lastChunk;
            rootFSB.m_firstFree = l & this.m_chunkMask;
        }
    }

    public final String toString() {
        int length = (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
        this.tempBuf.setLength(0);
        return this.getString(this.tempBuf, 0, 0, length).toString();
    }

    public final void append(char value) {
        char[] chunk;
        boolean lastchunk;
        boolean bl = lastchunk = this.m_lastChunk + 1 == this.m_array.length;
        if (this.m_firstFree < this.m_chunkSize) {
            chunk = this.m_array[this.m_lastChunk];
        } else {
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            this.m_firstFree = 0;
        }
        chunk[this.m_firstFree++] = value;
    }

    public final void append(String value) {
        if (value == null) {
            return;
        }
        int strlen = value.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            value.getChars(copyfrom, copyfrom + available, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(StringBuffer value) {
        if (value == null) {
            return;
        }
        int strlen = value.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            value.getChars(copyfrom, copyfrom + available, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(char[] chars, int start, int length) {
        int strlen = length;
        if (0 == strlen) {
            return;
        }
        int copyfrom = start;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            System.arraycopy(chars, copyfrom, this.m_array[this.m_lastChunk], this.m_firstFree, available);
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public final void append(FastStringBuffer value) {
        if (value == null) {
            return;
        }
        int strlen = value.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available > strlen) {
                available = strlen;
            }
            int sourcechunk = copyfrom + value.m_chunkSize - 1 >>> value.m_chunkBits;
            int sourcecolumn = copyfrom & value.m_chunkMask;
            int runlength = value.m_chunkSize - sourcecolumn;
            if (runlength > available) {
                runlength = available;
            }
            System.arraycopy(value.m_array[sourcechunk], sourcecolumn, this.m_array[this.m_lastChunk], this.m_firstFree, runlength);
            if (runlength != available) {
                System.arraycopy(value.m_array[sourcechunk + 1], 0, this.m_array[this.m_lastChunk], this.m_firstFree + runlength, available - runlength);
            }
            copyfrom += available;
            if ((strlen -= available) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available;
    }

    public boolean isWhitespace(int start, int length) {
        int sourcechunk = start >>> this.m_chunkBits;
        int sourcecolumn = start & this.m_chunkMask;
        int available = this.m_chunkSize - sourcecolumn;
        while (length > 0) {
            int runlength = length <= available ? length : available;
            boolean chunkOK = sourcechunk == 0 && this.m_innerFSB != null ? this.m_innerFSB.isWhitespace(sourcecolumn, runlength) : XMLCharacterRecognizer.isWhiteSpace((char[])this.m_array[sourcechunk], (int)sourcecolumn, (int)runlength);
            if (!chunkOK) {
                return false;
            }
            length -= runlength;
            ++sourcechunk;
            sourcecolumn = 0;
            available = this.m_chunkSize;
        }
        return true;
    }

    public String getString(int start, int length) {
        this.tempBuf.setLength(0);
        return this.getString(this.tempBuf, start >>> this.m_chunkBits, start & this.m_chunkMask, length).toString();
    }

    public StringBuffer getString() {
        this.tempBuf.setLength(0);
        return this.getString(this.tempBuf);
    }

    public StringBuffer getString(StringBuffer buf) {
        for (int i = 0; i < this.m_lastChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.getString(buf);
                continue;
            }
            buf.append(this.m_array[i], 0, this.m_chunkSize);
        }
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.getString(buf);
        } else {
            buf.append(this.m_array[this.m_lastChunk], 0, this.m_firstFree);
        }
        return buf;
    }

    public void copyTo(char[] newBuf, int offset) {
        int pos = offset;
        for (int i = 0; i < this.m_lastChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.copyTo(newBuf, pos);
            } else {
                System.arraycopy(this.m_array[i], 0, newBuf, pos, this.m_chunkSize);
            }
            pos += this.m_chunkSize;
        }
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.copyTo(newBuf, pos);
        } else {
            System.arraycopy(this.m_array[this.m_lastChunk], 0, newBuf, pos, this.m_firstFree);
        }
    }

    public static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public String getNormalizedString(int mode) {
        this.tempBuf.setLength(0);
        return this.getNormalizedString(this.tempBuf, mode).toString();
    }

    public StringBuffer getNormalizedString(StringBuffer sb, int mode) {
        int end;
        if ((mode & 2) != 0) {
            for (end = this.m_firstFree - 1; end > 0 && FastStringBuffer.isWhiteSpace(this.m_array[this.m_lastChunk][end]); --end) {
            }
        }
        boolean pos = false;
        for (int i = 0; i < this.m_lastChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.getNormalizedString(sb, mode);
                continue;
            }
            if (i == 0 && (mode & 1) != 0) {
                int j;
                for (j = 0; j < this.m_chunkSize && FastStringBuffer.isWhiteSpace(this.m_array[i][j]); ++j) {
                }
                sb.append(this.m_array[i], j, this.m_chunkSize - j);
                continue;
            }
            sb.append(this.m_array[i], 0, this.m_chunkSize);
        }
        if (this.m_lastChunk == 0) {
            if (this.m_innerFSB != null) {
                this.m_innerFSB.getNormalizedString(sb, mode);
            } else if ((mode & 1) != 0) {
                int j;
                for (j = 0; FastStringBuffer.isWhiteSpace(this.m_array[this.m_lastChunk][j]) && j <= end; ++j) {
                }
                sb.append(this.m_array[this.m_lastChunk], j, end - j + 1);
            } else {
                sb.append(this.m_array[this.m_lastChunk], 0, end + 1);
            }
        } else {
            sb.append(this.m_array[this.m_lastChunk], 0, end + 1);
        }
        return sb;
    }

    StringBuffer getString(StringBuffer sb, int start, int length) {
        return this.getString(sb, start >>> this.m_chunkBits, start & this.m_chunkMask, length);
    }

    StringBuffer getString(StringBuffer sb, int startChunk, int startColumn, int length) {
        int stop = (startChunk << this.m_chunkBits) + startColumn + length;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.getString(sb, startColumn, this.m_chunkSize - startColumn);
            } else {
                sb.append(this.m_array[i], startColumn, this.m_chunkSize - startColumn);
            }
            startColumn = 0;
        }
        if (stopChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.getString(sb, startColumn, stopColumn - startColumn);
        } else if (stopColumn > startColumn) {
            sb.append(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
        return sb;
    }

    public char charAt(int pos) {
        int startChunk = pos >>> this.m_chunkBits;
        if (startChunk == 0 && this.m_innerFSB != null) {
            return this.m_innerFSB.charAt(pos & this.m_chunkMask);
        }
        return this.m_array[startChunk][pos & this.m_chunkMask];
    }

    private FastStringBuffer(FastStringBuffer source) {
        this.m_chunkBits = source.m_chunkBits;
        this.m_maxChunkBits = source.m_maxChunkBits;
        this.m_rebundleBits = source.m_rebundleBits;
        this.m_chunkSize = source.m_chunkSize;
        this.m_chunkMask = source.m_chunkMask;
        this.m_array = source.m_array;
        this.m_innerFSB = source.m_innerFSB;
        this.m_lastChunk = source.m_lastChunk - 1;
        this.m_firstFree = source.m_chunkSize;
        source.m_array = new char[16][];
        source.m_innerFSB = this;
        source.m_lastChunk = 1;
        source.m_firstFree = 0;
        source.m_chunkBits += this.m_rebundleBits;
        source.m_chunkSize = 1 << source.m_chunkBits;
        source.m_chunkMask = source.m_chunkSize - 1;
    }

    public CharSequence subSequence(int start, int end) {
        return this.getString(start, end - start);
    }
}

