/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.exist.storage.IndexPaths;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Configuration
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger((Class)Configuration.class);
    protected DocumentBuilder builder = null;
    protected HashMap config = new HashMap();
    protected String file = null;

    public Configuration(String file) throws DatabaseConfigurationException {
        this(file, null);
    }

    public Configuration(String file, String dbHome) throws DatabaseConfigurationException {
        try {
            NodeList xupdates;
            NodeList serializers;
            NodeList dbcon;
            String pathSep = System.getProperty("file.separator", "/");
            InputStream is = Configuration.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                LOG.info((Object)"Reading configuration from classloader");
                this.file = file;
            } else {
                File f = new File(file);
                if (!f.isAbsolute() && dbHome != null) {
                    file = dbHome + pathSep + file;
                    f = new File(file);
                }
                if (!f.canRead()) {
                    LOG.info((Object)"unable to read configuration. Trying to guess location ...");
                    if (dbHome == null && (dbHome = System.getProperty("exist.home")) == null) {
                        dbHome = System.getProperty("user.dir");
                    }
                    if (dbHome != null) {
                        file = dbHome + pathSep + file;
                    }
                    if (!(f = new File(file)).canRead()) {
                        LOG.warn((Object)"giving up");
                        throw new DatabaseConfigurationException("unable to read configuration file");
                    }
                }
                this.file = file;
                is = new FileInputStream(file);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
            InputSource src = new InputSource(is);
            Document doc = this.builder.parse(src);
            Element root = doc.getDocumentElement();
            NodeList indexer = doc.getElementsByTagName("indexer");
            if (indexer.getLength() > 0) {
                Element p = (Element)indexer.item(0);
                String parseNum = p.getAttribute("parseNumbers");
                String indexDepth = p.getAttribute("index-depth");
                String stemming = p.getAttribute("stemming");
                String termFreq = p.getAttribute("track-term-freq");
                String suppressWS = p.getAttribute("suppress-whitespace");
                String caseSensitive = p.getAttribute("caseSensitive");
                String tokenizer = p.getAttribute("tokenizer");
                String validation = p.getAttribute("validation");
                String suppressWSmixed = p.getAttribute("preserve-whitespace-mixed-content");
                if (parseNum != null) {
                    this.config.put("indexer.indexNumbers", parseNum.equals("yes"));
                }
                if (stemming != null) {
                    this.config.put("indexer.stem", stemming.equals("yes"));
                }
                if (termFreq != null) {
                    this.config.put("indexer.store-term-freq", termFreq.equals("yes"));
                }
                if (caseSensitive != null) {
                    this.config.put("indexer.case-sensitive", caseSensitive.equals("yes"));
                }
                if (suppressWS != null) {
                    this.config.put("indexer.suppress-whitespace", suppressWS);
                }
                if (validation != null) {
                    this.config.put("indexer.validation", validation);
                }
                if (tokenizer != null) {
                    this.config.put("indexer.tokenizer", tokenizer);
                }
                if (indexDepth != null) {
                    try {
                        int depth = Integer.parseInt(indexDepth);
                        this.config.put("indexer.index-depth", new Integer(depth));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (suppressWSmixed != null) {
                    this.config.put("indexer.preserve-whitespace-mixed-content", suppressWSmixed.equals("yes"));
                }
                NodeList index = p.getElementsByTagName("index");
                TreeMap<String, IndexPaths> indexPathMap = new TreeMap<String, IndexPaths>();
                this.config.put("indexer.map", indexPathMap);
                for (int i = 0; i < index.getLength(); ++i) {
                    String ps;
                    String indexAlphaNum;
                    Element idx = (Element)index.item(i);
                    String doctype = idx.getAttribute("doctype");
                    String def = idx.getAttribute("default");
                    IndexPaths paths = new IndexPaths(def.equals("all"));
                    String indexAttributes = idx.getAttribute("attributes");
                    if (indexAttributes != null) {
                        paths.setIncludeAttributes(indexAttributes.equals("true"));
                    }
                    if ((indexAlphaNum = idx.getAttribute("alphanum")) != null) {
                        paths.setIncludeAlphaNum(indexAlphaNum.equals("true"));
                    }
                    if ((indexDepth = idx.getAttribute("index-depth")) != null) {
                        try {
                            int depth = Integer.parseInt(indexDepth);
                            paths.setIndexDepth(depth);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    NodeList include = idx.getElementsByTagName("include");
                    for (int j = 0; j < include.getLength(); ++j) {
                        ps = ((Element)include.item(j)).getAttribute("path");
                        paths.addInclude(ps);
                    }
                    indexPathMap.put(doctype, paths);
                    NodeList exclude = idx.getElementsByTagName("exclude");
                    for (int j = 0; j < exclude.getLength(); ++j) {
                        ps = ((Element)exclude.item(j)).getAttribute("path");
                        paths.addExclude(ps);
                    }
                    NodeList preserveContent = idx.getElementsByTagName("preserveContent");
                    for (int j = 0; j < preserveContent.getLength(); ++j) {
                        ps = ((Element)preserveContent.item(j)).getAttribute("path");
                        paths.addpreserveContent(ps);
                    }
                }
                NodeList stopwords = p.getElementsByTagName("stopwords");
                if (stopwords.getLength() > 0) {
                    String stopwordFile = ((Element)stopwords.item(0)).getAttribute("file");
                    File sf = new File(stopwordFile);
                    if (!sf.canRead()) {
                        stopwordFile = dbHome + pathSep + stopwordFile;
                        sf = new File(stopwordFile);
                    }
                    if (sf.canRead()) {
                        this.config.put("stopwords", stopwordFile);
                    }
                }
                CatalogResolver resolver = new CatalogResolver(true);
                System.setProperty("xml.catalog.verbosity", "10");
                this.config.put("resolver", resolver);
                NodeList entityResolver = p.getElementsByTagName("entity-resolver");
                if (entityResolver.getLength() > 0) {
                    Element r = (Element)entityResolver.item(0);
                    NodeList catalogs = r.getElementsByTagName("catalog");
                    for (int i = 0; i < catalogs.getLength(); ++i) {
                        File catalogFile;
                        String catalog = ((Element)catalogs.item(i)).getAttribute("file");
                        if (pathSep.equals("\\")) {
                            catalog = catalog.replace('/', '\\');
                        }
                        if (!(catalogFile = dbHome == null ? new File(catalog) : new File(dbHome + pathSep + catalog)).exists()) continue;
                        resolver.getCatalog().parseCatalog(catalogFile.getAbsolutePath());
                    }
                }
            }
            if ((dbcon = doc.getElementsByTagName("db-connection")).getLength() > 0) {
                NodeList watchConf;
                NodeList poolConf;
                Element con = (Element)dbcon.item(0);
                String cacheMem = con.getAttribute("cacheSize");
                String pageSize = con.getAttribute("pageSize");
                String dataFiles = con.getAttribute("files");
                String buffers = con.getAttribute("buffers");
                String collBuffers = con.getAttribute("collection_buffers");
                String wordBuffers = con.getAttribute("words_buffers");
                String elementBuffers = con.getAttribute("elements_buffers");
                String freeMem = con.getAttribute("free_mem_min");
                String mysql = con.getAttribute("database");
                if (mysql != null) {
                    this.config.put("database", mysql);
                }
                if (dataFiles != null) {
                    File df = new File(dataFiles);
                    if (!df.isAbsolute() && dbHome != null) {
                        dataFiles = dbHome + pathSep + dataFiles;
                        df = new File(dataFiles);
                    }
                    if (!df.canRead()) {
                        throw new DatabaseConfigurationException("cannot read data directory: " + df.getAbsolutePath());
                    }
                    this.config.put("db-connection.data-dir", df.getAbsolutePath());
                    LOG.info((Object)("data directory = " + df.getAbsolutePath()));
                }
                if (cacheMem != null) {
                    if (cacheMem.endsWith("M") || cacheMem.endsWith("m")) {
                        cacheMem = cacheMem.substring(0, cacheMem.length() - 1);
                    }
                    try {
                        this.config.put("db-connection.cache-size", new Integer(cacheMem));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (buffers != null) {
                    try {
                        this.config.put("db-connection.buffers", new Integer(buffers));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (pageSize != null) {
                    try {
                        this.config.put("db-connection.page-size", new Integer(pageSize));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (collBuffers != null) {
                    try {
                        this.config.put("db-connection.collections.buffers", new Integer(collBuffers));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (wordBuffers != null) {
                    try {
                        this.config.put("db-connection.words.buffers", new Integer(wordBuffers));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (elementBuffers != null) {
                    try {
                        this.config.put("db-connection.elements.buffers", new Integer(elementBuffers));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (freeMem != null) {
                    try {
                        this.config.put("db-connection.min_free_memory", new Integer(freeMem));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if ((poolConf = con.getElementsByTagName("pool")).getLength() > 0) {
                    Element pool = (Element)poolConf.item(0);
                    String min = pool.getAttribute("min");
                    String max = pool.getAttribute("max");
                    String sync = pool.getAttribute("sync-period");
                    String maxShutdownWait = pool.getAttribute("wait-before-shutdown");
                    if (min != null) {
                        try {
                            this.config.put("db-connection.pool.min", new Integer(min));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (max != null) {
                        try {
                            this.config.put("db-connection.pool.max", new Integer(max));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (sync != null) {
                        try {
                            this.config.put("db-connection.pool.sync-period", new Long(sync));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (maxShutdownWait != null) {
                        try {
                            this.config.put("db-connection.pool.shutdown-wait", new Long(maxShutdownWait));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                if ((watchConf = con.getElementsByTagName("watchdog")).getLength() > 0) {
                    Element watchDog = (Element)watchConf.item(0);
                    String timeout = watchDog.getAttribute("query-timeout");
                    String maxOutput = watchDog.getAttribute("output-size-limit");
                    if (timeout != null) {
                        try {
                            this.config.put("db-connection.watchdog.query-timeout", new Long(timeout));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (maxOutput != null) {
                        try {
                            this.config.put("db-connection.watchdog.output-size-limit", new Integer(maxOutput));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if ((serializers = doc.getElementsByTagName("serializer")).getLength() > 0) {
                String tagAttributeMatches;
                String tagElementMatches;
                String internalId;
                String indent;
                String xsl;
                Element serializer = (Element)serializers.item(0);
                String xinclude = serializer.getAttribute("enable-xinclude");
                if (xinclude != null) {
                    this.config.put("serialization.enable-xinclude", xinclude);
                }
                if ((xsl = serializer.getAttribute("enable-xsl")) != null) {
                    this.config.put("serialization.enable-xsl", xsl);
                }
                if ((indent = serializer.getAttribute("indent")) != null) {
                    this.config.put("serialization.indent", indent);
                }
                if ((internalId = serializer.getAttribute("add-exist-id")) != null) {
                    this.config.put("serialization.add-exist-id", internalId);
                }
                if ((tagElementMatches = serializer.getAttribute("match-tagging-elements")) != null) {
                    this.config.put("serialization.match-tagging-elements", tagElementMatches);
                }
                if ((tagAttributeMatches = serializer.getAttribute("match-tagging-attributes")) != null) {
                    this.config.put("serialization.match-tagging-attributes", tagAttributeMatches);
                }
            }
            if ((xupdates = doc.getElementsByTagName("xupdate")).getLength() > 0) {
                String consistencyCheck;
                String fragmentation;
                Element xupdate = (Element)xupdates.item(0);
                String growth = xupdate.getAttribute("growth-factor");
                if (growth != null) {
                    this.config.put("xupdate.growth-factor", new Integer(growth));
                }
                if ((fragmentation = xupdate.getAttribute("allowed-fragmentation")) != null) {
                    this.config.put("xupdate.fragmentation", new Integer(fragmentation));
                }
                if ((consistencyCheck = xupdate.getAttribute("enable-consistency-checks")) != null) {
                    this.config.put("xupdate.consistency-checks", consistencyCheck.equals("yes"));
                }
            }
        }
        catch (SAXException e) {
            LOG.warn((Object)("error while reading config file: " + file), (Throwable)e);
            throw new DatabaseConfigurationException(e.getMessage());
        }
        catch (ParserConfigurationException cfg) {
            LOG.warn((Object)("error while reading config file: " + file), (Throwable)cfg);
            throw new DatabaseConfigurationException(cfg.getMessage());
        }
        catch (IOException io) {
            LOG.warn((Object)("error while reading config file: " + file), (Throwable)io);
            throw new DatabaseConfigurationException(io.getMessage());
        }
    }

    public int getInteger(String name) {
        Object obj = this.getProperty(name);
        if (obj == null || !(obj instanceof Integer)) {
            return -1;
        }
        return (Integer)obj;
    }

    public String getPath() {
        return this.file;
    }

    public Object getProperty(String name) {
        return this.config.get(name);
    }

    public boolean hasProperty(String name) {
        return this.config.containsKey(name);
    }

    public void setProperty(String name, Object obj) {
        this.config.put(name, obj);
    }

    public void error(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }
}

