/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.store;

import java.io.EOFException;
import java.io.IOException;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class StorageAddress {
    public static final long createPointer(int page, short tid) {
        return (long)tid | ((long)page & 0xFFFFFFFFL) << 32;
    }

    public static final long createPointer(int page, short tid, short flags) {
        return (long)tid | ((long)flags & 0xFFFFL) << 16 | ((long)page & 0xFFFFFFFFL) << 32;
    }

    public static final short tidFromPointer(long pointer) {
        return (short)(pointer & 0xFFFFL);
    }

    public static final int pageFromPointer(long pointer) {
        return (int)(pointer >>> 32 & 0xFFFFFFFFL);
    }

    public static final short flagsFromPointer(long pointer) {
        return (short)(pointer >>> 16 & 0xFFFFL);
    }

    public static final boolean equals(long p0, long p1) {
        return (p0 & 0xFFFFFFFF0000FFFFL) == (p1 & 0xFFFFFFFF0000FFFFL);
    }

    public static final void write(long pointer, VariableByteOutputStream os) {
        os.writeInt(StorageAddress.pageFromPointer(pointer));
        os.writeShort(StorageAddress.tidFromPointer(pointer));
        os.writeShort(StorageAddress.flagsFromPointer(pointer));
    }

    public static final long read(VariableByteInput is) throws IOException, EOFException {
        return StorageAddress.createPointer(is.readInt(), is.readShort(), is.readShort());
    }

    public static final String toString(long pointer) {
        return StorageAddress.pageFromPointer(pointer) + ":" + StorageAddress.tidFromPointer(pointer);
    }
}

