/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.store;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.indexer.IndexQuery;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeProxy;
import org.exist.dom.XMLUtil;
import org.exist.storage.BufferStats;
import org.exist.storage.NativeBroker;
import org.exist.storage.Signatures;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRUCache;
import org.exist.storage.store.ItemId;
import org.exist.storage.store.NodeIterator;
import org.exist.storage.store.StorageAddress;
import org.exist.util.ByteConversion;
import org.exist.util.Lock;
import org.exist.util.Lockable;
import org.exist.util.ReadOnlyException;
import org.exist.util.ReentrantReadWriteLock;
import org.exist.util.hashtable.Object2LongIdentityHashMap;
import org.exist.xquery.TerminatedException;

public class DOMFile
extends BTree
implements Lockable {
    public static final short FILE_FORMAT_VERSION_ID = 2;
    public static final byte LOB = 21;
    public static final byte RECORD = 20;
    public static final short OVERFLOW = 0;
    public static final long DATA_SYNC_PERIOD = 4200L;
    private final Cache dataCache;
    private DOMFileHeader fileHeader;
    private Object owner = null;
    private Lock lock = null;
    private final Object2LongIdentityHashMap pages = new Object2LongIdentityHashMap(64);
    private DocumentImpl currentDocument = null;

    public DOMFile(int buffers, int dataBuffers) {
        super(buffers);
        this.lock = new ReentrantReadWriteLock("dom.dbx");
        this.fileHeader = (DOMFileHeader)this.getFileHeader();
        this.fileHeader.setPageCount(0L);
        this.fileHeader.setTotalCount(0L);
        this.dataCache = new LRUCache(dataBuffers);
        this.dataCache.setFileName("dom.dbx");
    }

    public DOMFile(File file, int buffers, int dataBuffers) {
        this(buffers, dataBuffers);
        this.setFile(file);
    }

    protected final Cache getPageBuffer() {
        return this.dataCache;
    }

    public short getFileVersion() {
        return 2;
    }

    public void setCurrentDocument(DocumentImpl doc) {
        this.currentDocument = doc;
    }

    public long add(byte[] value) throws ReadOnlyException {
        if (value == null || value.length == 0) {
            return -1L;
        }
        if (value.length + 4 > this.fileHeader.getWorkSize()) {
            LOG.debug((Object)"Creating overflow page");
            OverflowDOMPage overflow = new OverflowDOMPage();
            overflow.write(value);
            byte[] pnum = ByteConversion.longToByte(overflow.getPageNum());
            return this.add(pnum, true);
        }
        return this.add(value, false);
    }

    private long add(byte[] value, boolean overflowPage) throws ReadOnlyException {
        int valueLen = value.length;
        Object myOwner = this.owner;
        DOMPage page = this.getCurrentPage();
        if (page == null || page.len + 4 + valueLen > page.data.length) {
            DOMPage newPage = new DOMPage();
            if (page != null) {
                DOMFilePageHeader ph = page.getPageHeader();
                ph.setNextDataPage(newPage.getPageNum());
                newPage.getPageHeader().setPrevDataPage(page.getPageNum());
                page.setDirty(true);
                this.dataCache.add(page);
            }
            page = newPage;
            this.setCurrentPage(newPage);
            if (this.owner != myOwner) {
                LOG.error((Object)"Owner changed during transaction!!!!!!!!!!!!!!!!!");
            }
        }
        DOMFilePageHeader ph = page.getPageHeader();
        short tid = ph.getNextTID();
        ByteConversion.shortToByte(tid, page.data, page.len);
        page.len += 2;
        ByteConversion.shortToByte(overflowPage ? (short)0 : (short)valueLen, page.data, page.len);
        page.len += 2;
        System.arraycopy(value, 0, page.data, page.len, valueLen);
        page.len += valueLen;
        ph.incRecordCount();
        ph.setDataLength(page.len);
        page.setDirty(true);
        this.dataCache.add(page, 2);
        long p = StorageAddress.createPointer((int)page.getPageNum(), tid);
        return p;
    }

    public long addBinary(byte[] value) {
        OverflowDOMPage overflow = new OverflowDOMPage();
        overflow.write(value);
        return overflow.getPageNum();
    }

    public byte[] getBinary(long pageNum) {
        return this.getOverflowValue(pageNum);
    }

    public long insertAfter(DocumentImpl doc, Value key, byte[] value) {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return -1L;
            }
            return this.insertAfter(doc, p, value);
        }
        catch (BTreeException e) {
            LOG.warn((Object)"key not found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"IO error", (Throwable)e);
        }
        return -1L;
    }

    public long insertAfter(DocumentImpl doc, long address, byte[] value) {
        RecordPos rec;
        boolean isOverflow = false;
        if (value.length + 4 > this.fileHeader.getWorkSize()) {
            OverflowDOMPage overflow = new OverflowDOMPage();
            LOG.debug((Object)("creating overflow page: " + overflow.getPageNum()));
            overflow.write(value);
            value = ByteConversion.longToByte(overflow.getPageNum());
            isOverflow = true;
        }
        if ((rec = this.findRecord(address)) == null) {
            LOG.warn((Object)"page not found");
            return -1L;
        }
        short l = ByteConversion.byteToShort(rec.page.data, rec.offset);
        if (ItemId.isRelocated(rec.tid)) {
            rec.offset += 8;
        }
        rec.offset = l == 0 ? (rec.offset += 10) : rec.offset + l + 2;
        int dataLen = rec.page.getPageHeader().getDataLength();
        if (rec.offset < dataLen) {
            if (dataLen + value.length + 4 < this.fileHeader.getWorkSize() && rec.page.getPageHeader().hasRoom()) {
                int end = rec.offset + value.length + 4;
                System.arraycopy(rec.page.data, rec.offset, rec.page.data, end, dataLen - rec.offset);
                rec.page.len = dataLen + value.length + 4;
                rec.page.getPageHeader().setDataLength(rec.page.len);
            } else {
                rec = this.splitDataPage(doc, rec);
                if (rec.offset + value.length + 4 > this.fileHeader.getWorkSize() || !rec.page.getPageHeader().hasRoom()) {
                    DOMPage newPage = new DOMPage();
                    LOG.debug((Object)("creating additional page: " + newPage.getPageNum()));
                    newPage.getPageHeader().setNextDataPage(rec.page.getPageHeader().getNextDataPage());
                    newPage.getPageHeader().setPrevDataPage(rec.page.getPageNum());
                    rec.page.getPageHeader().setNextDataPage(newPage.getPageNum());
                    rec.page.setDirty(true);
                    this.dataCache.add(rec.page);
                    rec.page = newPage;
                    rec.offset = 0;
                    rec.page.len = value.length + 4;
                    rec.page.getPageHeader().setDataLength(rec.page.len);
                    rec.page.getPageHeader().setRecordCount((short)1);
                } else {
                    rec.page.len = rec.offset + value.length + 4;
                    rec.page.getPageHeader().setDataLength(rec.page.len);
                    dataLen = rec.offset;
                }
            }
        } else if (dataLen + value.length + 4 > this.fileHeader.getWorkSize() || !rec.page.getPageHeader().hasRoom()) {
            DOMPage newPage = new DOMPage();
            LOG.debug((Object)("creating new page: " + newPage.getPageNum()));
            long next = rec.page.getPageHeader().getNextDataPage();
            newPage.getPageHeader().setNextDataPage(next);
            newPage.getPageHeader().setPrevDataPage(rec.page.getPageNum());
            rec.page.getPageHeader().setNextDataPage(newPage.getPageNum());
            if (-1L < next) {
                DOMPage nextPage = this.getCurrentPage(next);
                nextPage.getPageHeader().setPrevDataPage(newPage.getPageNum());
                nextPage.setDirty(true);
                this.dataCache.add(nextPage);
            }
            rec.page.setDirty(true);
            this.dataCache.add(rec.page);
            rec.page = newPage;
            rec.offset = 0;
            rec.page.len = value.length + 4;
            rec.page.getPageHeader().setDataLength(rec.page.len);
        } else {
            rec.page.len = dataLen + value.length + 4;
            rec.page.getPageHeader().setDataLength(rec.page.len);
        }
        short tid = rec.page.getPageHeader().getNextTID();
        ByteConversion.shortToByte(tid, rec.page.data, rec.offset);
        rec.offset += 2;
        ByteConversion.shortToByte(isOverflow ? (short)0 : (short)value.length, rec.page.data, rec.offset);
        rec.offset += 2;
        System.arraycopy(value, 0, rec.page.data, rec.offset, value.length);
        rec.offset += value.length;
        rec.page.getPageHeader().incRecordCount();
        rec.page.setDirty(true);
        if (rec.page.getPageHeader().getCurrentTID() >= 12286 && doc != null) {
            doc.triggerDefrag();
        }
        this.dataCache.add(rec.page);
        return StorageAddress.createPointer((int)rec.page.getPageNum(), tid);
    }

    private RecordPos splitDataPage(DocumentImpl doc, RecordPos rec) {
        DOMPage firstSplitPage;
        if (this.currentDocument != null) {
            this.currentDocument.incSplitCount();
        }
        boolean requireSplit = false;
        for (int pos = rec.offset; pos < rec.page.len; pos += 10) {
            short currentId = ByteConversion.byteToShort(rec.page.data, pos);
            if (ItemId.isLink(currentId)) continue;
            requireSplit = true;
            break;
        }
        if (!requireSplit) {
            LOG.debug((Object)("page " + rec.page.getPageNum() + ": no split required"));
            rec.offset = rec.page.len;
            return rec;
        }
        NodeIndexListener idx = doc.getIndexListener();
        int oldDataLen = rec.page.getPageHeader().getDataLength();
        byte[] oldData = rec.page.data;
        long oldPageNum = rec.page.getPageNum();
        rec.page.data = new byte[this.fileHeader.getWorkSize()];
        System.arraycopy(oldData, 0, rec.page.data, 0, rec.offset);
        rec.page.len = rec.offset;
        rec.page.setDirty(true);
        DOMPage nextSplitPage = firstSplitPage = new DOMPage();
        nextSplitPage.getPageHeader().setNextTID(rec.page.getPageHeader().getCurrentTID());
        short splitRecordCount = 0;
        LOG.debug((Object)("splitting " + rec.page.getPageNum() + " at " + rec.offset + ": new: " + nextSplitPage.getPageNum() + "; next: " + rec.page.getPageHeader().getNextDataPage()));
        int pos = rec.offset;
        while (pos < oldDataLen) {
            short currentId = ByteConversion.byteToShort(oldData, pos);
            short tid = ItemId.getId(currentId);
            pos += 2;
            if (ItemId.isLink(currentId)) {
                ByteConversion.shortToByte(currentId, rec.page.data, rec.page.len);
                rec.page.len += 2;
                System.arraycopy(oldData, pos, rec.page.data, rec.page.len, 8);
                rec.page.len += 8;
                pos += 8;
            } else {
                long backLink;
                DOMPage newPage;
                int realLen;
                short currentLen = ByteConversion.byteToShort(oldData, pos);
                pos += 2;
                int n = realLen = currentLen == 0 ? 8 : (int)currentLen;
                if (nextSplitPage.len + realLen + 12 > this.fileHeader.getWorkSize()) {
                    newPage = new DOMPage();
                    newPage.getPageHeader().setNextTID((short)(rec.page.getPageHeader().getNextTID() - 1));
                    newPage.getPageHeader().setPrevDataPage(nextSplitPage.getPageNum());
                    LOG.debug((Object)("creating new split page: " + newPage.getPageNum()));
                    nextSplitPage.getPageHeader().setNextDataPage(newPage.getPageNum());
                    nextSplitPage.getPageHeader().setDataLength(nextSplitPage.len);
                    nextSplitPage.getPageHeader().setRecordCount(splitRecordCount);
                    nextSplitPage.setDirty(true);
                    this.dataCache.add(nextSplitPage);
                    this.dataCache.add(newPage);
                    nextSplitPage = newPage;
                    splitRecordCount = 0;
                }
                if (ItemId.isRelocated(currentId)) {
                    backLink = ByteConversion.byteToLong(oldData, pos);
                    pos += 8;
                    RecordPos origRec = this.findRecord(backLink, false);
                    long forwardLink = StorageAddress.createPointer((int)nextSplitPage.getPageNum(), tid);
                    ByteConversion.longToByte(forwardLink, origRec.page.data, origRec.offset);
                    origRec.page.setDirty(true);
                    this.dataCache.add(origRec.page);
                } else {
                    backLink = StorageAddress.createPointer((int)rec.page.getPageNum(), tid);
                }
                ByteConversion.shortToByte(ItemId.setIsRelocated(currentId), nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 2;
                ByteConversion.shortToByte(currentLen, nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 2;
                ByteConversion.longToByte(backLink, nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 8;
                try {
                    System.arraycopy(oldData, pos, nextSplitPage.data, nextSplitPage.len, realLen);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOG.error((Object)("pos = " + pos + "; len = " + nextSplitPage.len + "; currentLen = " + realLen + "; tid = " + currentId + "; page = " + rec.page.getPageNum()));
                    throw e;
                }
                nextSplitPage.len += realLen;
                pos += realLen;
                if (idx != null) {
                    idx.nodeChanged(StorageAddress.createPointer((int)oldPageNum, tid), StorageAddress.createPointer((int)nextSplitPage.getPageNum(), tid));
                }
                if (!ItemId.isRelocated(currentId)) {
                    if (rec.page.len + 10 > this.fileHeader.getWorkSize()) {
                        newPage = new DOMPage();
                        newPage.getPageHeader().setNextTID((short)(rec.page.getPageHeader().getNextTID() - 1));
                        newPage.getPageHeader().setPrevDataPage(rec.page.getPageNum());
                        newPage.getPageHeader().setNextDataPage(rec.page.getPageHeader().getNextDataPage());
                        LOG.debug((Object)("creating new page after split: " + newPage.getPageNum()));
                        rec.page.getPageHeader().setNextDataPage(newPage.getPageNum());
                        rec.page.getPageHeader().setDataLength(rec.page.len);
                        rec.page.getPageHeader().setRecordCount(this.countRecordsInPage(rec.page));
                        rec.page.setDirty(true);
                        this.dataCache.add(rec.page);
                        this.dataCache.add(newPage);
                        rec.page = newPage;
                        rec.page.len = 0;
                    }
                    ByteConversion.shortToByte(ItemId.setIsLink(currentId), rec.page.data, rec.page.len);
                    rec.page.len += 2;
                    long forwardLink = StorageAddress.createPointer((int)nextSplitPage.getPageNum(), tid);
                    ByteConversion.longToByte(forwardLink, rec.page.data, rec.page.len);
                    rec.page.len += 8;
                }
            }
            splitRecordCount = (short)(splitRecordCount + 1);
        }
        if (nextSplitPage.len == 0) {
            LOG.warn((Object)("page " + nextSplitPage.getPageNum() + " is empty. Remove it"));
            this.dataCache.remove(nextSplitPage);
            if (nextSplitPage == firstSplitPage) {
                firstSplitPage = null;
            }
            try {
                this.unlinkPages(nextSplitPage.page);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to remove empty split page: " + e.getMessage()), (Throwable)e);
            }
            nextSplitPage = null;
        } else {
            nextSplitPage.getPageHeader().setDataLength(nextSplitPage.len);
            nextSplitPage.getPageHeader().setNextDataPage(rec.page.getPageHeader().getNextDataPage());
            nextSplitPage.getPageHeader().setRecordCount(splitRecordCount);
            nextSplitPage.setDirty(true);
            this.dataCache.add(nextSplitPage);
            firstSplitPage.getPageHeader().setPrevDataPage(rec.page.getPageNum());
            if (nextSplitPage != firstSplitPage) {
                firstSplitPage.setDirty(true);
                this.dataCache.add(firstSplitPage);
            }
        }
        long next = rec.page.getPageHeader().getNextDataPage();
        if (-1L < next) {
            DOMPage nextPage = this.getCurrentPage(next);
            nextPage.getPageHeader().setPrevDataPage(nextSplitPage.getPageNum());
            nextPage.setDirty(true);
            this.dataCache.add(nextPage);
        }
        rec.page = this.getCurrentPage(rec.page.getPageNum());
        if (firstSplitPage != null) {
            rec.page.getPageHeader().setNextDataPage(firstSplitPage.getPageNum());
        }
        rec.page.getPageHeader().setDataLength(rec.page.len);
        rec.page.getPageHeader().setRecordCount(this.countRecordsInPage(rec.page));
        rec.offset = rec.page.len;
        return rec;
    }

    private short countRecordsInPage(DOMPage page) {
        short count = 0;
        int dlen = page.getPageHeader().getDataLength();
        int pos = 0;
        while (pos < dlen) {
            short currentId = ByteConversion.byteToShort(page.data, pos);
            if (ItemId.isLink(currentId)) {
                pos += 10;
            } else {
                short vlen = ByteConversion.byteToShort(page.data, pos + 2);
                pos = ItemId.isRelocated(currentId) ? (pos += vlen == 0 ? 20 : vlen + 12) : (pos += vlen == 0 ? 12 : vlen + 4);
            }
            count = (short)(count + 1);
        }
        return count;
    }

    public String debugPageContents(DOMPage page) {
        StringBuffer buf = new StringBuffer();
        buf.append("Page " + page.getPageNum() + ": ");
        int count = 0;
        int dlen = page.getPageHeader().getDataLength();
        int pos = 0;
        while (pos < dlen) {
            short currentId = ByteConversion.byteToShort(page.data, pos);
            buf.append(ItemId.getId(currentId) + "[" + pos);
            if (ItemId.isLink(currentId)) {
                buf.append(':').append(10).append("] ");
                pos += 10;
            } else {
                short vlen = ByteConversion.byteToShort(page.data, pos + 2);
                if (vlen < 0) {
                    LOG.warn((Object)("Illegal length: " + vlen));
                    return buf.toString();
                }
                buf.append(':').append(vlen).append("] ");
                pos = ItemId.isRelocated(currentId) ? (pos += vlen == 0 ? 20 : vlen + 12) : (pos += vlen == 0 ? 12 : vlen + 4);
            }
            count = (short)(count + 1);
        }
        buf.append("; records in page: " + count);
        buf.append("; nextTID: " + page.getPageHeader().getCurrentTID());
        return buf.toString();
    }

    public boolean close() throws DBException {
        this.flush();
        super.close();
        return true;
    }

    public boolean create() throws DBException {
        return super.create((short)12, this.lock);
    }

    public Paged.FileHeader createFileHeader() {
        return new DOMFileHeader(1024L, PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new DOMFileHeader(read);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new DOMFileHeader(pageCount, PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new DOMFileHeader(pageCount, pageSize);
    }

    protected Paged.Page createNewPage() {
        try {
            Paged.Page page = this.getFreePage();
            DOMFilePageHeader ph = (DOMFilePageHeader)page.getPageHeader();
            ph.setStatus((byte)20);
            ph.setDirty(true);
            ph.setNextDataPage(-1L);
            ph.setPrevDataPage(-1L);
            ph.setNextTID((short)-1);
            ph.setDataLength(0);
            ph.setRecordCount((short)0);
            if (this.currentDocument != null) {
                this.currentDocument.incPageCount();
            }
            return page;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return null;
        }
    }

    protected void unlinkPages(Paged.Page page) throws IOException {
        super.unlinkPages(page);
    }

    public Paged.PageHeader createPageHeader() {
        return new DOMFilePageHeader();
    }

    public ArrayList findKeys(IndexQuery query) throws IOException, BTreeException {
        FindCallback cb = new FindCallback(1);
        try {
            this.query(query, cb);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"Method terminated");
        }
        return cb.getValues();
    }

    private long findNode(NodeImpl node, long target, Iterator iter) {
        if (node.hasChildNodes()) {
            long firstChildId = XMLUtil.getFirstChildId((DocumentImpl)node.getOwnerDocument(), node.getGID());
            if (firstChildId < 0L) {
                LOG.debug((Object)("first child not found: " + node.getGID()));
                return 0L;
            }
            long lastChildId = firstChildId + (long)node.getChildCount();
            for (long gid = firstChildId; gid < lastChildId; ++gid) {
                NodeImpl child = (NodeImpl)iter.next();
                if (child == null) {
                    LOG.warn((Object)("Next node missing. gid = " + gid + "; last = " + lastChildId + "; parent= " + node.getNodeName() + "; count = " + node.getChildCount()));
                }
                if (gid == target) {
                    return ((NodeIterator)iter).currentAddress();
                }
                child.setGID(gid);
                long p = this.findNode(child, target, iter);
                if (p == 0L) continue;
                return p;
            }
        }
        return 0L;
    }

    protected long findValue(Object lock, NodeProxy node) throws IOException, BTreeException {
        DocumentImpl doc = node.getDoc();
        NativeBroker.NodeRef nodeRef = new NativeBroker.NodeRef(doc.getDocId(), node.getGID());
        long p = this.findValue(nodeRef);
        if (p == -1L) {
            long id = node.getGID();
            long parentPointer = -1L;
            do {
                if ((id = XMLUtil.getParentId(doc, id)) < 1L) {
                    LOG.warn((Object)(node.gid + " not found."));
                    Thread.dumpStack();
                    throw new BTreeException("node " + node.gid + " not found.");
                }
                NativeBroker.NodeRef parentRef = new NativeBroker.NodeRef(doc.getDocId(), id);
                try {
                    parentPointer = this.findValue(parentRef);
                }
                catch (BTreeException bte) {
                    // empty catch block
                }
            } while (parentPointer == -1L);
            long firstChildId = XMLUtil.getFirstChildId(doc, id);
            NodeIterator iter = new NodeIterator(lock, this, node.getDocument(), parentPointer);
            NodeImpl n = (NodeImpl)iter.next();
            n.setGID(id);
            long address = this.findNode(n, node.gid, iter);
            if (address == 0L) {
                return -1L;
            }
            return address;
        }
        return p;
    }

    public ArrayList findValues(IndexQuery query) throws IOException, BTreeException {
        FindCallback cb = new FindCallback(0);
        try {
            this.query(query, cb);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"Method terminated");
        }
        return cb.getValues();
    }

    public boolean flush() throws DBException {
        super.flush();
        this.dataCache.flush();
        this.closeDocument();
        try {
            if (this.fileHeader.isDirty()) {
                this.fileHeader.write();
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)"sync failed", (Throwable)ioe);
        }
        return true;
    }

    public void printStatistics() {
        super.printStatistics();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getName()).append(" DATA ");
        buf.append(this.dataCache.getBuffers()).append(" / ");
        buf.append(this.dataCache.getUsedBuffers()).append(" / ");
        buf.append(this.dataCache.getHits()).append(" / ");
        buf.append(this.dataCache.getFails());
        LOG.info((Object)buf.toString());
    }

    public BufferStats getDataBufferStats() {
        return new BufferStats(this.dataCache.getBuffers(), this.dataCache.getUsedBuffers(), this.dataCache.getHits(), this.dataCache.getFails());
    }

    public Value get(Value key) {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return null;
            }
            return this.get(p);
        }
        catch (BTreeException bte) {
            return null;
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
            return null;
        }
    }

    public Value get(NodeProxy node) {
        try {
            long p = this.findValue(this.owner, node);
            if (p == -1L) {
                return null;
            }
            return this.get(p);
        }
        catch (BTreeException bte) {
            return null;
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
            return null;
        }
    }

    public Value get(long p) {
        Value v;
        RecordPos rec = this.findRecord(p);
        if (rec == null) {
            LOG.warn((Object)("object at " + StorageAddress.toString(p) + " not found."));
            Thread.dumpStack();
            return null;
        }
        short l = ByteConversion.byteToShort(rec.page.data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.tid)) {
            rec.offset += 8;
        }
        if (l == 0) {
            long pnum = ByteConversion.byteToLong(rec.page.data, rec.offset);
            byte[] data = this.getOverflowValue(pnum);
            v = new Value(data);
        } else {
            v = new Value(rec.page.data, rec.offset, l);
        }
        v.setAddress(p);
        return v;
    }

    protected byte[] getOverflowValue(long pnum) {
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pnum);
            return overflow.read();
        }
        catch (IOException e) {
            LOG.error((Object)"io error while loading overflow value", (Throwable)e);
            return null;
        }
    }

    public void removeOverflowValue(long pnum) {
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pnum);
            overflow.delete();
        }
        catch (IOException e) {
            LOG.error((Object)"io error while removing overflow value", (Throwable)e);
        }
    }

    private final DOMPage getCurrentPage() {
        long pnum = this.pages.get(this.owner);
        if (pnum < 0L) {
            DOMPage page = new DOMPage();
            this.pages.put(this.owner, page.page.getPageNum());
            this.dataCache.add(page);
            return page;
        }
        return this.getCurrentPage(pnum);
    }

    protected final DOMPage getCurrentPage(long p) {
        DOMPage page = (DOMPage)this.dataCache.get(p);
        if (page == null) {
            page = new DOMPage(p);
        }
        return page;
    }

    public void closeDocument() {
        this.pages.remove(this.owner);
    }

    public boolean open() throws DBException {
        return super.open((short)2, this.lock);
    }

    public long put(Value key, byte[] value) throws ReadOnlyException {
        long p = this.add(value);
        try {
            this.addValue(key, p);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
            return -1L;
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
            return -1L;
        }
        return p;
    }

    public void remove(Value key) {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return;
            }
            this.remove(key, p);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
    }

    private void removeLink(long p) {
        RecordPos rec = this.findRecord(p, false);
        DOMFilePageHeader ph = rec.page.getPageHeader();
        int end = rec.offset + 8;
        System.arraycopy(rec.page.data, rec.offset + 8, rec.page.data, rec.offset - 2, rec.page.len - end);
        rec.page.len -= 10;
        ph.setDataLength(rec.page.len);
        rec.page.setDirty(true);
        ph.decRecordCount();
        if (rec.page.len == 0) {
            this.removePage(rec.page);
            rec.page = null;
        } else {
            this.dataCache.add(rec.page);
        }
    }

    public void remove(long p) {
        RecordPos rec = this.findRecord(p);
        int startOffset = rec.offset - 2;
        DOMFilePageHeader ph = rec.page.getPageHeader();
        short l = ByteConversion.byteToShort(rec.page.data, rec.offset);
        rec.offset += 2;
        if (ItemId.isLink(rec.tid)) {
            throw new RuntimeException("Cannot remove link ...");
        }
        if (ItemId.isRelocated(rec.tid)) {
            long backLink = ByteConversion.byteToLong(rec.page.data, rec.offset);
            this.removeLink(backLink);
            rec.offset += 8;
            l = (short)(l + 8);
        }
        if (l == 0) {
            long pnum = ByteConversion.byteToLong(rec.page.data, rec.offset);
            rec.offset += 8;
            try {
                OverflowDOMPage overflow = new OverflowDOMPage(pnum);
                overflow.delete();
            }
            catch (IOException e) {
                LOG.error((Object)"io error while removing overflow page", (Throwable)e);
            }
            l = (short)(l + 8);
        }
        int end = startOffset + 4 + l;
        int len = ph.getDataLength();
        System.arraycopy(rec.page.data, end, rec.page.data, startOffset, len - end);
        rec.page.setDirty(true);
        len = len - l - 4;
        ph.setDataLength(len);
        rec.page.len = len;
        rec.page.setDirty(true);
        ph.decRecordCount();
        if (rec.page.len == 0) {
            LOG.debug((Object)("removing page " + rec.page.getPageNum()));
            this.removePage(rec.page);
            rec.page = null;
        } else {
            rec.page.cleanUp();
            this.dataCache.add(rec.page);
        }
    }

    public void remove(Value key, long p) {
        this.remove(p);
        try {
            this.removeValue(key);
        }
        catch (BTreeException e) {
            LOG.warn((Object)"btree error while removing node", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while removing node", (Throwable)e);
        }
    }

    public void removePage(DOMPage page) {
        this.dataCache.remove(page);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getNextDataPage() > -1L) {
            DOMPage next = this.getCurrentPage(ph.getNextDataPage());
            next.getPageHeader().setPrevDataPage(ph.getPrevDataPage());
            next.setDirty(true);
            this.dataCache.add(next);
        }
        if (ph.getPrevDataPage() > -1L) {
            DOMPage prev = this.getCurrentPage(ph.getPrevDataPage());
            prev.getPageHeader().setNextDataPage(ph.getNextDataPage());
            prev.setDirty(true);
            this.dataCache.add(prev);
        }
        try {
            ph.setNextDataPage(-1L);
            ph.setPrevDataPage(-1L);
            ph.setDataLength(0);
            ph.setNextTID((short)-1);
            ph.setRecordCount((short)0);
            this.unlinkPages(page.page);
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
        }
        if (this.currentDocument != null) {
            this.currentDocument.decPageCount();
        }
    }

    public void removeAll(long p) {
        long pnum = StorageAddress.pageFromPointer(p);
        while (-1L < pnum) {
            DOMPage page = this.getCurrentPage(pnum);
            pnum = page.getPageHeader().getNextDataPage();
            this.dataCache.remove(page);
            try {
                DOMFilePageHeader ph = page.getPageHeader();
                ph.setNextDataPage(-1L);
                ph.setPrevDataPage(-1L);
                ph.setDataLength(0);
                ph.setNextTID((short)-1);
                ph.setRecordCount((short)0);
                page.len = 0;
                this.unlinkPages(page.page);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error while removing page: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String debugPages(DocumentImpl doc) {
        StringBuffer buf = new StringBuffer();
        buf.append("Pages used by ").append(doc.getName());
        buf.append("; docId ").append(doc.getDocId()).append(':');
        long pnum = StorageAddress.pageFromPointer(((NodeImpl)doc.getFirstChild()).getInternalAddress());
        while (-1L < pnum) {
            DOMPage page = this.getCurrentPage(pnum);
            this.dataCache.add(page);
            buf.append(' ').append(pnum);
            pnum = page.getPageHeader().getNextDataPage();
        }
        buf.append("; Document metadata at " + StorageAddress.toString(doc.getAddress()));
        return buf.toString();
    }

    private final void setCurrentPage(DOMPage page) {
        long pnum = this.pages.get(this.owner);
        if (pnum == page.page.getPageNum()) {
            return;
        }
        this.pages.put(this.owner, page.page.getPageNum());
    }

    public final Lock getLock() {
        return this.lock;
    }

    public final void setOwnerObject(Object obj) {
        this.owner = obj;
    }

    public boolean update(Value key, byte[] value) throws ReadOnlyException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return false;
            }
            this.update(p, value);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
            bte.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
            return false;
        }
        return true;
    }

    public void update(long p, byte[] value) throws ReadOnlyException {
        RecordPos rec = this.findRecord(p);
        short l = ByteConversion.byteToShort(rec.page.data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.tid)) {
            rec.offset += 8;
        }
        if (value.length < l) {
            throw new IllegalStateException("shrinked");
        }
        if (value.length > l) {
            throw new IllegalStateException("value too long: expected: " + value.length + "; got: " + l);
        }
        System.arraycopy(value, 0, rec.page.data, rec.offset, value.length);
        rec.page.setDirty(true);
    }

    public String getNodeValue(NodeProxy proxy) {
        try {
            String value;
            long address = proxy.getInternalAddress();
            if (address < 0L) {
                address = this.findValue(this, proxy);
            }
            if (address == -1L) {
                return null;
            }
            RecordPos rec = this.findRecord(address);
            if (rec == null) {
                LOG.warn((Object)("Node data could not be found! Page: " + StorageAddress.pageFromPointer(address) + "; tid: " + StorageAddress.tidFromPointer(address)));
                throw new RuntimeException("Node data could not be found for node " + proxy.gid);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.getNodeValue(os, rec, true);
            byte[] data = os.toByteArray();
            try {
                value = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value = new String(data);
            }
            return value;
        }
        catch (BTreeException e) {
            LOG.warn((Object)"btree error while reading node value", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while reading node value", (Throwable)e);
        }
        return null;
    }

    private void getNodeValue(ByteArrayOutputStream os, RecordPos rec, boolean firstCall) {
        boolean foundNext = false;
        do {
            if (rec.offset > rec.page.getPageHeader().getDataLength()) {
                long nextPage = rec.page.getPageHeader().getNextDataPage();
                if (nextPage < 0L) {
                    LOG.warn((Object)"bad link to next page");
                    return;
                }
                rec.page = this.getCurrentPage(nextPage);
                this.dataCache.add(rec.page);
                rec.offset = 2;
            }
            rec.tid = ByteConversion.byteToShort(rec.page.data, rec.offset - 2);
            if (ItemId.isLink(rec.tid)) {
                rec.offset += 10;
                continue;
            }
            foundNext = true;
        } while (!foundNext);
        int len = ByteConversion.byteToShort(rec.page.data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.tid)) {
            rec.offset += 8;
        }
        byte[] data = rec.page.data;
        int readOffset = rec.offset;
        if (len == 0) {
            long op = ByteConversion.byteToLong(data, rec.offset);
            data = this.getOverflowValue(op);
            len = data.length;
            readOffset = 0;
            rec.offset += 8;
        }
        short type = Signatures.getType(data[readOffset]);
        switch (type) {
            case 1: {
                int children = ByteConversion.byteToInt(data, readOffset + 1);
                byte attrSizeType = (byte)((data[readOffset] & 0xC) >> 2);
                short attributes = (short)Signatures.read(attrSizeType, data, readOffset + 5);
                rec.offset += len + 2;
                for (int i = 0; i < children; ++i) {
                    this.getNodeValue(os, rec, false);
                    if (children - attributes <= 1) continue;
                    os.write(32);
                }
                return;
            }
            case 3: {
                os.write(data, readOffset + 1, len - 1);
                break;
            }
            case 2: {
                if (!firstCall) break;
                byte idSizeType = (byte)(data[readOffset] & 3);
                boolean hasNamespace = (data[readOffset] & 0x10) == 16;
                int next = Signatures.getLength(idSizeType) + 1;
                if (hasNamespace) {
                    short prefixLen = ByteConversion.byteToShort(data, readOffset + (next += 2));
                    next += prefixLen + 2;
                }
                os.write(rec.page.data, readOffset + next, len - next);
            }
        }
        if (len != 0) {
            rec.offset += len + 2;
        }
    }

    protected RecordPos findRecord(long p) {
        return this.findRecord(p, true);
    }

    protected RecordPos findRecord(long p, boolean skipLinks) {
        long pageNr = StorageAddress.pageFromPointer(p);
        short targetId = StorageAddress.tidFromPointer(p);
        while (pageNr > -1L) {
            DOMPage page = this.getCurrentPage(pageNr);
            this.dataCache.add(page);
            RecordPos rec = page.findRecord(targetId);
            if (rec == null) {
                pageNr = page.getPageHeader().getNextDataPage();
                if (pageNr == page.getPageNum()) {
                    LOG.debug((Object)("circular link to next page on " + pageNr));
                    return null;
                }
                LOG.debug((Object)(this.owner.toString() + ": tid " + targetId + " not found on " + page.page.getPageInfo() + ". Loading " + pageNr + "; contents: " + this.debugPageContents(page)));
                continue;
            }
            if (rec.isLink) {
                if (!skipLinks) {
                    return rec;
                }
                long forwardLink = ByteConversion.byteToLong(page.data, rec.offset);
                pageNr = StorageAddress.pageFromPointer(forwardLink);
                targetId = StorageAddress.tidFromPointer(forwardLink);
                continue;
            }
            return rec;
        }
        return null;
    }

    public final void addToBuffer(DOMPage page) {
        this.dataCache.add(page);
    }

    protected static final class RecordPos {
        DOMPage page = null;
        int offset = -1;
        short tid = 0;
        boolean isLink = false;

        public RecordPos(int offset, DOMPage page, short tid) {
            this.offset = offset;
            this.page = page;
            this.tid = tid;
        }
    }

    private final class RangeCallback
    implements BTreeCallback {
        ArrayList values = new ArrayList();

        public ArrayList getValues() {
            return this.values;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            RecordPos rec = DOMFile.this.findRecord(pointer);
            short l = ByteConversion.byteToShort(rec.page.data, rec.offset);
            int dataStart = rec.offset + 2;
            this.values.add(new Value(rec.page.data, dataStart, l));
            return true;
        }
    }

    private final class FindCallback
    implements BTreeCallback {
        public static final int KEYS = 1;
        public static final int VALUES = 0;
        int mode = 0;
        ArrayList values = new ArrayList();

        public FindCallback(int mode) {
            this.mode = mode;
        }

        public ArrayList getValues() {
            return this.values;
        }

        public boolean indexInfo(Value value, long pointer) {
            switch (this.mode) {
                case 0: {
                    RecordPos rec = DOMFile.this.findRecord(pointer);
                    short l = ByteConversion.byteToShort(rec.page.data, rec.offset);
                    int dataStart = rec.offset + 2;
                    this.values.add(new Value(rec.page.data, dataStart, l));
                    return true;
                }
                case 1: {
                    this.values.add(value);
                    return true;
                }
            }
            return false;
        }
    }

    protected final class OverflowDOMPage {
        Paged.Page firstPage = null;

        public OverflowDOMPage() {
            LOG.debug((Object)"Creating overflow page");
            this.firstPage = DOMFile.this.createNewPage();
        }

        public OverflowDOMPage(long first) throws IOException {
            this.firstPage = DOMFile.this.getPage(first);
        }

        public void write(byte[] data) {
            try {
                int remaining = data.length;
                int chunkSize = DOMFile.this.fileHeader.getWorkSize();
                Paged.Page page = this.firstPage;
                Paged.Page next = null;
                int pos = 0;
                while (remaining > 0) {
                    chunkSize = remaining > DOMFile.this.fileHeader.getWorkSize() ? DOMFile.this.fileHeader.getWorkSize() : remaining;
                    Value value = new Value(data, pos, chunkSize);
                    if ((remaining -= chunkSize) > 0) {
                        next = DOMFile.this.createNewPage();
                        page.getPageHeader().setNextPage(next.getPageNum());
                    } else {
                        page.getPageHeader().setNextPage(-1L);
                    }
                    DOMFile.this.writeValue(page, value);
                    pos += chunkSize;
                    page = next;
                    next = null;
                }
            }
            catch (IOException e) {
                LOG.error((Object)"io error while writing overflow page", (Throwable)e);
            }
        }

        public byte[] read() {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Paged.Page page = this.firstPage;
            int count = 0;
            while (page != null) {
                try {
                    byte[] chunk = page.read();
                    os.write(chunk);
                    long np = page.getPageHeader().getNextPage();
                    page = np > -1L ? DOMFile.this.getPage(np) : null;
                }
                catch (IOException e) {
                    LOG.error((Object)("io error while loading overflow page " + this.firstPage.getPageNum() + "; read: " + count), (Throwable)e);
                    break;
                }
                ++count;
            }
            return os.toByteArray();
        }

        public void delete() throws IOException {
            Paged.Page page = this.firstPage;
            while (page != null) {
                page.read();
                LOG.debug((Object)("removing overflow page " + page.getPageNum()));
                long np = page.getPageHeader().getNextPage();
                DOMFile.this.unlinkPages(page);
                page = np > -1L ? DOMFile.this.getPage(np) : null;
            }
        }

        public long getPageNum() {
            return this.firstPage.getPageNum();
        }
    }

    protected final class DOMPage
    implements Cacheable {
        byte[] data;
        int len = 0;
        Paged.Page page;
        DOMFilePageHeader ph;
        int refCount = 0;
        int timestamp = 0;
        boolean saved = true;
        boolean invalidated = false;

        public DOMPage() {
            this.page = DOMFile.this.createNewPage();
            this.ph = (DOMFilePageHeader)this.page.getPageHeader();
            this.data = new byte[DOMFile.this.fileHeader.getWorkSize()];
            this.len = 0;
        }

        public DOMPage(long pos) {
            try {
                this.page = DOMFile.this.getPage(pos);
                this.load(this.page);
            }
            catch (IOException ioe) {
                LOG.debug((Object)ioe);
                ioe.printStackTrace();
            }
        }

        public DOMPage(Paged.Page page) {
            this.page = page;
            this.load(page);
        }

        public RecordPos findRecord(short targetId) {
            int dlen = this.ph.getDataLength();
            RecordPos rec = null;
            int pos = 0;
            while (pos < dlen) {
                short currentId = ByteConversion.byteToShort(this.data, pos);
                byte flags = ItemId.getFlags(currentId);
                if (ItemId.matches(currentId, targetId)) {
                    if ((flags & 1) != 0) {
                        rec = new RecordPos(pos + 2, this, currentId);
                        rec.isLink = true;
                        break;
                    }
                    rec = new RecordPos(pos + 2, this, currentId);
                    break;
                }
                if ((flags & 1) != 0) {
                    pos += 10;
                    continue;
                }
                short vlen = ByteConversion.byteToShort(this.data, pos + 2);
                if (vlen < 0) {
                    LOG.warn((Object)("page = " + this.page.getPageNum() + "; pos = " + pos + "; vlen = " + vlen + "; tid = " + currentId + "; target = " + targetId));
                }
                pos = (flags & 2) != 0 ? (pos += vlen + 12) : (pos += vlen + 4);
                if (vlen != 0) continue;
                pos += 8;
            }
            return rec;
        }

        public long getKey() {
            return this.page.getPageNum();
        }

        public int getReferenceCount() {
            return this.refCount;
        }

        public int decReferenceCount() {
            return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
        }

        public int incReferenceCount() {
            if (this.refCount < 10000) {
                ++this.refCount;
            }
            return this.refCount;
        }

        public void setReferenceCount(int count) {
            this.refCount = count;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public DOMFilePageHeader getPageHeader() {
            return this.ph;
        }

        public long getPageNum() {
            return this.page.getPageNum();
        }

        public boolean isDirty() {
            return !this.saved;
        }

        public void setDirty(boolean dirty) {
            this.saved = !dirty;
            this.page.getPageHeader().setDirty(dirty);
        }

        private void load(Paged.Page page) {
            try {
                this.data = page.read();
                this.ph = (DOMFilePageHeader)page.getPageHeader();
                this.len = this.ph.getDataLength();
                if (this.data.length == 0) {
                    LOG.debug((Object)("page " + page.getPageNum() + " data length == 0"));
                    return;
                }
            }
            catch (IOException ioe) {
                LOG.debug((Object)ioe);
                ioe.printStackTrace();
            }
            this.saved = true;
        }

        public void write() {
            if (this.page == null) {
                return;
            }
            try {
                if (!this.ph.isDirty()) {
                    return;
                }
                this.ph.setDataLength(this.len);
                DOMFile.this.writeValue(this.page, this.data);
                this.setDirty(false);
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
            }
        }

        public String dumpPage() {
            return "Contents of page " + this.page.getPageNum() + ": " + Paged.hexDump(this.data);
        }

        public boolean sync() {
            if (this.isDirty()) {
                this.write();
                return true;
            }
            return false;
        }

        public boolean allowUnload() {
            return true;
        }

        public boolean equals(Object obj) {
            DOMPage other = (DOMPage)obj;
            return this.page.equals(other.page);
        }

        public void invalidate() {
            this.invalidated = true;
        }

        public boolean isInvalidated() {
            return this.invalidated;
        }

        public void cleanUp() {
            int dlen = this.ph.getDataLength();
            short maxTID = 0;
            int pos = 0;
            while (pos < dlen) {
                short currentId = ByteConversion.byteToShort(this.data, pos);
                short tid = ItemId.getId(currentId);
                if (tid > 16382) {
                    LOG.debug((Object)DOMFile.this.debugPageContents(this));
                    throw new RuntimeException("TID overflow in page " + this.getPageNum());
                }
                if (tid > maxTID) {
                    maxTID = tid;
                }
                if (ItemId.isLink(currentId)) {
                    pos += 10;
                    continue;
                }
                short vlen = ByteConversion.byteToShort(this.data, pos + 2);
                if (ItemId.isRelocated(currentId)) {
                    pos += vlen == 0 ? 20 : vlen + 12;
                    continue;
                }
                pos += vlen == 0 ? 12 : vlen + 4;
            }
            this.ph.setNextTID(maxTID);
        }
    }

    protected static final class DOMFilePageHeader
    extends BTree.BTreePageHeader {
        protected int dataLen = 0;
        protected long nextDataPage = -1L;
        protected long prevDataPage = -1L;
        protected short tid = (short)-1;
        protected short records = 0;

        public DOMFilePageHeader() {
        }

        public DOMFilePageHeader(byte[] data, int offset) throws IOException {
            super(data, offset);
        }

        public void decRecordCount() {
            this.records = (short)(this.records - 1);
        }

        public short getCurrentTID() {
            return this.tid;
        }

        public short getNextTID() {
            this.tid = (short)(this.tid + 1);
            if (this.tid == 16383) {
                throw new RuntimeException("no spare ids on page");
            }
            return this.tid;
        }

        public boolean hasRoom() {
            return this.tid < 16382;
        }

        public void setNextTID(short tid) {
            if (tid > 16382) {
                throw new RuntimeException("TID overflow! TID = " + tid);
            }
            this.tid = tid;
        }

        public int getDataLength() {
            return this.dataLen;
        }

        public long getNextDataPage() {
            return this.nextDataPage;
        }

        public long getPrevDataPage() {
            return this.prevDataPage;
        }

        public short getRecordCount() {
            return this.records;
        }

        public void incRecordCount() {
            this.records = (short)(this.records + 1);
        }

        public int read(byte[] data, int offset) throws IOException {
            offset = super.read(data, offset);
            this.records = ByteConversion.byteToShort(data, offset);
            this.dataLen = ByteConversion.byteToInt(data, offset += 2);
            this.nextDataPage = ByteConversion.byteToLong(data, offset += 4);
            this.prevDataPage = ByteConversion.byteToLong(data, offset += 8);
            this.tid = ByteConversion.byteToShort(data, offset += 8);
            return offset + 2;
        }

        public int write(byte[] data, int offset) throws IOException {
            offset = super.write(data, offset);
            ByteConversion.shortToByte(this.records, data, offset);
            ByteConversion.intToByte(this.dataLen, data, offset += 2);
            ByteConversion.longToByte(this.nextDataPage, data, offset += 4);
            ByteConversion.longToByte(this.prevDataPage, data, offset += 8);
            ByteConversion.shortToByte(this.tid, data, offset += 8);
            return offset + 2;
        }

        public void setDataLength(int len) {
            this.dataLen = len;
        }

        public void setNextDataPage(long page) {
            this.nextDataPage = page;
        }

        public void setPrevDataPage(long page) {
            this.prevDataPage = page;
        }

        public void setRecordCount(short recs) {
            this.records = recs;
        }
    }

    private final class DOMFileHeader
    extends BTree.BTreeFileHeader {
        protected LinkedList reserved;

        public DOMFileHeader() {
            this.reserved = new LinkedList();
        }

        public DOMFileHeader(long pageCount) {
            super(pageCount);
            this.reserved = new LinkedList();
        }

        public DOMFileHeader(long pageCount, int pageSize) {
            super(pageCount, pageSize);
            this.reserved = new LinkedList();
        }

        public DOMFileHeader(long pageCount, int pageSize, byte blockSize) {
            super(pageCount, pageSize, blockSize);
            this.reserved = new LinkedList();
        }

        public DOMFileHeader(boolean read) throws IOException {
            super(read);
            this.reserved = new LinkedList();
        }

        public void addReservedPage(long page) {
            this.reserved.addFirst(new Long(page));
        }

        public long getReservedPage() {
            if (this.reserved.size() == 0) {
                return -1L;
            }
            return (Long)this.reserved.removeLast();
        }

        public void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            int rp = raf.readInt();
            for (int i = 0; i < rp; ++i) {
                long l = raf.readLong();
                this.reserved.addFirst(new Long(l));
            }
        }

        public void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeInt(this.reserved.size());
            Iterator i = this.reserved.iterator();
            while (i.hasNext()) {
                Long l = (Long)i.next();
                raf.writeLong(l);
            }
        }
    }
}

