/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.store;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.indexer.IndexQuery;
import org.exist.storage.BufferStats;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRUCache;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.store.BFileCallback;
import org.exist.storage.store.FreeList;
import org.exist.storage.store.FreeSpace;
import org.exist.storage.store.StorageAddress;
import org.exist.util.ByteArray;
import org.exist.util.ByteConversion;
import org.exist.util.FastByteBuffer;
import org.exist.util.FixedByteArray;
import org.exist.util.IndexCallback;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.util.ReentrantReadWriteLock;
import org.exist.xquery.TerminatedException;

public class BFile
extends BTree {
    private static final Logger LOG = Logger.getLogger((Class)BFile.class);
    public static final short FILE_FORMAT_VERSION_ID = 3;
    public static final long DATA_SYNC_PERIOD = 15000L;
    public static final int PAGE_MIN_FREE = 64;
    public static final byte RECORD = 20;
    public static final byte LOB = 21;
    public static final byte FREE_LIST = 22;
    public static final byte MULTI_PAGE = 23;
    protected BFileHeader fileHeader = (BFileHeader)this.getFileHeader();
    protected int minFree;
    protected Cache dataCache = null;
    protected Lock lock = null;
    public int fixedKeyLen = -1;

    public BFile(File file, int btreeBuffers, int dataBuffers) {
        super(file, btreeBuffers);
        this.dataCache = new LRUCache(dataBuffers);
        this.dataCache.setFileName(this.getFile().getName());
        this.minFree = 64;
        this.lock = new ReentrantReadWriteLock(file.getName());
    }

    public short getFileVersion() {
        return 3;
    }

    public Lock getLock() {
        return this.lock;
    }

    protected long getDataSyncPeriod() {
        return 15000L;
    }

    /*
     * Loose catch block
     */
    public long append(Value key, ByteArray value) throws ReadOnlyException, IOException {
        if (key == null) {
            LOG.debug((Object)"key is null");
            return -1L;
        }
        try {
            long p;
            block10: {
                int l;
                int offset;
                byte[] data;
                int valueLen;
                DataPage page;
                block11: {
                    p = this.findValue(key);
                    if (p == -1L) {
                        p = this.storeValue(value);
                        this.addValue(key, p);
                        return p;
                    }
                    long pnum = StorageAddress.pageFromPointer(p);
                    short tid = StorageAddress.tidFromPointer(p);
                    page = this.getDataPage(pnum);
                    if (page instanceof OverflowPage) {
                        ((OverflowPage)page).append(value);
                        break block10;
                    }
                    valueLen = value.size();
                    data = page.getData();
                    offset = page.findValuePosition(tid);
                    if (offset < 0) {
                        throw new IOException("tid " + tid + " not found on page " + pnum);
                    }
                    l = ByteConversion.byteToInt(data, offset);
                    if (offset + 4 > data.length || offset < 0) {
                        LOG.error((Object)("wrong pointer (tid: " + tid + page.getPageInfo() + ") in file " + this.getFile().getName() + "; offset = " + offset));
                        return -1L;
                    }
                    if (offset + 4 + l <= data.length) break block11;
                    LOG.error((Object)("found invalid data record (" + page.getPageInfo() + "): " + "length=" + data.length + "; required=" + (offset + 4 + l)));
                    return -1L;
                }
                byte[] newData = new byte[l + valueLen];
                System.arraycopy(data, offset + 4, newData, 0, l);
                value.copyTo(newData, l);
                p = this.update(p, page, key, new FixedByteArray(newData, 0, newData.length));
            }
            return p;
        }
        catch (BTreeException bte) {
            long p = this.storeValue(value);
            this.addValue(key, p);
            return p;
            {
                catch (BTreeException bte2) {
                    LOG.warn((Object)"btree exception while appending value", (Throwable)bte2);
                    return -1L;
                }
            }
        }
    }

    public boolean close() throws DBException {
        super.close();
        return true;
    }

    public boolean containsKey(Value key) {
        try {
            return this.findValue(key) != -1L;
        }
        catch (BTreeException bte) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean create() throws DBException {
        if (super.create((short)this.fixedKeyLen, this.lock)) {
            this.fileHeader.setLastDataPage(-1L);
            return true;
        }
        return false;
    }

    private SinglePage createDataPage() {
        try {
            SinglePage page = new SinglePage();
            this.dataCache.add(page, 2);
            return page;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return null;
        }
    }

    public Paged.FileHeader createFileHeader() {
        return new BFileHeader(PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(boolean read) throws IOException {
        return new BFileHeader(PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(long pageCount) {
        return new BFileHeader(PAGE_SIZE);
    }

    public Paged.FileHeader createFileHeader(long pageCount, int pageSize) {
        return new BFileHeader(pageSize);
    }

    public Paged.PageHeader createPageHeader() {
        return new BFilePageHeader();
    }

    public void removeAll(IndexQuery query) throws IOException, BTreeException {
        block2: {
            try {
                this.remove(query, new BTreeCallback(){

                    public boolean indexInfo(Value value, long pointer) throws TerminatedException {
                        try {
                            BFile.this.remove(pointer);
                            return true;
                        }
                        catch (ReadOnlyException e) {
                            LOG.debug((Object)"file is read-only");
                            return false;
                        }
                    }
                });
            }
            catch (TerminatedException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"removeAll() - method has been terminated.");
            }
        }
    }

    public ArrayList findEntries(IndexQuery query) throws IOException, BTreeException, TerminatedException {
        FindCallback cb = new FindCallback(2);
        this.query(query, cb);
        return cb.getValues();
    }

    public ArrayList findKeys(IndexQuery query) throws IOException, BTreeException, TerminatedException {
        FindCallback cb = new FindCallback(1);
        this.query(query, cb);
        return cb.getValues();
    }

    public void find(IndexQuery query, IndexCallback callback) throws IOException, BTreeException, TerminatedException {
        FindCallback cb = new FindCallback(callback);
        this.query(query, cb);
    }

    public boolean flush() throws DBException {
        this.dataCache.flush();
        super.flush();
        return true;
    }

    public BufferStats getDataBufferStats() {
        if (this.dataCache != null) {
            return new BufferStats(this.dataCache.getBuffers(), this.dataCache.getUsedBuffers(), this.dataCache.getHits(), this.dataCache.getFails());
        }
        return null;
    }

    public void printStatistics() {
        super.printStatistics();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getName()).append(" DATA ");
        buf.append(this.dataCache.getBuffers()).append(" / ");
        buf.append(this.dataCache.getUsedBuffers()).append(" / ");
        buf.append(this.dataCache.getHits()).append(" / ");
        buf.append(this.dataCache.getFails());
        LOG.info((Object)buf.toString());
    }

    public Value get(Value key) {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return null;
            }
            long pnum = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            return this.get(page, p);
        }
        catch (BTreeException b) {
            LOG.debug((Object)("key " + key + " not found"));
        }
        catch (IOException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public VariableByteInput getAsStream(Value key) throws IOException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return null;
            }
            long pnum = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            switch (page.getPageHeader().getStatus()) {
                case 23: {
                    return ((OverflowPage)page).getDataStream(p);
                }
            }
            return this.getAsStream(page, p);
        }
        catch (BTreeException b) {
            LOG.debug((Object)("key " + key + " not found"));
            return null;
        }
    }

    public VariableByteInput getAsStream(long pointer) throws IOException {
        DataPage page = this.getDataPage(StorageAddress.pageFromPointer(pointer));
        switch (page.getPageHeader().getStatus()) {
            case 23: {
                return ((OverflowPage)page).getDataStream(pointer);
            }
        }
        return this.getAsStream(page, pointer);
    }

    private VariableByteInput getAsStream(DataPage page, long pointer) throws IOException {
        this.dataCache.add(page.getFirstPage(), 2);
        short tid = StorageAddress.tidFromPointer(pointer);
        int offset = page.findValuePosition(tid);
        if (offset < 0) {
            throw new IOException("no data found at tid " + tid + "; page " + page.getPageNum());
        }
        byte[] data = page.getData();
        int l = ByteConversion.byteToInt(data, offset);
        SimplePageInput input = new SimplePageInput(data, offset + 4, l, pointer);
        return input;
    }

    public Value get(long p) {
        try {
            long pnum = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pnum);
            return this.get(page, p);
        }
        catch (BTreeException b) {
        }
        catch (IOException e) {
            LOG.debug((Object)e);
        }
        return null;
    }

    protected Value get(DataPage page, long p) throws BTreeException, IOException {
        byte[] data;
        short tid = StorageAddress.tidFromPointer(p);
        int offset = page.findValuePosition(tid);
        if (offset > (data = page.getData()).length || offset < 0) {
            LOG.error((Object)("wrong pointer (tid: " + tid + page.getPageInfo() + ") in file " + this.getFile().getName() + "; offset = " + offset));
            return null;
        }
        int l = ByteConversion.byteToInt(data, offset);
        if (l + 6 > data.length) {
            LOG.error((Object)(this.getFile().getName() + " wrong data length in page " + page.getPageNum() + ": expected=" + (l + 6) + "; found=" + data.length));
            return null;
        }
        this.dataCache.add(page.getFirstPage());
        Value v = new Value(data, offset + 4, l);
        v.setAddress(p);
        return v;
    }

    private DataPage getDataPage(long pos) throws IOException {
        return this.getDataPage(pos, true);
    }

    private DataPage getDataPage(long pos, boolean initialize) throws IOException {
        DataPage wp = (DataPage)this.dataCache.get(pos);
        if (wp == null) {
            Paged.Page page = this.getPage(pos);
            if (page == null) {
                LOG.debug((Object)("page " + pos + " not found!"));
                return null;
            }
            byte[] data = page.read();
            if (page.getPageHeader().getStatus() == 23) {
                return new OverflowPage(page, data);
            }
            return new SinglePage(page, data, initialize);
        }
        if (wp.getPageHeader().getStatus() == 23) {
            return new OverflowPage(wp);
        }
        return wp;
    }

    public ArrayList getEntries() throws IOException, BTreeException, TerminatedException {
        IndexQuery query = new IndexQuery(0, "");
        FindCallback cb = new FindCallback(2);
        this.query(query, cb);
        return cb.getValues();
    }

    public ArrayList getKeys() throws IOException, BTreeException, TerminatedException {
        IndexQuery query = new IndexQuery(0, "");
        FindCallback cb = new FindCallback(1);
        this.query(query, cb);
        return cb.getValues();
    }

    public ArrayList getValues() throws IOException, BTreeException, TerminatedException {
        IndexQuery query = new IndexQuery(0, "");
        FindCallback cb = new FindCallback(0);
        this.query(query, cb);
        return cb.getValues();
    }

    public boolean open() throws DBException {
        return super.open((short)3, this.lock);
    }

    public long put(Value key, byte[] data, boolean overwrite) throws ReadOnlyException {
        FastByteBuffer buf = new FastByteBuffer(5);
        buf.append(data);
        return this.put(key, buf, overwrite);
    }

    public long put(Value key, ByteArray value) throws ReadOnlyException {
        return this.put(key, value, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long put(Value key, ByteArray value, boolean overwrite) throws ReadOnlyException {
        if (key == null) {
            LOG.debug((Object)"key is null");
            return -1L;
        }
        try {
            try {
                long p = this.findValue(key);
                if (p == -1L) {
                    p = this.storeValue(value);
                    this.addValue(key, p);
                    return p;
                }
                if (overwrite) {
                    return this.update(p, key, value);
                }
                return -1L;
            }
            catch (BTreeException bte) {
                long p = this.storeValue(value);
                this.addValue(key, p);
                return p;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return -1L;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn((Object)e);
            return -1L;
        }
        catch (BTreeException bte) {
            bte.printStackTrace();
            LOG.warn((Object)bte);
            return -1L;
        }
    }

    public void remove(Value key) throws ReadOnlyException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return;
            }
            long pos = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pos);
            this.remove(page, p);
            this.removeValue(key);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
    }

    public void remove(long p) throws ReadOnlyException {
        try {
            long pos = StorageAddress.pageFromPointer(p);
            DataPage page = this.getDataPage(pos);
            this.remove(page, p);
        }
        catch (BTreeException e) {
            LOG.debug((Object)"btree problem", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Object)"io problem", (Throwable)e);
        }
    }

    private void remove(DataPage page, long p) throws BTreeException, IOException, ReadOnlyException {
        byte[] data;
        if (page.getPageHeader().getStatus() == 23) {
            page.delete();
            return;
        }
        short tid = StorageAddress.tidFromPointer(p);
        int offset = page.findValuePosition(tid);
        if (offset > (data = page.getData()).length || offset < 0) {
            LOG.error((Object)("wrong pointer (tid: " + tid + ", " + page.getPageInfo() + ")"));
            return;
        }
        int l = ByteConversion.byteToInt(data, offset);
        int end = offset + 4 + l;
        int len = page.getPageHeader().getDataLength();
        System.arraycopy(data, end, data, offset - 2, len - end);
        page.getPageHeader().setDirty(true);
        page.getPageHeader().decRecordCount();
        len = len - l - 6;
        page.getPageHeader().setDataLength(len);
        page.setDirty(true);
        if (len == 0) {
            this.fileHeader.removeFreeSpace(this.fileHeader.getFreeSpace(page.getPageNum()));
            this.dataCache.remove(page);
            page.delete();
        } else {
            page.removeTID(tid, l + 6);
            int newFree = this.fileHeader.getWorkSize() - len;
            if (newFree > this.minFree) {
                FreeSpace free = this.fileHeader.getFreeSpace(page.getPageNum());
                if (free == null) {
                    free = new FreeSpace(page.getPageNum(), newFree);
                    this.fileHeader.addFreeSpace(free);
                } else {
                    free.setFree(newFree);
                }
            }
            this.dataCache.add(page, 2);
        }
    }

    private final void saveFreeSpace(FreeSpace space, DataPage page) {
        int free = this.fileHeader.getWorkSize() - page.getPageHeader().getDataLength();
        space.setFree(free);
        if (free < this.minFree) {
            this.fileHeader.removeFreeSpace(space);
        }
    }

    public void setLocation(String location) {
        this.setFile(new File(location + ".dbx"));
    }

    private long storeValue(ByteArray value) throws IOException, ReadOnlyException {
        int vlen = value.size();
        if (6 + vlen > this.fileHeader.getWorkSize()) {
            OverflowPage page = new OverflowPage();
            byte[] data = new byte[vlen + 6];
            page.getPageHeader().setDataLength(vlen + 6);
            ByteConversion.shortToByte((short)1, data, 0);
            ByteConversion.intToByte(vlen, data, 2);
            value.copyTo(data, 6);
            page.setData(data);
            page.setDirty(true);
            return StorageAddress.createPointer((int)page.getPageNum(), (short)1);
        }
        DataPage page = null;
        short tid = -1;
        FreeSpace free = null;
        int realSpace = 0;
        while (tid < 0) {
            free = this.fileHeader.findFreeSpace(vlen + 6);
            if (free == null) {
                page = this.createDataPage();
                page.setData(new byte[this.fileHeader.getWorkSize()]);
                free = new FreeSpace(page.getPageNum(), this.fileHeader.getWorkSize() - page.getPageHeader().getDataLength());
                this.fileHeader.addFreeSpace(free);
            } else {
                page = this.getDataPage(free.getPage());
                if (page.getPageHeader().getStatus() != 20) {
                    LOG.warn((Object)("page " + page.getPageNum() + " is not a data page; removing it"));
                    this.fileHeader.removeFreeSpace(free);
                    continue;
                }
                realSpace = this.fileHeader.getWorkSize() - page.getPageHeader().getDataLength();
                if (realSpace < 6 + vlen) {
                    LOG.warn((Object)("wrong data length in list of free pages: adjusting to " + realSpace));
                    free.setFree(realSpace);
                    continue;
                }
            }
            if ((tid = page.getNextTID()) >= 0) continue;
            LOG.info((Object)("removing page " + page.getPageNum() + " from free pages"));
            this.fileHeader.removeFreeSpace(free);
        }
        int len = page.getPageHeader().getDataLength();
        byte[] data = page.getData();
        ByteConversion.shortToByte(tid, data, len);
        page.setOffset(tid, len += 2);
        ByteConversion.intToByte(vlen, data, len);
        value.copyTo(data, len += 4);
        page.getPageHeader().setDataLength(len += vlen);
        page.getPageHeader().incRecordCount();
        this.saveFreeSpace(free, page);
        page.setDirty(true);
        this.dataCache.add(page);
        return StorageAddress.createPointer((int)page.getPageNum(), tid);
    }

    public long update(Value key, ByteArray value) throws ReadOnlyException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                return -1L;
            }
            return this.update(p, key, value);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
        }
        catch (IOException ioe) {
            LOG.debug((Object)ioe);
        }
        return -1L;
    }

    public long update(long p, Value key, ByteArray value) throws ReadOnlyException {
        try {
            return this.update(p, this.getDataPage(StorageAddress.pageFromPointer(p)), key, value);
        }
        catch (BTreeException bte) {
            LOG.debug((Object)bte);
            return -1L;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
            return -1L;
        }
    }

    protected long update(long p, DataPage page, Value key, ByteArray value) throws BTreeException, IOException, ReadOnlyException {
        if (page.getPageHeader().getStatus() == 23) {
            int valueLen = value.size();
            if (valueLen + 6 < this.fileHeader.getWorkSize()) {
                this.remove(page, p);
                long np = this.storeValue(value);
                this.addValue(key, np);
                return np;
            }
            byte[] data = new byte[valueLen + 6];
            ByteConversion.shortToByte((short)1, data, 0);
            ByteConversion.intToByte(valueLen, data, 2);
            value.copyTo(data, 6);
            page.setData(data);
            return p;
        }
        this.remove(page, p);
        long np = this.storeValue(value);
        this.addValue(key, np);
        return np;
    }

    public void debugFreeList() {
        this.fileHeader.debugFreeList();
    }

    private final class SinglePage
    extends DataPage {
        byte[] data;
        Paged.Page page;
        BFilePageHeader ph;
        short[] offsets;

        public SinglePage() throws IOException {
            this(true);
        }

        public SinglePage(boolean compress) throws IOException {
            this.data = null;
            this.offsets = null;
            this.page = BFile.this.getFreePage();
            this.ph = (BFilePageHeader)this.page.getPageHeader();
            this.ph.setStatus((byte)20);
            this.ph.setDirty(true);
            this.ph.setDataLength(0);
            BFile.this.fileHeader.setLastDataPage(this.page.getPageNum());
            this.data = new byte[BFile.this.fileHeader.getWorkSize()];
            this.offsets = new short[32];
            this.ph.nextTID = (short)32;
            Arrays.fill(this.offsets, (short)-1);
        }

        public SinglePage(Paged.Page p, byte[] data, boolean initialize) throws IOException {
            this.data = null;
            this.offsets = null;
            if (p == null) {
                throw new IOException("illegal page");
            }
            if (p.getPageHeader().getStatus() != 20 && p.getPageHeader().getStatus() != 23) {
                LOG.debug((Object)("not a data-page: " + p.getPageInfo()));
                throw new IOException("not a data-page: " + p.getPageHeader().getStatus());
            }
            this.data = data;
            this.page = p;
            this.ph = (BFilePageHeader)this.page.getPageHeader();
            if (initialize) {
                this.offsets = new short[this.ph.nextTID];
                this.readOffsets();
            }
        }

        public final int findValuePosition(short tid) throws IOException {
            return this.offsets[tid];
        }

        private void readOffsets() throws IOException {
            Arrays.fill(this.offsets, (short)-1);
            int dlen = this.ph.getDataLength();
            int pos = 0;
            while (pos < dlen) {
                short tid = ByteConversion.byteToShort(this.data, pos);
                if (tid >= this.offsets.length) {
                    LOG.error((Object)("Problematic tid found: " + tid + "; trying to recover ..."));
                    short[] t = new short[tid + 1];
                    Arrays.fill(t, (short)-1);
                    System.arraycopy(this.offsets, 0, t, 0, this.offsets.length);
                    this.offsets = t;
                    this.ph.nextTID = (short)(tid + 1);
                }
                this.offsets[tid] = (short)(pos + 2);
                pos = (short)(pos + (ByteConversion.byteToInt(this.data, pos + 2) + 6));
            }
        }

        public short getNextTID() {
            for (short i = 0; i < this.offsets.length; i = (short)(i + 1)) {
                if (this.offsets[i] != -1) continue;
                return i;
            }
            short tid = (short)this.offsets.length;
            short next = (short)(this.ph.nextTID * 2);
            if (next < 0 || next < this.ph.nextTID) {
                return -1;
            }
            short[] t = new short[next];
            Arrays.fill(t, (short)-1);
            System.arraycopy(this.offsets, 0, t, 0, this.offsets.length);
            this.offsets = t;
            this.ph.nextTID = next;
            return tid;
        }

        private String printContents() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.offsets.length; i = (int)((short)(i + 1))) {
                buf.append('[').append(i).append(", ").append(this.offsets[i]).append(']');
            }
            return buf.toString();
        }

        public void setOffset(short tid, int offset) {
            this.offsets[tid] = (short)offset;
        }

        public void removeTID(short tid, int length) throws IOException {
            int offset = this.offsets[tid] - 2;
            this.offsets[tid] = -1;
            for (int i = 0; i < this.offsets.length; i = (int)((short)(i + 1))) {
                if (this.offsets[i] <= offset) continue;
                int n = i;
                this.offsets[n] = (short)(this.offsets[n] - length);
            }
        }

        public void delete() throws IOException {
            this.ph.setDataLength(0);
            this.ph.setNextInChain(-1L);
            this.ph.setLastInChain(-1L);
            this.ph.setTID((short)-1);
            this.ph.setRecordCount((short)0);
            this.setReferenceCount(0);
            this.ph.setDirty(true);
            BFile.this.unlinkPages(this.page);
        }

        public SinglePage getFirstPage() {
            return this;
        }

        public byte[] getData() {
            return this.data;
        }

        public BFilePageHeader getPageHeader() {
            return this.ph;
        }

        public String getPageInfo() {
            return this.page.getPageInfo();
        }

        public long getPageNum() {
            return this.page.getPageNum();
        }

        public void setData(byte[] buf) {
            this.data = buf;
        }

        public void write() throws IOException {
            BFile.this.writeValue(this.page, new Value(this.data));
            this.setDirty(false);
        }
    }

    private final class MultiPageInput
    implements VariableByteInput,
    PageInputStream {
        private SinglePage nextPage;
        private int pageLen;
        private int offset = 0;
        private long address = 0L;

        public MultiPageInput() {
        }

        public MultiPageInput(SinglePage first, long address) {
            this.nextPage = first;
            this.offset = 6;
            this.pageLen = BFile.this.fileHeader.getWorkSize();
            BFile.this.dataCache.add(first, 3);
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }

        public final int read() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            return this.nextPage.data[this.offset++] & 0xFF;
        }

        public final byte readByte() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            return this.nextPage.data[this.offset++];
        }

        public final short readShort() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            byte b = this.nextPage.data[this.offset++];
            short i = (short)(b & 0x7F);
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                b = this.nextPage.data[this.offset++];
                i = (short)(i | (b & 0x7F) << shift);
                shift += 7;
            }
            return i;
        }

        public final int readInt() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            byte b = this.nextPage.data[this.offset++];
            int i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                b = this.nextPage.data[this.offset++];
                i |= (b & 0x7F) << shift;
                shift += 7;
            }
            return i;
        }

        public final long readLong() throws IOException {
            if (this.offset == this.pageLen) {
                this.advance();
            }
            byte b = this.nextPage.data[this.offset++];
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                b = this.nextPage.data[this.offset++];
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            return i;
        }

        public final void skip(int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                do {
                    if (this.offset != this.pageLen) continue;
                    this.advance();
                } while ((this.nextPage.data[this.offset++] & 0x80) > 0);
            }
        }

        public final void skipBytes(long count) throws IOException {
            for (long i = 0L; i < count; ++i) {
                if (this.offset++ != this.pageLen) continue;
                this.advance();
            }
        }

        private final void advance() throws IOException {
            long next = this.nextPage.getPageHeader().getNextInChain();
            if (next < 1L) {
                this.pageLen = -1;
                this.offset = 0;
                throw new EOFException();
            }
            try {
                BFile.this.lock.acquire(0);
                this.nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                this.pageLen = this.nextPage.ph.getDataLength();
                this.offset = 0;
                BFile.this.dataCache.add(this.nextPage);
            }
            catch (LockException e) {
                throw new IOException("failed to acquire a read lock on " + BFile.this.getFile().getName());
            }
            finally {
                BFile.this.lock.release();
            }
        }

        public final int available() throws IOException {
            return this.pageLen < 0 ? 0 : this.pageLen;
        }

        public final int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            if (this.pageLen < 0) {
                return -1;
            }
            for (int i = 0; i < len; ++i) {
                if (this.offset == this.pageLen) {
                    long next = this.nextPage.getPageHeader().getNextInChain();
                    if (next < 1L) {
                        this.pageLen = -1;
                        this.offset = 0;
                        return i;
                    }
                    this.nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                    this.pageLen = this.nextPage.ph.getDataLength();
                    this.offset = 0;
                    BFile.this.dataCache.add(this.nextPage);
                }
                b[off + i] = this.nextPage.data[this.offset++];
            }
            return len;
        }

        public final String readUTF() throws IOException, EOFException {
            String s;
            int len = this.readInt();
            byte[] data = new byte[len];
            this.read(data);
            try {
                s = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                s = new String(data);
            }
            return s;
        }

        public final void copyTo(VariableByteOutputStream os) throws IOException {
            byte more;
            do {
                if (this.offset == this.pageLen) {
                    this.advance();
                }
                more = this.nextPage.data[this.offset++];
                os.writeByte(more);
            } while ((more = (byte)(more & 0x80)) > 0);
        }

        public final void copyTo(VariableByteOutputStream os, int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                byte more;
                do {
                    if (this.offset == this.pageLen) {
                        this.advance();
                    }
                    more = this.nextPage.data[this.offset++];
                    os.writeByte(more);
                } while ((more & 0x200) > 0);
            }
        }
    }

    private final class SimplePageInput
    extends VariableByteArrayInput
    implements PageInputStream {
        private long address;

        public SimplePageInput() {
            this.address = 0L;
        }

        public SimplePageInput(byte[] data, int start, int len, long address) {
            super(data, start, len);
            this.address = 0L;
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }
    }

    public static interface PageInputStream {
        public long getAddress();
    }

    private final class OverflowPage
    extends DataPage {
        byte[] data;
        SinglePage firstPage;

        public OverflowPage() throws IOException {
            this.data = null;
            this.firstPage = new SinglePage(false);
            BFilePageHeader ph = this.firstPage.getPageHeader();
            ph.setStatus((byte)23);
            ph.setNextInChain(0L);
            ph.setLastInChain(0L);
            ph.setDataLength(0);
            this.firstPage.setData(new byte[BFile.this.fileHeader.getWorkSize()]);
            BFile.this.dataCache.add(this.firstPage, 3);
        }

        public OverflowPage(DataPage page) {
            this.data = null;
            this.firstPage = (SinglePage)page;
        }

        public OverflowPage(Paged.Page p, byte[] data) throws IOException {
            this.data = null;
            this.firstPage = new SinglePage(p, data, false);
            this.firstPage.getPageHeader().setStatus((byte)23);
        }

        public void append(ByteArray chunk) throws IOException {
            BFilePageHeader ph = this.firstPage.getPageHeader();
            long next = ph.getLastInChain();
            DataPage page = next > 0L ? BFile.this.getDataPage(next, false) : this.firstPage;
            ph = page.getPageHeader();
            int chunkSize = BFile.this.fileHeader.getWorkSize() - ph.getDataLength();
            int chunkLen = chunk.size();
            if (chunkLen < chunkSize) {
                chunkSize = chunkLen;
            }
            chunk.copyTo(0, page.getData(), ph.getDataLength(), chunkSize);
            ph.setDataLength(ph.getDataLength() + chunkSize);
            page.setDirty(true);
            int remaining = chunkLen - chunkSize;
            int current = chunkSize;
            chunkSize = BFile.this.fileHeader.getWorkSize();
            if (remaining > 0) {
                while (remaining > 0) {
                    SinglePage nextPage = BFile.this.createDataPage();
                    nextPage.setData(new byte[BFile.this.fileHeader.getWorkSize()]);
                    page.getPageHeader().setNextInChain(nextPage.getPageNum());
                    page.setDirty(true);
                    BFile.this.dataCache.add(page);
                    page = nextPage;
                    if (remaining < chunkSize) {
                        chunkSize = remaining;
                    }
                    chunk.copyTo(current, page.getData(), 0, chunkSize);
                    page.setDirty(true);
                    if (page != this.firstPage) {
                        page.getPageHeader().setDataLength(chunkSize);
                    }
                    remaining -= chunkSize;
                    current += chunkSize;
                }
            }
            ph = this.firstPage.getPageHeader();
            if (page != this.firstPage) {
                BFile.this.dataCache.add(page);
                ph.setLastInChain(page.getPageNum());
                ph.setDataLength(ph.getDataLength() + chunkLen);
            } else {
                ph.setLastInChain(0L);
            }
            ByteConversion.intToByte(this.firstPage.getPageHeader().getDataLength() - 6, this.firstPage.getData(), 2);
            this.firstPage.setDirty(true);
            BFile.this.dataCache.add(this.firstPage, 2);
        }

        public void delete() throws IOException {
            long next = this.firstPage.getPageNum();
            SinglePage page = this.firstPage;
            do {
                next = page.getPageHeader().getNextInChain();
                page.getPageHeader().setNextInChain(-1L);
                page.setDirty(true);
                BFile.this.dataCache.remove(page);
                page.delete();
                if (next <= 0L) continue;
                page = (SinglePage)BFile.this.getDataPage(next, false);
            } while (next > 0L);
        }

        public VariableByteInput getDataStream(long pointer) {
            MultiPageInput input = new MultiPageInput(this.firstPage, pointer);
            return input;
        }

        public byte[] getData() throws IOException {
            long next;
            if (this.data != null) {
                return this.data;
            }
            SinglePage page = this.firstPage;
            ByteArrayOutputStream os = new ByteArrayOutputStream(page.getPageHeader().getDataLength());
            do {
                byte[] temp = page.getData();
                next = page.getPageHeader().getNextInChain();
                int len = next > 0L ? BFile.this.fileHeader.getWorkSize() : page.getPageHeader().getDataLength();
                os.write(temp, 0, len);
                if (next <= 0L) continue;
                page = (SinglePage)BFile.this.getDataPage(next, false);
                BFile.this.dataCache.add(page);
            } while (next > 0L);
            this.data = os.toByteArray();
            if (this.data.length != this.firstPage.getPageHeader().getDataLength()) {
                LOG.warn((Object)(BFile.this.getFile().getName() + " read=" + this.data.length + "; expected=" + this.firstPage.getPageHeader().getDataLength()));
            }
            return this.data;
        }

        public SinglePage getFirstPage() {
            return this.firstPage;
        }

        public BFilePageHeader getPageHeader() {
            return this.firstPage.getPageHeader();
        }

        public String getPageInfo() {
            return "MULTI_PAGE: " + this.firstPage.getPageInfo();
        }

        public long getPageNum() {
            return this.firstPage.getPageNum();
        }

        public void setData(byte[] data) {
            this.data = data;
            try {
                this.write();
            }
            catch (IOException e) {
                LOG.warn((Object)e);
            }
        }

        public void write() throws IOException {
            SinglePage nextPage;
            if (this.data == null) {
                return;
            }
            int chunkSize = BFile.this.fileHeader.getWorkSize();
            int remaining = this.data.length;
            int current = 0;
            long next = 0L;
            SinglePage page = this.firstPage;
            page.getPageHeader().setDataLength(remaining);
            while (remaining > 0) {
                if (remaining < chunkSize) {
                    chunkSize = remaining;
                }
                System.arraycopy(this.data, current, page.getData(), 0, chunkSize);
                if (page != this.firstPage) {
                    page.getPageHeader().setDataLength(chunkSize);
                }
                page.setDirty(true);
                current += chunkSize;
                next = page.getPageHeader().getNextInChain();
                if ((remaining -= chunkSize) > 0) {
                    if (next > 0L) {
                        nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                        BFile.this.dataCache.add(page);
                        page = nextPage;
                        continue;
                    }
                    nextPage = BFile.this.createDataPage();
                    nextPage.setData(new byte[BFile.this.fileHeader.getWorkSize()]);
                    nextPage.getPageHeader().setNextInChain(0L);
                    page.getPageHeader().setNextInChain(nextPage.getPageNum());
                    BFile.this.dataCache.add(page);
                    page = nextPage;
                    continue;
                }
                page.getPageHeader().setNextInChain(0L);
                if (page != this.firstPage) {
                    page.setDirty(true);
                    BFile.this.dataCache.add(page);
                    this.firstPage.getPageHeader().setLastInChain(page.getPageNum());
                } else {
                    this.firstPage.getPageHeader().setLastInChain(0L);
                }
                this.firstPage.setDirty(true);
                BFile.this.dataCache.add(this.firstPage, 3);
            }
            if (next > 0L) {
                while (next > 0L) {
                    nextPage = (SinglePage)BFile.this.getDataPage(next, false);
                    next = nextPage.getPageHeader().getNextInChain();
                    nextPage.setDirty(true);
                    nextPage.delete();
                    BFile.this.dataCache.remove(nextPage);
                }
            }
        }

        public int findValuePosition(short tid) throws IOException {
            return 2;
        }

        public short getNextTID() {
            return 1;
        }

        public void removeTID(short tid, int length) {
        }

        public void setOffset(short tid, int offset) {
        }
    }

    private final class FindCallback
    implements BTreeCallback {
        public static final int BOTH = 2;
        public static final int KEYS = 1;
        public static final int VALUES = 0;
        private int mode = 0;
        private IndexCallback callback = null;
        private ArrayList values = null;

        public FindCallback(int mode) {
            this.mode = mode;
            this.values = new ArrayList();
        }

        public FindCallback(IndexCallback callback) {
            this.mode = 2;
            this.callback = callback;
        }

        public ArrayList getValues() {
            return this.values;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            try {
                switch (this.mode) {
                    case 0: {
                        long pos = StorageAddress.pageFromPointer(pointer);
                        short tid = StorageAddress.tidFromPointer(pointer);
                        DataPage page = BFile.this.getDataPage(pos);
                        BFile.this.dataCache.add(page.getFirstPage());
                        int offset = page.findValuePosition(tid);
                        byte[] data = page.getData();
                        int l = ByteConversion.byteToInt(data, offset);
                        Value v = new Value(data, offset + 4, l);
                        v.setAddress(pointer);
                        if (this.callback != null) {
                            return this.callback.indexInfo(value, v);
                        }
                        this.values.add(v);
                        return true;
                    }
                    case 1: {
                        value.setAddress(pointer);
                        if (this.callback != null) {
                            return this.callback.indexInfo(value, null);
                        }
                        this.values.add(value);
                        return true;
                    }
                    case 2: {
                        Value[] entry = new Value[2];
                        entry[0] = value;
                        long pos = StorageAddress.pageFromPointer(pointer);
                        short tid = StorageAddress.tidFromPointer(pointer);
                        DataPage page = BFile.this.getDataPage(pos);
                        BFile.this.dataCache.add(page);
                        int offset = page.findValuePosition(tid);
                        byte[] data = page.getData();
                        int l = ByteConversion.byteToInt(data, offset);
                        Value v = new Value(data, offset + 4, l);
                        v.setAddress(pointer);
                        entry[1] = v;
                        if (this.callback != null) {
                            return this.callback.indexInfo(value, v);
                        }
                        this.values.add(entry);
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private final class FilterCallback
    implements BTreeCallback {
        BFileCallback callback;

        public FilterCallback(BFileCallback callback) {
            this.callback = callback;
        }

        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            try {
                long pos = StorageAddress.pageFromPointer(pointer);
                short tid = StorageAddress.tidFromPointer(pointer);
                DataPage page = BFile.this.getDataPage(pos);
                int offset = page.findValuePosition(tid);
                byte[] data = page.getData();
                int l = ByteConversion.byteToInt(data, offset);
                Value v = new Value(data, offset + 4, l);
                this.callback.info(value, v);
                return true;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return true;
            }
        }
    }

    private abstract class DataPage
    implements Comparable,
    Cacheable {
        int refCount = 0;
        int timestamp = 0;
        boolean saved = true;

        private DataPage() {
        }

        public abstract void delete() throws IOException;

        public abstract byte[] getData() throws IOException;

        public abstract BFilePageHeader getPageHeader();

        public abstract String getPageInfo();

        public abstract long getPageNum();

        public abstract int findValuePosition(short var1) throws IOException;

        public abstract short getNextTID();

        public abstract void removeTID(short var1, int var2) throws IOException;

        public abstract void setOffset(short var1, int var2);

        public long getKey() {
            return this.getPageNum();
        }

        public int getReferenceCount() {
            return this.refCount;
        }

        public int incReferenceCount() {
            if (this.refCount < 10000) {
                ++this.refCount;
            }
            return this.refCount;
        }

        public int decReferenceCount() {
            return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
        }

        public void setReferenceCount(int count) {
            this.refCount = count;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public boolean sync() {
            if (this.isDirty()) {
                try {
                    this.write();
                    return true;
                }
                catch (IOException e) {
                    LOG.error((Object)("IO exception occurred while saving page " + this.getPageNum()));
                }
            }
            return false;
        }

        public boolean isDirty() {
            return !this.saved;
        }

        public boolean allowUnload() {
            return true;
        }

        public abstract void setData(byte[] var1);

        public abstract SinglePage getFirstPage();

        public void setDirty(boolean dirty) {
            this.saved = !dirty;
            this.getPageHeader().setDirty(dirty);
        }

        public abstract void write() throws IOException;

        public int compareTo(Object other) {
            if (this.getPageNum() == ((DataPage)other).getPageNum()) {
                return 0;
            }
            if (this.getPageNum() > ((DataPage)other).getPageNum()) {
                return 1;
            }
            return -1;
        }
    }

    private final class BFilePageHeader
    extends BTree.BTreePageHeader {
        private int dataLen;
        private long lastInChain;
        private long nextInChain;
        private short nextTID;
        private short records;

        public BFilePageHeader() {
            this.dataLen = 0;
            this.lastInChain = -1L;
            this.nextInChain = -1L;
            this.nextTID = (short)-1;
            this.records = 0;
        }

        public BFilePageHeader(byte[] data, int offset) throws IOException {
            super(data, offset);
            this.dataLen = 0;
            this.lastInChain = -1L;
            this.nextInChain = -1L;
            this.nextTID = (short)-1;
            this.records = 0;
        }

        public void decRecordCount() {
            this.records = (short)(this.records - 1);
        }

        public int getDataLength() {
            return this.dataLen;
        }

        public long getLastInChain() {
            return this.lastInChain;
        }

        public long getNextInChain() {
            return this.nextInChain;
        }

        public short getNextTID() {
            if (this.nextTID == Short.MAX_VALUE) {
                LOG.warn((Object)"tid limit reached");
                return -1;
            }
            this.nextTID = (short)(this.nextTID + 1);
            return this.nextTID;
        }

        public short getCurrentTID() {
            if (this.nextTID == Short.MAX_VALUE) {
                return -1;
            }
            return this.nextTID;
        }

        public short getRecordCount() {
            return this.records;
        }

        public void incRecordCount() {
            this.records = (short)(this.records + 1);
        }

        public int read(byte[] data, int offset) throws IOException {
            offset = super.read(data, offset);
            this.records = ByteConversion.byteToShort(data, offset);
            this.dataLen = ByteConversion.byteToInt(data, offset += 2);
            this.nextTID = ByteConversion.byteToShort(data, offset += 4);
            this.nextInChain = ByteConversion.byteToLong(data, offset += 2);
            this.lastInChain = ByteConversion.byteToLong(data, offset += 8);
            return offset + 8;
        }

        public void setDataLength(int len) {
            this.dataLen = len;
        }

        public void setLastInChain(long p) {
            this.lastInChain = p;
        }

        public void setNextInChain(long b) {
            this.nextInChain = b;
        }

        public void setRecordCount(short recs) {
            this.records = recs;
        }

        public void setTID(short tid) {
            this.nextTID = tid;
        }

        public int write(byte[] data, int offset) throws IOException {
            offset = super.write(data, offset);
            ByteConversion.shortToByte(this.records, data, offset);
            ByteConversion.intToByte(this.dataLen, data, offset += 2);
            ByteConversion.shortToByte(this.nextTID, data, offset += 4);
            ByteConversion.longToByte(this.nextInChain, data, offset += 2);
            ByteConversion.longToByte(this.lastInChain, data, offset += 8);
            return offset + 8;
        }
    }

    private final class BFileHeader
    extends BTree.BTreeFileHeader {
        private long lastDataPage = -1L;
        private FreeList freeList = new FreeList();
        public static final int MAX_FREE_LIST_LEN = 128;

        public BFileHeader(int pageSize) {
        }

        public void addFreeSpace(FreeSpace freeSpace) {
            this.freeList.add(freeSpace);
        }

        public FreeSpace findFreeSpace(int needed) {
            return this.freeList.find(needed);
        }

        public FreeSpace getFreeSpace(long page) {
            return this.freeList.retrieve(page);
        }

        public void removeFreeSpace(FreeSpace space) {
            if (space == null) {
                return;
            }
            this.freeList.remove(space);
        }

        public void debugFreeList() {
            LOG.debug((Object)(BFile.this.getFile().getName() + ": " + this.freeList.toString()));
        }

        public long getLastDataPage() {
            return this.lastDataPage;
        }

        public void read(RandomAccessFile raf) throws IOException {
            super.read(raf);
            this.lastDataPage = raf.readLong();
            this.freeList.read(raf);
        }

        public void setLastDataPage(long last) {
            this.lastDataPage = last;
        }

        public void write(RandomAccessFile raf) throws IOException {
            super.write(raf);
            raf.writeLong(this.lastDataPage);
            this.freeList.write(raf);
        }
    }
}

