/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.XMLUtil;
import org.exist.memtree.NodeImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.XIncludeFilter;
import org.exist.util.Configuration;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.ReceiverToSAX;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class Serializer
implements XMLReader {
    protected static final Logger LOG = Logger.getLogger((Class)Serializer.class);
    public static final String EXIST_NS = "http://exist.sourceforge.net/NS/exist";
    public static final int TAG_NONE = 0;
    public static final int TAG_ELEMENT_MATCHES = 1;
    public static final int TAG_ATTRIBUTE_MATCHES = 2;
    public static final int TAG_BOTH = 4;
    public static final String GENERATE_DOC_EVENTS = "sax-document-events";
    public static final String ENCODING = "encoding";
    protected static final QName ATTR_HITS_QNAME = new QName("hits", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_START_QNAME = new QName("start", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_COUNT_QNAME = new QName("count", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_RESULT_QNAME = new QName("result", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_TYPE_QNAME = new QName("type", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_VALUE_QNAME = new QName("value", "http://exist.sourceforge.net/NS/exist", "exist");
    protected DBBroker broker;
    protected String encoding = "UTF-8";
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    protected SAXTransformerFactory factory;
    protected boolean createContainerElements = false;
    protected Properties defaultProperties = new Properties();
    protected Properties outputProperties;
    protected Templates templates = null;
    protected TransformerHandler xslHandler = null;
    protected XIncludeFilter xinclude;
    protected Receiver receiver = null;
    protected SAXSerializer xmlout = null;
    protected LexicalHandler lexicalHandler = null;
    protected User user = null;

    public Serializer(DBBroker broker, Configuration config) {
        this.broker = broker;
        this.factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.xinclude = new XIncludeFilter(this);
        this.receiver = this.xinclude;
        String option = (String)config.getProperty("serialization.enable-xsl");
        if (option != null) {
            this.defaultProperties.setProperty("process-xsl-pi", option);
        } else {
            this.defaultProperties.setProperty("process-xsl-pi", "no");
        }
        option = (String)config.getProperty("serialization.enable-xinclude");
        if (option != null) {
            this.defaultProperties.setProperty("expand-xincludes", option);
        }
        if ((option = (String)config.getProperty("serialization.indent")) != null) {
            this.defaultProperties.setProperty("indent", option);
        }
        boolean tagElements = true;
        boolean tagAttributes = false;
        option = (String)config.getProperty("serialization.match-tagging-elements");
        if (option != null) {
            tagElements = option.equals("yes");
        }
        if ((option = (String)config.getProperty("serialization.match-tagging-attributes")) != null) {
            tagAttributes = option.equals("yes");
        }
        option = tagElements && tagAttributes ? "both" : (tagElements ? "elements" : (tagAttributes ? "attributes" : "none"));
        this.defaultProperties.setProperty("highlight-matches", option);
        this.defaultProperties.setProperty(GENERATE_DOC_EVENTS, "true");
        this.outputProperties = new Properties(this.defaultProperties);
    }

    public void setProperties(Properties properties) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("http://xml.org/sax/properties/lexical-handler")) {
                this.lexicalHandler = (LexicalHandler)properties.get(key);
                continue;
            }
            this.setProperty(key, properties.getProperty(key));
        }
    }

    public void setProperties(Hashtable table) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (table == null) {
            return;
        }
        Iterator i = table.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
    }

    public void setProperty(String prop, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (prop.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            this.outputProperties.put(prop, value);
        }
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.outputProperties.getProperty(key, defaultValue);
        return value;
    }

    public boolean isStylesheetApplied() {
        return this.templates != null;
    }

    protected int getHighlightingMode() {
        String option = this.getProperty("highlight-matches", "elements");
        if (option.equals("both")) {
            return 4;
        }
        if (option.equals("elements")) {
            return 1;
        }
        if (option.equals("attributes")) {
            return 2;
        }
        return 0;
    }

    protected void applyXSLHandler(Writer writer) {
        StreamResult result = new StreamResult(writer);
        this.xslHandler.setResult(result);
        if (this.getProperty("expand-xincludes", "yes").equals("yes")) {
            this.xinclude.setReceiver(new ReceiverToSAX(this.xslHandler));
            this.receiver = this.xinclude;
        } else {
            this.receiver = new ReceiverToSAX(this.xslHandler);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            throw new SAXNotSupportedException(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void parse(InputSource input) throws IOException, SAXException {
        String doc = input.getSystemId();
        if (doc == null) {
            throw new SAXException("source is not an eXist document");
        }
        this.parse(doc);
    }

    protected void setDocument(DocumentImpl doc) {
        this.xinclude.setDocument(doc);
    }

    public void parse(String systemId) throws IOException, SAXException {
        try {
            DocumentImpl doc = (DocumentImpl)this.broker.getDocument(systemId);
            if (doc == null) {
                throw new SAXException("document " + systemId + " not found in database");
            }
            LOG.debug((Object)("serializing " + doc.getFileName()));
            if (!doc.getPermissions().validate(this.broker.getUser(), 4)) {
                throw new PermissionDeniedException("Not allowed to read resource");
            }
            this.toSAX(doc);
        }
        catch (PermissionDeniedException e) {
            throw new SAXException("permission denied");
        }
    }

    public void reset() {
        this.receiver = this.xinclude;
        this.xinclude.setReceiver(null);
        this.xslHandler = null;
        this.templates = null;
        this.outputProperties.clear();
    }

    public String serialize(DocumentImpl doc) throws SAXException {
        StringWriter writer = new StringWriter();
        this.serialize(doc, writer);
        return writer.toString();
    }

    public void serialize(DocumentImpl doc, Writer writer) throws SAXException {
        String stylesheet;
        if (this.outputProperties.getProperty("process-xsl-pi", "no").equals("yes") && (stylesheet = this.hasXSLPi(doc)) != null) {
            this.setStylesheet(doc, stylesheet);
        }
        this.setStylesheetFromProperties(doc);
        if (this.templates != null) {
            this.applyXSLHandler(writer);
        } else {
            this.setPrettyPrinter(writer, true);
        }
        this.serializeToReceiver(doc, true);
        this.releasePrettyPrinter();
    }

    public String serialize(NodeValue n) throws SAXException {
        this.setStylesheetFromProperties(n.getOwnerDocument());
        StringWriter out = new StringWriter();
        if (this.templates != null) {
            this.applyXSLHandler(out);
        } else {
            this.setPrettyPrinter(out, false);
        }
        this.serializeToReceiver(n, true);
        this.releasePrettyPrinter();
        return out.toString();
    }

    public String serialize(NodeProxy p) throws SAXException {
        this.setStylesheetFromProperties(p.getOwnerDocument());
        StringWriter out = new StringWriter();
        if (this.templates != null) {
            this.applyXSLHandler(out);
        } else {
            this.setPrettyPrinter(out, false);
        }
        this.serializeToReceiver(p, false);
        this.releasePrettyPrinter();
        return out.toString();
    }

    public void setSAXHandlers(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        ReceiverToSAX toSAX = new ReceiverToSAX(contentHandler);
        toSAX.setLexicalHandler(lexicalHandler);
        if (this.getProperty("expand-xincludes", "yes").equals("yes")) {
            this.xinclude.setReceiver(toSAX);
            this.receiver = this.xinclude;
        } else {
            this.receiver = toSAX;
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.setSAXHandlers(handler, null);
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            throw new SAXNotSupportedException(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    protected void setPrettyPrinter(Writer writer, boolean xmlDecl) {
        this.outputProperties.setProperty("omit-xml-declaration", xmlDecl ? "no" : "yes");
        this.xmlout = SAXSerializerPool.getInstance().borrowSAXSerializer();
        this.xmlout.setWriter(writer);
        this.xmlout.setOutputProperties(this.outputProperties);
        if (this.getProperty("expand-xincludes", "yes").equals("yes")) {
            this.xinclude.setReceiver(this.xmlout);
            this.receiver = this.xinclude;
        } else {
            this.receiver = this.xmlout;
        }
    }

    protected void releasePrettyPrinter() {
        if (this.xmlout != null) {
            SAXSerializerPool.getInstance().returnSAXSerializer(this.xmlout);
        }
        this.xmlout = null;
    }

    protected void setStylesheetFromProperties(Document doc) {
        if (this.templates != null) {
            return;
        }
        String stylesheet = this.outputProperties.getProperty("stylesheet");
        if (stylesheet != null) {
            if (doc instanceof DocumentImpl) {
                this.setStylesheet((DocumentImpl)doc, stylesheet);
            } else {
                this.setStylesheet(null, stylesheet);
            }
        }
    }

    protected void checkStylesheetParams() {
        if (this.xslHandler == null) {
            return;
        }
        Enumeration<?> e = this.outputProperties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            if (!property.startsWith("stylesheet-param")) continue;
            String value = this.outputProperties.getProperty(property);
            property = property.substring("stylesheet-param".length() + 1);
            this.xslHandler.getTransformer().setParameter(property, value);
        }
    }

    public void setStylesheet(String stylesheet) {
        this.setStylesheet(null, stylesheet);
    }

    public void setStylesheet(DocumentImpl doc, String stylesheet) {
        if (stylesheet == null) {
            this.templates = null;
            return;
        }
        long start = System.currentTimeMillis();
        this.xslHandler = null;
        try {
            if (stylesheet.indexOf(":") > -1) {
                StreamSource source = new StreamSource(stylesheet);
                this.templates = this.factory.newTemplates(source);
            } else {
                if (doc != null && !stylesheet.startsWith("/")) {
                    stylesheet = doc.getCollection().getName() + '/' + stylesheet;
                }
                DocumentImpl xsl = null;
                try {
                    xsl = (DocumentImpl)this.broker.getDocument(stylesheet);
                }
                catch (PermissionDeniedException e) {
                    LOG.debug((Object)"permission denied to read stylesheet");
                }
                if (xsl == null) {
                    LOG.debug((Object)"stylesheet not found");
                    return;
                }
                if (!xsl.getPermissions().validate(this.broker.getUser(), 4)) {
                    LOG.debug((Object)"Permission denied to read stylesheet doc.");
                    return;
                }
                if (xsl.getCollection() != null) {
                    this.factory.setURIResolver(new InternalURIResolver(xsl.getCollection().getName()));
                }
                Receiver oldReceiver = this.receiver;
                TemplatesHandler handler = this.factory.newTemplatesHandler();
                this.receiver = new ReceiverToSAX(handler);
                try {
                    this.serializeToReceiver(xsl, true);
                    this.templates = handler.getTemplates();
                }
                catch (SAXException e) {
                    LOG.warn((Object)"SAXException while creating template", (Throwable)e);
                }
                this.receiver = oldReceiver;
                this.factory.setURIResolver(null);
            }
            LOG.debug((Object)("compiling stylesheet took " + (System.currentTimeMillis() - start)));
            if (this.templates != null) {
                this.xslHandler = this.factory.newTransformerHandler(this.templates);
            }
        }
        catch (TransformerConfigurationException e) {
            LOG.debug((Object)"error compiling stylesheet", (Throwable)e);
            return;
        }
        this.checkStylesheetParams();
    }

    public void setStylesheetParam(String param, String value) {
        if (this.xslHandler != null) {
            this.xslHandler.getTransformer().setParameter(param, value);
        }
    }

    protected void setXSLHandler() {
        if (this.templates == null) {
            return;
        }
        if (this.xslHandler != null) {
            SAXResult result = new SAXResult();
            boolean processXInclude = this.getProperty("expand-xincludes", "yes").equals("yes");
            ReceiverToSAX filter = processXInclude ? (ReceiverToSAX)this.xinclude.getReceiver() : (ReceiverToSAX)this.receiver;
            result.setHandler(filter.getContentHandler());
            result.setLexicalHandler(filter.getLexicalHandler());
            filter.setLexicalHandler(this.xslHandler);
            filter.setContentHandler(this.xslHandler);
            this.xslHandler.setResult(result);
            if (processXInclude) {
                this.xinclude.setReceiver(new ReceiverToSAX(this.xslHandler));
                this.receiver = this.xinclude;
            } else {
                this.receiver = new ReceiverToSAX(this.xslHandler);
            }
        }
    }

    public void toSAX(DocumentImpl doc) throws SAXException {
        String stylesheet;
        if (this.outputProperties.getProperty("process-xsl-pi", "no").equals("yes") && (stylesheet = this.hasXSLPi(doc)) != null) {
            this.setStylesheet(doc, stylesheet);
        }
        this.setStylesheetFromProperties(doc);
        this.setXSLHandler();
        this.serializeToReceiver(doc, this.getProperty(GENERATE_DOC_EVENTS, "false").equals("true"));
    }

    public void toSAX(NodeValue n) throws SAXException {
        this.setStylesheetFromProperties(n.getOwnerDocument());
        this.setXSLHandler();
        this.serializeToReceiver(n, this.getProperty(GENERATE_DOC_EVENTS, "false").equals("true"));
    }

    public void toSAX(NodeProxy p) throws SAXException {
        this.setStylesheetFromProperties(p.getOwnerDocument());
        this.setXSLHandler();
        if (p.gid < 0L) {
            this.serializeToReceiver(p.getDocument(), this.getProperty(GENERATE_DOC_EVENTS, "false").equals("true"));
        } else {
            this.serializeToReceiver(p, this.getProperty(GENERATE_DOC_EVENTS, "false").equals("true"));
        }
    }

    public void toSAX(Sequence seq, int start, int count, boolean wrap) throws SAXException {
        this.setStylesheetFromProperties(null);
        this.setXSLHandler();
        AttrList attrs = new AttrList();
        attrs.addAttribute(ATTR_HITS_QNAME, Integer.toString(seq.getLength()));
        attrs.addAttribute(ATTR_START_QNAME, Integer.toString(start));
        attrs.addAttribute(ATTR_COUNT_QNAME, Integer.toString(count));
        this.receiver.startDocument();
        if (wrap) {
            this.receiver.startPrefixMapping("exist", EXIST_NS);
            this.receiver.startElement(ELEM_RESULT_QNAME, attrs);
        }
        for (int i = --start; i < start + count; ++i) {
            Item item = seq.itemAt(i);
            if (item == null) {
                LOG.debug((Object)("item " + i + " not found"));
                continue;
            }
            if (Type.subTypeOf(item.getType(), -1)) {
                NodeValue node = (NodeValue)item;
                this.serializeToReceiver(node, false);
                continue;
            }
            attrs = new AttrList();
            attrs.addAttribute(ATTR_TYPE_QNAME, Type.getTypeName(item.getType()));
            this.receiver.startElement(ELEM_VALUE_QNAME, attrs);
            try {
                this.receiver.characters(item.getStringValue());
            }
            catch (XPathException e) {
                throw new SAXException(e.getMessage(), e);
            }
            this.receiver.endElement(ELEM_VALUE_QNAME);
        }
        if (wrap) {
            this.receiver.endElement(ELEM_RESULT_QNAME);
            this.receiver.endPrefixMapping("exist");
        }
        this.receiver.endDocument();
    }

    public void toReceiver(NodeProxy p) throws SAXException {
        this.serializeToReceiver(p, false);
    }

    protected abstract void serializeToReceiver(NodeProxy var1, boolean var2) throws SAXException;

    protected abstract void serializeToReceiver(DocumentImpl var1, boolean var2) throws SAXException;

    protected void serializeToReceiver(NodeValue v, boolean generateDocEvents) throws SAXException {
        if (v.getImplementationType() == 1) {
            this.serializeToReceiver((NodeProxy)v, generateDocEvents);
        } else {
            this.serializeToReceiver((NodeImpl)v, generateDocEvents);
        }
    }

    protected void serializeToReceiver(NodeImpl n, boolean generateDocEvents) throws SAXException {
        if (generateDocEvents) {
            this.receiver.startDocument();
        }
        n.streamTo(this, this.receiver);
        if (generateDocEvents) {
            this.receiver.endDocument();
        }
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    private String hasXSLPi(Document doc) {
        NodeList docChildren = doc.getChildNodes();
        for (int i = 0; i < docChildren.getLength(); ++i) {
            String href;
            Node node = docChildren.item(i);
            if (node.getNodeType() != 7 || !((ProcessingInstruction)node).getTarget().equals("xml-stylesheet")) continue;
            LOG.debug((Object)"Found stylesheet instruction");
            String xsl = ((ProcessingInstruction)node).getData();
            String type = XMLUtil.parseValue(xsl, "type");
            if (type == null || !type.equals("text/xml") && !type.equals("text/xsl") && !type.equals("application/xslt+xml") || (href = XMLUtil.parseValue(xsl, "href")) == null) continue;
            LOG.debug((Object)("stylesheet = " + href));
            return href;
        }
        return null;
    }

    private class InternalURIResolver
    implements URIResolver {
        private String collectionId = null;

        public InternalURIResolver(String collection) {
            this.collectionId = collection;
        }

        public Source resolve(String href, String base) throws TransformerException {
            LOG.debug((Object)("resolving stylesheet ref " + href));
            if (href.indexOf(58) > -1) {
                return null;
            }
            URI baseURI = URI.create(this.collectionId + '/');
            URI uri = URI.create(href);
            href = baseURI.resolve(uri).toString();
            Serializer serializer = Serializer.this.broker.newSerializer();
            return new SAXSource(serializer, new InputSource(href));
        }
    }
}

