/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io;

import java.io.EOFException;
import java.io.IOException;
import org.exist.storage.io.AbstractVariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class VariableByteArrayInput
extends AbstractVariableByteInput {
    private byte[] data;
    private int position;
    private int end;

    public VariableByteArrayInput() {
    }

    public VariableByteArrayInput(byte[] data) {
        this.data = data;
        this.position = 0;
        this.end = data.length;
    }

    public VariableByteArrayInput(byte[] data, int offset, int length) {
        this.data = data;
        this.position = offset;
        this.end = offset + length;
    }

    public void initialize(byte[] data, int offset, int length) {
        this.data = data;
        this.position = offset;
        this.end = offset + length;
    }

    public byte readByte() throws IOException, EOFException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.data[this.position++];
    }

    public int read() throws IOException {
        if (this.position == this.end) {
            return -1;
        }
        return this.data[this.position++] & 0xFF;
    }

    public int available() throws IOException {
        return this.end - this.position;
    }

    public short readShort() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        byte b = this.data[this.position++];
        short i = (short)(b & 0x7F);
        int shift = 7;
        while ((b & 0x80) != 0) {
            if (this.position == this.end) {
                throw new EOFException();
            }
            b = this.data[this.position++];
            i = (short)(i | (b & 0x7F) << shift);
            shift += 7;
        }
        return i;
    }

    public int readInt() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        byte b = this.data[this.position++];
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            if (this.position == this.end) {
                throw new EOFException();
            }
            b = this.data[this.position++];
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public long readLong() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        byte b = this.data[this.position++];
        long i = (long)b & 0x7FL;
        int shift = 7;
        while ((b & 0x80) != 0) {
            if (this.position == this.end) {
                throw new EOFException();
            }
            b = this.data[this.position++];
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public void copyTo(VariableByteOutputStream os, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            byte more;
            do {
                more = this.data[this.position++];
                os.buf.append(more);
            } while ((more & 0x200) > 0);
        }
    }

    public void skip(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            while (this.position < this.end && (this.data[this.position++] & 0x80) > 0) {
            }
        }
    }

    public void skipBytes(long count) throws IOException {
        long i = 0L;
        while (i < count && this.position < this.end) {
            ++i;
            ++this.position;
        }
    }
}

