/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.SequencedLongHashMap;

public class LRUCache
implements Cache {
    private int max;
    private SequencedLongHashMap map;
    private int hits = 0;
    private int misses = 0;
    private String fileName = null;

    public LRUCache(int size) {
        this.max = size;
        this.map = new SequencedLongHashMap(size);
    }

    public void add(Cacheable item, int initialRefCount) {
        this.add(item);
    }

    public void add(Cacheable item) {
        if (this.map.size() == this.max) {
            this.removeOne(item);
        }
        this.map.put(item.getKey(), item);
    }

    public Cacheable get(Cacheable item) {
        return this.get(item.getKey());
    }

    public Cacheable get(long key) {
        Cacheable obj = (Cacheable)this.map.get(key);
        if (obj == null) {
            ++this.misses;
        } else {
            ++this.hits;
        }
        return obj;
    }

    public void remove(Cacheable item) {
        this.map.remove(item.getKey());
    }

    public void flush() {
        for (SequencedLongHashMap.Entry next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
            Cacheable cacheable = (Cacheable)next.getValue();
            if (!cacheable.isDirty()) continue;
            cacheable.sync();
        }
    }

    public boolean hasDirtyItems() {
        for (SequencedLongHashMap.Entry next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
            Cacheable cacheable = (Cacheable)next.getValue();
            if (!cacheable.isDirty()) continue;
            return true;
        }
        return false;
    }

    public int getBuffers() {
        return this.max;
    }

    public int getUsedBuffers() {
        return this.map.size();
    }

    public int getHits() {
        return this.hits;
    }

    public int getFails() {
        return this.misses;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private final void removeOne(Cacheable item) {
        boolean removed = false;
        SequencedLongHashMap.Entry next = this.map.getFirstEntry();
        do {
            Cacheable cached;
            if ((cached = (Cacheable)next.getValue()).allowUnload() && cached.getKey() != item.getKey()) {
                cached.sync();
                this.map.remove(next.getKey());
                removed = true;
                continue;
            }
            if ((next = next.getNext()) != null) continue;
            LOG.debug((Object)"Unable to remove entry");
            next = this.map.getFirstEntry();
        } while (!removed);
    }
}

