/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.GClockCache;

public class LRDCache
extends GClockCache {
    protected int totalReferences = 0;
    private int nextCleanup;
    private String fileName = "unknown";
    private int maxReferences;
    private int ageingPeriod;

    public LRDCache(int size) {
        super(size);
        this.maxReferences = size * 10000;
        this.ageingPeriod = size * 5000;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public void add(Cacheable item, int initialRefCount) {
        Cacheable old = (Cacheable)this.map.get(item.getKey());
        if (old != null) {
            old.incReferenceCount();
            ++this.totalReferences;
        } else {
            item.setReferenceCount(initialRefCount);
            item.setTimestamp(this.totalReferences);
            if (this.count < this.size) {
                this.items[this.count++] = item;
                this.map.put(item.getKey(), item);
                ++this.used;
            } else {
                this.removeOne(item);
            }
            this.totalReferences += initialRefCount;
        }
        if (this.totalReferences > this.maxReferences) {
            this.cleanup();
        } else if (this.totalReferences > this.nextCleanup) {
            this.ageReferences();
        }
    }

    protected Cacheable removeOne(Cacheable item) {
        Cacheable old;
        double rd = 0.0;
        double minRd = -1.0;
        int bucket = -1;
        for (int i = 0; i < this.items.length; ++i) {
            old = this.items[i];
            if (old == null) {
                bucket = i;
                break;
            }
            rd = (double)old.getReferenceCount() / (double)(this.totalReferences - old.getTimestamp());
            if (!(minRd < 0.0) && !(rd < minRd) || !old.allowUnload()) continue;
            minRd = rd;
            bucket = i;
        }
        if ((old = this.items[bucket]) != null) {
            this.map.remove(old.getKey());
            old.sync();
        } else {
            ++this.used;
        }
        this.items[bucket] = item;
        this.map.put(item.getKey(), item);
        return old;
    }

    protected void ageReferences() {
        int limit = this.ageingPeriod / 10;
        for (int i = 0; i < this.count; ++i) {
            Cacheable item = this.items[i];
            if (item == null) continue;
            int refCount = item.getReferenceCount();
            if (refCount > limit) {
                item.setReferenceCount(refCount - limit);
                continue;
            }
            item.setReferenceCount(1);
        }
        this.nextCleanup += this.ageingPeriod;
    }

    protected void cleanup() {
        LOG.debug((Object)("totalReferences = " + this.totalReferences + "; maxReferences = " + this.maxReferences));
        this.totalReferences = this.count;
        for (int i = 0; i < this.count; ++i) {
            Cacheable item = this.items[i];
            if (item == null) continue;
            item.setReferenceCount(1);
            item.setTimestamp(1);
        }
        LOG.debug((Object)(this.fileName + " total references: " + this.totalReferences));
        this.nextCleanup = this.totalReferences + this.ageingPeriod;
    }
}

