/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.analysis;

public class TextToken {
    public static final int ALPHA = 1;
    public static final int ALPHANUM = 2;
    public static final int DIGIT = 3;
    public static final int EOF = -1;
    public static final int FLOAT = 4;
    public static final int LETTER = 5;
    public static final int NUMBER = 6;
    public static final int P = 7;
    public static final int WS = 8;
    public static final int HOST = 9;
    public static final int EMAIL = 10;
    public static final int ACRONYM = 11;
    public static final TextToken WS_TOKEN = new TextToken(8);
    public static final TextToken EOF_TOKEN = new TextToken(-1);
    public static final String[] types = new String[]{"letter", "digit", "whitespace", "number", "alpha", "alphanum", "p", "float"};
    private int end = 0;
    private int start = 0;
    private CharSequence tokenText;
    private int tokenType = -1;

    public TextToken() {
    }

    public TextToken(int type, CharSequence text) {
        this(type, text, 0, text.length());
    }

    public TextToken(int type, CharSequence text, int start) {
        this(type, text, start, start);
    }

    public TextToken(int type, CharSequence text, int start, int end) {
        this.tokenType = type;
        this.tokenText = text;
        this.start = start;
        this.end = end;
    }

    public TextToken(int type) {
        this.tokenType = type;
    }

    public void set(int type, CharSequence text, int start) {
        this.tokenType = type;
        this.tokenText = text;
        this.start = start;
        this.end = start;
    }

    public boolean isAlpha() {
        return this.tokenType == 1;
    }

    public void consumeNext() {
        ++this.end;
    }

    public char getChar() {
        return this.tokenText.charAt(this.start);
    }

    public CharSequence getCharSequence() {
        if (this.start >= this.tokenText.length() || this.end > this.tokenText.length()) {
            throw new StringIndexOutOfBoundsException("start: " + this.start + "; end=" + this.end + "; text=" + this.tokenText);
        }
        return this.tokenText.subSequence(this.start, this.end);
    }

    public String getText() {
        if (this.start >= this.tokenText.length() || this.end > this.tokenText.length()) {
            throw new StringIndexOutOfBoundsException("start: " + this.start + "; end=" + this.end + "; text=" + this.tokenText);
        }
        return ((Object)this.tokenText.subSequence(this.start, this.end)).toString();
    }

    public int getType() {
        return this.tokenType;
    }

    public void setType(int type) {
        this.tokenType = type;
    }

    public void setText(String text) {
        this.tokenText = text;
    }
}

