/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Observable;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeSet;
import org.exist.dom.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexPaths;
import org.exist.storage.TermMatcher;
import org.exist.storage.analysis.SimpleTokenizer;
import org.exist.storage.analysis.Tokenizer;
import org.exist.util.Configuration;
import org.exist.util.Occurrences;
import org.exist.util.PorterStemmer;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;

public abstract class TextSearchEngine
extends Observable {
    protected static final Logger LOG = Logger.getLogger((Class)TextSearchEngine.class);
    protected TreeSet stoplist = new TreeSet();
    protected DBBroker broker = null;
    protected Tokenizer tokenizer;
    protected Configuration config;
    protected boolean indexNumbers = false;
    protected boolean stem = false;
    protected boolean termFreq = true;
    protected PorterStemmer stemmer = null;
    protected int trackMatches = 1;

    public TextSearchEngine(DBBroker broker, Configuration conf) {
        String tokenizerClass;
        String track;
        Boolean termFrequencies;
        Boolean stemming;
        this.broker = broker;
        this.config = conf;
        Boolean num = (Boolean)this.config.getProperty("indexer.indexNumbers");
        if (num != null) {
            this.indexNumbers = num;
        }
        if ((stemming = (Boolean)this.config.getProperty("indexer.stem")) != null) {
            this.stem = stemming;
        }
        if ((termFrequencies = (Boolean)this.config.getProperty("indexer.store-term-freq")) != null) {
            this.termFreq = termFrequencies;
        }
        if ((track = (String)this.config.getProperty("serialization.match-tagging-elements")) != null) {
            int n = this.trackMatches = track.equalsIgnoreCase("yes") ? 1 : 0;
        }
        if ((track = (String)this.config.getProperty("serialization.match-tagging-attributes")) != null && track.equalsIgnoreCase("yes")) {
            this.trackMatches |= 2;
        }
        if ((tokenizerClass = (String)this.config.getProperty("indexer.tokenizer")) != null) {
            try {
                Class<?> tokClass = Class.forName(tokenizerClass);
                this.tokenizer = (Tokenizer)tokClass.newInstance();
                LOG.debug((Object)("using tokenizer: " + tokenizerClass));
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)e);
            }
            catch (InstantiationException e) {
                LOG.debug((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.debug((Object)e);
            }
        }
        if (this.tokenizer == null) {
            LOG.debug((Object)"using simple tokenizer");
            this.tokenizer = new SimpleTokenizer();
        }
        if (this.stem) {
            this.stemmer = new PorterStemmer();
        }
        this.tokenizer.setStemming(this.stem);
        String stopword = (String)this.config.getProperty("stopwords");
        if (stopword != null) {
            try {
                FileReader in = new FileReader(stopword);
                StreamTokenizer tok = new StreamTokenizer(in);
                int next = tok.nextToken();
                while (next != -1) {
                    if (next != -3) continue;
                    this.stoplist.add(tok.sval);
                    next = tok.nextToken();
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)e);
            }
            catch (IOException e) {
                LOG.debug((Object)e);
            }
        }
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public abstract void storeText(IndexPaths var1, TextImpl var2, boolean var3);

    public abstract void storeAttribute(IndexPaths var1, AttrImpl var2);

    public abstract void flush();

    public abstract void close();

    public int getTrackMatches() {
        return this.trackMatches;
    }

    public void setTrackMatches(int flags) {
        this.trackMatches = flags;
    }

    public NodeSet getNodesContaining(XQueryContext context, DocumentSet docs, NodeSet contextSet, String expr) throws TerminatedException {
        return this.getNodesContaining(context, docs, contextSet, expr, 0);
    }

    public abstract NodeSet getNodesContaining(XQueryContext var1, DocumentSet var2, NodeSet var3, String var4, int var5) throws TerminatedException;

    public abstract NodeSet getNodes(XQueryContext var1, DocumentSet var2, NodeSet var3, TermMatcher var4, CharSequence var5) throws TerminatedException;

    public abstract Occurrences[] scanIndexTerms(User var1, Collection var2, String var3, String var4, boolean var5) throws PermissionDeniedException;

    public abstract String[] getIndexTerms(DocumentSet var1, TermMatcher var2);

    public abstract void dropIndex(Collection var1);

    public abstract void dropIndex(DocumentImpl var1);

    public abstract void reindex(DocumentImpl var1, NodeImpl var2);
}

