/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.indexer.IndexQuery;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.SymbolTable;
import org.exist.dom.XMLUtil;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.ElementIndex;
import org.exist.storage.ElementValue;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.store.BFile;
import org.exist.storage.store.StorageAddress;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.FastQSort;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.util.Occurrences;
import org.exist.util.ProgressIndicator;
import org.exist.util.ReadOnlyException;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.Node;

public class NativeElementIndex
extends ElementIndex {
    private static Logger LOG = Logger.getLogger((String)NativeElementIndex.class.getName());
    protected BFile dbElement;
    private VariableByteOutputStream os = new VariableByteOutputStream();

    public NativeElementIndex(DBBroker broker, Configuration config, BFile dbElement) {
        super(broker, config);
        this.dbElement = dbElement;
    }

    public void addRow(QName qname, NodeProxy proxy) {
        ArrayList buf;
        if (this.elementIds.containsKey(qname)) {
            buf = (ArrayList)this.elementIds.get(qname);
        } else {
            buf = new ArrayList(50);
            this.elementIds.put(qname, buf);
        }
        buf.add(proxy);
    }

    public NodeSet getAttributesByName(DocumentSet docs, QName qname, NodeSelector selector) {
        qname.setLocalName(qname.getLocalName());
        NodeSet result = this.findElementsByTagName((byte)1, docs, qname, selector);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeSet findElementsByTagName(byte type, DocumentSet docs, QName qname, NodeSelector selector) {
        ExtArrayNodeSet result = new ExtArrayNodeSet(docs.getLength(), 256);
        SymbolTable symbols = this.broker.getSymbols();
        VariableByteInput is = null;
        short nodeType = type == 1 ? (short)2 : 1;
        Lock lock = this.dbElement.getLock();
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            ElementValue ref;
            Collection collection = (Collection)i.next();
            short collectionId = collection.getId();
            if (type == 2) {
                ref = new ElementValue(type, collectionId, qname.getLocalName());
            } else {
                short sym = symbols.getSymbol(qname.getLocalName());
                short nsSym = symbols.getNSSymbol(qname.getNamespaceURI());
                ref = new ElementValue(type, collectionId, sym, nsSym);
            }
            try {
                lock.acquire(0);
                is = this.dbElement.getAsStream(ref);
                if (is == null) continue;
                while (is.available() > 0) {
                    int docId = is.readInt();
                    int len = is.readInt();
                    DocumentImpl doc = docs.getDoc(docId);
                    if (doc == null) {
                        is.skip(len * 4);
                        continue;
                    }
                    long gid = 0L;
                    for (int k = 0; k < len; ++k) {
                        NodeProxy p;
                        gid += is.readLong();
                        if (selector == null) {
                            p = new NodeProxy(doc, gid, nodeType, StorageAddress.read(is));
                        } else {
                            p = selector.match(doc, gid);
                            if (p != null) {
                                p.setInternalAddress(StorageAddress.read(is));
                                p.setNodeType(nodeType);
                            } else {
                                is.skip(3);
                            }
                        }
                        if (p == null) continue;
                        result.add(p, len);
                    }
                }
            }
            catch (EOFException e) {}
            continue;
            catch (LockException e) {
                LOG.warn((Object)"findElementsByTagName(byte, DocumentSet, QName, NodeSelector) - failed to acquire lock", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LOG.warn((Object)("findElementsByTagName(byte, DocumentSet, QName, NodeSelector) - io exception while reading elements for " + qname), (Throwable)e);
                continue;
            }
            finally {
                lock.release();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Occurrences[] scanIndexedElements(Collection collection, boolean inclusive) throws PermissionDeniedException {
        if (!collection.getPermissions().validate(this.broker.getUser(), 4)) {
            throw new PermissionDeniedException("you don't have the permission to read collection " + collection.getName());
        }
        ArrayList<Collection> collections = inclusive ? collection.getDescendants(this.broker, this.broker.getUser()) : new ArrayList<Collection>();
        collections.add(collection);
        TreeMap<QName, Occurrences> map = new TreeMap<QName, Occurrences>();
        XQueryContext context = new XQueryContext(this.broker);
        Lock lock = this.dbElement.getLock();
        Iterator i = collections.iterator();
        while (i.hasNext()) {
            Collection current = (Collection)i.next();
            short collectionId = current.getId();
            ElementValue ref = new ElementValue(0, collectionId);
            IndexQuery query = new IndexQuery(7, (Value)ref);
            try {
                lock.acquire();
                ArrayList values = this.dbElement.findEntries(query);
                Iterator j = values.iterator();
                while (j.hasNext()) {
                    String namespace;
                    Value[] val = (Value[])j.next();
                    short elementId = ByteConversion.byteToShort(val[0].getData(), 3);
                    short nsSymbol = ByteConversion.byteToShort(val[0].getData(), 5);
                    String name = this.broker.getSymbols().getName(elementId);
                    QName qname = new QName(name, namespace = nsSymbol == 0 ? "" : this.broker.getSymbols().getNamespace(nsSymbol));
                    Occurrences oc = (Occurrences)map.get(qname);
                    if (oc == null) {
                        qname.setPrefix(context.getPrefixForURI(namespace));
                        oc = new Occurrences(qname);
                        map.put(qname, oc);
                    }
                    VariableByteArrayInput is = new VariableByteArrayInput(val[1].data(), val[1].start(), val[1].getLength());
                    try {
                        while (is.available() > 0) {
                            int docId = is.readInt();
                            int len = is.readInt();
                            oc.addOccurrences(len);
                            is.skip(len * 4);
                        }
                    }
                    catch (EOFException e) {
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"unexpected exception", (Throwable)e);
                    }
                }
            }
            catch (BTreeException e) {
                LOG.warn((Object)"exception while reading element index", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"exception while reading element index", (Throwable)e);
            }
            catch (LockException e) {
                LOG.warn((Object)"failed to acquire lock", (Throwable)e);
            }
            catch (TerminatedException e) {
                LOG.warn((Object)"Method terminated", (Throwable)e);
            }
            finally {
                lock.release();
            }
        }
        Occurrences[] result = new Occurrences[map.size()];
        return map.values().toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Collection collection) {
        LOG.debug((Object)"removing elements ...");
        ElementValue ref = new ElementValue(collection.getId());
        IndexQuery query = new IndexQuery(7, (Value)ref);
        Lock lock = this.dbElement.getLock();
        try {
            lock.acquire(1);
            this.dbElement.removeAll(query);
        }
        catch (LockException e) {
            LOG.error((Object)"could not acquire lock on elements index", (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void consistencyCheck(DocumentImpl doc) throws EXistException {
        short collectionId = doc.getCollection().getId();
        ElementValue ref = new ElementValue(collectionId);
        IndexQuery query = new IndexQuery(7, (Value)ref);
        Lock lock = this.dbElement.getLock();
        try {
            lock.acquire(1);
            ArrayList elements = this.dbElement.findKeys(query);
            long last = 0L;
            StringBuffer msg = new StringBuffer();
            int i = 0;
            while (i < elements.size()) {
                Value key = (Value)elements.get(i);
                Value value = this.dbElement.get(key);
                byte[] data = value.getData();
                short symbol = ByteConversion.byteToShort(key.data(), key.start() + 3);
                String nodeName = this.broker.getSymbols().getName(symbol);
                msg.setLength(0);
                msg.append("Checking ").append(nodeName).append(": ");
                VariableByteArrayInput is = new VariableByteArrayInput(data);
                try {
                    while (is.available() > 0) {
                        int docId = is.readInt();
                        int len = is.readInt();
                        if (docId == doc.getDocId()) {
                        } else {
                            is.skip(len * 4);
                            continue;
                        }
                        for (int j = 0; j < len; ++j) {
                            long gid;
                            long delta = is.readLong();
                            last = gid = last + delta;
                            long address = StorageAddress.read(is);
                            Node node = this.broker.objectWith(new NodeProxy(doc, gid, address));
                            if (node == null) {
                                throw new EXistException("Node " + gid + " in document " + doc.getFileName() + " not found.");
                            }
                            if (node.getNodeType() != 1 && node.getNodeType() != 2) {
                                LOG.warn((Object)("Node " + gid + " in document " + doc.getFileName() + " is not an element or attribute node."));
                                LOG.debug((Object)("Type = " + node.getNodeType() + "; name = " + node.getNodeName() + "; value = " + node.getNodeValue()));
                                throw new EXistException("Node " + gid + " in document " + doc.getFileName() + " is not an element or attribute node.");
                            }
                            if (!node.getLocalName().equals(nodeName)) {
                                LOG.warn((Object)("Node name does not correspond to index entry. Expected " + nodeName + "; found " + node.getLocalName()));
                            }
                            msg.append(StorageAddress.toString(address)).append(' ');
                        }
                    }
                }
                catch (EOFException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"removeDocument(String) - eof", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("removeDocument(String) " + e.getMessage()), (Throwable)e);
                }
                LOG.debug((Object)msg.toString());
                ++i;
            }
            return;
        }
        catch (LockException e) {
            LOG.warn((Object)"removeDocument(String) - could not acquire lock on elements", (Throwable)e);
            return;
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"method terminated", (Throwable)e);
            return;
        }
        catch (BTreeException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        catch (IOException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void dropIndex(DocumentImpl doc) throws ReadOnlyException {
        collectionId = doc.getCollection().getId();
        ref = new ElementValue(collectionId);
        query = new IndexQuery(7, (Value)ref);
        lock = this.dbElement.getLock();
        try {
            lock.acquire(1);
            elements = this.dbElement.findKeys(query);
            if (NativeElementIndex.LOG.isDebugEnabled()) {
                NativeElementIndex.LOG.debug((Object)("removeDocument() - found " + elements.size() + " elements."));
            }
            for (i = 0; i < elements.size(); ++i) {
                key = (Value)elements.get(i);
                value = this.dbElement.get(key);
                data = value.getData();
                is = new VariableByteArrayInput(data);
                os = new VariableByteOutputStream();
                changed = false;
lbl18:
                // 2 sources

                try {
                    while (is.available() > 0) {
                        block20: {
                            docId = is.readInt();
                            len = is.readInt();
                            if (docId == doc.getDocId()) break block20;
                            os.writeInt(docId);
                            os.writeInt(len);
                            for (j = 0; j < len; ++j) {
                                delta = is.readLong();
                                address = StorageAddress.read(is);
                                os.writeLong(delta);
                                StorageAddress.write(address, os);
                            }
                            ** GOTO lbl18
                        }
                        changed = true;
                        is.skip(len * 4);
                    }
                }
                catch (EOFException e) {
                    if (NativeElementIndex.LOG.isDebugEnabled()) {
                        NativeElementIndex.LOG.debug((Object)"removeDocument(String) - eof", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    NativeElementIndex.LOG.warn((Object)("removeDocument(String) " + e.getMessage()), (Throwable)e);
                }
                if (!changed || this.dbElement.put(key, os.data()) >= 0L || !NativeElementIndex.LOG.isDebugEnabled()) continue;
                NativeElementIndex.LOG.debug((Object)"removeDocument() - could not save element");
            }
        }
        catch (LockException e) {
            NativeElementIndex.LOG.warn((Object)"removeDocument(String) - could not acquire lock on elements", (Throwable)e);
        }
        catch (TerminatedException e) {
            NativeElementIndex.LOG.warn((Object)"method terminated", (Throwable)e);
        }
        catch (BTreeException e) {
            NativeElementIndex.LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            NativeElementIndex.LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(DocumentImpl oldDoc, NodeImpl node) {
        if (this.elementIds.size() == 0) {
            return;
        }
        Lock lock = this.dbElement.getLock();
        ArrayList<NodeProxy> oldList = new ArrayList<NodeProxy>();
        VariableByteInput is = null;
        short collectionId = oldDoc.getCollection().getId();
        try {
            Iterator i = this.elementIds.entrySet().iterator();
            while (i.hasNext()) {
                ElementValue ref;
                Map.Entry entry = i.next();
                ArrayList idList = (ArrayList)entry.getValue();
                QName qname = (QName)entry.getKey();
                if (qname.getNameType() != 2) {
                    short sym = this.broker.getSymbols().getSymbol(qname.getLocalName());
                    short nsSym = this.broker.getSymbols().getNSSymbol(qname.getNamespaceURI());
                    ref = new ElementValue(qname.getNameType(), collectionId, sym, nsSym);
                } else {
                    ref = new ElementValue(qname.getNameType(), collectionId, qname.getLocalName());
                }
                try {
                    long address;
                    long delta;
                    long last;
                    int len;
                    lock.acquire(1);
                    is = this.dbElement.getAsStream(ref);
                    this.os.clear();
                    oldList.clear();
                    if (is != null) {
                        try {
                            while (is.available() > 0) {
                                int docId = is.readInt();
                                len = is.readInt();
                                if (docId != oldDoc.getDocId()) {
                                    this.os.writeInt(docId);
                                    this.os.writeInt(len);
                                    is.copyTo(this.os, len * 4);
                                    continue;
                                }
                                last = 0L;
                                for (int j = 0; j < len; ++j) {
                                    long gid;
                                    delta = is.readLong();
                                    last = gid = last + delta;
                                    address = StorageAddress.read(is);
                                    if (node == null && oldDoc.getTreeLevel(gid) < oldDoc.reindexRequired()) {
                                        idList.add(new NodeProxy(oldDoc, gid, address));
                                        continue;
                                    }
                                    if (node == null || XMLUtil.isDescendant(oldDoc, node.getGID(), gid)) continue;
                                    oldList.add(new NodeProxy(oldDoc, gid, address));
                                }
                            }
                        }
                        catch (EOFException e) {
                        }
                        catch (IOException e) {
                            LOG.error((Object)("io-error while updating index for element " + qname));
                        }
                    }
                    if (node != null) {
                        idList.addAll(oldList);
                    }
                    FastQSort.sort(idList, 0, idList.size() - 1);
                    len = idList.size();
                    this.os.writeInt(this.doc.getDocId());
                    this.os.writeInt(len);
                    last = 0L;
                    for (int j = 0; j < len; ++j) {
                        NodeProxy p = (NodeProxy)idList.get(j);
                        delta = p.gid - last;
                        last = p.gid;
                        this.os.writeLong(delta);
                        StorageAddress.write(p.getInternalAddress(), this.os);
                    }
                    if (is == null) {
                        this.dbElement.put(ref, this.os.data());
                        continue;
                    }
                    address = ((BFile.PageInputStream)((Object)is)).getAddress();
                    this.dbElement.update(address, ref, this.os.data());
                }
                catch (LockException e) {
                    LOG.error((Object)("could not acquire lock for index on " + qname));
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)("io error while reindexing " + qname), (Throwable)e);
                    is = null;
                }
                finally {
                    lock.release(1);
                }
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"database is read only");
        }
        this.elementIds.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (this.elementIds.size() == 0) {
            return;
        }
        Lock lock = this.dbElement.getLock();
        ArrayList<NodeProxy> newList = new ArrayList<NodeProxy>();
        short collectionId = this.doc.getCollection().getId();
        try {
            Iterator i = this.elementIds.entrySet().iterator();
            while (i.hasNext()) {
                try {
                    long delta;
                    long last;
                    int len;
                    ElementValue ref;
                    lock.acquire(1);
                    Map.Entry entry = i.next();
                    ArrayList idList = (ArrayList)entry.getValue();
                    QName qname = (QName)entry.getKey();
                    if (qname.getNameType() != 2) {
                        short sym = this.broker.getSymbols().getSymbol(qname.getLocalName());
                        short nsSym = this.broker.getSymbols().getNSSymbol(qname.getNamespaceURI());
                        ref = new ElementValue(qname.getNameType(), collectionId, sym, nsSym);
                    } else {
                        ref = new ElementValue(qname.getNameType(), collectionId, qname.getLocalName());
                    }
                    Value val = this.dbElement.get(ref);
                    this.os.clear();
                    newList.clear();
                    if (val != null) {
                        byte[] data = val.getData();
                        VariableByteArrayInput is = new VariableByteArrayInput(data);
                        try {
                            while (is.available() > 0) {
                                int docId = is.readInt();
                                len = is.readInt();
                                if (docId != this.doc.getDocId()) {
                                    this.os.writeInt(docId);
                                    this.os.writeInt(len);
                                    try {
                                        is.copyTo(this.os, len * 4);
                                    }
                                    catch (EOFException e) {
                                        LOG.error((Object)("EOF while copying: expected: " + len));
                                    }
                                    continue;
                                }
                                last = 0L;
                                for (int j = 0; j < len; ++j) {
                                    long gid;
                                    delta = is.readLong();
                                    last = gid = last + delta;
                                    long address = StorageAddress.read(is);
                                    if (NativeElementIndex.containsNode(idList, gid)) continue;
                                    newList.add(new NodeProxy(this.doc, gid, address));
                                }
                            }
                        }
                        catch (EOFException e) {
                            LOG.error((Object)("end-of-file while updating index for element " + qname));
                        }
                        catch (IOException e) {
                            LOG.error((Object)("io-error while updating index for element " + qname));
                        }
                    }
                    FastQSort.sort(newList, 0, newList.size() - 1);
                    len = newList.size();
                    this.os.writeInt(this.doc.getDocId());
                    this.os.writeInt(len);
                    last = 0L;
                    for (int j = 0; j < len; ++j) {
                        NodeProxy p = (NodeProxy)newList.get(j);
                        delta = p.gid - last;
                        last = p.gid;
                        this.os.writeLong(delta);
                        StorageAddress.write(p.getInternalAddress(), this.os);
                    }
                    if (val == null) {
                        this.dbElement.put(ref, this.os.data());
                        continue;
                    }
                    this.dbElement.update(val.getAddress(), ref, this.os.data());
                }
                catch (LockException e) {
                    LOG.error((Object)"could not acquire lock on elements", (Throwable)e);
                }
                finally {
                    lock.release();
                }
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"database is read only");
        }
        this.elementIds.clear();
    }

    private static final boolean containsNode(List list, long gid) {
        for (int i = 0; i < list.size(); ++i) {
            if (((NodeProxy)list.get((int)i)).gid != gid) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.elementIds.size() == 0) {
            return;
        }
        ProgressIndicator progress = new ProgressIndicator(this.elementIds.size(), 5);
        int count = 1;
        short collectionId = this.doc.getCollection().getId();
        Lock lock = this.dbElement.getLock();
        try {
            Iterator i = this.elementIds.entrySet().iterator();
            while (i.hasNext()) {
                ElementValue ref;
                Map.Entry entry = i.next();
                QName qname = (QName)entry.getKey();
                ArrayList idList = (ArrayList)entry.getValue();
                this.os.clear();
                FastQSort.sort(idList, 0, idList.size() - 1);
                int len = idList.size();
                this.os.writeInt(this.doc.getDocId());
                this.os.writeInt(len);
                long prevId = 0L;
                for (int j = 0; j < len; ++j) {
                    NodeProxy proxy = (NodeProxy)idList.get(j);
                    long cid = proxy.gid - prevId;
                    prevId = proxy.gid;
                    this.os.writeLong(cid);
                    StorageAddress.write(proxy.getInternalAddress(), this.os);
                }
                if (qname.getNameType() != 2) {
                    short sym = this.broker.getSymbols().getSymbol(qname.getLocalName());
                    short nsSym = this.broker.getSymbols().getNSSymbol(qname.getNamespaceURI());
                    ref = new ElementValue(qname.getNameType(), collectionId, sym, nsSym);
                } else {
                    ref = new ElementValue(qname.getNameType(), collectionId, qname.getLocalName());
                }
                try {
                    lock.acquire(1);
                    if (this.dbElement.append(ref, this.os.data()) < 0L) {
                        LOG.warn((Object)("could not save index for element " + qname));
                        continue;
                    }
                }
                catch (LockException e) {
                    LOG.error((Object)"could not acquire lock on elements", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error((Object)("io error while writing element " + qname), (Throwable)e);
                }
                finally {
                    lock.release();
                    continue;
                }
                progress.setValue(count);
                if (progress.changed()) {
                    this.setChanged();
                    this.notifyObservers(progress);
                }
                ++count;
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"database is read-only");
            return;
        }
        progress.finish();
        this.setChanged();
        this.notifyObservers(progress);
        this.elementIds.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        Lock lock = this.dbElement.getLock();
        try {
            lock.acquire(1);
            try {
                this.dbElement.flush();
            }
            catch (DBException dbe) {
                LOG.warn((Object)dbe);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)"could not acquire lock for elements", (Throwable)e);
        }
        finally {
            lock.release();
        }
    }

    public boolean close() throws DBException {
        return this.dbElement.close();
    }

    public void printStatistics() {
        this.dbElement.printStatistics();
    }
}

