/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.exist.source.AbstractSource;
import org.exist.source.Source;

public class URLSource
extends AbstractSource {
    private static final Logger LOG = Logger.getLogger((Class)URLSource.class);
    private URL url;
    private URLConnection connection = null;
    private long lastModified = 0L;

    public URLSource(URL url) {
        this.url = url;
    }

    private long getLastModification() {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            return this.connection.getLastModified();
        }
        catch (IOException e) {
            LOG.warn((Object)("URL could not be opened: " + e.getMessage()), (Throwable)e);
            return 0L;
        }
    }

    public Object getKey() {
        return this.url.toString();
    }

    public int isValid() {
        long modified = this.getLastModification();
        if (modified == 0L && modified > this.lastModified) {
            return -1;
        }
        return 1;
    }

    public int isValid(Source other) {
        return -1;
    }

    public Reader getReader() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            InputStreamReader reader = new InputStreamReader(this.connection.getInputStream(), "UTF-8");
            this.connection = null;
            return reader;
        }
        catch (IOException e) {
            LOG.warn((Object)("URL could not be opened: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getContent() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            String content = this.connection.getContent().toString();
            this.connection = null;
            return content;
        }
        catch (IOException e) {
            LOG.warn((Object)("URL could not be opened: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

