/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SecurityManager {
    public static final String ACL_FILE = "users.xml";
    public static final String DBA_GROUP = "dba";
    public static final String DBA_USER = "admin";
    public static final String GUEST_GROUP = "guest";
    public static final String GUEST_USER = "guest";
    public static final String SYSTEM = "/db/system";
    private static final Logger LOG = Logger.getLogger((Class)SecurityManager.class);
    private BrokerPool pool;
    private Int2ObjectHashMap groups;
    private Int2ObjectHashMap users;
    private int nextUserId;
    private int nextGroupId;
    private BrokerPool brokerPool;

    public SecurityManager(BrokerPool pool, DBBroker sysBroker) {
        block13: {
            this.groups = new Int2ObjectHashMap(65);
            this.users = new Int2ObjectHashMap(65);
            this.nextUserId = 0;
            this.nextGroupId = 0;
            this.pool = pool;
            DBBroker broker = sysBroker;
            try {
                Collection sysCollection = broker.getCollection(SYSTEM);
                if (sysCollection == null) {
                    sysCollection = broker.getOrCreateCollection(SYSTEM);
                    sysCollection.setPermissions(504);
                    broker.saveCollection(sysCollection);
                }
                DocumentImpl acl = sysCollection.getDocument(broker, ACL_FILE);
                Element docElement = null;
                if (acl != null) {
                    docElement = acl.getDocumentElement();
                }
                if (docElement == null) {
                    LOG.debug((Object)"creating system users");
                    User user = new User(DBA_USER, null);
                    user.addGroup(DBA_GROUP);
                    user.setUID(++this.nextUserId);
                    this.users.put(user.getUID(), user);
                    user = new User("guest", "guest", "guest");
                    user.setUID(++this.nextUserId);
                    this.users.put(user.getUID(), user);
                    this.addGroup(DBA_GROUP);
                    this.addGroup("guest");
                    this.save(broker);
                    break block13;
                }
                LOG.debug((Object)"loading acl");
                Element root = acl.getDocumentElement();
                NodeList nl = root.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node;
                    int j;
                    NodeList ul;
                    String lastId;
                    if (nl.item(i).getNodeType() != 1) continue;
                    Element next = (Element)nl.item(i);
                    if (next.getTagName().equals("users")) {
                        lastId = next.getAttribute("last-id");
                        try {
                            this.nextUserId = Integer.parseInt(lastId);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        ul = next.getChildNodes();
                        for (j = 0; j < ul.getLength(); ++j) {
                            node = ul.item(j);
                            if (node.getNodeType() != 1 || !node.getLocalName().equals("user")) continue;
                            User user = new User((Element)node);
                            this.users.put(user.getUID(), user);
                        }
                        continue;
                    }
                    if (!next.getTagName().equals("groups")) continue;
                    lastId = next.getAttribute("last-id");
                    try {
                        this.nextGroupId = Integer.parseInt(lastId);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    ul = next.getChildNodes();
                    for (j = 0; j < ul.getLength(); ++j) {
                        node = ul.item(j);
                        if (node.getNodeType() != 1 || !node.getLocalName().equals("group")) continue;
                        Group group = new Group((Element)node);
                        this.groups.put(group.getId(), group);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.debug((Object)("loading acl failed: " + e.getMessage()));
            }
        }
    }

    public synchronized void deleteUser(String name) throws PermissionDeniedException {
        this.deleteUser(this.getUser(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteUser(User user) throws PermissionDeniedException {
        if (user == null) {
            return;
        }
        if (user.getName().equals(DBA_USER) || user.getName().equals("guest")) {
            throw new PermissionDeniedException("user " + user.getName() + " is required by the system. It cannot be removed.");
        }
        if ((user = (User)this.users.remove(user.getUID())) != null) {
            LOG.debug((Object)("user " + user.getName() + " removed"));
        } else {
            LOG.debug((Object)"user not found");
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get();
            this.save(broker);
        }
        catch (EXistException e) {
            e.printStackTrace();
        }
        finally {
            this.pool.release(broker);
        }
    }

    public synchronized User getUser(String name) {
        Iterator i = this.users.valueIterator();
        while (i.hasNext()) {
            User user = (User)i.next();
            if (!user.getName().equals(name)) continue;
            return user;
        }
        LOG.debug((Object)("user " + name + " not found"));
        return null;
    }

    public synchronized User getUser(int uid) {
        User user = (User)this.users.get(uid);
        if (user == null) {
            LOG.debug((Object)("user with uid " + uid + " not found"));
        }
        return user;
    }

    public synchronized User[] getUsers() {
        User[] u = new User[this.users.size()];
        int j = 0;
        Iterator i = this.users.valueIterator();
        while (i.hasNext()) {
            u[j] = (User)i.next();
            ++j;
        }
        return u;
    }

    public synchronized void addGroup(String name) {
        Group group = new Group(name, ++this.nextGroupId);
        this.groups.put(group.getId(), group);
    }

    public synchronized boolean hasGroup(String name) {
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            if (!group.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized Group getGroup(String name) {
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public synchronized Group getGroup(int gid) {
        return (Group)this.groups.get(gid);
    }

    public synchronized String[] getGroups() {
        ArrayList<String> list = new ArrayList<String>(this.groups.size());
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            list.add(group.getName());
        }
        String[] gl = new String[list.size()];
        list.toArray(gl);
        return gl;
    }

    public synchronized boolean hasAdminPrivileges(User user) {
        return user.hasGroup(DBA_GROUP);
    }

    public synchronized boolean hasUser(String name) {
        Iterator i = this.users.valueIterator();
        while (i.hasNext()) {
            User user = (User)i.next();
            if (!user.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized void save(DBBroker broker) throws EXistException {
        LOG.debug((Object)"storing acl file");
        StringBuffer buf = new StringBuffer();
        buf.append("<auth>");
        buf.append("<groups last-id=\"");
        buf.append(Integer.toString(this.nextGroupId));
        buf.append("\">");
        Iterator i = this.groups.valueIterator();
        while (i.hasNext()) {
            buf.append(((Group)i.next()).toString());
        }
        buf.append("</groups>");
        buf.append("<users last-id=\"");
        buf.append(Integer.toString(this.nextUserId));
        buf.append("\">");
        i = this.users.valueIterator();
        while (i.hasNext()) {
            buf.append(((User)i.next()).toString());
        }
        buf.append("</users>");
        buf.append("</auth>");
        broker.flush();
        broker.sync(1);
        try {
            broker.setUser(this.getUser(DBA_USER));
            Collection sysCollection = broker.getCollection(SYSTEM);
            DocumentImpl doc = sysCollection.addDocument(broker, ACL_FILE, buf.toString(), true);
            doc.setPermissions(504);
            broker.saveCollection(doc.getCollection());
        }
        catch (SAXException e) {
            throw new EXistException(e.getMessage());
        }
        catch (PermissionDeniedException e) {
            throw new EXistException(e.getMessage());
        }
        catch (TriggerException e) {
            throw new EXistException(e.getMessage());
        }
        catch (LockException e) {
            throw new EXistException(e.getMessage());
        }
        broker.flush();
        broker.sync(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setUser(User user) {
        if (user.getUID() < 0) {
            user.setUID(++this.nextUserId);
        }
        this.users.put(user.getUID(), user);
        Iterator i = user.getGroups();
        while (i.hasNext()) {
            String group = (String)i.next();
            if (this.hasGroup(group)) continue;
            this.addGroup(group);
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get();
            this.save(broker);
            this.createUserHome(broker, user);
        }
        catch (EXistException e) {
            LOG.debug((Object)"error while creating user", (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            LOG.debug((Object)"error while create home collection", (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    private void createUserHome(DBBroker broker, User user) throws EXistException, PermissionDeniedException {
        if (user.getHome() == null) {
            return;
        }
        broker.setUser(this.getUser(DBA_USER));
        Collection home = broker.getOrCreateCollection(user.getHome());
        home.getPermissions().setOwner(user.getName());
        home.getPermissions().setGroup(user.getPrimaryGroup());
        broker.saveCollection(home);
    }

    public BrokerPool getBrokerPool() {
        return this.brokerPool;
    }

    public void setBrokerPool(BrokerPool brokerPool) {
        this.brokerPool = brokerPool;
    }
}

