/*
 * Decompiled with CFR 0.152.
 */
package org.exist.schema.test;

import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.exist.schema.SchemaService;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.XMLType;
import org.w3c.dom.Node;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class GenericSchemaServiceTest
extends TestCase {
    private static final String URI = "xmldb:exist:///db";
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private Collection rootCollection = null;
    private static final String ADDRESSBOOK_SCHEMA = "<?xml version='1.0'?><xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'    targetNamespace='http://jmvanel.free.fr/xsd/addressBook'    xmlns='http://jmvanel.free.fr/xsd/addressBook' elementFormDefault='qualified'>  <xsd:attribute name='uselessAttribute' type='xsd:string'/>  <xsd:complexType name='record'>      <xsd:sequence>         <xsd:element name='cname' type='xsd:string'/>        <xsd:element name='email' type='xsd:string'/>      </xsd:sequence>   </xsd:complexType>   <xsd:element name='addressBook'>     <xsd:complexType>         <xsd:sequence>         <xsd:element name='owner' type='record'/>        <xsd:element name='person' type='record'                       minOccurs='0' maxOccurs='unbounded'/>        </xsd:sequence>            </xsd:complexType>   </xsd:element> </xsd:schema> ";
    private static final String ADDRESSBOOK_DOCUMENT = "<?xml version='1.0'?> <addressBook xmlns='http://jmvanel.free.fr/xsd/addressBook'>      <owner>         <cname>John Punin</cname>        <email>puninj@cs.rpi.edu</email>     </owner>      <person>         <cname>Harrison Ford</cname>        <email>hford@famous.org</email>      </person>      <person>         <cname>Julia Roberts</cname>        <email>jr@pw.com</email>      </person> </addressBook> ";
    private static final String ADDRESSBOOK_DOCUMENT_INVALID = "<?xml version='1.0'?> <addressBook xmlns='http://jmvanel.free.fr/xsd/addressBook'>      <owner>         <cname>John Punin</cname>        <email>puninj@cs.rpi.edu</email>     </owner>      <person>         <cname>Harrison Ford</cname>        <email>hford@famous.org</email>      </person>      <person>         <name>Julia Roberts</name>        <email>jr@pw.com</email>      </person> </addressBook> ";
    private static final String TRANSIENT_SCHEMA = "<?xml version='1.0'?><xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'    targetNamespace='http://somewhere.invalid/transient'    xmlns:t='http://somewhere.invalid/transient' elementFormDefault='qualified'>  <xsd:element name='testElement' type='xsd:string'/></xsd:schema>";
    private static final String TRANSIENT_TEST_DOCUMENT = "<testElement xmlns='http://somewhere.invalid/transient'>test Strings can contain numbers: 123</testElement>";

    public GenericSchemaServiceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Class<?> cl = Class.forName(DRIVER);
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        this.rootCollection = DatabaseManager.getCollection((String)URI, (String)"admin", null);
        if (this.rootCollection == null) {
            throw new Exception("Could not connect to database.");
        }
    }

    private SchemaService getSchemaService() throws XMLDBException {
        return (SchemaService)this.rootCollection.getService("SchemaService", "1.0");
    }

    protected void insertSchemas() throws XMLDBException {
        SchemaService service = this.getSchemaService();
        service.putSchema(ADDRESSBOOK_SCHEMA);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetName() throws Exception {
        this.getSchemaService().getName().equals("SchemaService");
    }

    public void testGetVersion() throws XMLDBException {
        this.getSchemaService().getVersion().equals("1.0");
    }

    public void testPutSchema() throws XMLDBException {
        this.getSchemaService().putSchema(ADDRESSBOOK_SCHEMA);
        GenericSchemaServiceTest.assertNotNull((Object)this.getSchemaService().getSchema("http://jmvanel.free.fr/xsd/addressBook"));
    }

    public void testGetSchema() throws XMLDBException {
        this.insertSchemas();
        XMLResource schema = this.getSchemaService().getSchema("http://jmvanel.free.fr/xsd/addressBook");
        GenericSchemaServiceTest.assertNotNull((Object)schema);
        Node domSchema = schema.getContentAsDOM();
        String targetNamespace = domSchema.getAttributes().getNamedItem("targetNamespace").getNodeValue();
        GenericSchemaServiceTest.assertEquals((String)targetNamespace, (String)"http://jmvanel.free.fr/xsd/addressBook");
    }

    public void testValidateContents() throws XMLDBException {
        this.insertSchemas();
        GenericSchemaServiceTest.assertTrue((boolean)this.getSchemaService().validateContents(ADDRESSBOOK_DOCUMENT));
        try {
            this.getSchemaService().validateContents(ADDRESSBOOK_DOCUMENT_INVALID);
            GenericSchemaServiceTest.assertTrue((boolean)false);
        }
        catch (XMLDBException e) {
            GenericSchemaServiceTest.assertTrue((boolean)true);
            String message = e.getMessage();
            System.out.println(message);
            GenericSchemaServiceTest.assertTrue((message.indexOf("Invalid content") > -1 ? 1 : 0) != 0);
            GenericSchemaServiceTest.assertTrue((message.indexOf("element 'name'") > -1 ? 1 : 0) != 0);
        }
    }

    public void testValidateResource() throws XMLDBException {
        Collection collection = DatabaseManager.getCollection((String)URI, (String)"admin", null);
        XMLResource resource = (XMLResource)collection.createResource("addressbook.xml", "XMLResource");
        resource.setContent((Object)ADDRESSBOOK_DOCUMENT);
        collection.storeResource((Resource)resource);
        resource = (XMLResource)collection.createResource("addressbook_invalid.xml", "XMLResource");
        resource.setContent((Object)ADDRESSBOOK_DOCUMENT_INVALID);
        collection.storeResource((Resource)resource);
        GenericSchemaServiceTest.assertTrue((boolean)this.getSchemaService().validateResource("addressbook.xml"));
        try {
            this.getSchemaService().validateResource("addressbook_invalid.xml");
            GenericSchemaServiceTest.assertTrue((boolean)false);
        }
        catch (XMLDBException e) {
            GenericSchemaServiceTest.assertTrue((boolean)true);
            String message = e.getCause().getMessage();
            System.out.println(message);
            GenericSchemaServiceTest.assertTrue((message.indexOf("Invalid content") > -1 ? 1 : 0) != 0);
            GenericSchemaServiceTest.assertTrue((message.indexOf("element 'name'") > -1 ? 1 : 0) != 0);
        }
    }

    public void testGetAttribute() throws XMLDBException {
        this.insertSchemas();
        AttributeDecl attribute = this.getSchemaService().getAttribute(new QName("http://jmvanel.free.fr/xsd/addressBook", "uselessAttribute"));
        GenericSchemaServiceTest.assertNotNull((Object)attribute);
        GenericSchemaServiceTest.assertEquals((String)"uselessAttribute", (String)attribute.getName());
    }

    public void testGetElement() throws XMLDBException {
        this.insertSchemas();
        ElementDecl element = this.getSchemaService().getElement(new QName("http://jmvanel.free.fr/xsd/addressBook", "addressBook"));
        GenericSchemaServiceTest.assertNotNull((Object)element);
        GenericSchemaServiceTest.assertEquals((String)"addressBook", (String)element.getName());
    }

    public void testGetType() throws XMLDBException {
        this.insertSchemas();
        XMLType type = this.getSchemaService().getType(new QName("http://jmvanel.free.fr/xsd/addressBook", "record"));
        GenericSchemaServiceTest.assertNotNull((Object)type);
        GenericSchemaServiceTest.assertEquals((String)"record", (String)type.getName());
    }

    public void testIsKnownNamespace() throws XMLDBException {
        this.insertSchemas();
        GenericSchemaServiceTest.assertEquals((boolean)true, (boolean)this.getSchemaService().isKnownNamespace("http://jmvanel.free.fr/xsd/addressBook"));
        GenericSchemaServiceTest.assertEquals((boolean)false, (boolean)this.getSchemaService().isKnownNamespace("http://dont.have.this.namespace"));
    }

    public void testRegisterTransientSchema() throws XMLDBException {
        SchemaService service = this.getSchemaService();
        service.registerTransientSchema(TRANSIENT_SCHEMA);
        GenericSchemaServiceTest.assertTrue((boolean)service.validateContents(TRANSIENT_TEST_DOCUMENT));
    }

    public void testRebuildIndex() throws XMLDBException {
        this.insertSchemas();
        this.getSchemaService().rebuildIndex();
        this.getSchemaService().isKnownNamespace("http://jmvanel.free.fr/xsd/addressBook");
    }
}

