/*
 * Decompiled with CFR 0.152.
 */
package org.exist.schema.internalaccess;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.schema.SchemaAccess;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xmldb.api.base.XMLDBException;

public class InternalSchemaAccess
implements SchemaAccess {
    private static InternalSchemaAccess singleInstance = null;
    private BrokerPool brokerPool = null;
    private Hashtable schemaCache = new Hashtable();
    private Hashtable typeCache = new Hashtable();
    private Hashtable elementCache = new Hashtable();
    private Hashtable attributeCache = new Hashtable();
    private static final String SCHEMA_COLLECTION_PATH = "/db/system/schema";
    private static final String INDEX_NAME = "/db/system/schema/.index";

    private InternalSchemaAccess() throws EXistException {
        this.brokerPool = BrokerPool.getInstance();
    }

    public static InternalSchemaAccess getSingleInstance() throws EXistException {
        if (singleInstance == null) {
            singleInstance = new InternalSchemaAccess();
        }
        return singleInstance;
    }

    private String getDocumentAsString(String docName) throws XMLDBException {
        DBBroker broker;
        block7: {
            broker = null;
            broker = this.brokerPool.get();
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            DocumentImpl doc = (DocumentImpl)this.getDocumentAsDOM(docName);
            if (doc == null) break block7;
            String string = serializer.serialize(doc);
            Object var7_8 = null;
            if (broker != null) {
                this.brokerPool.release(broker);
            }
            return string;
        }
        try {
            String string = null;
            Object var7_9 = null;
            if (broker != null) {
                this.brokerPool.release(broker);
            }
            return string;
        }
        catch (Exception e) {
            try {
                throw new XMLDBException(1, "Error getting document " + docName, (Throwable)e);
            }
            catch (Throwable throwable) {
                block8: {
                    Object var7_10 = null;
                    if (broker == null) break block8;
                    this.brokerPool.release(broker);
                }
                throw throwable;
            }
        }
    }

    private Document getDocumentAsDOM(String docName) throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get();
            DocumentImpl documentImpl = (DocumentImpl)broker.getDocument(docName);
            Object var6_4 = null;
            if (broker != null) {
                this.brokerPool.release(broker);
            }
            return documentImpl;
        }
        catch (Exception e) {
            try {
                throw new XMLDBException(1, "Error getting document " + docName, (Throwable)e);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_5 = null;
                    if (broker == null) break block5;
                    this.brokerPool.release(broker);
                }
                throw throwable;
            }
        }
    }

    private String getSchemaFilename(String targetNamespace) throws XMLDBException {
        if (targetNamespace == null) {
            throw new XMLDBException(1, "null is not a valid namespace!");
        }
        Element root = this.getDocumentAsDOM(INDEX_NAME).getDocumentElement();
        if ("schema-index".equals(root.getNodeName())) {
            NodeList schemas = root.getChildNodes();
            for (int i = 0; i < schemas.getLength(); ++i) {
                Node targetNamespaceAttr;
                Node schema = schemas.item(i);
                if (!"schema".equals(schema.getNodeName()) || (targetNamespaceAttr = schema.getAttributes().getNamedItem("targetNamespace")) == null || !targetNamespace.equals(targetNamespaceAttr.getNodeValue())) continue;
                return schema.getAttributes().getNamedItem("resourceName").getNodeValue();
            }
        } else {
            throw new XMLDBException(1, "invalid schema index. Unexpected root element " + root.getNodeName(), null);
        }
        return null;
    }

    public Schema getCastorSchema(String targetNamespace) throws XMLDBException {
        Schema castorSchema;
        block5: {
            String schemaFilename;
            castorSchema = (Schema)this.schemaCache.get(targetNamespace);
            if (castorSchema == null && (schemaFilename = this.getSchemaFilename(targetNamespace)) != null) {
                try {
                    String schema = this.getDocumentAsString("/db/system/schema/" + schemaFilename);
                    if (schema != null) {
                        castorSchema = new SchemaReader(new InputSource(new StringReader(schema))).read();
                        if (castorSchema != null) {
                            this.schemaCache.put(targetNamespace, castorSchema);
                        }
                        break block5;
                    }
                    throw new XMLDBException(1, "Schema document for target namespace " + targetNamespace + " not found even though it is in the index.", null);
                }
                catch (IOException e) {
                    throw new XMLDBException(1, "Error parsing schema " + targetNamespace, (Throwable)e);
                }
            }
        }
        return castorSchema;
    }

    public void putSchema(String schemaContents) throws XMLDBException {
        throw new UnsupportedOperationException("InternalSchemaAccess does not support storing of schemas.");
    }

    public boolean validate(String id) throws XMLDBException {
        return false;
    }

    public XMLType getType(QName qname) throws XMLDBException {
        if (qname.getNamespaceURI() == null || "".equals(qname.getNamespaceURI())) {
            throw new IllegalArgumentException("QName " + qname.toString() + " is not fully qualified.");
        }
        XMLType type = (XMLType)this.typeCache.get(qname);
        if (type == null) {
            Schema schema = this.getCastorSchema(qname.getNamespaceURI());
            type = schema.getType(qname.getLocalPart());
            this.typeCache.put(qname, type);
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ElementDecl getElement(QName qname) throws XMLDBException {
        if (qname.getNamespaceURI() == null || "".equals(qname.getNamespaceURI())) {
            throw new IllegalArgumentException("QName " + qname.toString() + " is not fully qualified.");
        }
        ElementDecl element = (ElementDecl)this.elementCache.get(qname);
        if (element != null) return element;
        Schema schema = this.getCastorSchema(qname.getNamespaceURI());
        if (schema == null) return null;
        element = schema.getElementDecl(qname.getLocalPart());
        if (element == null) return null;
        this.elementCache.put(qname, element);
        return element;
    }

    public AttributeDecl getAttribute(QName qname) throws XMLDBException {
        if (qname.getNamespaceURI() == null || "".equals(qname.getNamespaceURI())) {
            throw new IllegalArgumentException("QName " + qname.toString() + " is not fully qualified.");
        }
        AttributeDecl attribute = (AttributeDecl)this.attributeCache.get(qname);
        if (attribute == null) {
            Schema schema = this.getCastorSchema(qname.getNamespaceURI());
            attribute = schema.getAttribute(qname.getLocalPart());
            this.attributeCache.put(qname, attribute);
        }
        return attribute;
    }

    public boolean isKnownNamespace(String namespaceURI) throws XMLDBException {
        return this.getCastorSchema(namespaceURI) != null;
    }
}

