/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree.test;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.util.serializer.DOMSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DOMTest
extends TestCase {
    private static final String file = "samples/biblio.rdf";
    private static final String xml = "<test count=\"1\" value=\"5543\" xmlns:x=\"http://foo.org\" xmlns=\"http://bla.org\"><x:title id=\"s1\">My title</x:title><paragraph>First paragraph</paragraph><section><title>subsection</title></section></test>";

    public static void main(String[] args) {
        TestRunner.run((Class)DOMTest.class);
    }

    public DOMTest(String name) {
        super(name);
    }

    public void testDocumentBuilder() throws Exception {
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setContentHandler(receiver);
        reader.parse(new InputSource(new StringReader(xml)));
        Document doc = receiver.getDocument();
        Node node = doc.getFirstChild();
        StringWriter writer = new StringWriter();
        DOMSerializer serializer = new DOMSerializer(writer, null);
        serializer.serialize(node);
        System.out.println(writer.toString());
    }

    public void print(Node node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    System.out.println('<' + node.getNodeName() + '>');
                    break;
                }
                case 3: {
                    System.out.println(node.getNodeValue());
                    break;
                }
                default: {
                    System.out.println("unknown node type");
                }
            }
            if (node.hasChildNodes()) {
                this.print(node.getFirstChild());
            }
            node = node.getNextSibling();
        }
    }
}

