/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import java.util.Arrays;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.xquery.XQueryContext;
import org.xml.sax.Attributes;

public class MemTreeBuilder {
    protected DocumentImpl doc;
    protected short level = 1;
    protected int[] prevNodeInLevel;
    protected XQueryContext context = null;

    public MemTreeBuilder() {
        this(null);
    }

    public MemTreeBuilder(XQueryContext context) {
        this.context = context;
        this.prevNodeInLevel = new int[15];
        Arrays.fill(this.prevNodeInLevel, -1);
        this.prevNodeInLevel[0] = 0;
    }

    public DocumentImpl getDocument() {
        return this.doc;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public int getSize() {
        return this.doc.getSize();
    }

    public void startDocument() {
        this.doc = new DocumentImpl(this.context);
    }

    public void endDocument() {
    }

    public int startElement(String namespaceURI, String localName, String qname, Attributes attributes) {
        int p = qname.indexOf(58);
        String prefix = null;
        if (this.context != null) {
            prefix = this.context.getPrefixForURI(namespaceURI);
        }
        if (prefix == null) {
            prefix = p > -1 ? qname.substring(0, p) : "";
        }
        QName qn = new QName(localName, namespaceURI, prefix);
        return this.startElement(qn, attributes);
    }

    public int startElement(QName qn, Attributes attributes) {
        int prevNr;
        int nodeNr = this.doc.addNode((short)1, this.level, qn);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrNS = attributes.getURI(i);
                String attrLocalName = attributes.getLocalName(i);
                String attrQName = attributes.getQName(i);
                if (attrQName.startsWith("xmlns") || attrNS.equals("http://exist.sourceforge.net/NS/exist")) continue;
                int p = attrQName.indexOf(58);
                String attrPrefix = p > -1 ? attrQName.substring(0, p) : null;
                p = this.doc.addAttribute(nodeNr, new QName(attrLocalName, attrNS, attrPrefix), attributes.getValue(i));
            }
        }
        if (this.level + 1 >= this.prevNodeInLevel.length) {
            int[] t = new int[this.level + 2];
            System.arraycopy(this.prevNodeInLevel, 0, t, 0, this.level);
            this.prevNodeInLevel = t;
        }
        if ((prevNr = this.prevNodeInLevel[this.level]) > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        this.level = (short)(this.level + 1);
        return nodeNr;
    }

    public void endElement() {
        this.prevNodeInLevel[this.level] = -1;
        this.level = (short)(this.level - 1);
    }

    public int addReferenceNode(NodeProxy proxy) {
        int nodeNr = this.doc.addNode((short)100, this.level, null);
        this.doc.addReferenceNode(nodeNr, proxy);
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        return nodeNr;
    }

    public int addAttribute(QName qname, String value) {
        int lastNode = this.doc.getLastNode();
        lastNode = 0 < lastNode && this.doc.nodeKind[lastNode] != 1 ? this.characters(value) : this.doc.addAttribute(lastNode, qname, value);
        return lastNode;
    }

    public int characters(char[] ch, int start, int len) {
        int nodeNr = this.doc.addNode((short)3, this.level, null);
        this.doc.addChars(nodeNr, ch, start, len);
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        return nodeNr;
    }

    public int characters(CharSequence s) {
        int nodeNr = this.doc.addNode((short)3, this.level, null);
        this.doc.addChars(nodeNr, s);
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        return nodeNr;
    }

    public int comment(CharSequence data) {
        int nodeNr = this.doc.addNode((short)8, this.level, null);
        this.doc.addChars(nodeNr, data);
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        return nodeNr;
    }

    public int comment(char[] ch, int start, int len) {
        int nodeNr = this.doc.addNode((short)8, this.level, null);
        this.doc.addChars(nodeNr, ch, start, len);
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        return nodeNr;
    }

    public int processingInstruction(String target, String data) {
        QName qn = new QName(target, null, null);
        int nodeNr = this.doc.addNode((short)7, this.level, qn);
        this.doc.addChars(nodeNr, data);
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        return nodeNr;
    }

    public int namespaceNode(String prefix, String uri) {
        return this.namespaceNode(new QName(prefix, uri, "xmlns"));
    }

    public int namespaceNode(QName qn) {
        int lastNode = this.doc.getLastNode();
        int nodeNr = this.doc.addNamespace(lastNode, qn);
        return nodeNr;
    }
}

