/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import java.util.Arrays;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.memtree.AttributeImpl;
import org.exist.memtree.CommentImpl;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.ElementImpl;
import org.exist.memtree.NamespaceNode;
import org.exist.memtree.NodeImpl;
import org.exist.memtree.ProcessingInstructionImpl;
import org.exist.memtree.ReferenceNode;
import org.exist.memtree.TextImpl;
import org.exist.storage.serializers.Serializer;
import org.exist.util.hashtable.NamePool;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DocumentImpl
extends NodeImpl
implements Document {
    protected XQueryContext context;
    protected NamePool namePool = new NamePool();
    protected short[] nodeKind = null;
    protected short[] treeLevel;
    protected int[] next;
    protected int[] nodeName;
    protected int[] alpha;
    protected int[] alphaLen;
    protected char[] characters;
    protected int nextChar = 0;
    protected int[] attrName;
    protected int[] attrParent;
    protected String[] attrValue;
    protected int nextAttr = 0;
    protected int[] namespaceParent;
    protected int[] namespaceCode;
    protected int nextNamespace = 0;
    protected int size = 1;
    protected int documentRootNode = -1;
    protected NodeProxy[] references;
    protected int nextRef = 0;
    private static final int NODE_SIZE = 128;
    private static final int ATTR_SIZE = 64;
    private static final int CHAR_BUF_SIZE = 1024;
    private static final int REF_SIZE = 128;

    public DocumentImpl(XQueryContext context) {
        super(null, 0);
        this.context = context;
    }

    private void init() {
        this.nodeKind = new short[128];
        this.treeLevel = new short[128];
        this.next = new int[128];
        Arrays.fill(this.next, -1);
        this.nodeName = new int[128];
        this.alpha = new int[128];
        this.alphaLen = new int[128];
        Arrays.fill(this.alphaLen, -1);
        this.characters = new char[1024];
        this.attrName = new int[64];
        this.attrParent = new int[64];
        this.attrValue = new String[64];
        this.namespaceCode = new int[5];
        this.namespaceParent = new int[5];
        this.references = new NodeProxy[128];
        this.treeLevel[0] = 0;
        this.nodeKind[0] = 9;
        this.document = this;
    }

    public void reset() {
        this.size = 0;
        this.nextChar = 0;
        this.nextAttr = 0;
        this.nextRef = 0;
    }

    public int getSize() {
        return this.size;
    }

    public int addNode(short kind, short level, QName qname) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.size == this.nodeKind.length) {
            this.grow();
        }
        this.nodeKind[this.size] = kind;
        this.treeLevel[this.size] = level;
        this.nodeName[this.size] = qname != null ? this.namePool.add(qname) : -1;
        this.alpha[this.size] = -1;
        this.next[this.size] = -1;
        return this.size++;
    }

    public void addChars(int nodeNr, char[] ch, int start, int len) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alpha[nodeNr] = this.nextChar;
        this.alphaLen[nodeNr] = len;
        System.arraycopy(ch, start, this.characters, this.nextChar, len);
        this.nextChar += len;
    }

    public void addChars(int nodeNr, CharSequence s) {
        int len;
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextChar + (len = s.length()) >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alpha[nodeNr] = this.nextChar;
        this.alphaLen[nodeNr] = len;
        for (int i = 0; i < len; ++i) {
            this.characters[this.nextChar++] = s.charAt(i);
        }
    }

    public void addReferenceNode(int nodeNr, NodeProxy proxy) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextRef == this.references.length) {
            this.growReferences();
        }
        this.references[this.nextRef] = proxy;
        ++this.nextRef;
    }

    public int addAttribute(int nodeNr, QName qname, String value) throws DOMException {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextAttr == this.attrName.length) {
            this.growAttributes();
        }
        this.attrParent[this.nextAttr] = nodeNr;
        this.attrName[this.nextAttr] = this.namePool.add(qname);
        this.attrValue[this.nextAttr] = value;
        if (this.alpha[nodeNr] < 0) {
            this.alpha[nodeNr] = this.nextAttr;
        }
        return this.nextAttr++;
    }

    public int addNamespace(int nodeNr, QName qname) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.nextNamespace == this.namespaceCode.length) {
            this.growNamespaces();
        }
        this.namespaceCode[this.nextNamespace] = this.namePool.add(qname);
        this.namespaceParent[this.nextNamespace] = nodeNr;
        if (this.alphaLen[nodeNr] < 0) {
            this.alphaLen[nodeNr] = this.nextNamespace;
        }
        return this.nextNamespace++;
    }

    public int getLastNode() {
        return this.size - 1;
    }

    private void grow() {
        int newSize = this.size * 3 / 2;
        short[] newNodeKind = new short[newSize];
        System.arraycopy(this.nodeKind, 0, newNodeKind, 0, this.size);
        this.nodeKind = newNodeKind;
        short[] newTreeLevel = new short[newSize];
        System.arraycopy(this.treeLevel, 0, newTreeLevel, 0, this.size);
        this.treeLevel = newTreeLevel;
        int[] newNext = new int[newSize];
        Arrays.fill(newNext, -1);
        System.arraycopy(this.next, 0, newNext, 0, this.size);
        this.next = newNext;
        int[] newNodeName = new int[newSize];
        System.arraycopy(this.nodeName, 0, newNodeName, 0, this.size);
        this.nodeName = newNodeName;
        int[] newAlpha = new int[newSize];
        System.arraycopy(this.alpha, 0, newAlpha, 0, this.size);
        this.alpha = newAlpha;
        int[] newAlphaLen = new int[newSize];
        Arrays.fill(newAlphaLen, -1);
        System.arraycopy(this.alphaLen, 0, newAlphaLen, 0, this.size);
        this.alphaLen = newAlphaLen;
    }

    private void growAttributes() {
        int size = this.attrName.length;
        int newSize = size * 3 / 2;
        int[] newAttrName = new int[newSize];
        System.arraycopy(this.attrName, 0, newAttrName, 0, size);
        this.attrName = newAttrName;
        int[] newAttrParent = new int[newSize];
        System.arraycopy(this.attrParent, 0, newAttrParent, 0, size);
        this.attrParent = newAttrParent;
        String[] newAttrValue = new String[newSize];
        System.arraycopy(this.attrValue, 0, newAttrValue, 0, size);
        this.attrValue = newAttrValue;
    }

    private void growReferences() {
        int size = this.references.length;
        int newSize = size * 3 / 2;
        NodeProxy[] newReferences = new NodeProxy[newSize];
        System.arraycopy(this.references, 0, newReferences, 0, size);
        this.references = newReferences;
    }

    private void growNamespaces() {
        int size = this.namespaceCode.length;
        int newSize = size * 3 / 2;
        int[] newCodes = new int[newSize];
        System.arraycopy(this.namespaceCode, 0, newCodes, 0, size);
        this.namespaceCode = newCodes;
        int[] newParents = new int[newSize];
        System.arraycopy(this.namespaceParent, 0, newParents, 0, size);
        this.namespaceParent = newParents;
    }

    public NodeImpl getAttribute(int nodeNr) throws DOMException {
        return new AttributeImpl(this, nodeNr);
    }

    public NodeImpl getNamespaceNode(int nodeNr) throws DOMException {
        return new NamespaceNode(this, nodeNr);
    }

    /*
     * WARNING - void declaration
     */
    public NodeImpl getNode(int nodeNr) throws DOMException {
        void var2_2;
        if (nodeNr == 0) {
            return this;
        }
        if (nodeNr >= this.size) {
            throw new DOMException(3, "node not found");
        }
        switch (this.nodeKind[nodeNr]) {
            case 1: {
                NodeImpl node = new ElementImpl(this, nodeNr);
                break;
            }
            case 3: {
                NodeImpl node = new TextImpl(this, nodeNr);
                break;
            }
            case 8: {
                NodeImpl node = new CommentImpl(this, nodeNr);
                break;
            }
            case 7: {
                NodeImpl node = new ProcessingInstructionImpl(this, nodeNr);
                break;
            }
            case 100: {
                NodeImpl node = new ReferenceNode(this, nodeNr);
                break;
            }
            default: {
                throw new DOMException(8, "node not found");
            }
        }
        return var2_2;
    }

    public Node getParentNode() {
        return null;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return null;
    }

    public Element getDocumentElement() {
        if (this.size == 1) {
            return null;
        }
        int nodeNr = 1;
        while (this.nodeKind[nodeNr] != 1) {
            if (this.next[nodeNr] < nodeNr) {
                return null;
            }
            nodeNr = this.next[nodeNr];
        }
        return (Element)((Object)this.getNode(nodeNr));
    }

    public Node getFirstChild() {
        if (this.size > 1) {
            return this.getNode(1);
        }
        return null;
    }

    public Element createElement(String arg0) throws DOMException {
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String arg0) {
        return null;
    }

    public Comment createComment(String arg0) {
        return null;
    }

    public CDATASection createCDATASection(String arg0) throws DOMException {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String arg0, String arg1) throws DOMException {
        return null;
    }

    public Attr createAttribute(String arg0) throws DOMException {
        return null;
    }

    public EntityReference createEntityReference(String arg0) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagName(String arg0) {
        return null;
    }

    public Node importNode(Node arg0, boolean arg1) throws DOMException {
        return null;
    }

    public Element createElementNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    public Attr createAttributeNS(String arg0, String arg1) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return null;
    }

    public Element getElementById(String arg0) {
        return null;
    }

    public Document getOwnerDocument() {
        return this;
    }

    public void copyTo(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        NodeImpl top = node;
        while (node != null) {
            this.copyStartNode(node, receiver);
            NodeImpl nextNode = (NodeImpl)node.getFirstChild();
            while (nextNode == null) {
                this.copyEndNode(node, receiver);
                if (top != null && top.nodeNumber == node.nodeNumber) break;
                nextNode = (NodeImpl)node.getNextSibling();
                if (nextNode != null || (node = (NodeImpl)node.getParentNode()) != null && (top == null || top.nodeNumber != node.nodeNumber)) continue;
                this.copyEndNode(node, receiver);
                nextNode = null;
                break;
            }
            node = nextNode;
        }
    }

    private void copyStartNode(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        int nr = node.nodeNumber;
        switch (node.getNodeType()) {
            case 1: {
                int ns;
                int attr;
                QName nodeName = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                receiver.startElement(nodeName, null);
                if (-1 < attr) {
                    for (attr = this.document.alpha[nr]; attr < this.document.nextAttr && this.document.attrParent[attr] == nr; ++attr) {
                        QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
                        receiver.attribute(attrQName, this.attrValue[attr]);
                    }
                }
                if (-1 >= (ns = this.document.alphaLen[nr])) break;
                XQueryContext context = receiver.getContext();
                while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr) {
                    QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                    receiver.addNamespaceNode(nsQName);
                    context.declareInScopeNamespace(nsQName.getLocalName(), nsQName.getNamespaceURI());
                    ++ns;
                }
                break;
            }
            case 3: {
                receiver.characters(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 2: {
                QName attrQName = (QName)this.document.namePool.get(this.document.attrName[nr]);
                receiver.attribute(attrQName, this.attrValue[nr]);
                break;
            }
            case 8: {
                receiver.comment(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                String data = new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                receiver.processingInstruction(qn.getLocalName(), data);
                break;
            }
            case 100: {
                receiver.addReferenceNode(this.document.references[this.document.alpha[nr]]);
            }
        }
    }

    private void copyEndNode(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        if (node.getNodeType() == 1) {
            receiver.endElement(node.getQName());
        }
    }

    public void streamTo(Serializer serializer, NodeImpl node, Receiver receiver) throws SAXException {
        NodeImpl top = node;
        while (node != null) {
            this.startNode(serializer, node, receiver);
            NodeImpl nextNode = (NodeImpl)node.getFirstChild();
            while (nextNode == null) {
                this.endNode(node, receiver);
                if (top != null && top.nodeNumber == node.nodeNumber) break;
                nextNode = (NodeImpl)node.getNextSibling();
                if (nextNode != null || (node = (NodeImpl)node.getParentNode()) != null && (top == null || top.nodeNumber != node.nodeNumber)) continue;
                this.endNode(node, receiver);
                nextNode = null;
                break;
            }
            node = nextNode;
        }
    }

    private void startNode(Serializer serializer, NodeImpl node, Receiver receiver) throws SAXException {
        int nr = node.nodeNumber;
        switch (node.getNodeType()) {
            case 1: {
                int ns;
                QName nodeName = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                if (-1 < ns) {
                    for (ns = this.document.alphaLen[nr]; ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr; ++ns) {
                        QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                        receiver.startPrefixMapping(nsQName.getLocalName(), nsQName.getNamespaceURI());
                    }
                }
                AttrList attribs = null;
                int attr = this.document.alpha[nr];
                if (-1 < attr) {
                    attribs = new AttrList();
                    while (attr < this.document.nextAttr && this.document.attrParent[attr] == nr) {
                        QName attrQName = (QName)this.document.namePool.get(this.document.attrName[attr]);
                        attribs.addAttribute(attrQName, this.attrValue[attr]);
                        ++attr;
                    }
                }
                receiver.startElement(nodeName, attribs);
                break;
            }
            case 3: {
                receiver.characters(new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]));
                break;
            }
            case 2: {
                QName attrQName = (QName)this.document.namePool.get(this.document.attrName[nr]);
                receiver.attribute(attrQName, this.attrValue[nr]);
                break;
            }
            case 8: {
                receiver.comment(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[nr]);
                String data = new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                receiver.processingInstruction(qn.getLocalName(), data);
                break;
            }
            case 100: {
                serializer.toReceiver(this.document.references[this.document.alpha[nr]]);
            }
        }
    }

    private void endNode(NodeImpl node, Receiver receiver) throws SAXException {
        if (node.getNodeType() == 1) {
            int ns;
            receiver.endElement(node.getQName());
            int nr = node.nodeNumber;
            if (-1 < ns) {
                for (ns = this.document.alphaLen[nr]; ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr; ++ns) {
                    QName nsQName = (QName)this.document.namePool.get(this.document.namespaceCode[ns]);
                    receiver.endPrefixMapping(nsQName.getLocalName());
                }
            }
        }
    }

    protected NodeSet toNodeSet(NodeImpl node) throws XPathException {
        String data;
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        try {
            data = serializer.serialize(node);
        }
        catch (SAXException e) {
            throw new XPathException("Error occurred while storing temporary fragment: " + e.getMessage(), e);
        }
        return this.context.storeTemporaryDoc(data);
    }
}

