/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.CollectionCache;
import org.exist.dom.DocumentImpl;
import org.exist.dom.QName;
import org.exist.http.webdav.WebDAV;
import org.exist.http.webdav.WebDAVUtil;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Propfind
extends AbstractWebDAVMethod {
    private static final int FIND_ALL_PROPERTIES = 0;
    private static final int FIND_BY_PROPERTY = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static final SimpleDateFormat modificationDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final String PREFIX = "D";
    private static final QName DISPLAY_NAME_PROP;
    private static final QName CREATION_DATE_PROP;
    private static final QName RESOURCE_TYPE_PROP;
    private static final QName CONTENT_TYPE_PROP;
    private static final QName CONTENT_LENGTH_PROP;
    private static final QName LAST_MODIFIED_PROP;
    private static final QName SUPPORTED_LOCK_PROP;
    private static final QName EXCLUSIVE_LOCK_PROP;
    private static final QName WRITE_LOCK_PROP;
    private static final QName ETAG_PROP;
    private static final QName STATUS_PROP;
    private static final QName COLLECTION_PROP;
    private static final QName[] DEFAULT_COLLECTION_PROPS;
    private static final QName[] DEFAULT_RESOURCE_PROPS;

    public Propfind(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        CollectionCache collectionCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            block51: {
                block50: {
                    block47: {
                        block46: {
                            block45: {
                                try {
                                    try {
                                        DocumentBuilder docBuilder;
                                        broker = this.pool.get(user);
                                        collection = broker.openCollection(path, 0);
                                        if (collection == null) {
                                            int pos = path.lastIndexOf(47);
                                            String collName = path.substring(0, pos);
                                            String docName = path.substring(pos + 1);
                                            collection = broker.openCollection(collName, 0);
                                            if (collection == null) {
                                                LOG.debug((Object)("No resource or collection found for path: " + path));
                                                response.sendError(404, "No resource or collection found");
                                                Object var21_16 = null;
                                                if (resource != null) {
                                                    resource.getUpdateLock().release(0);
                                                }
                                                if (collection != null) {
                                                    collection.release();
                                                }
                                                this.pool.release(broker);
                                                return;
                                            }
                                            resource = collection.getDocumentWithLock(broker, docName, 0);
                                            if (resource == null) {
                                                LOG.debug((Object)("No resource found for path: " + path));
                                                response.sendError(404, "No resource or collection found");
                                                break block45;
                                            }
                                        }
                                        if (!collection.getPermissions().validate(user, 4)) {
                                            response.sendError(403);
                                            break block46;
                                        }
                                        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                                        docFactory.setNamespaceAware(true);
                                        try {
                                            docBuilder = docFactory.newDocumentBuilder();
                                        }
                                        catch (ParserConfigurationException e1) {
                                            throw new ServletException("Failed to create XML parser: ", (Throwable)e1);
                                        }
                                        Document doc = WebDAVUtil.parseRequestContent(request, response, docBuilder);
                                        int type = 0;
                                        DAVProperties searchedProperties = new DAVProperties();
                                        if (doc != null) {
                                            Element propfind = doc.getDocumentElement();
                                            if (!propfind.getLocalName().equals("propfind") || !propfind.getNamespaceURI().equals("DAV:")) {
                                                LOG.debug((Object)("Unexpected element found: " + propfind.getNodeName()));
                                                response.sendError(400, "Unexpected element found: " + propfind.getNodeName());
                                                break block47;
                                            }
                                            NodeList childNodes = propfind.getChildNodes();
                                            for (int i = 0; i < childNodes.getLength(); ++i) {
                                                Node currentNode = childNodes.item(i);
                                                if (currentNode.getNodeType() != 1) continue;
                                                if (currentNode.getNamespaceURI().equals("DAV:")) {
                                                    if (currentNode.getLocalName().equals("prop")) {
                                                        type = 1;
                                                        this.getPropertyNames(currentNode, searchedProperties);
                                                    }
                                                    if (currentNode.getLocalName().equals("allprop")) {
                                                        type = 0;
                                                    }
                                                    if (!currentNode.getLocalName().equals("propname")) continue;
                                                    type = 2;
                                                    continue;
                                                }
                                                LOG.debug((Object)("Unexpected child: " + currentNode.getNodeName()));
                                                response.sendError(400, "Unexpected element found: " + currentNode.getNodeName());
                                                Object var21_20 = null;
                                                if (resource != null) {
                                                    resource.getUpdateLock().release(0);
                                                }
                                                if (collection != null) {
                                                    collection.release();
                                                }
                                                this.pool.release(broker);
                                                return;
                                            }
                                        }
                                        String servletPath = this.getServletPath(request);
                                        int depth = this.getDepth(request);
                                        StringWriter os = new StringWriter();
                                        SAXSerializer serializer = SAXSerializerPool.getInstance().borrowSAXSerializer();
                                        try {
                                            serializer.setWriter(os);
                                            serializer.setOutputProperties(WebDAV.OUTPUT_PROPERTIES);
                                            AttributesImpl attrs = new AttributesImpl();
                                            serializer.startDocument();
                                            serializer.startPrefixMapping(PREFIX, "DAV:");
                                            serializer.startElement("DAV:", "multistatus", "D:multistatus", attrs);
                                            if (type == 0 || type == 1) {
                                                if (resource != null) {
                                                    this.writeResourceProperties(user, searchedProperties, type, collection, resource, serializer, servletPath);
                                                } else {
                                                    this.writeCollectionProperties(user, broker, searchedProperties, type, collection, serializer, servletPath, depth, 0);
                                                }
                                            } else if (type == 2) {
                                                this.writePropertyNames(collection, resource, serializer, servletPath);
                                            }
                                            serializer.endElement("DAV:", "multistatus", "D:multistatus");
                                            serializer.endPrefixMapping(PREFIX);
                                            serializer.endDocument();
                                        }
                                        catch (SAXException e) {
                                            throw new ServletException("Exception while writing multistatus response: " + e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            SAXSerializerPool.getInstance().returnSAXSerializer(serializer);
                                        }
                                        String content = os.toString();
                                        LOG.debug((Object)("response:\n" + content));
                                        this.writeResponse(response, content);
                                        break block50;
                                    }
                                    catch (EXistException e) {
                                        throw new ServletException(e.getMessage(), (Throwable)e);
                                    }
                                    catch (LockException e) {
                                        response.sendError(500, e.getMessage());
                                        Object var21_22 = null;
                                        if (resource != null) {
                                            resource.getUpdateLock().release(0);
                                        }
                                        if (collection != null) {
                                            collection.release();
                                        }
                                        this.pool.release(broker);
                                        break block51;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var21_23 = null;
                                    if (resource != null) {
                                        resource.getUpdateLock().release(0);
                                    }
                                    if (collection != null) {
                                        collection.release();
                                    }
                                    this.pool.release(broker);
                                    throw throwable;
                                }
                            }
                            Object var21_17 = null;
                            if (resource != null) {
                                resource.getUpdateLock().release(0);
                            }
                            if (collection != null) {
                                collection.release();
                            }
                            this.pool.release(broker);
                            return;
                        }
                        Object var21_18 = null;
                        if (resource != null) {
                            resource.getUpdateLock().release(0);
                        }
                        if (collection != null) {
                            collection.release();
                        }
                        this.pool.release(broker);
                        return;
                    }
                    Object var21_19 = null;
                    if (resource != null) {
                        resource.getUpdateLock().release(0);
                    }
                    if (collection != null) {
                        collection.release();
                    }
                    this.pool.release(broker);
                    return;
                }
                Object var21_21 = null;
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
                if (collection != null) {
                    collection.release();
                }
                this.pool.release(broker);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCollectionProperties(User user, DBBroker broker, DAVProperties searchedProperties, int type, Collection collection, SAXSerializer serializer, String servletPath, int maxDepth, int currentDepth) throws SAXException {
        List unvisited;
        if (!collection.getPermissions().validate(user, 4)) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        searchedProperties.reset();
        serializer.startElement("DAV:", "response", "D:response", attrs);
        serializer.startElement("DAV:", "href", "D:href", attrs);
        serializer.characters(servletPath + collection.getName());
        serializer.endElement("DAV:", "href", "D:href");
        serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
        serializer.startElement("DAV:", "prop", "D:prop", attrs);
        if (this.shouldIncludeProperty(type, searchedProperties, DISPLAY_NAME_PROP)) {
            String displayName = collection.getName();
            int p = displayName.lastIndexOf(47);
            if (p > -1) {
                displayName = displayName.substring(p + 1);
            }
            this.writeSimpleElement(DISPLAY_NAME_PROP, displayName, serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, RESOURCE_TYPE_PROP)) {
            serializer.startElement("DAV:", "resourcetype", "D:resourcetype", attrs);
            this.writeEmptyElement(COLLECTION_PROP, serializer);
            serializer.endElement("DAV:", "resourcetype", "D:resourcetype");
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CREATION_DATE_PROP)) {
            long created = collection.getCreationTime();
            this.writeSimpleElement(CREATION_DATE_PROP, creationDateFormat.format(new Date(created)), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, LAST_MODIFIED_PROP)) {
            long created = collection.getCreationTime();
            this.writeSimpleElement(LAST_MODIFIED_PROP, modificationDateFormat.format(new Date(created)), serializer);
        }
        serializer.endElement("DAV:", "prop", "D:prop");
        this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 200 OK", serializer);
        serializer.endElement("DAV:", "propstat", "D:propstat");
        if (type == 1 && (unvisited = searchedProperties.unvisitedProperties()).size() > 0) {
            serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
            serializer.startElement("DAV:", "prop", "D:prop", attrs);
            Iterator i = unvisited.iterator();
            while (i.hasNext()) {
                this.writeEmptyElement((QName)i.next(), serializer);
            }
            serializer.endElement("DAV:", "prop", "D:prop");
            this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 404 Not Found", serializer);
            serializer.endElement("DAV:", "propstat", "D:propstat");
        }
        serializer.endElement("DAV:", "response", "D:response");
        if (currentDepth++ < maxDepth) {
            if (collection.getDocumentCount() > 0) {
                Iterator i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    try {
                        doc.getUpdateLock().acquire(0);
                        this.writeResourceProperties(user, searchedProperties, type, collection, doc, serializer, servletPath);
                    }
                    catch (LockException e) {
                        LOG.debug((Object)("Failed to acquire lock on document " + doc.getName()));
                    }
                    finally {
                        doc.getUpdateLock().release(0);
                    }
                }
            }
            if (collection.getChildCollectionCount() > 0) {
                Iterator i = collection.collectionIterator();
                while (i.hasNext()) {
                    String child = (String)i.next();
                    Collection childCollection = null;
                    try {
                        childCollection = broker.openCollection(collection.getName() + '/' + child, 0);
                        if (childCollection == null) continue;
                        this.writeCollectionProperties(user, broker, searchedProperties, type, childCollection, serializer, servletPath, maxDepth, currentDepth);
                    }
                    catch (Exception e) {}
                    continue;
                    finally {
                        if (childCollection != null) {
                            childCollection.release();
                        }
                    }
                }
            }
        }
    }

    private void writeResourceProperties(User user, DAVProperties searchedProperties, int type, Collection collection, DocumentImpl resource, SAXSerializer serializer, String servletPath) throws SAXException {
        List unvisited;
        if (!resource.getPermissions().validate(user, 4)) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        searchedProperties.reset();
        serializer.startElement("DAV:", "response", "D:response", attrs);
        serializer.startElement("DAV:", "href", "D:href", attrs);
        serializer.characters(servletPath + collection.getName() + '/' + resource.getFileName());
        serializer.endElement("DAV:", "href", "D:href");
        serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
        serializer.startElement("DAV:", "prop", "D:prop", attrs);
        if (this.shouldIncludeProperty(type, searchedProperties, DISPLAY_NAME_PROP)) {
            this.writeSimpleElement(DISPLAY_NAME_PROP, resource.getFileName(), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, RESOURCE_TYPE_PROP)) {
            this.writeEmptyElement(RESOURCE_TYPE_PROP, serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CREATION_DATE_PROP)) {
            long created = resource.getCreated();
            this.writeSimpleElement(CREATION_DATE_PROP, creationDateFormat.format(new Date(created)), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, LAST_MODIFIED_PROP)) {
            long modified = resource.getLastModified();
            this.writeSimpleElement(LAST_MODIFIED_PROP, modificationDateFormat.format(new Date(modified)), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CONTENT_LENGTH_PROP)) {
            this.writeSimpleElement(CONTENT_LENGTH_PROP, Long.toString(resource.getContentLength()), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CONTENT_TYPE_PROP)) {
            if (resource.getResourceType() == 0) {
                this.writeSimpleElement(CONTENT_TYPE_PROP, "text/xml", serializer);
            } else {
                this.writeSimpleElement(CONTENT_TYPE_PROP, "application/octet-stream", serializer);
            }
        }
        if (this.shouldIncludeProperty(type, searchedProperties, SUPPORTED_LOCK_PROP)) {
            serializer.startElement("DAV:", "supportedlock", "D:supportedlock", attrs);
            serializer.startElement("DAV:", "lockentry", "D:lockentry", attrs);
            serializer.startElement("DAV:", "lockscope", "D:lockscope", attrs);
            this.writeEmptyElement(EXCLUSIVE_LOCK_PROP, serializer);
            serializer.endElement("DAV:", "lockscope", "D:lockscope");
            serializer.startElement("DAV:", "locktype", "D:locktype", attrs);
            this.writeEmptyElement(WRITE_LOCK_PROP, serializer);
            serializer.endElement("DAV:", "locktype", "D:locktype");
            serializer.endElement("DAV:", "lockentry", "D:lockentry");
            serializer.endElement("DAV:", "supportedlock", "D:supportedlock");
        }
        serializer.endElement("DAV:", "prop", "D:prop");
        this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 200 OK", serializer);
        serializer.endElement("DAV:", "propstat", "D:propstat");
        if (type == 1 && (unvisited = searchedProperties.unvisitedProperties()).size() > 0) {
            serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
            serializer.startElement("DAV:", "prop", "D:prop", attrs);
            Iterator i = unvisited.iterator();
            while (i.hasNext()) {
                this.writeEmptyElement((QName)i.next(), serializer);
            }
            serializer.endElement("DAV:", "prop", "D:prop");
            this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 404 Not Found", serializer);
            serializer.endElement("DAV:", "propstat", "D:propstat");
        }
        serializer.endElement("DAV:", "response", "D:response");
    }

    private void writePropertyNames(Collection collection, DocumentImpl resource, SAXSerializer serializer, String servletPath) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        serializer.startElement("DAV:", "response", "D:response", attrs);
        serializer.startElement("DAV:", "href", "D:href", attrs);
        String href = servletPath + (resource != null ? collection.getName() + '/' + resource.getFileName() : collection.getName());
        serializer.characters(href);
        serializer.endElement("DAV:", "href", "D:href");
        serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
        serializer.startElement("DAV:", "prop", "D:prop", attrs);
        QName[] defaults = resource == null ? DEFAULT_COLLECTION_PROPS : DEFAULT_RESOURCE_PROPS;
        for (int i = 0; i < defaults.length; ++i) {
            this.writeEmptyElement(defaults[i], serializer);
        }
        serializer.endElement("DAV:", "prop", "D:prop");
        this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 200 OK", serializer);
        serializer.endElement("DAV:", "propstat", "D:propstat");
        serializer.endElement("DAV:", "response", "D:response");
    }

    private boolean shouldIncludeProperty(int type, DAVProperties properties, QName name) {
        if (type == 0) {
            return true;
        }
        return properties.includeProperty(name);
    }

    private void writeEmptyElement(QName qname, SAXSerializer serializer) throws SAXException {
        serializer.startElement("DAV:", qname.getLocalName(), qname.toString(), new AttributesImpl());
        serializer.endElement("DAV:", qname.getLocalName(), qname.toString());
    }

    private void writeSimpleElement(QName element, String content, SAXSerializer serializer) throws SAXException {
        serializer.startElement("DAV:", element.getLocalName(), element.toString(), new AttributesImpl());
        serializer.characters(content);
        serializer.endElement("DAV:", element.getLocalName(), element.toString());
    }

    private void writeResponse(HttpServletResponse response, String content) throws IOException {
        response.setStatus(207);
        response.setContentType("text/xml; charset=UTF-8");
        byte[] data = content.getBytes("UTF-8");
        response.setContentLength(data.length);
        ServletOutputStream os = response.getOutputStream();
        os.write(data);
        os.flush();
    }

    private String getServletPath(HttpServletRequest request) {
        String servletPath = request.getContextPath();
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        if ((servletPath = servletPath + request.getServletPath()).endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        return servletPath;
    }

    protected int getDepth(HttpServletRequest req) {
        int depth = 1;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null && depthStr.equals("0")) {
            depth = 0;
        }
        return depth;
    }

    private void getPropertyNames(Node propNode, DAVProperties properties) {
        NodeList childList = propNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node currentNode = childList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            properties.add(currentNode);
        }
    }

    static {
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        modificationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        DISPLAY_NAME_PROP = new QName("displayname", "DAV:", PREFIX);
        CREATION_DATE_PROP = new QName("creationdate", "DAV:", PREFIX);
        RESOURCE_TYPE_PROP = new QName("resourcetype", "DAV:", PREFIX);
        CONTENT_TYPE_PROP = new QName("getcontenttype", "DAV:", PREFIX);
        CONTENT_LENGTH_PROP = new QName("getcontentlength", "DAV:", PREFIX);
        LAST_MODIFIED_PROP = new QName("getlastmodified", "DAV:", PREFIX);
        SUPPORTED_LOCK_PROP = new QName("supportedlock", "DAV:", PREFIX);
        EXCLUSIVE_LOCK_PROP = new QName("exclusive", "DAV:", PREFIX);
        WRITE_LOCK_PROP = new QName("write", "DAV:", PREFIX);
        ETAG_PROP = new QName("etag", "DAV:", PREFIX);
        STATUS_PROP = new QName("status", "DAV:", PREFIX);
        COLLECTION_PROP = new QName("collection", "DAV:", PREFIX);
        DEFAULT_COLLECTION_PROPS = new QName[]{DISPLAY_NAME_PROP, RESOURCE_TYPE_PROP, CREATION_DATE_PROP, LAST_MODIFIED_PROP};
        DEFAULT_RESOURCE_PROPS = new QName[]{DISPLAY_NAME_PROP, RESOURCE_TYPE_PROP, CREATION_DATE_PROP, LAST_MODIFIED_PROP, CONTENT_TYPE_PROP, CONTENT_LENGTH_PROP, SUPPORTED_LOCK_PROP};
    }

    private static class DAVProperties
    extends HashMap {
        DAVProperties() {
        }

        void add(Node node) {
            QName qname = new QName(node.getLocalName(), node.getNamespaceURI());
            if (node.getNamespaceURI().equals("DAV:")) {
                qname.setPrefix(Propfind.PREFIX);
            } else {
                qname.setPrefix(node.getPrefix());
            }
            if (!this.containsKey(qname)) {
                this.put(qname, new Visited());
            }
        }

        boolean includeProperty(QName property) {
            Visited visited = (Visited)this.get(property);
            if (visited == null) {
                return false;
            }
            boolean include = !visited.isVisited();
            visited.setVisited(true);
            return include;
        }

        List unvisitedProperties() {
            ArrayList list = new ArrayList(5);
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (((Visited)entry.getValue()).visited) continue;
                list.add(entry.getKey());
            }
            return list;
        }

        void reset() {
            Iterator i = this.values().iterator();
            while (i.hasNext()) {
                Visited visited = (Visited)i.next();
                visited.setVisited(false);
            }
        }
    }

    private static class Visited {
        boolean visited = false;

        private Visited() {
        }

        boolean isVisited() {
            return this.visited;
        }

        void setVisited(boolean visit) {
            this.visited = visit;
        }
    }
}

