/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.WebDAV;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.xml.sax.SAXException;

public class Get
extends AbstractWebDAVMethod {
    private static final String SERIALIZE_ERROR = "Error while serializing document: ";

    public Get(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        byte[] contentData;
        block18: {
            DocumentImpl resource;
            DBBroker broker;
            block17: {
                block16: {
                    broker = null;
                    contentData = null;
                    resource = null;
                    try {
                        try {
                            broker = this.pool.get();
                            resource = broker.openDocument(path, 0);
                            if (resource == null) {
                                response.sendError(403, "GET is not available on collections");
                                Object var12_8 = null;
                                if (resource != null) {
                                    resource.getUpdateLock().release(0);
                                }
                                this.pool.release(broker);
                                return;
                            }
                            if (!resource.getPermissions().validate(user, 4)) {
                                response.sendError(403, "Not allowed to read resource");
                                break block16;
                            }
                            String contentType = resource.getResourceType() == 0 ? "text/xml" : "application/octet-stream";
                            response.setContentType(contentType);
                            response.addDateHeader("Last-Modified", resource.getLastModified());
                            if (resource.getResourceType() == 0) {
                                Serializer serializer = broker.getSerializer();
                                serializer.reset();
                                try {
                                    serializer.setProperties(WebDAV.OUTPUT_PROPERTIES);
                                    String content = serializer.serialize(resource);
                                    contentData = content.getBytes("UTF-8");
                                    break block17;
                                }
                                catch (SAXException e) {
                                    throw new ServletException(SERIALIZE_ERROR + e.getMessage(), (Throwable)e);
                                }
                            }
                            contentData = broker.getBinaryResourceData((BinaryDocument)resource);
                            break block17;
                        }
                        catch (EXistException e) {
                            throw new ServletException(SERIALIZE_ERROR + e.getMessage(), (Throwable)e);
                        }
                        catch (PermissionDeniedException e) {
                            response.sendError(403, "Not allowed to read resource");
                            Object var12_11 = null;
                            if (resource != null) {
                                resource.getUpdateLock().release(0);
                            }
                            this.pool.release(broker);
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (resource != null) {
                            resource.getUpdateLock().release(0);
                        }
                        this.pool.release(broker);
                        throw throwable;
                    }
                }
                Object var12_9 = null;
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
                this.pool.release(broker);
                return;
            }
            Object var12_10 = null;
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
            this.pool.release(broker);
        }
        if (contentData == null) {
            response.sendError(404);
            return;
        }
        response.setContentLength(contentData.length);
        ServletOutputStream os = response.getOutputStream();
        os.write(contentData);
        os.flush();
    }
}

