/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;

public class Delete
extends AbstractWebDAVMethod {
    public Delete(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        block26: {
            Collection collection;
            DBBroker broker;
            block25: {
                block24: {
                    block23: {
                        broker = null;
                        collection = null;
                        DocumentImpl resource = null;
                        try {
                            try {
                                broker = this.pool.get(user);
                                collection = broker.openCollection(path, 1);
                                if (collection == null) {
                                    int pos = path.lastIndexOf(47);
                                    String collName = path.substring(0, pos);
                                    String docName = path.substring(pos + 1);
                                    LOG.debug((Object)("collection = " + collName + "; doc = " + docName));
                                    collection = broker.openCollection(collName, 1);
                                    if (collection == null) {
                                        LOG.debug((Object)("No resource or collection found for path: " + path));
                                        response.sendError(404, "No resource or collection found");
                                        Object var12_15 = null;
                                        if (collection != null) {
                                            collection.release();
                                        }
                                        this.pool.release(broker);
                                        return;
                                    }
                                    resource = collection.getDocument(broker, docName);
                                    if (resource == null) {
                                        LOG.debug((Object)("No resource found for path: " + path));
                                        response.sendError(404, "No resource or collection found");
                                        break block23;
                                    }
                                }
                                if (!collection.getPermissions().validate(user, 4)) {
                                    LOG.debug((Object)"Permission denied to read collection");
                                    response.sendError(403);
                                    break block24;
                                }
                                if (resource == null) {
                                    broker.removeCollection(collection);
                                    break block25;
                                }
                                if (resource.getResourceType() == 1) {
                                    collection.removeBinaryResource(broker, resource.getFileName());
                                    break block25;
                                } else {
                                    collection.removeDocument(broker, resource.getFileName());
                                }
                                break block25;
                            }
                            catch (EXistException e) {
                                response.sendError(500, e.getMessage());
                                Object var12_19 = null;
                                if (collection != null) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block26;
                            }
                            catch (PermissionDeniedException e) {
                                response.sendError(403, e.getMessage());
                                Object var12_20 = null;
                                if (collection != null) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block26;
                            }
                            catch (LockException e) {
                                response.sendError(409, e.getMessage());
                                Object var12_21 = null;
                                if (collection != null) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block26;
                            }
                            catch (TriggerException e) {
                                response.sendError(409, e.getMessage());
                                Object var12_22 = null;
                                if (collection != null) {
                                    collection.release();
                                }
                                this.pool.release(broker);
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_23 = null;
                            if (collection != null) {
                                collection.release();
                            }
                            this.pool.release(broker);
                            throw throwable;
                        }
                    }
                    Object var12_16 = null;
                    if (collection != null) {
                        collection.release();
                    }
                    this.pool.release(broker);
                    return;
                }
                Object var12_17 = null;
                if (collection != null) {
                    collection.release();
                }
                this.pool.release(broker);
                return;
            }
            Object var12_18 = null;
            if (collection != null) {
                collection.release();
            }
            this.pool.release(broker);
        }
        response.setStatus(204);
    }
}

