/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import junit.framework.TestCase;

public class RESTServiceTest
extends TestCase {
    private static final String SERVER_URI = "http://localhost:8088";
    private static final String RESOURCE_URI = "http://localhost:8088/db/test/test.xml";
    private static final String COLLECTION_URI = "http://localhost:8088/db/test";
    private static final String XML_DATA = "<test><para>\u00e4\u00e4\u00fc\u00fc\u00f6\u00f6\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc</para></test>";
    private static final String XUPDATE = "<xu:modifications xmlns:xu=\"http://www.xmldb.org/xupdate\" version=\"1.0\"><xu:append select=\"/test\" child=\"1\"><para>Inserted paragraph.</para></xu:append></xu:modifications>";
    private static final String QUERY_REQUEST = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><query xmlns=\"http://exist.sourceforge.net/NS/exist\"><properties><property name=\"indent\" value=\"yes\"/><property name=\"encoding\" value=\"UTF-8\"/></properties><text>xquery version \"1.0\";(::pragma exist:serialize indent=no ::)//para[. = '\u00e4\u00e4\u00fc\u00fc\u00f6\u00f6\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc']/text()</text></query>";

    public RESTServiceTest(String name) {
        super(name);
    }

    public void testPut() throws IOException {
        System.out.println("--- Storing document ---");
        HttpURLConnection connect = this.getConnection(RESOURCE_URI);
        connect.setRequestMethod("PUT");
        connect.setDoOutput(true);
        connect.setRequestProperty("ContentType", "text/xml");
        OutputStreamWriter writer = new OutputStreamWriter(connect.getOutputStream(), "UTF-8");
        writer.write(XML_DATA);
        ((Writer)writer).close();
        connect.connect();
        int r = connect.getResponseCode();
        RESTServiceTest.assertEquals((String)("Server returned response code " + r), (int)200, (int)r);
        this.doGet();
    }

    public void testXUpdate() throws IOException {
        HttpURLConnection connect = this.preparePost(XUPDATE);
        connect.connect();
        int r = connect.getResponseCode();
        RESTServiceTest.assertEquals((String)("Server returned response code " + r), (int)200, (int)r);
        this.doGet();
    }

    public void testQueryPost() throws IOException {
        HttpURLConnection connect = this.preparePost(QUERY_REQUEST);
        connect.connect();
        int r = connect.getResponseCode();
        RESTServiceTest.assertEquals((String)("Server returned response code " + r), (int)200, (int)r);
        System.out.println(this.readResponse(connect.getInputStream()));
    }

    public void testQueryGet() throws IOException {
        String uri = "http://localhost:8088/db/test?_query=" + URLEncoder.encode("doc('/db/test/test.xml')//para[. = '\u00e4\u00e4\u00fc\u00fc\u00f6\u00f6\u00c4\u00c4\u00d6\u00d6\u00dc\u00dc']/text()");
        HttpURLConnection connect = this.getConnection(uri);
        connect.setRequestMethod("GET");
        connect.connect();
        int r = connect.getResponseCode();
        RESTServiceTest.assertEquals((String)("Server returned response code " + r), (int)200, (int)r);
        System.out.println(this.readResponse(connect.getInputStream()));
    }

    protected void doGet() throws IOException {
        System.out.println("--- Retrieving document ---");
        HttpURLConnection connect = this.getConnection(RESOURCE_URI);
        connect.setRequestMethod("GET");
        connect.connect();
        int r = connect.getResponseCode();
        RESTServiceTest.assertEquals((String)("Server returned response code " + r), (int)200, (int)r);
        System.out.println(this.readResponse(connect.getInputStream()));
    }

    protected HttpURLConnection preparePost(String content) throws IOException {
        HttpURLConnection connect = this.getConnection(RESOURCE_URI);
        connect.setRequestMethod("POST");
        connect.setDoOutput(true);
        connect.setRequestProperty("ContentType", "text/xml");
        OutputStreamWriter writer = new OutputStreamWriter(connect.getOutputStream(), "UTF-8");
        writer.write(content);
        ((Writer)writer).close();
        return connect;
    }

    protected String readResponse(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuffer out = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            out.append(line);
            out.append("\r\n");
        }
        return out.toString();
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        URL u = new URL(url);
        return (HttpURLConnection)u.openConnection();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

