/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.http.Response;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.serializers.Serializer;
import org.exist.util.LockException;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SAXSerializerPool;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class RESTServer {
    protected static final String NS = "http://exist.sourceforge.net/NS/exist";
    protected static final String XUPDATE_NS = "http://www.xmldb.org/xupdate";
    protected static final Logger LOG = Logger.getLogger((Class)RESTServer.class);
    protected static final Properties defaultProperties = new Properties();
    private static final DateFormat dateFormat;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response doGet(DBBroker broker, Map parameters, String path) throws BadRequestException, PermissionDeniedException, NotFoundException {
        String stylesheet;
        String option;
        String p_start;
        String p_howmany;
        int howmany = 10;
        int start = 1;
        boolean wrap = true;
        Properties outputProperties = new Properties();
        String query = (String)parameters.get("_xpath");
        if (query == null) {
            query = (String)parameters.get("_query");
        }
        if ((p_howmany = (String)parameters.get("_howmany")) != null) {
            try {
                howmany = Integer.parseInt(p_howmany);
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Parameter _howmany should be an int");
            }
        }
        if ((p_start = (String)parameters.get("_start")) != null) {
            try {
                start = Integer.parseInt(p_start);
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Parameter _start should be an int");
            }
        }
        if ((option = (String)parameters.get("_wrap")) != null) {
            wrap = option.equals("yes");
        }
        if ((option = (String)parameters.get("_indent")) != null) {
            outputProperties.setProperty("indent", option);
        }
        if ((stylesheet = (String)parameters.get("_xsl")) != null) {
            if (stylesheet.equals("no")) {
                outputProperties.setProperty("process-xsl-pi", stylesheet);
            } else {
                outputProperties.setProperty("stylesheet", stylesheet);
            }
        } else {
            outputProperties.setProperty("process-xsl-pi", "yes");
        }
        LOG.debug((Object)("stylesheet = " + stylesheet));
        String encoding = (String)parameters.get("_encoding");
        if (encoding != null) {
            outputProperties.setProperty("encoding", encoding);
        } else {
            encoding = "UTF-8";
        }
        Response response = new Response();
        if (query != null) {
            response.setContent(this.search(broker, query, path, howmany, start, outputProperties, wrap));
            return response;
        }
        DocumentImpl d = (DocumentImpl)broker.getDocument(path);
        if (d == null) {
            Collection collection = broker.getCollection(path);
            if (collection == null) throw new NotFoundException("Document " + path + " not found");
            if (collection.getPermissions().validate(broker.getUser(), 4)) return new Response(this.printCollection(broker, collection));
            throw new PermissionDeniedException("Not allowed to read collection");
        }
        if (!d.getPermissions().validate(broker.getUser(), 4)) {
            throw new PermissionDeniedException("Not allowed to read resource");
        }
        if (d.getResourceType() == 1) {
            response.setContent(broker.getBinaryResourceData((BinaryDocument)d));
            return response;
        }
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        if (stylesheet != null) {
            serializer.setStylesheet(d, stylesheet);
            response.setContentType("text/html");
        }
        try {
            serializer.setProperties(outputProperties);
            response.setContent(serializer.serialize(d));
            if (!serializer.isStylesheetApplied()) return response;
            response.setContentType("text/html");
            return response;
        }
        catch (SAXException saxe) {
            LOG.warn((Object)saxe);
            throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
        }
    }

    public Response doPost(DBBroker broker, String content, String path) throws BadRequestException, PermissionDeniedException {
        Response response;
        block32: {
            boolean indent = true;
            boolean summary = false;
            int howmany = 10;
            int start = 1;
            boolean enclose = true;
            String mime = "text/xml";
            Properties outputProperties = new Properties(defaultProperties);
            String query = null;
            response = null;
            try {
                InputSource src = new InputSource(new StringReader(content));
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setNamespaceAware(true);
                DocumentBuilder docBuilder = null;
                try {
                    docBuilder = docFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    LOG.warn((Object)e);
                    throw new BadRequestException(e.getMessage());
                }
                Document doc = docBuilder.parse(src);
                Element root = doc.getDocumentElement();
                String rootNS = root.getNamespaceURI();
                if (rootNS != null && rootNS.equals(NS)) {
                    if (root.getLocalName().equals("query")) {
                        String option = root.getAttribute("start");
                        if (option != null) {
                            try {
                                start = Integer.parseInt(option);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if ((option = root.getAttribute("max")) != null) {
                            try {
                                howmany = Integer.parseInt(option);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if ((option = root.getAttribute("enclose")) != null && option.equals("no")) {
                            enclose = false;
                        }
                        option = root.getAttribute("mime");
                        mime = "text/xml";
                        if (option != null && !option.equals("")) {
                            mime = option;
                        }
                        NodeList children = root.getChildNodes();
                        for (int i = 0; i < children.getLength(); ++i) {
                            Node child = children.item(i);
                            if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(NS)) continue;
                            if (child.getLocalName().equals("text")) {
                                StringBuffer buf = new StringBuffer();
                                for (Node next = child.getFirstChild(); next != null; next = next.getNextSibling()) {
                                    if (next.getNodeType() != 3 && next.getNodeType() != 4) continue;
                                    buf.append(next.getNodeValue());
                                }
                                query = buf.toString();
                                continue;
                            }
                            if (!child.getLocalName().equals("properties")) continue;
                            for (Node node = child.getFirstChild(); node != null; node = node.getNextSibling()) {
                                if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(NS) || !node.getLocalName().equals("property")) continue;
                                Element property = (Element)node;
                                String key = property.getAttribute("name");
                                String value = property.getAttribute("value");
                                LOG.debug((Object)(key + " = " + value));
                                if (key == null || value == null) continue;
                                outputProperties.setProperty(key, value);
                            }
                        }
                    }
                    if (query != null) {
                        response = new Response();
                        response.setContentType(mime);
                        response.setContent(this.search(broker, query, path, howmany, start, outputProperties, enclose));
                        break block32;
                    }
                    throw new BadRequestException("No query specified");
                }
                if (rootNS != null && rootNS.equals(XUPDATE_NS)) {
                    LOG.debug((Object)("Got xupdate request: " + content));
                    DocumentSet docs = new DocumentSet();
                    Collection collection = broker.getCollection(path);
                    if (collection != null) {
                        collection.allDocs(broker, docs, true, true);
                    } else {
                        DocumentImpl xupdateDoc = (DocumentImpl)broker.getDocument(path);
                        if (xupdateDoc != null) {
                            if (!xupdateDoc.getPermissions().validate(broker.getUser(), 4)) {
                                throw new PermissionDeniedException("Not allowed to read collection");
                            }
                            docs.add(xupdateDoc);
                        } else {
                            broker.getAllDocuments(docs);
                        }
                    }
                    XUpdateProcessor processor = new XUpdateProcessor(broker, docs);
                    Modification[] modifications = processor.parse(new InputSource(new StringReader(content)));
                    long mods = 0L;
                    for (int i = 0; i < modifications.length; ++i) {
                        mods += modifications[i].process();
                        broker.flush();
                    }
                    response = new Response("<?xml version='1.0'?>\n<exist:modifications mlns:exist='http://exist.sourceforge.net/NS/exist' count='" + mods + "'>" + mods + "modifications processed.</exist:modifications>");
                    break block32;
                }
                throw new BadRequestException("Unknown XML root element: " + root.getNodeName());
            }
            catch (SAXException e) {
                Exception cause = e;
                if (e.getException() != null) {
                    cause = e.getException();
                }
                LOG.debug((Object)("SAX exception while parsing request: " + cause.getMessage()), (Throwable)cause);
                throw new BadRequestException("SAX exception while parsing request: " + cause.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new BadRequestException("Parser exception while parsing request: " + e.getMessage());
            }
            catch (XPathException e) {
                throw new BadRequestException("Query exception while parsing request: " + e.getMessage());
            }
            catch (IOException e) {
                throw new BadRequestException("IO exception while parsing request: " + e.getMessage());
            }
            catch (EXistException e) {
                throw new BadRequestException(e.getMessage());
            }
            catch (LockException e) {
                throw new PermissionDeniedException(e.getMessage());
            }
        }
        return response;
    }

    public Response doPut(DBBroker broker, File tempFile, String contentType, String docPath) throws BadRequestException, PermissionDeniedException {
        Response response;
        if (tempFile == null) {
            throw new BadRequestException("No request content found for PUT");
        }
        try {
            int p = docPath.lastIndexOf(47);
            if (p < 0 || p == docPath.length() - 1) {
                throw new BadRequestException("Bad path: " + docPath);
            }
            String collectionName = docPath.substring(0, p);
            docPath = docPath.substring(p + 1);
            Collection collection = broker.getCollection(collectionName);
            if (collection == null) {
                LOG.debug((Object)("creating collection " + collectionName));
                collection = broker.getOrCreateCollection(collectionName);
                broker.saveCollection(collection);
            }
            String url = tempFile.toURI().toASCIIString();
            if (contentType == null || contentType.equalsIgnoreCase("text/xml")) {
                DocumentImpl doc = collection.addDocument(broker, docPath, new InputSource(url));
                response = new Response();
                response.setDescription("Document " + docPath + " stored.");
            } else {
                int l;
                byte[] chunk = new byte[4096];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileInputStream is = new FileInputStream(tempFile);
                while ((l = is.read(chunk)) > -1) {
                    os.write(chunk, 0, l);
                }
                collection.addBinaryResource(broker, docPath, os.toByteArray());
                response = new Response();
                response.setDescription("Document " + docPath + " stored as binary resource.");
            }
        }
        catch (SAXParseException e) {
            throw new BadRequestException("Parsing exception at " + e.getLineNumber() + "/" + e.getColumnNumber() + ": " + e.toString());
        }
        catch (SAXException e) {
            Exception o = e.getException();
            if (o == null) {
                o = e;
            }
            throw new BadRequestException("Parsing exception: " + o.getMessage());
        }
        catch (EXistException e) {
            throw new BadRequestException("Internal error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new BadRequestException("Internal error: " + e.getMessage());
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (LockException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        return response;
    }

    public Response doDelete(DBBroker broker, String path) throws PermissionDeniedException, NotFoundException {
        Response response;
        try {
            Collection collection = broker.getCollection(path);
            if (collection != null) {
                LOG.debug((Object)("removing collection " + path));
                broker.removeCollection(collection);
                response = new Response();
                response.setDescription("Collection " + path + " removed.");
            } else {
                String docName;
                DocumentImpl doc = (DocumentImpl)broker.getDocument(path);
                if (doc == null) {
                    throw new NotFoundException("No document or collection found for path: " + path);
                }
                LOG.debug((Object)("removing document " + path));
                int p = path.lastIndexOf(47);
                String string = docName = p < 0 || p == path.length() - 1 ? path : path.substring(p + 1);
                if (doc.getResourceType() == 1) {
                    doc.getCollection().removeBinaryResource(broker, docName);
                } else {
                    doc.getCollection().removeDocument(broker, docName);
                }
                response = new Response();
                response.setDescription("Document " + path + " removed.");
            }
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException("Trigger failed: " + e.getMessage());
        }
        catch (LockException e) {
            throw new PermissionDeniedException("Could not acquire lock: " + e.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String search(DBBroker broker, String query, String path, int howmany, int start, Properties outputProperties, boolean wrap) throws BadRequestException, PermissionDeniedException {
        Object result = null;
        StringSource source = new StringSource(query);
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(source);
        XQueryContext context = compiled == null ? xquery.newContext() : compiled.getContext();
        context.setStaticallyKnownDocuments(new String[]{path});
        if (compiled == null) {
            compiled = xquery.compile(context, source);
        }
        this.checkPragmas(context, outputProperties);
        try {
            long startTime = System.currentTimeMillis();
            Sequence resultSequence = xquery.execute(compiled, null);
            long queryTime = System.currentTimeMillis() - startTime;
            LOG.debug((Object)("Found " + resultSequence.getLength() + " in " + queryTime + "ms."));
            String string = this.printResults(broker, resultSequence, howmany, start, queryTime, outputProperties, wrap);
            pool.returnCompiledXQuery(source, compiled);
            return string;
        }
        catch (Throwable throwable) {
            try {
                pool.returnCompiledXQuery(source, compiled);
                throw throwable;
            }
            catch (XPathException e) {
                throw new BadRequestException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new BadRequestException(e.getMessage(), e);
            }
        }
    }

    protected void checkPragmas(XQueryContext context, Properties properties) throws XPathException {
        Pragma pragma = context.getPragma(Pragma.SERIALIZE_QNAME);
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Pragma.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().toString() + ": '" + contents[i] + "'");
            }
            LOG.debug((Object)("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]));
            properties.setProperty(pair[0], pair[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printCollection(DBBroker broker, Collection collection) {
        SAXSerializer serializer = null;
        StringWriter writer = new StringWriter();
        try {
            serializer = SAXSerializerPool.getInstance().borrowSAXSerializer();
            serializer.setWriter(writer);
            serializer.setOutputProperties(defaultProperties);
            AttributesImpl attrs = new AttributesImpl();
            serializer.startDocument();
            serializer.startPrefixMapping("exist", NS);
            serializer.startElement(NS, "result", "exist:result", attrs);
            attrs.addAttribute("", "name", "name", "CDATA", collection.getName());
            this.printPermissions(attrs, collection.getPermissions());
            serializer.startElement(NS, "collection", "exist:collection", attrs);
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                String child = (String)i.next();
                Collection childCollection = broker.getCollection(collection.getName() + '/' + child);
                if (!childCollection.getPermissions().validate(broker.getUser(), 4)) continue;
                attrs.clear();
                attrs.addAttribute("", "name", "name", "CDATA", child);
                attrs.addAttribute("", "created", "created", "CDATA", dateFormat.format(new Date(childCollection.getCreationTime())));
                this.printPermissions(attrs, childCollection.getPermissions());
                serializer.startElement(NS, "collection", "exist:collection", attrs);
                serializer.endElement(NS, "collection", "exist:collection");
            }
            i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (!doc.getPermissions().validate(broker.getUser(), 4)) continue;
                String resource = doc.getFileName();
                int p = resource.lastIndexOf(47);
                attrs.clear();
                attrs.addAttribute("", "name", "name", "CDATA", p < 0 ? resource : resource.substring(p + 1));
                attrs.addAttribute("", "created", "created", "CDATA", dateFormat.format(new Date(doc.getCreated())));
                attrs.addAttribute("", "last-modified", "last-modified", "CDATA", dateFormat.format(new Date(doc.getLastModified())));
                this.printPermissions(attrs, doc.getPermissions());
                serializer.startElement(NS, "resource", "exist:resource", attrs);
                serializer.endElement(NS, "resource", "exist:resource");
            }
            serializer.endElement(NS, "collection", "exist:collection");
            serializer.endElement(NS, "result", "exist:result");
            serializer.endDocument();
        }
        catch (SAXException e) {
            LOG.warn((Object)("Error while serializing collection contents: " + e.getMessage()), (Throwable)e);
        }
        finally {
            SAXSerializerPool.getInstance().returnSAXSerializer(serializer);
        }
        return writer.toString();
    }

    protected void printPermissions(AttributesImpl attrs, Permission perm) {
        attrs.addAttribute("", "owner", "owner", "CDATA", perm.getOwner());
        attrs.addAttribute("", "group", "group", "CDATA", perm.getOwnerGroup());
        attrs.addAttribute("", "permissions", "permissions", "CDATA", perm.toString());
    }

    protected String printResults(DBBroker broker, Sequence results, int howmany, int start, long queryTime, Properties outputProperties, boolean wrap) throws BadRequestException {
        int rlen = results.getLength();
        if (rlen > 0) {
            if (start < 1 || start > rlen) {
                throw new BadRequestException("Start parameter out of range");
            }
            if (howmany + start > rlen || howmany <= 0) {
                howmany = rlen - start + 1;
            }
        } else {
            howmany = 0;
        }
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        outputProperties.setProperty("sax-document-events", "false");
        SAXSerializer sax = null;
        try {
            StringWriter writer = new StringWriter();
            sax = SAXSerializerPool.getInstance().borrowSAXSerializer();
            sax.setWriter(writer);
            sax.setOutputProperties(outputProperties);
            serializer.setProperties(outputProperties);
            serializer.setSAXHandlers(sax, sax);
            serializer.toSAX(results, start, howmany, wrap);
            return writer.toString();
        }
        catch (SAXException e) {
            LOG.warn((Object)e);
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
    }

    static {
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("expand-xincludes", "yes");
        defaultProperties.setProperty("highlight-matches", "elements");
        defaultProperties.setProperty("process-xsl-pi", "yes");
        dateFormat = new SimpleDateFormat("MMM d, yyyy hh:mm:ss");
    }
}

