/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.TransformerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.util.Range;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.DOMSerializerPool;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String dump(DocumentFragment fragment) {
        DOMSerializer serializer = DOMSerializerPool.getInstance().borrowDOMSerializer();
        serializer.reset();
        StringWriter writer = new StringWriter();
        serializer.setWriter(writer);
        try {
            serializer.serialize(fragment);
        }
        catch (TransformerException transformerException) {
        }
        finally {
            DOMSerializerPool.getInstance().returnDOMSerializer(serializer);
        }
        return writer.toString();
    }

    public static final void copyChildren(Document new_doc, Node node, Node new_node) {
        NodeList children = node.getChildNodes();
        block5: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            switch (child.getNodeType()) {
                case 1: {
                    Node new_child = XMLUtil.copyNode(new_doc, child);
                    new_node.appendChild(new_child);
                    continue block5;
                }
                case 2: {
                    Node new_child = XMLUtil.copyNode(new_doc, child);
                    ((Element)new_node).setAttributeNode((Attr)new_child);
                    continue block5;
                }
                case 3: {
                    Node new_child = XMLUtil.copyNode(new_doc, child);
                    new_node.appendChild(new_child);
                }
            }
        }
    }

    public static final Node copyNode(Document new_doc, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                Element new_node = new_doc.createElementNS(node.getNamespaceURI(), node.getNodeName());
                XMLUtil.copyChildren(new_doc, node, new_node);
                return new_node;
            }
            case 3: {
                Text new_node = new_doc.createTextNode(((Text)node).getData());
                return new_node;
            }
            case 2: {
                Attr new_node = new_doc.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                new_node.setValue(((Attr)node).getValue());
                return new_node;
            }
        }
        return null;
    }

    public static final String encodeAttrMarkup(String str) {
        StringBuffer buf = new StringBuffer();
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    boolean isEntity = false;
                    for (int j = i + 1; j < str.length(); ++j) {
                        if (str.charAt(j) == ';') {
                            isEntity = true;
                            break;
                        }
                        if (!Character.isLetter(str.charAt(j))) break;
                    }
                    if (isEntity) {
                        buf.append('&');
                        continue block6;
                    }
                    buf.append("&amp;");
                    continue block6;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static final String decodeAttrMarkup(String str) {
        StringBuffer out = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            int p;
            char ch = str.charAt(i);
            if (ch == '&' && -1 < (p = str.indexOf(59, i))) {
                String ent = str.substring(i + 1, p);
                if (ent.equals("amp")) {
                    out.append('&');
                } else if (ent.equals("lt")) {
                    out.append('<');
                } else if (ent.equals("gt")) {
                    out.append('>');
                } else if (ent.equals("quot")) {
                    out.append('\"');
                }
                i = p;
                continue;
            }
            out.append(ch);
        }
        return out.toString();
    }

    public static final String getEncoding(String xmlDecl) {
        if (xmlDecl == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int p0 = xmlDecl.indexOf("encoding");
        if (p0 < 0) {
            return null;
        }
        for (int i = p0 + 8; i < xmlDecl.length(); ++i) {
            if (Character.isWhitespace(xmlDecl.charAt(i)) || xmlDecl.charAt(i) == '=') continue;
            if (xmlDecl.charAt(i) == '\"') {
                while (xmlDecl.charAt(++i) != '\"' && i < xmlDecl.length()) {
                    buf.append(xmlDecl.charAt(i));
                }
                return buf.toString();
            }
            return null;
        }
        return null;
    }

    public static final long getFirstChildId(DocumentImpl doc, long gid) {
        int level = doc.getTreeLevel(gid);
        if (level < 0) {
            throw new RuntimeException("child index out of bounds");
        }
        return XMLUtil.getFirstChildId(doc, gid, level);
    }

    public static final long getFirstChildId(DocumentImpl doc, long gid, int level) {
        int order = doc.getTreeLevelOrder(level + 1);
        if (order < 0) {
            System.err.println("level " + (level + 1) + " out of bounds: " + gid + "; start = " + doc.getLevelStartPoint(level));
            Thread.dumpStack();
        }
        return (gid - doc.getLevelStartPoint(level)) * (long)order + doc.getLevelStartPoint(level + 1);
    }

    public static final Range getChildRange(DocumentImpl doc, long gid) {
        int level = doc.getTreeLevel(gid);
        int order = doc.getTreeLevelOrder(level + 1);
        long start = (gid - doc.getLevelStartPoint(level)) * (long)order + doc.getLevelStartPoint(level + 1);
        return new Range(start, start + (long)order - 1L);
    }

    public static final long getParentId(NodeProxy node) {
        return XMLUtil.getParentId(node.getDocument(), node.gid);
    }

    public static final long getParentId(DocumentImpl doc, long gid) {
        int level = doc.getTreeLevel(gid);
        if (level < 0) {
            return -1L;
        }
        return XMLUtil.getParentId(doc, gid, level);
    }

    public static final long getParentId(DocumentImpl doc, long gid, int level) {
        if (level < 1) {
            return -1L;
        }
        return (gid - doc.treeLevelStartPoints[level]) / (long)doc.treeLevelOrder[level] + doc.treeLevelStartPoints[level - 1];
    }

    public static final boolean isDescendantOrSelf(DocumentImpl doc, long ancestor, long descendant) {
        if (ancestor == descendant) {
            return true;
        }
        while ((descendant = XMLUtil.getParentId(doc, descendant)) > -1L) {
            if (descendant != ancestor) continue;
            return true;
        }
        return false;
    }

    public static final boolean isDescendant(DocumentImpl doc, long ancestor, long descendant) {
        while ((descendant = XMLUtil.getParentId(doc, descendant)) > -1L) {
            if (descendant != ancestor) continue;
            return true;
        }
        return false;
    }

    public static final NodeProxy parentWithChild(NodeSet contextSet, DocumentImpl doc, long gid, int level) {
        NodeProxy temp = contextSet.get(doc, gid);
        if (temp != null) {
            return temp;
        }
        if (level < 0) {
            level = doc.getTreeLevel(gid);
        }
        while (gid > 0L) {
            gid = level == 0 ? -1L : (gid - doc.treeLevelStartPoints[level]) / (long)doc.treeLevelOrder[level] + doc.treeLevelStartPoints[level - 1];
            temp = contextSet.get(doc, gid);
            if (temp != null) {
                return temp;
            }
            --level;
        }
        return null;
    }

    public static final NodeProxy parentWithChild(NodeSet contextSet, NodeProxy child, int level) {
        NodeProxy temp = contextSet.get(child);
        if (temp != null) {
            return temp;
        }
        if (level < 0) {
            level = child.getDocument().getTreeLevel(child.gid);
        }
        while (child.gid > 0L) {
            child.gid = (child.gid - child.getDocument().getLevelStartPoint(level)) / (long)child.getDocument().getTreeLevelOrder(level) + child.getDocument().getLevelStartPoint(level - 1);
            temp = contextSet.get(child.getDocument(), child.gid);
            if (temp != null) {
                return temp;
            }
            --level;
        }
        return null;
    }

    public static final String getXMLDecl(byte[] data) {
        boolean foundTag = false;
        for (int i = 0; i < data.length && !foundTag; ++i) {
            if (data[i] != 60) continue;
            foundTag = true;
            if (data[i + 1] != 63 || data[i + 2] != 120 || data[i + 3] != 109 || data[i + 4] != 108) continue;
            for (int j = i + 5; j < data.length; ++j) {
                if (data[j] != 63 || data[j + 1] != 62) continue;
                String xmlDecl = new String(data, i, j - i + 2);
                return xmlDecl;
            }
        }
        return null;
    }

    public static final String readFile(File file) throws IOException {
        return XMLUtil.readFile(file, "ISO-8859-1");
    }

    public static String readFile(File file, String defaultEncoding) throws IOException {
        return XMLUtil.readFile(new FileInputStream(file), defaultEncoding);
    }

    public static String readFile(InputStream in, String defaultEncoding) throws IOException {
        int l;
        byte[] chunk = new byte[512];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        do {
            if ((l = in.read(chunk)) <= 0) continue;
            out.write(chunk, 0, l);
        } while (l > -1);
        in.close();
        byte[] data = out.toByteArray();
        String xmlDecl = XMLUtil.getXMLDecl(data);
        String enc = XMLUtil.getEncoding(xmlDecl);
        if (enc == null) {
            enc = defaultEncoding;
        }
        try {
            return new String(out.toByteArray(), enc);
        }
        catch (UnsupportedEncodingException e) {
            return new String(out.toByteArray());
        }
    }

    public static String parseValue(String value, String key) {
        int p = value.indexOf(key);
        if (p < 0) {
            return null;
        }
        return XMLUtil.parseValue(value, p);
    }

    public static String parseValue(String value, int p) {
        while (p < value.length() && value.charAt(++p) != '\"') {
        }
        if (p == value.length()) {
            return null;
        }
        int e = ++p;
        while (e < value.length() && value.charAt(++e) != '\"') {
        }
        if (e == value.length()) {
            return null;
        }
        return value.substring(p, e);
    }
}

