/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.QNamePool;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.util.hashtable.Object2IntHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SymbolTable {
    private static final Logger LOG = Logger.getLogger((Class)SymbolTable.class);
    protected Object2IntHashMap nameSymbols = new Object2IntHashMap(200);
    protected Int2ObjectHashMap names = new Int2ObjectHashMap(200);
    protected Object2IntHashMap nsSymbols = new Object2IntHashMap(200);
    protected Int2ObjectHashMap namespaces = new Int2ObjectHashMap(200);
    protected Object2IntHashMap defaultMappings = new Object2IntHashMap(200);
    protected QNamePool namePool = new QNamePool();
    protected short max = 0;
    protected short nsMax = 0;
    protected boolean changed = false;
    protected File file;

    public SymbolTable(File file) {
        this.file = file;
    }

    public synchronized QName getQName(String namespaceURI, String localName, String prefix) {
        return this.namePool.add(namespaceURI, localName, prefix);
    }

    public synchronized short getSymbol(Element element) {
        short id = (short)this.nameSymbols.get(element.getLocalName());
        if (id > -1) {
            return id;
        }
        id = this.max = (short)(this.max + 1);
        this.nameSymbols.put(element.getLocalName(), id);
        this.names.put(id, element.getLocalName());
        this.changed = true;
        String prefix = element.getPrefix();
        if (prefix != null && prefix.length() > 0 && !this.defaultMappings.containsKey(prefix)) {
            short nsId = this.getNSSymbol(element.getNamespaceURI());
            this.defaultMappings.put(prefix, nsId);
        }
        return id;
    }

    public synchronized short getSymbol(Attr attr) {
        String key = '@' + attr.getLocalName();
        short id = (short)this.nameSymbols.get(key);
        if (id > -1) {
            return id;
        }
        id = this.max = (short)(this.max + 1);
        this.nameSymbols.put(key, id);
        this.names.put(id, attr.getLocalName());
        this.changed = true;
        String prefix = attr.getPrefix();
        if (prefix != null && prefix.length() > 0 && !this.defaultMappings.containsKey(prefix)) {
            short nsId = this.getNSSymbol(attr.getNamespaceURI());
            this.defaultMappings.put(prefix, nsId);
        }
        return id;
    }

    public synchronized short getSymbol(String name) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        short id = (short)this.nameSymbols.get(name);
        if (id > -1) {
            return id;
        }
        id = this.max = (short)(this.max + 1);
        this.nameSymbols.put(name, id);
        this.names.put(id, name);
        this.changed = true;
        return id;
    }

    public synchronized short getNSSymbol(String ns) {
        if (ns == null || ns.length() == 0) {
            return 0;
        }
        short id = (short)this.nsSymbols.get(ns);
        if (id > -1) {
            return id;
        }
        id = this.nsMax = (short)(this.nsMax + 1);
        this.nsSymbols.put(ns, id);
        this.namespaces.put(id, ns);
        this.changed = true;
        return id;
    }

    public synchronized String getNamespace(short id) {
        return id == 0 ? "" : (String)this.namespaces.get(id);
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized String getName(short id) {
        return (String)this.names.get(id);
    }

    public String[] getSymbols() {
        String[] result = new String[this.nameSymbols.size()];
        int j = 0;
        Iterator i = this.nameSymbols.iterator();
        while (i.hasNext()) {
            result[j] = (String)i.next();
            ++j;
        }
        return result;
    }

    public synchronized String getDefaultNamespace(String prefix) {
        if (this.defaultMappings.containsKey(prefix)) {
            return this.getNamespace((short)this.defaultMappings.get(prefix));
        }
        return null;
    }

    public synchronized String[] defaultPrefixList() {
        String[] prefixes = new String[this.defaultMappings.size()];
        int i = 0;
        Iterator j = this.defaultMappings.iterator();
        while (j.hasNext()) {
            prefixes[i] = (String)j.next();
            ++i;
        }
        return prefixes;
    }

    public synchronized void write(VariableByteOutputStream ostream) throws IOException {
        short id;
        String entry;
        ostream.writeShort(this.max);
        ostream.writeShort(this.nsMax);
        ostream.writeInt(this.nameSymbols.size());
        Iterator i = this.nameSymbols.iterator();
        while (i.hasNext()) {
            entry = (String)i.next();
            ostream.writeUTF(entry);
            id = (short)this.nameSymbols.get(entry);
            if (id < 0) {
                Thread.dumpStack();
            }
            ostream.writeShort(id);
        }
        ostream.writeInt(this.nsSymbols.size());
        i = this.nsSymbols.iterator();
        while (i.hasNext()) {
            entry = (String)i.next();
            ostream.writeUTF(entry);
            id = (short)this.nsSymbols.get(entry);
            if (id < 0) {
                Thread.dumpStack();
            }
            ostream.writeShort(id);
        }
        ostream.writeInt(this.defaultMappings.size());
        Iterator i2 = this.defaultMappings.iterator();
        while (i2.hasNext()) {
            String prefix = (String)i2.next();
            short nsId = (short)this.defaultMappings.get(prefix);
            ostream.writeUTF(prefix);
            ostream.writeShort(nsId);
        }
        this.changed = false;
    }

    public synchronized void read(VariableByteInput istream) throws IOException {
        short id;
        String name;
        int i;
        this.max = istream.readShort();
        this.nsMax = istream.readShort();
        int count = istream.readInt();
        for (i = 0; i < count; ++i) {
            name = istream.readUTF();
            id = istream.readShort();
            this.nameSymbols.put(name, id);
            if (name.charAt(0) == '@') {
                this.names.put(id, name.substring(1));
                continue;
            }
            this.names.put(id, name);
        }
        count = istream.readInt();
        for (i = 0; i < count; ++i) {
            name = istream.readUTF();
            id = istream.readShort();
            this.nsSymbols.put(name, id);
            this.namespaces.put(id, name);
        }
        count = istream.readInt();
        for (int i2 = 0; i2 < count; ++i2) {
            String prefix = istream.readUTF();
            short nsId = istream.readShort();
            this.defaultMappings.put(prefix, nsId);
        }
        this.changed = false;
    }

    public File getFile() {
        return this.file;
    }
}

