/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeObjectPool;
import org.exist.util.ByteConversion;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ProcessingInstructionImpl
extends NodeImpl
implements ProcessingInstruction {
    protected String target;
    protected String data;

    public ProcessingInstructionImpl() {
        super((short)7);
    }

    public ProcessingInstructionImpl(long gid) {
        super((short)7, gid);
    }

    public ProcessingInstructionImpl(long gid, String target, String data) {
        super((short)7, gid);
        this.target = target;
        this.data = data;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getNodeName() {
        return this.target;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?");
        buf.append(this.target);
        buf.append(" ");
        buf.append(this.data);
        buf.append(" ?>");
        return buf.toString();
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first, ArrayList prefixes) throws SAXException {
        contentHandler.processingInstruction(this.getTarget(), this.getData());
    }

    public byte[] serialize() {
        byte[] dd;
        byte[] td;
        try {
            td = this.target.getBytes("UTF-8");
            dd = this.data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            td = this.target.getBytes();
            dd = this.data.getBytes();
        }
        byte[] d = new byte[td.length + dd.length + 5];
        d[0] = 64;
        ByteConversion.intToByte(td.length, d, 1);
        System.arraycopy(td, 0, d, 5, td.length);
        System.arraycopy(dd, 0, d, 5 + td.length, dd.length);
        return d;
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, boolean pooled) {
        String cdata;
        String target;
        int l = ByteConversion.byteToInt(data, start + 1);
        try {
            target = new String(data, start + 5, l, "UTF-8");
            cdata = new String(data, start + 5 + l, len - 5 - l, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            target = new String(data, start + 5, l);
            cdata = new String(data, start + 5 + l, len - 5 - l);
        }
        ProcessingInstructionImpl pi = pooled ? (ProcessingInstructionImpl)NodeObjectPool.getInstance().borrowNode(ProcessingInstructionImpl.class) : new ProcessingInstructionImpl();
        pi.target = target;
        pi.data = cdata;
        return pi;
    }
}

