/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Comparator;
import java.util.Iterator;
import org.exist.dom.AbstractNodeSet;
import org.exist.dom.AttrImpl;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.Match;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeSet;
import org.exist.dom.XMLUtil;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.UntypedAtomicValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NodeProxy
extends AbstractNodeSet
implements NodeValue,
Comparable {
    public DocumentImpl doc = null;
    public long gid = 0L;
    private long internalAddress = -1L;
    public short nodeType = (short)-1;
    public Match match = null;
    private ContextItem context = null;

    public NodeProxy() {
    }

    public NodeProxy(DocumentImpl doc, long gid) {
        this.doc = doc;
        this.gid = gid;
    }

    public NodeProxy(DocumentImpl doc, long gid, short nodeType) {
        this.doc = doc;
        this.gid = gid;
        this.nodeType = nodeType;
    }

    public NodeProxy(DocumentImpl doc, long gid, short nodeType, long address) {
        this.doc = doc;
        this.gid = gid;
        this.nodeType = nodeType;
        this.internalAddress = address;
    }

    public NodeProxy(DocumentImpl doc, long gid, long address) {
        this.gid = gid;
        this.doc = doc;
        this.internalAddress = address;
    }

    public NodeProxy(NodeProxy p) {
        this.doc = p.doc;
        this.gid = p.gid;
        this.nodeType = p.nodeType;
        this.match = p.match;
        this.internalAddress = p.internalAddress;
    }

    public NodeProxy(NodeImpl node) {
        this((DocumentImpl)node.getOwnerDocument(), node.getGID());
        this.internalAddress = node.getInternalAddress();
    }

    public int getImplementationType() {
        return 1;
    }

    public int compareTo(NodeProxy other) {
        int diff = this.doc.docId - other.doc.docId;
        return diff == 0 ? (this.gid < other.gid ? -1 : (this.gid > other.gid ? 1 : 0)) : diff;
    }

    public int compareTo(Object other) {
        if (!(other instanceof NodeProxy)) {
            return 1;
        }
        NodeProxy p = (NodeProxy)other;
        if (this.doc.docId == p.doc.docId) {
            if (this.gid == p.gid) {
                return 0;
            }
            if (this.gid < p.gid) {
                return -1;
            }
            return 1;
        }
        if (this.doc.docId < p.doc.docId) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeProxy)) {
            throw new RuntimeException("cannot compare nodes from different implementations");
        }
        NodeProxy node = (NodeProxy)other;
        return node.doc.getDocId() == this.doc.getDocId() && node.gid == this.gid;
    }

    public boolean equals(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 1) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        NodeProxy node = (NodeProxy)other;
        return node.doc.getDocId() == this.doc.getDocId() && node.gid == this.gid;
    }

    public boolean before(NodeValue other) throws XPathException {
        return this.before(other, true);
    }

    protected boolean before(NodeValue other, boolean includeAncestors) throws XPathException {
        int lb;
        int la;
        if (other.getImplementationType() != 1) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        NodeProxy node = (NodeProxy)other;
        if (this.doc.docId != node.doc.docId) {
            return false;
        }
        long pa = this.gid;
        long pb = node.gid;
        if (la > lb) {
            for (la = this.doc.getTreeLevel(this.gid); la > lb; --la) {
                pa = XMLUtil.getParentId(this.doc, pa, la);
            }
            if (pa == pb) {
                return false;
            }
            return pa < pb;
        }
        if (lb > la) {
            for (lb = this.doc.getTreeLevel(node.gid); lb > la; --lb) {
                pb = XMLUtil.getParentId(node.doc, pb, lb);
            }
            if (pb == pa) {
                return includeAncestors;
            }
            return pa < pb;
        }
        return pa < pb;
    }

    public boolean after(NodeValue other) throws XPathException {
        return this.after(other, true);
    }

    protected boolean after(NodeValue other, boolean includeDescendants) throws XPathException {
        int lb;
        int la;
        if (other.getImplementationType() != 1) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        NodeProxy node = (NodeProxy)other;
        if (this.doc.docId != node.doc.docId) {
            return false;
        }
        long pa = this.gid;
        long pb = node.gid;
        if (la > lb) {
            for (la = this.doc.getTreeLevel(this.gid); la > lb; --la) {
                pa = XMLUtil.getParentId(this.doc, pa, la);
            }
            if (pa == pb) {
                return includeDescendants;
            }
            return pa > pb;
        }
        if (lb > la) {
            for (lb = this.doc.getTreeLevel(node.gid); lb > la; --lb) {
                pb = XMLUtil.getParentId(node.doc, pb, lb);
            }
            if (pb == pa) {
                return false;
            }
            return pa > pb;
        }
        return pa > pb;
    }

    public DocumentImpl getDoc() {
        return this.doc;
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public DocumentImpl getDocument() {
        return this.doc;
    }

    public void setDocument(DocumentImpl doc) {
        this.doc = doc;
    }

    public long getGID() {
        return this.gid;
    }

    public Node getNode() {
        return this.doc.getNode(this);
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public String getNodeValue() {
        return this.doc.getBroker().getNodeValue(this);
    }

    public void setGID(long gid) {
        this.gid = gid;
    }

    public String toString() {
        return this.doc.getNode(this.gid).toString();
    }

    public String pprint() {
        return this.doc.getDocId() + ":" + this.gid;
    }

    public void setDoc(DocumentImpl doc) {
        this.doc = doc;
    }

    public void setNodeType(short nodeType) {
        this.nodeType = nodeType;
    }

    public long getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(long internalAddress) {
        this.internalAddress = internalAddress;
    }

    public void setHasIndex(boolean hasIndex) {
        this.internalAddress = hasIndex ? this.internalAddress | 0x10000L : this.internalAddress & 0xFFFFFFFFFFFEFFFFL;
    }

    public boolean hasIndex() {
        return (this.internalAddress & 0x10000L) > 0L;
    }

    public Match getMatches() {
        return this.match;
    }

    public void setMatches(Match match) {
        this.match = match;
    }

    public boolean hasMatch(Match m) {
        if (m == null || this.match == null) {
            return false;
        }
        Match next = this.match;
        do {
            if (!next.equals(m)) continue;
            return true;
        } while ((next = next.getNextMatch()) != null);
        return false;
    }

    public void addMatch(Match m) {
        if (this.match == null) {
            this.match = m;
            this.match.prevMatch = null;
            this.match.nextMatch = null;
            return;
        }
        Match next = this.match;
        while (next != null) {
            int cmp = next.compareTo(m);
            if (cmp == 0 && m.getNodeId() == next.getNodeId()) {
                return;
            }
            if (cmp < 0) {
                if (next.prevMatch != null) {
                    next.prevMatch.nextMatch = m;
                } else {
                    this.match = m;
                }
                m.prevMatch = next.prevMatch;
                next.prevMatch = m;
                m.nextMatch = next;
                return;
            }
            if (next.nextMatch == null) {
                next.nextMatch = m;
                m.prevMatch = next;
                m.nextMatch = null;
                return;
            }
            next = next.nextMatch;
        }
    }

    public void addMatches(NodeProxy p) {
        if (p == this) {
            return;
        }
        Match m = p.getMatches();
        while (m != null) {
            this.addMatch(new Match(m));
            m = m.nextMatch;
        }
    }

    public void printMatches(Match m) {
        System.out.print(this.gid);
        System.out.print(": ");
        Match next = m;
        while (next != null) {
            System.out.print(next.getMatchingTerm() + " [" + next.getNodeId() + "] ");
            System.out.print("-> " + (next.nextMatch == null ? "null" : next.nextMatch.getMatchingTerm()));
            System.out.print(" ");
            next = next.nextMatch;
        }
        System.out.println();
    }

    public void addContextNode(NodeProxy node) {
        if (this.context == null) {
            this.context = new ContextItem(node);
            return;
        }
        for (ContextItem next = this.context; next != null && next.getNode().gid != node.gid; next = next.getNextItem()) {
            if (next.getNextItem() != null) continue;
            next.setNextItem(new ContextItem(node));
            break;
        }
    }

    public void printContext() {
        System.out.print(this.gid + ": ");
        for (ContextItem next = this.context; next != null; next = next.getNextItem()) {
            System.out.print(next.getNode().gid);
            System.out.print(' ');
        }
        System.out.println();
    }

    public void copyContext(NodeProxy node) {
        this.context = node.getContext();
    }

    public void clearContext() {
        this.context = null;
    }

    public ContextItem getContext() {
        return this.context;
    }

    public NodeProxy parentWithChild(DocumentImpl otherDoc, long otherId, boolean directParent, boolean includeSelf, int level) {
        if (otherDoc.getDocId() != this.doc.getDocId()) {
            return null;
        }
        if (includeSelf && otherId == this.gid) {
            return this;
        }
        if (level < 0) {
            level = this.doc.getTreeLevel(otherId);
        }
        while (otherId > 0L) {
            if ((otherId = XMLUtil.getParentId(this.doc, otherId, level)) == this.gid) {
                return this;
            }
            if (directParent) {
                return null;
            }
            --level;
        }
        return null;
    }

    public NodeSet getRange(DocumentImpl document, long lower, long upper) {
        if (this.doc.getDocId() == document.getDocId() && this.gid >= lower && this.gid <= upper) {
            return this;
        }
        return NodeSet.EMPTY_SET;
    }

    public int getType() {
        switch (this.nodeType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 6;
            }
        }
        return -1;
    }

    public Sequence toSequence() {
        return this;
    }

    public String getStringValue() {
        return this.getNodeValue();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        return new StringValue(this.getNodeValue()).convertTo(requiredType);
    }

    public AtomicValue atomize() throws XPathException {
        return new UntypedAtomicValue(this.getNodeValue());
    }

    public Iterator iterator() {
        return new SingleNodeIterator(this);
    }

    public SequenceIterator iterate() {
        return new SingleNodeIterator(this);
    }

    public SequenceIterator unorderedIterator() {
        return new SingleNodeIterator(this);
    }

    public boolean contains(DocumentImpl doc, long nodeId) {
        return this.doc.getDocId() == doc.getDocId() && this.gid == nodeId;
    }

    public boolean contains(NodeProxy proxy) {
        return this.doc.getDocId() == proxy.doc.getDocId() && this.gid == proxy.gid;
    }

    public void addAll(NodeSet other) {
    }

    public void add(NodeProxy proxy) {
    }

    public int getLength() {
        return 1;
    }

    public Node item(int pos) {
        return pos > 0 ? null : this.getNode();
    }

    public Item itemAt(int pos) {
        return pos > 0 ? null : this;
    }

    public NodeProxy get(int pos) {
        return pos > 0 ? null : this;
    }

    public NodeProxy get(NodeProxy p) {
        return this.contains(p) ? this : null;
    }

    public NodeProxy get(DocumentImpl doc, long nodeId) {
        return this.contains(doc, nodeId) ? this : null;
    }

    public void toSAX(DBBroker broker, ContentHandler handler) throws SAXException {
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperty("sax-document-events", "false");
        serializer.setSAXHandlers(handler, null);
        serializer.toSAX(this);
    }

    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        if (this.nodeType == 2) {
            AttrImpl attr = (AttrImpl)this.getNode();
            receiver.attribute(attr.getQName(), attr.getValue());
        } else {
            receiver.addReferenceNode(this);
        }
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(NodeProxy.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(Node.class)) {
            return 1;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(NodeProxy.class)) {
            return this;
        }
        if (target.isAssignableFrom(Node.class)) {
            return this.getNode();
        }
        if (target == Object.class) {
            return this.getNode();
        }
        StringValue v = new StringValue(this.getStringValue());
        return v.toJavaObject(target);
    }

    private static final class SingleNodeIterator
    implements Iterator,
    SequenceIterator {
        private boolean hasNext = true;
        private NodeProxy node;

        public SingleNodeIterator(NodeProxy node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.node;
            }
            return null;
        }

        public void remove() {
            throw new RuntimeException("not supported");
        }

        public Item nextItem() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.node;
            }
            return null;
        }
    }

    public static class NodeProxyComparator
    implements Comparator {
        public static final NodeProxyComparator instance = new NodeProxyComparator();

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null || obj2 == null) {
                throw new NullPointerException("cannot compare null values");
            }
            if (!(obj1 instanceof NodeProxy) || !(obj2 instanceof NodeProxy)) {
                throw new RuntimeException("cannot compare nodes from different implementations");
            }
            NodeProxy p1 = (NodeProxy)obj1;
            NodeProxy p2 = (NodeProxy)obj2;
            if (p1.doc.docId == p2.doc.docId) {
                if (p1.gid == p2.gid) {
                    return 0;
                }
                if (p1.gid < p2.gid) {
                    return -1;
                }
                return 1;
            }
            if (p1.doc.docId < p2.doc.docId) {
                return -1;
            }
            return 1;
        }
    }
}

