/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.dom.AttrImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeObjectPool;
import org.exist.dom.NodeProxy;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.dom.TextImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.Signatures;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class NodeImpl
implements Node,
QNameable {
    protected static final Logger LOG = Logger.getLogger((Class)NodeImpl.class);
    protected long gid;
    protected long internalAddress = -1L;
    protected short nodeType = 0;
    protected DocumentImpl ownerDocument = null;

    private NodeImpl() {
    }

    public NodeImpl(short nodeType) {
        this(nodeType, 0L);
    }

    public NodeImpl(long gid) {
        this(0, gid);
    }

    public NodeImpl(short nodeType, long gid) {
        this.nodeType = nodeType;
        this.gid = gid;
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        short type = Signatures.getType(data[start]);
        switch (type) {
            case 3: {
                return TextImpl.deserialize(data, start, len, pooled);
            }
            case 1: {
                return ElementImpl.deserialize(data, start, len, doc, pooled);
            }
            case 2: {
                return AttrImpl.deserialize(data, start, len, doc, pooled);
            }
            case 7: {
                return ProcessingInstructionImpl.deserialize(data, start, len, pooled);
            }
            case 8: {
                return CommentImpl.deserialize(data, start, len, pooled);
            }
        }
        LOG.debug((Object)("Unknown node type: " + type));
        return null;
    }

    public static NodeImpl deserialize(byte[] data, int start, int len, DocumentImpl doc) {
        return NodeImpl.deserialize(data, start, len, doc, false);
    }

    public void clear() {
        this.gid = 0L;
        this.internalAddress = -1L;
        this.ownerDocument = null;
    }

    public Node appendChild(Node child) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    public Node appendChildren(NodeList nodes, int child) throws DOMException {
        throw new DOMException(9, "Cannot append children to a node of type " + this.nodeType);
    }

    public Node cloneNode(boolean deep) {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeImpl)) {
            return false;
        }
        return ((NodeImpl)obj).gid == this.gid;
    }

    public long firstChildID() {
        return 0L;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public short getAttributesCount() {
        return 0;
    }

    public DBBroker getBroker() {
        return this.ownerDocument.broker;
    }

    public int getChildCount() {
        return 0;
    }

    public NodeList getChildNodes() {
        return new NodeListImpl();
    }

    public Node getFirstChild() {
        return null;
    }

    public long getGID() {
        return this.gid;
    }

    public long getInternalAddress() {
        return this.internalAddress;
    }

    public Node getLastChild() {
        return null;
    }

    public String getLocalName() {
        QName nodeName = this.getQName();
        if (nodeName != null) {
            return nodeName.getLocalName();
        }
        return "";
    }

    public QName getQName() {
        switch (this.nodeType) {
            case 9: {
                return QName.DOCUMENT_QNAME;
            }
            case 3: {
                return QName.TEXT_QNAME;
            }
            case 8: {
                return QName.COMMENT_QNAME;
            }
            case 10: {
                return QName.DOCTYPE_QNAME;
            }
        }
        return null;
    }

    public String getNamespaceURI() {
        QName nodeName = this.getQName();
        if (nodeName != null) {
            return nodeName.getNamespaceURI();
        }
        return "";
    }

    public String getNodeName() {
        QName nodeName = this.getQName();
        if (nodeName != null) {
            return nodeName.toString();
        }
        return "";
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public String getNodeValue() throws DOMException {
        return "";
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public long getParentGID() {
        int level = this.ownerDocument.getTreeLevel(this.gid);
        return (this.gid - this.ownerDocument.getLevelStartPoint(level)) / (long)this.ownerDocument.getTreeLevelOrder(level) + this.ownerDocument.getLevelStartPoint(level - 1);
    }

    public Node getParentNode() {
        long pid = this.getParentGID();
        return pid < 0L ? this.ownerDocument : this.ownerDocument.getNode(pid);
    }

    public NodePath getPath() {
        NodePath path = new NodePath();
        Node parent = this.getParentNode();
        while (parent.getNodeType() != 9) {
            path.addComponent(parent.getNodeName());
            parent = parent.getParentNode();
        }
        return path;
    }

    public String getPrefix() {
        QName nodeName = this.getQName();
        if (nodeName != null) {
            String prefix = nodeName.getPrefix();
            return prefix == null ? "" : prefix;
        }
        return "";
    }

    public Node getPreviousSibling() {
        int level = this.ownerDocument.getTreeLevel(this.gid);
        if (level == 0) {
            return this.ownerDocument.getPreviousSibling(this);
        }
        long pid = (this.gid - this.ownerDocument.getLevelStartPoint(level)) / (long)this.ownerDocument.getTreeLevelOrder(level) + this.ownerDocument.getLevelStartPoint(level - 1);
        long firstChildId = (pid - this.ownerDocument.getLevelStartPoint(level - 1)) * (long)this.ownerDocument.getTreeLevelOrder(level) + this.ownerDocument.getLevelStartPoint(level);
        if (this.gid > firstChildId) {
            return this.ownerDocument.getNode(this.gid - 1L);
        }
        return null;
    }

    public Node getNextSibling() {
        int level = this.ownerDocument.getTreeLevel(this.gid);
        if (level == 0) {
            return this.ownerDocument.getFollowingSibling(this);
        }
        long pid = (this.gid - this.ownerDocument.getLevelStartPoint(level)) / (long)this.ownerDocument.getTreeLevelOrder(level) + this.ownerDocument.getLevelStartPoint(level - 1);
        long firstChildId = (pid - this.ownerDocument.getLevelStartPoint(level - 1)) * (long)this.ownerDocument.getTreeLevelOrder(level) + this.ownerDocument.getLevelStartPoint(level);
        if (this.gid < firstChildId + (long)this.ownerDocument.getTreeLevelOrder(level) - 1L) {
            return this.ownerDocument.getNode(this.gid + 1L);
        }
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    public Node insertAfter(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    public Node insertAfter(NodeList nodes, Node refChild) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    public Node insertBefore(NodeList nodes, Node refChild) throws DOMException {
        throw new DOMException(9, "not implemented");
    }

    public boolean isSupported(String key, String value) {
        return false;
    }

    public long lastChildID() {
        return 0L;
    }

    public void normalize() {
    }

    public Node removeChild(Node node) throws DOMException {
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return null;
    }

    public byte[] serialize() {
        return null;
    }

    public void setAttributes(short attribNum) {
    }

    protected void setChildCount(int count) {
    }

    public void setGID(long gid) {
        this.gid = gid;
    }

    public void setInternalAddress(long address) {
        this.internalAddress = address;
    }

    public void setNodeName(QName name) {
    }

    public void setNodeValue(String value) throws DOMException {
    }

    public void setOwnerDocument(Document doc) {
        this.ownerDocument = (DocumentImpl)doc;
    }

    public void setPrefix(String prefix) throws DOMException {
        QName nodeName = this.getQName();
        if (nodeName != null) {
            nodeName.setPrefix(prefix);
        }
    }

    public boolean supports(String feature, String version) {
        return false;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first) throws SAXException {
        this.toSAX(contentHandler, lexicalHandler, first, new TreeSet());
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first, Set namespaces) throws SAXException {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Long.toString(this.gid));
        buf.append('\t');
        buf.append(this.getQName());
        return buf.toString();
    }

    public String toString(boolean top) {
        return this.toString();
    }

    protected NodeImpl getLastNode(NodeImpl node) {
        NodeProxy p = new NodeProxy(this.ownerDocument, node.gid, node.internalAddress);
        Iterator iterator = this.ownerDocument.getBroker().getNodeIterator(p);
        iterator.next();
        return this.getLastNode(iterator, node);
    }

    protected NodeImpl getLastNode(Iterator iterator, NodeImpl node) {
        if (node.hasChildNodes()) {
            long firstChild = node.firstChildID();
            long lastChild = firstChild + (long)node.getChildCount();
            NodeImpl next = null;
            for (long gid = firstChild; gid < lastChild; ++gid) {
                next = (NodeImpl)iterator.next();
                next.setGID(gid);
                next = this.getLastNode(iterator, next);
            }
            return next;
        }
        return node;
    }

    public void updateChild(Node oldChild, Node newChild) throws DOMException {
        throw new DOMException(7, "method not allowed on this node type");
    }

    public void release() {
        this.clear();
        NodeObjectPool.getInstance().returnNode(this);
    }
}

