/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.exist.dom.AbstractNodeSetBase;
import org.exist.dom.ArraySet;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentOrderComparator;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.XMLUtil;
import org.exist.util.FastQSort;
import org.exist.util.Range;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;

public class ExtArrayNodeSet
extends AbstractNodeSetBase {
    private TreeMap map;
    private int initalSize = 128;
    private int size = 0;
    private boolean isSorted = false;
    private boolean isInDocumentOrder = false;
    private int lastDoc = -1;
    private Part lastPart = null;
    private int state = 0;
    private DocumentSet cachedDocuments = null;
    private DocumentOrderComparator docOrderComparator = new DocumentOrderComparator();

    public ExtArrayNodeSet() {
        this.map = new TreeMap();
    }

    public ExtArrayNodeSet(int initialDocsCount, int initialArraySize) {
        this.initalSize = initialArraySize;
        this.map = new TreeMap();
    }

    public ExtArrayNodeSet(int initialArraySize) {
        this(512, initialArraySize);
    }

    public void add(NodeProxy proxy) {
        this.getPart(proxy.getDocument(), true, this.initalSize).add(proxy);
        ++this.size;
        this.isSorted = false;
        this.isInDocumentOrder = false;
        this.setHasChanged();
    }

    public void add(NodeProxy proxy, int sizeHint) {
        this.getPart(proxy.getDocument(), true, sizeHint > -1 ? sizeHint : this.initalSize).add(proxy);
        ++this.size;
        this.isSorted = false;
        this.isInDocumentOrder = false;
        this.setHasChanged();
    }

    private void setHasChanged() {
        this.state = this.state == Integer.MAX_VALUE ? (this.state = 0) : this.state + 1;
        this.cachedDocuments = null;
    }

    public int getSizeHint(DocumentImpl doc) {
        Part part = this.getPart(doc, false, 0);
        return part == null ? -1 : part.length;
    }

    private Part getPart(DocumentImpl doc, boolean create, int sizeHint) {
        if (doc.docId == this.lastDoc && this.lastPart != null) {
            return this.lastPart;
        }
        Part part = (Part)this.map.get(doc);
        if (part == null && create) {
            part = new Part(sizeHint, doc);
            this.map.put(doc, part);
        }
        this.lastPart = part;
        this.lastDoc = doc.docId;
        return part;
    }

    public Iterator iterator() {
        this.sort();
        return new ExtArrayIterator(this.map);
    }

    public SequenceIterator iterate() {
        this.sortInDocumentOrder();
        return new ExtArrayIterator(this.map);
    }

    public SequenceIterator unorderedIterator() {
        this.sort();
        return new ExtArrayIterator(this.map);
    }

    public boolean containsDoc(DocumentImpl doc) {
        return this.map.containsKey(doc);
    }

    public boolean contains(DocumentImpl doc, long nodeId) {
        Part part = this.getPart(doc, false, 0);
        return part == null ? false : part.contains(nodeId);
    }

    public boolean contains(NodeProxy proxy) {
        Part part = this.getPart(proxy.getDocument(), false, 0);
        return part == null ? false : part.contains(proxy.gid);
    }

    public void addAll(NodeSet other) {
        Iterator i = other.iterator();
        while (i.hasNext()) {
            this.add((NodeProxy)i.next());
        }
    }

    public int getLength() {
        this.sort();
        return this.size;
    }

    public Node item(int pos) {
        this.sortInDocumentOrder();
        NodeProxy p = this.get(pos);
        return p == null ? null : p.getNode();
    }

    public NodeProxy get(int pos) {
        int count = 0;
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            if (count + part.length > pos) {
                return part.get(pos - count);
            }
            count += part.length;
        }
        return null;
    }

    public NodeProxy get(NodeProxy p) {
        Part part = this.getPart(p.getDocument(), false, 0);
        return part == null ? null : part.get(p.gid);
    }

    public NodeProxy get(DocumentImpl doc, long nodeId) {
        this.sort();
        Part part = this.getPart(doc, false, 0);
        return part == null ? null : part.get(nodeId);
    }

    public Item itemAt(int pos) {
        this.sortInDocumentOrder();
        return this.get(pos);
    }

    public void remove(NodeProxy node) {
        Part part = this.getPart(node.getDocument(), false, 0);
        if (part == null) {
            return;
        }
        part.remove(node);
        if (part.length == 0) {
            this.map.remove(node.getDocument());
        }
        this.setHasChanged();
    }

    public NodeSet getRange(DocumentImpl doc, long lower, long upper) {
        Part part = this.getPart(doc, false, 0);
        return part.getRange(lower, upper);
    }

    public NodeSet hasChildrenInSet(NodeProxy parent, int mode, boolean rememberContext) {
        Part part = this.getPart(parent.getDocument(), false, 0);
        if (part == null) {
            return new ArraySet(1);
        }
        return part.getChildrenInSet(parent, mode, rememberContext);
    }

    public void sort() {
        if (this.isSorted) {
            return;
        }
        this.size = 0;
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            part.sort();
            this.size += part.removeDuplicates();
        }
        this.isSorted = true;
        this.isInDocumentOrder = false;
    }

    public final void sortInDocumentOrder() {
        if (this.isInDocumentOrder) {
            return;
        }
        this.size = 0;
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            part.sortInDocumentOrder();
            this.size += part.removeDuplicates();
        }
        this.isSorted = false;
        this.isInDocumentOrder = true;
    }

    public void setSelfAsContext() {
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            part.setSelfAsContext();
        }
    }

    public NodeSet selectParentChild(NodeSet al, int mode, boolean rememberContext) {
        this.sort();
        return super.selectParentChild(al, mode, rememberContext);
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, boolean rememberContext) {
        this.sort();
        return super.selectAncestorDescendant(al, mode, includeSelf, rememberContext);
    }

    public NodeSet selectSiblings(NodeSet siblings, int mode) {
        this.sort();
        return super.selectSiblings(siblings, mode);
    }

    public NodeSet selectAncestors(NodeSet al, boolean includeSelf, boolean rememberContext) {
        this.sort();
        return super.selectAncestors(al, includeSelf, rememberContext);
    }

    public NodeProxy parentWithChild(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf, int level) {
        this.sort();
        Part part = this.getPart(doc, false, -1);
        return part == null ? null : part.parentWithChild(doc, gid, directParent, includeSelf, level);
    }

    public DocumentSet getDocumentSet() {
        if (this.cachedDocuments != null) {
            return this.cachedDocuments;
        }
        this.cachedDocuments = new DocumentSet(this.map.size());
        this.sort();
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            this.cachedDocuments.add(part.getDocument(), false);
        }
        this.isSorted = true;
        return this.cachedDocuments;
    }

    public boolean hasChanged(int previousState) {
        return this.state != previousState;
    }

    public int getState() {
        return this.state;
    }

    private static class ExtArrayIterator
    implements Iterator,
    SequenceIterator {
        Iterator docsIterator;
        Part currentPart = null;
        int pos = 0;
        NodeProxy next = null;

        ExtArrayIterator(Map map) {
            this.docsIterator = map.values().iterator();
            if (this.docsIterator.hasNext()) {
                this.currentPart = (Part)this.docsIterator.next();
            }
            if (this.currentPart != null && this.currentPart.length > 0) {
                this.next = this.currentPart.get(0);
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                return null;
            }
            NodeProxy n = this.next;
            this.next = null;
            if (++this.pos == this.currentPart.length) {
                if (this.docsIterator.hasNext()) {
                    this.currentPart = (Part)this.docsIterator.next();
                    if (this.currentPart != null && this.currentPart.length > 0) {
                        this.next = this.currentPart.get(0);
                        this.pos = 0;
                    }
                }
            } else {
                this.next = this.currentPart.get(this.pos);
            }
            return n;
        }

        public Item nextItem() {
            return (Item)this.next();
        }

        public void remove() {
        }
    }

    private class Part {
        private NodeProxy[] array;
        private int length = 0;

        Part(int initialSize, DocumentImpl myDoc) {
            this.array = new NodeProxy[initialSize];
        }

        void add(NodeProxy p) {
            if (this.length > 0 && this.array[this.length - 1].gid == p.gid) {
                return;
            }
            if (this.length == this.array.length) {
                int newLength = this.length << 1;
                NodeProxy[] temp = new NodeProxy[newLength];
                System.arraycopy(this.array, 0, temp, 0, this.length);
                this.array = temp;
            }
            this.array[this.length++] = p;
        }

        boolean contains(long gid) {
            return this.get(gid) != null;
        }

        NodeProxy get(int pos) {
            return this.array[pos];
        }

        NodeProxy get(long gid) {
            int low = 0;
            int high = this.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                NodeProxy p = this.array[mid];
                if (p.gid == gid) {
                    return p;
                }
                if (p.gid > gid) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return null;
        }

        DocumentImpl getDocument() {
            if (this.length == 0) {
                return null;
            }
            return this.array[0].getDocument();
        }

        void sort() {
            FastQSort.sortByNodeId(this.array, 0, this.length - 1);
        }

        void sortInDocumentOrder() {
            FastQSort.sort(this.array, ExtArrayNodeSet.this.docOrderComparator, 0, this.length - 1);
        }

        NodeProxy parentWithChild(DocumentImpl doc, long gid, boolean directParent, boolean includeSelf, int level) {
            NodeProxy temp;
            if (includeSelf && (temp = this.get(gid)) != null) {
                return temp;
            }
            if (level < 0) {
                level = doc.getTreeLevel(gid);
            }
            while (gid > 0L) {
                temp = this.get(gid = XMLUtil.getParentId(doc, gid, level));
                if (temp != null) {
                    return temp;
                }
                if (directParent) {
                    return null;
                }
                --level;
            }
            return null;
        }

        NodeSet getChildrenInSet(NodeProxy parent, int mode, boolean rememberContext) {
            ExtArrayNodeSet result = new ExtArrayNodeSet();
            Range range = XMLUtil.getChildRange(parent.getDocument(), parent.gid);
            int low = 0;
            int high = this.length - 1;
            int mid = 0;
            while (low <= high) {
                mid = (low + high) / 2;
                NodeProxy p = this.array[mid];
                if (range.inRange(p.gid)) break;
                if (p.gid > range.getStart()) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return result;
            }
            while (mid > 0 && this.array[mid - 1].gid >= range.getStart()) {
                --mid;
            }
            block6: for (int i = mid; i < this.length && this.array[i].gid <= range.getEnd(); ++i) {
                switch (mode) {
                    case 1: {
                        if (rememberContext) {
                            this.array[i].addContextNode(parent);
                        } else {
                            this.array[i].copyContext(parent);
                        }
                        result.add(this.array[i], range.getDistance());
                        continue block6;
                    }
                    case 0: {
                        if (rememberContext) {
                            parent.addContextNode(this.array[i]);
                        } else {
                            parent.copyContext(this.array[i]);
                        }
                        result.add(parent, 1);
                    }
                }
            }
            return result;
        }

        NodeSet getRange(long lower, long upper) {
            ExtArrayNodeSet result = new ExtArrayNodeSet((int)(upper - lower) + 1);
            int low = 0;
            int high = this.length - 1;
            int mid = 0;
            while (low <= high) {
                mid = (low + high) / 2;
                NodeProxy p = this.array[mid];
                if (p.gid >= lower && p.gid <= upper) break;
                if (p.gid > lower) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return result;
            }
            while (mid > 0 && this.array[mid - 1].gid >= lower) {
                --mid;
            }
            for (int i = mid; i < this.length && this.array[i].gid <= upper; ++i) {
                result.add(this.array[i]);
            }
            return result;
        }

        void remove(NodeProxy node) {
            int low = 0;
            int high = this.length - 1;
            int mid = -1;
            while (low <= high) {
                mid = (low + high) / 2;
                NodeProxy p = this.array[mid];
                if (p.gid == node.gid) break;
                if (p.gid > node.gid) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return;
            }
            if (mid < this.length - 1) {
                System.arraycopy(this.array, mid + 1, this.array, mid, this.length - mid - 1);
            }
            --this.length;
        }

        int removeDuplicates() {
            int j = 0;
            for (int i = 1; i < this.length; ++i) {
                if (this.array[i].gid == this.array[j].gid || i == ++j) continue;
                this.array[j] = this.array[i];
            }
            this.length = ++j;
            return this.length;
        }

        void setSelfAsContext() {
            for (int i = 0; i < this.length; ++i) {
                this.array[i].addContextNode(this.array[i]);
            }
        }
    }
}

