/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.EOFException;
import java.io.IOException;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.DocumentTypeImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeListImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NullNodeIndexListener;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.io.VariableByteArrayInput;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.store.StorageAddress;
import org.exist.util.Lock;
import org.exist.util.MultiReadReentrantLock;
import org.exist.util.SyntaxException;
import org.exist.xquery.DescendantSelector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl
implements Document,
Comparable {
    public static final byte XML_FILE = 0;
    public static final byte BINARY_FILE = 1;
    public static final byte DOCUMENT_NODE_SIGNATURE = 15;
    private transient NodeIndexListener listener = NullNodeIndexListener.INSTANCE;
    protected transient DBBroker broker = null;
    protected int children = 0;
    protected long[] childList = null;
    protected transient Collection collection = null;
    protected int docId = -1;
    protected transient DocumentType docType = null;
    protected String fileName = null;
    protected long created = 0L;
    protected long lastModified = 0L;
    protected int pageCount = 0;
    protected transient int splitCount = 0;
    protected int maxDepth = 0;
    protected transient int reindex = -1;
    protected Permission permissions = new Permission(492);
    protected int[] treeLevelOrder = new int[15];
    protected transient long[] treeLevelStartPoints = new long[15];
    private transient boolean complete = true;
    private transient int lockOwnerId = 0;
    private transient Lock updateLock = null;

    public DocumentImpl(DBBroker broker, Collection collection) {
        super((short)9, 0L);
        this.broker = broker;
        this.collection = collection;
        this.ownerDocument = this;
        this.treeLevelOrder[0] = 1;
    }

    public DocumentImpl(DBBroker broker) {
        this(broker, null, null);
    }

    public DocumentImpl(DBBroker broker, String fileName) {
        this(broker, null, null);
        this.fileName = fileName;
    }

    public DocumentImpl(DBBroker broker, String fileName, Collection collection) {
        super((short)9, 0L);
        this.broker = broker;
        this.fileName = fileName;
        this.ownerDocument = this;
        this.collection = collection;
        this.treeLevelOrder[0] = 1;
    }

    public DocumentImpl(DocumentImpl old) {
        super((short)9, 0L);
        int i;
        this.broker = old.broker;
        this.fileName = old.fileName;
        this.ownerDocument = this;
        this.collection = old.collection;
        if (old.collection == null) {
            throw new RuntimeException("Collection == null");
        }
        this.children = old.children;
        this.maxDepth = old.maxDepth;
        this.docId = old.docId;
        this.childList = old.childList;
        this.docType = old.docType;
        this.permissions = old.permissions;
        this.treeLevelOrder = new int[old.treeLevelOrder.length];
        for (i = 0; i < this.treeLevelOrder.length; ++i) {
            this.treeLevelOrder[i] = old.treeLevelOrder[i];
        }
        this.treeLevelStartPoints = new long[old.treeLevelStartPoints.length];
        for (i = 0; i < this.treeLevelStartPoints.length; ++i) {
            this.treeLevelStartPoints[i] = old.treeLevelStartPoints[i];
        }
    }

    public void copyOf(DocumentImpl other) {
        this.maxDepth = other.maxDepth;
        this.childList = null;
        this.children = 0;
        this.docType = other.getDoctype();
        this.treeLevelOrder = other.treeLevelOrder;
        this.treeLevelStartPoints = other.treeLevelStartPoints;
        this.internalAddress = -1L;
        this.lastModified = other.getLastModified();
        this.pageCount = 0;
    }

    public void copyChildren(DocumentImpl other) {
        this.childList = other.childList;
        this.children = other.children;
    }

    public byte getResourceType() {
        return 0;
    }

    public boolean isLockedForWrite() {
        return this.getUpdateLock().isLockedForWrite();
    }

    public void setCollection(Collection parent) {
        this.collection = parent;
    }

    protected static NodeImpl createNode(long gid, short type) {
        NodeImpl node;
        switch (type) {
            case 3: {
                node = new TextImpl(gid);
                break;
            }
            case 1: {
                node = new ElementImpl(gid);
                break;
            }
            case 2: {
                node = new AttrImpl(gid);
                break;
            }
            default: {
                LOG.debug((Object)"unknown node type");
                node = null;
            }
        }
        return node;
    }

    public Node adoptNode(Node node) throws DOMException {
        return node;
    }

    public void appendChild(NodeImpl child) throws DOMException {
        ++this.children;
        this.resizeChildList();
        this.childList[this.children - 1] = child.internalAddress;
    }

    public void calculateTreeLevelStartPoints() throws EXistException {
        this.calculateTreeLevelStartPoints(true);
    }

    public void calculateTreeLevelStartPoints(boolean failOnError) throws EXistException {
        this.treeLevelStartPoints = new long[this.maxDepth + 1];
        this.treeLevelStartPoints[0] = 1L;
        this.treeLevelStartPoints[1] = 2L;
        for (int i = 1; i < this.maxDepth; ++i) {
            this.treeLevelStartPoints[i + 1] = (this.treeLevelStartPoints[i] - this.treeLevelStartPoints[i - 1]) * (long)this.treeLevelOrder[i] + this.treeLevelStartPoints[i];
            if (this.treeLevelStartPoints[i + 1] <= 0x6FFFFFFFFFFFFFFFL && this.treeLevelStartPoints[i + 1] >= 0L) continue;
            throw new EXistException("The document is too complex/irregularily structured to be mapped into eXist's numbering scheme. Number of children per level of the tree: " + this.printTreeLevelOrder());
        }
    }

    public String printTreeLevelOrder() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ ");
        for (int i = 0; i < this.maxDepth; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.treeLevelOrder[i]);
        }
        buf.append(" ]");
        return buf.toString();
    }

    public final int compareTo(Object other) {
        long otherId = ((DocumentImpl)other).docId;
        if (otherId == (long)this.docId) {
            return 0;
        }
        if ((long)this.docId < otherId) {
            return -1;
        }
        return 1;
    }

    public Attr createAttribute(String name) throws DOMException {
        AttrImpl attr = new AttrImpl(new QName(name, "", null), null);
        attr.setOwnerDocument(this);
        return attr;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        int p = qualifiedName.indexOf(58);
        String name = p > -1 ? qualifiedName.substring(p) : qualifiedName;
        String prefix = p > -1 ? qualifiedName.substring(0, p) : null;
        AttrImpl attr = new AttrImpl(new QName(name, namespaceURI, prefix), null);
        attr.setOwnerDocument(this);
        return attr;
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    public Comment createComment(String data) {
        return null;
    }

    public DocumentFragment createDocumentFragment() throws DOMException {
        return null;
    }

    public Element createElement(String tagName) throws DOMException {
        ElementImpl element = new ElementImpl(new QName(tagName, "", null));
        element.setOwnerDocument(this);
        return element;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        int p = qualifiedName.indexOf(58);
        String name = p > -1 ? qualifiedName.substring(p) : qualifiedName;
        String prefix = p > -1 ? qualifiedName.substring(0, p) : null;
        ElementImpl element = new ElementImpl(new QName(name, namespaceURI, prefix));
        element.setOwnerDocument(this);
        return element;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

    public Text createTextNode(String data) {
        TextImpl text = new TextImpl(data);
        text.setOwnerDocument(this);
        return text;
    }

    protected NodeList findElementsByTagName(NodeImpl root, QName qname) {
        DocumentSet docs = new DocumentSet();
        docs.add(this);
        DescendantSelector selector = new DescendantSelector(new NodeProxy(root), false);
        return this.broker.getElementIndex().findElementsByTagName((byte)0, docs, qname, selector);
    }

    public int getChildCount() {
        return this.children;
    }

    public Node getFirstChild() {
        this.checkAvail();
        if (this.children == 0) {
            return null;
        }
        long address = this.childList[0];
        return this.broker.objectWith(new NodeProxy(this, 1L, address));
    }

    public long getFirstChildAddress() {
        if (this.children == 0) {
            return -1L;
        }
        this.checkAvail();
        return this.childList[0];
    }

    public NodeList getChildNodes() {
        this.checkAvail();
        NodeListImpl list = new NodeListImpl();
        for (int i = 0; i < this.children; ++i) {
            Node child = this.broker.objectWith(new NodeProxy(this, 1L, this.childList[i]));
            list.add(child);
        }
        return list;
    }

    protected Node getPreviousSibling(NodeImpl node) {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            NodeImpl next = (NodeImpl)cl.item(i);
            if (!StorageAddress.equals(node.internalAddress, next.internalAddress)) continue;
            return i == 0 ? null : cl.item(i - 1);
        }
        return null;
    }

    protected Node getFollowingSibling(NodeImpl node) {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            NodeImpl next = (NodeImpl)cl.item(i);
            if (!StorageAddress.equals(node.internalAddress, next.internalAddress)) continue;
            return i == this.children - 1 ? null : cl.item(i + 1);
        }
        return null;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public int getDocId() {
        return this.docId;
    }

    public DocumentType getDoctype() {
        this.checkAvail();
        return this.docType;
    }

    public Element getDocumentElement() {
        this.checkAvail();
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            if (cl.item(i).getNodeType() != 1) continue;
            return (Element)cl.item(i);
        }
        return null;
    }

    public Element getElementById(String elementId) {
        return null;
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.getElementsByTagNameNS("", tagname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        DocumentSet docs = new DocumentSet();
        docs.add(this);
        QName qname = new QName(localName, namespaceURI, null);
        return this.broker.getElementIndex().findElementsByTagName((byte)0, docs, qname, null);
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.collection.getName() + '/' + this.fileName;
    }

    private void checkAvail() {
        if (!this.complete) {
            this.broker.readDocumentMetadata(this);
        }
        this.complete = true;
    }

    public DOMImplementation getImplementation() {
        return null;
    }

    public long getLevelStartPoint(int level) {
        if (level > this.maxDepth || level < 0) {
            return -1L;
        }
        return this.treeLevelStartPoints[level];
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public Node getNode(long gid) {
        if (gid == 1L) {
            return this.getDocumentElement();
        }
        return this.broker.objectWith(this, gid);
    }

    public Node getNode(NodeProxy p) {
        return this.broker.objectWith(p);
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public NodeList getRange(long first, long last) {
        return this.broker.getRange(this, first, last);
    }

    public boolean getStandalone() {
        return true;
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public SymbolTable getSymbols() {
        return this.broker.getSymbols();
    }

    public int getTreeLevel(long gid) {
        for (int i = 0; i < this.maxDepth; ++i) {
            if (gid < this.treeLevelStartPoints[i] || i + 1 != this.maxDepth && gid >= this.treeLevelStartPoints[i + 1]) continue;
            return i;
        }
        return -1;
    }

    public int getTreeLevelOrder(int level) {
        if (level > this.maxDepth) {
            LOG.fatal((Object)("tree level " + level + " does not exist"));
            return -1;
        }
        return this.treeLevelOrder[level];
    }

    public int getTreeLevelOrder(long gid) {
        int order = 0;
        for (int i = 0; i < this.maxDepth; ++i) {
            if (gid < this.treeLevelStartPoints[i] || gid >= this.treeLevelStartPoints[i + 1]) continue;
            order = this.treeLevelOrder[i];
            break;
        }
        return order;
    }

    public String getVersion() {
        return "";
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    public boolean isSupported(String type, String value) {
        return false;
    }

    public void read(VariableByteInput istream) throws IOException, EOFException {
        this.docId = istream.readInt();
        this.fileName = istream.readUTF();
        this.children = istream.readInt();
        this.internalAddress = StorageAddress.createPointer(istream.readInt(), istream.readShort());
        this.maxDepth = istream.readInt();
        this.treeLevelOrder = new int[this.maxDepth + 1];
        for (int i = 0; i < this.maxDepth; ++i) {
            this.treeLevelOrder[i] = istream.readInt();
        }
        SecurityManager secman = this.broker.getBrokerPool().getSecurityManager();
        int uid = istream.readInt();
        int gid = istream.readInt();
        int perm = istream.readInt() & 0x1FF;
        if (secman == null) {
            this.permissions.setOwner("admin");
            this.permissions.setGroup("dba");
        } else {
            this.permissions.setOwner(secman.getUser(uid));
            this.permissions.setGroup(secman.getGroup(gid).getName());
        }
        this.permissions.setPermissions(perm);
        this.lockOwnerId = istream.readInt();
        try {
            this.calculateTreeLevelStartPoints();
        }
        catch (EXistException e) {
            // empty catch block
        }
        this.complete = false;
    }

    public void setBroker(DBBroker broker) {
        this.broker = broker;
    }

    public void setChildCount(int count) {
        this.children = count;
        if (this.children == 0) {
            this.childList = null;
        }
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public void setDocumentType(DocumentType docType) {
        this.docType = docType;
    }

    public void setEncoding(String enc) {
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMaxDepth(int depth) {
        this.maxDepth = depth;
        if (this.treeLevelOrder.length <= this.maxDepth) {
            int[] temp = new int[this.maxDepth + 1];
            System.arraycopy(this.treeLevelOrder, 0, temp, 0, this.treeLevelOrder.length);
            temp[this.maxDepth] = 0;
            this.treeLevelOrder = temp;
        }
    }

    public void incMaxDepth() {
        ++this.maxDepth;
        if (this.treeLevelOrder.length < this.maxDepth) {
            int[] temp = new int[this.maxDepth];
            System.arraycopy(this.treeLevelOrder, 0, temp, 0, this.maxDepth - 1);
            this.treeLevelOrder = temp;
            this.treeLevelOrder[this.maxDepth - 1] = 0;
        }
    }

    public void setUserLock(User user) {
        this.lockOwnerId = user == null ? 0 : user.getUID();
    }

    public User getUserLock() {
        if (this.lockOwnerId < 1) {
            return null;
        }
        SecurityManager secman = this.broker.getBrokerPool().getSecurityManager();
        return secman.getUser(this.lockOwnerId);
    }

    public void setPermissions(int mode) {
        this.permissions.setPermissions(mode);
    }

    public void setPermissions(String mode) throws SyntaxException {
        this.permissions.setPermissions(mode);
    }

    public void setPermissions(Permission perm) {
        this.permissions = perm;
    }

    public void setStandalone(boolean alone) {
    }

    public void setStrictErrorChecking(boolean strict) {
    }

    public void setTreeLevelOrder(int level, int order) {
        this.treeLevelOrder[level] = order;
    }

    public void setVersion(String version) {
    }

    public void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeByte(this.getResourceType());
        ostream.writeInt(this.docId);
        ostream.writeUTF(this.fileName);
        ostream.writeInt(this.children);
        ostream.writeInt(StorageAddress.pageFromPointer(this.internalAddress));
        ostream.writeShort(StorageAddress.tidFromPointer(this.internalAddress));
        ostream.writeInt(this.maxDepth);
        for (int i = 0; i < this.maxDepth; ++i) {
            ostream.writeInt(this.treeLevelOrder[i]);
        }
        SecurityManager secman = this.broker.getBrokerPool().getSecurityManager();
        if (secman == null) {
            ostream.writeInt(1);
            ostream.writeInt(1);
        } else {
            User user = secman.getUser(this.permissions.getOwner());
            Group group = secman.getGroup(this.permissions.getOwnerGroup());
            ostream.writeInt(user.getUID());
            ostream.writeInt(group.getId());
        }
        ostream.writeInt(this.permissions.getPermissions());
        if (this.lockOwnerId > 0) {
            ostream.writeInt(this.lockOwnerId);
        } else {
            ostream.writeInt(0);
        }
    }

    public int reindexRequired() {
        return this.reindex;
    }

    public byte[] serialize() {
        VariableByteOutputStream ostream = new VariableByteOutputStream(7);
        try {
            if (this.children > 0) {
                for (int i = 0; i < this.children; ++i) {
                    ostream.writeInt(StorageAddress.pageFromPointer(this.childList[i]));
                    ostream.writeShort(StorageAddress.tidFromPointer(this.childList[i]));
                }
            }
            ((DocumentTypeImpl)this.docType).write(ostream);
            ostream.writeLong(this.created);
            ostream.writeLong(this.lastModified);
            ostream.writeInt(this.pageCount);
            byte[] data = ostream.toByteArray();
            ostream.close();
            return data;
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while writing document data", (Throwable)e);
            return null;
        }
    }

    public void deserialize(byte[] data) {
        VariableByteArrayInput istream = new VariableByteArrayInput(data);
        try {
            this.childList = new long[this.children];
            for (int i = 0; i < this.children; ++i) {
                this.childList[i] = StorageAddress.createPointer(istream.readInt(), istream.readShort());
            }
            this.docType = new DocumentTypeImpl();
            ((DocumentTypeImpl)this.docType).read(istream);
            this.created = istream.readLong();
            this.lastModified = istream.readLong();
            if (istream.available() > 0) {
                this.pageCount = istream.readInt();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("IO error while reading document data for document " + this.fileName), (Throwable)e);
            LOG.warn((Object)("Document address is " + StorageAddress.toString(this.getAddress())));
        }
    }

    public void setReindexRequired(int level) {
        this.reindex = level;
    }

    public void setIndexListener(NodeIndexListener listener) {
        this.listener = listener;
    }

    public NodeIndexListener getIndexListener() {
        return this.listener;
    }

    public void clearIndexListener() {
        this.listener = NullNodeIndexListener.INSTANCE;
    }

    public void setAddress(long address) {
        this.internalAddress = address;
    }

    public long getAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(long address) {
    }

    public void updateChild(Node oldChild, Node newChild) throws DOMException {
        if (!(oldChild instanceof NodeImpl)) {
            throw new DOMException(4, "node does not belong to this document");
        }
        NodeImpl old = (NodeImpl)oldChild;
        NodeImpl newNode = (NodeImpl)newChild;
        NodeImpl previous = (NodeImpl)old.getPreviousSibling();
        if (previous == null) {
            previous = this;
        }
        if (oldChild.getNodeType() == 1) {
            if (newChild.getNodeType() != 1) {
                throw new DOMException(13, "a node replacing the document root needs to be an element");
            }
            this.broker.removeNode(old, old.getPath());
            this.broker.endRemove();
            newNode.gid = old.gid;
            this.broker.insertAfter(previous, newNode);
            this.broker.index(newNode);
            this.broker.flush();
        } else {
            this.broker.removeNode(old, old.getPath());
            this.broker.endRemove();
            newNode.gid = 0L;
            this.broker.insertAfter(previous, newNode);
        }
    }

    public Node insertBefore(NodeList nodes, Node refChild) throws DOMException {
        if (!(refChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        NodeImpl ref = (NodeImpl)refChild;
        long last = -1L;
        int idx = -1;
        for (int i = this.children - 1; i > -1; --i) {
            long next = this.childList[i];
            if (!StorageAddress.equals(ref.internalAddress, next)) continue;
            idx = i - 1;
            break;
        }
        if (idx < 0) {
            throw new DOMException(3, "reference node not found");
        }
        last = this.childList[idx];
        NodeImpl prev = (NodeImpl)this.broker.objectWith(new NodeProxy(this, 0L, last));
        for (int i = 0; i < nodes.getLength(); ++i) {
            prev = (NodeImpl)this.appendChild(prev, nodes.item(i));
            ++this.children;
            this.resizeChildList();
            this.childList[++idx] = prev.internalAddress;
        }
        this.broker.storeDocument(this);
        return prev;
    }

    public Node insertAfter(NodeList nodes, Node refChild) throws DOMException {
        if (!(refChild instanceof NodeImpl)) {
            throw new DOMException(4, "wrong node type");
        }
        NodeImpl ref = (NodeImpl)refChild;
        long last = -1L;
        int idx = -1;
        for (int i = 0; i < this.children; ++i) {
            long next = this.childList[i];
            if (!StorageAddress.equals(ref.internalAddress, next)) continue;
            last = next;
            idx = i + 1;
            break;
        }
        if (last < 0L) {
            throw new DOMException(3, "reference node not found");
        }
        NodeImpl prev = this.getLastNode((NodeImpl)this.broker.objectWith(new NodeProxy(this, 0L, last)));
        for (int i = 0; i < nodes.getLength(); ++i) {
            prev = (NodeImpl)this.appendChild(prev, nodes.item(i));
            ++this.children;
            this.resizeChildList();
            this.childList[idx] = prev.internalAddress;
        }
        this.broker.storeDocument(this);
        return prev;
    }

    private Node appendChild(NodeImpl last, Node child) throws DOMException {
        switch (child.getNodeType()) {
            case 7: {
                ProcessingInstructionImpl pi = new ProcessingInstructionImpl(0L);
                pi.setTarget(((ProcessingInstruction)child).getTarget());
                pi.setData(((ProcessingInstruction)child).getData());
                pi.setOwnerDocument(this);
                this.broker.insertAfter(last, pi);
                return pi;
            }
            case 8: {
                CommentImpl comment = new CommentImpl(0L, ((Comment)child).getData());
                comment.setOwnerDocument(this);
                this.broker.insertAfter(last, comment);
                return comment;
            }
        }
        throw new DOMException(13, "you cannot append a node of this type");
    }

    public long getCreated() {
        this.checkAvail();
        return this.created;
    }

    public long getLastModified() {
        this.checkAvail();
        return this.lastModified;
    }

    public void setCreated(long l) {
        this.created = l;
        if (this.lastModified == 0L) {
            this.lastModified = l;
        }
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public final synchronized Lock getUpdateLock() {
        if (this.updateLock == null) {
            this.updateLock = new MultiReadReentrantLock();
        }
        return this.updateLock;
    }

    public void incPageCount() {
        ++this.pageCount;
    }

    public void decPageCount() {
        --this.pageCount;
    }

    public int getContentLength() {
        this.checkAvail();
        return this.pageCount * this.broker.getPageSize();
    }

    public int getPageCount() {
        this.checkAvail();
        return this.pageCount;
    }

    public void setPageCount(int count) {
        this.pageCount = count;
    }

    private void resizeChildList() {
        long[] newChildList = new long[this.children];
        if (this.childList != null) {
            System.arraycopy(this.childList, 0, newChildList, 0, this.childList.length);
        }
        this.childList = newChildList;
    }

    public void incSplitCount() {
        ++this.splitCount;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public void setSplitCount(int count) {
        this.splitCount = count;
    }

    public void triggerDefrag() {
        this.splitCount = this.broker.getFragmentationLimit();
    }
}

