/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Set;
import org.exist.dom.NodeImpl;
import org.exist.util.XMLString;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    protected XMLString cdata = null;

    public CharacterDataImpl(short nodeType) {
        super(nodeType);
    }

    public CharacterDataImpl(short nodeType, long gid) {
        super(nodeType, gid);
    }

    public CharacterDataImpl(short nodeType, long gid, String data) {
        super(nodeType, gid);
        this.cdata = new XMLString(data.toCharArray());
    }

    public CharacterDataImpl(short nodeType, String data) {
        super(nodeType);
        this.cdata = new XMLString(data.toCharArray());
    }

    public CharacterDataImpl(short nodeType, char[] data, int start, int howmany) {
        super(nodeType);
        this.cdata = new XMLString(data, start, howmany);
    }

    public void clear() {
        this.cdata.reset();
    }

    public void appendData(String arg) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(arg.toCharArray());
        } else {
            this.cdata.append(arg);
        }
    }

    public void appendData(char[] data, int start, int howmany) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data, start, howmany);
        } else {
            this.cdata.append(data, start, howmany);
        }
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (this.cdata != null) {
            this.cdata.delete(offset, count);
        }
    }

    public String getData() throws DOMException {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString();
    }

    public XMLString getXMLString() {
        return this.cdata;
    }

    public String getLowerCaseData() throws DOMException {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString().toLowerCase();
    }

    public int getLength() {
        return this.cdata.length();
    }

    public String getNodeValue() {
        return this.cdata.toString();
    }

    public void insertData(int offset, String arg) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(arg.toCharArray());
        } else {
            this.cdata.insert(offset, arg);
        }
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (this.cdata == null) {
            throw new DOMException(2, "string index out of bounds");
        }
        this.cdata.replace(offset, count, arg);
    }

    public void setData(String data) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data.toCharArray());
        } else {
            this.cdata.setData(data.toCharArray(), 0, data.length());
        }
    }

    public void setData(XMLString data) throws DOMException {
        this.cdata = data;
    }

    public void setData(char[] data, int start, int howmany) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data, start, howmany);
        } else {
            this.cdata.setData(data, start, howmany);
        }
    }

    public String substringData(int offset, int count) throws DOMException {
        if (this.cdata == null) {
            throw new DOMException(2, "string index out of bounds");
        }
        return this.cdata.substring(offset, count);
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean first, Set namespaces) throws SAXException {
        if (first) {
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("http://exist.sourceforge.net/NS/exist", "id", "exist:id", "CDATA", Long.toString(this.gid));
            attribs.addAttribute("http://exist.sourceforge.net/NS/exist", "source", "exist:source", "CDATA", this.ownerDocument.getFileName());
            contentHandler.startElement("http://exist.sourceforge.net/NS/exist", "text", "exist:text", attribs);
        }
        char[] ch = new char[this.cdata.length()];
        this.cdata.toString().getChars(0, ch.length, ch, 0);
        contentHandler.characters(ch, 0, ch.length);
        if (first) {
            contentHandler.endElement("http://exist.sourceforge.net/NS/exist", "text", "exist:text");
        }
    }

    public String toString() {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString();
    }

    public void release() {
        this.cdata.release();
        super.release();
    }
}

