/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import java.util.Stack;
import org.exist.dom.AbstractNodeSetBase;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;

public class AVLTreeNodeSet
extends AbstractNodeSetBase {
    private Node root;
    private int size = 0;

    public SequenceIterator iterate() {
        return new InorderTraversal();
    }

    public SequenceIterator unorderedIterator() {
        return new InorderTraversal();
    }

    public void addAll(NodeSet other) {
        Iterator i = other.iterator();
        while (i.hasNext()) {
            this.add((NodeProxy)i.next());
        }
    }

    public int getLength() {
        return this.size;
    }

    public org.w3c.dom.Node item(int pos) {
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            NodeProxy p = (NodeProxy)it.next();
            if (i == pos) {
                return p.getNode();
            }
            ++i;
        }
        return null;
    }

    public NodeProxy get(int pos) {
        return (NodeProxy)this.itemAt(pos);
    }

    public final NodeProxy get(NodeProxy p) {
        Node n = this.searchData(p);
        return n == null ? null : n.getData();
    }

    public Item itemAt(int pos) {
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            NodeProxy p = (NodeProxy)it.next();
            if (i == pos) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public final void add(NodeProxy proxy) {
        if (proxy == null) {
            return;
        }
        if (this.root == null) {
            this.root = new Node(proxy);
            ++this.size;
            return;
        }
        Node tempNode = this.root;
        while (true) {
            int c;
            if ((c = tempNode.data.compareTo(proxy)) == 0) {
                return;
            }
            if (c > 0) {
                if (tempNode.hasLeftChild()) {
                    tempNode = tempNode.leftChild;
                    continue;
                }
                Node newNode = tempNode.addLeft(proxy);
                this.balance(newNode);
                ++this.size;
                return;
            }
            if (!tempNode.hasRightChild()) break;
            tempNode = tempNode.rightChild;
        }
        Node newNode = tempNode.addRight(proxy);
        this.balance(newNode);
        ++this.size;
    }

    public Node getMinNode() {
        if (this.root == null) {
            return null;
        }
        Node tempNode = this.root;
        while (tempNode.hasLeftChild()) {
            tempNode = tempNode.getLeftChild();
        }
        return tempNode;
    }

    public Node getMaxNode() {
        if (this.root == null) {
            return null;
        }
        Node tempNode = this.root;
        while (tempNode.hasRightChild()) {
            tempNode = tempNode.getRightChild();
        }
        return tempNode;
    }

    private void balance(Node node) {
        Node currentNode = node;
        Node currentParent = node.parent;
        while (currentNode != this.root) {
            Node nodeF;
            Node nodeE;
            Node nodeD;
            Node nodeC;
            Node nodeB;
            Node nodeA;
            int h = currentParent.height;
            currentParent.setHeight();
            if (h == currentParent.height) {
                return;
            }
            if (currentParent.balanced()) {
                currentNode = currentParent;
                currentParent = currentNode.parent;
                continue;
            }
            if (currentParent.leftHeight() - currentParent.rightHeight() == 2) {
                nodeA = currentParent;
                nodeB = nodeA.getLeftChild();
                nodeC = nodeB.getLeftChild();
                nodeD = nodeB.getRightChild();
                if (nodeB.leftHeight() > nodeB.rightHeight()) {
                    nodeA.addLeftChild(nodeD);
                    if (nodeA != this.root) {
                        if (nodeA.isLeftChild()) {
                            nodeA.parent.addLeftChild(nodeB);
                        } else {
                            nodeA.parent.addRightChild(nodeB);
                        }
                    } else {
                        this.root = nodeB;
                    }
                    nodeB.addRightChild(nodeA);
                    nodeA.setHeight();
                    nodeB.setHeight();
                    currentNode = nodeB;
                    currentParent = currentNode.parent;
                    continue;
                }
                nodeE = null;
                nodeF = null;
                if (nodeD.hasLeftChild()) {
                    nodeE = nodeD.getLeftChild();
                    nodeB.addRightChild(nodeE);
                } else {
                    nodeB.removeRightChild();
                }
                if (nodeD.hasRightChild()) {
                    nodeF = nodeD.getRightChild();
                    nodeA.addLeftChild(nodeF);
                } else {
                    nodeA.removeLeftChild();
                }
                if (currentParent != this.root) {
                    if (nodeA.isLeftChild()) {
                        nodeA.parent.addLeftChild(nodeD);
                    } else {
                        nodeA.parent.addRightChild(nodeD);
                    }
                } else {
                    this.root = nodeD;
                }
                nodeD.addLeftChild(nodeB);
                nodeD.addRightChild(nodeA);
                nodeB.setHeight();
                nodeA.setHeight();
                nodeD.setHeight();
                currentNode = nodeD;
                currentParent = currentNode.parent;
                continue;
            }
            if (currentParent.leftHeight() - currentParent.rightHeight() != -2) continue;
            nodeA = currentParent;
            nodeB = nodeA.getRightChild();
            nodeC = nodeB.getLeftChild();
            nodeD = nodeB.getRightChild();
            if (nodeB.leftHeight() < nodeB.rightHeight()) {
                nodeA.addRightChild(nodeC);
                if (nodeA != this.root) {
                    if (nodeA.isLeftChild()) {
                        nodeA.parent.addLeftChild(nodeB);
                    } else {
                        nodeA.parent.addRightChild(nodeB);
                    }
                } else {
                    this.root = nodeB;
                }
                nodeB.addLeftChild(nodeA);
                nodeA.setHeight();
                nodeB.setHeight();
                currentNode = nodeB;
                currentParent = currentNode.parent;
                continue;
            }
            nodeE = null;
            nodeF = null;
            if (nodeC.hasLeftChild()) {
                nodeE = nodeC.getLeftChild();
                nodeA.addRightChild(nodeE);
            } else {
                nodeA.removeRightChild();
            }
            if (nodeC.hasRightChild()) {
                nodeF = nodeC.getRightChild();
                nodeB.addLeftChild(nodeF);
            } else {
                nodeB.removeLeftChild();
            }
            if (nodeA != this.root) {
                if (nodeA.isLeftChild()) {
                    nodeA.parent.addLeftChild(nodeC);
                } else {
                    nodeA.parent.addRightChild(nodeC);
                }
            } else {
                this.root = nodeC;
            }
            nodeC.addLeftChild(nodeA);
            nodeC.addRightChild(nodeB);
            nodeB.setHeight();
            nodeA.setHeight();
            nodeC.setHeight();
            currentNode = nodeC;
            currentParent = currentNode.parent;
        }
    }

    public final Node searchData(NodeProxy proxy) {
        if (this.root == null) {
            return null;
        }
        Node tempNode = this.root;
        while (tempNode != null) {
            int c = tempNode.data.compareTo(proxy);
            if (c == 0) {
                return tempNode;
            }
            if (c < 0) {
                tempNode = tempNode.rightChild;
                continue;
            }
            tempNode = tempNode.leftChild;
        }
        return null;
    }

    public final NodeProxy get(DocumentImpl doc, long nodeId) {
        if (this.root == null) {
            return null;
        }
        Node tempNode = this.root;
        while (tempNode != null) {
            if (tempNode.data.getDocument().docId == doc.docId) {
                if (tempNode.data.gid == nodeId) {
                    return tempNode.data;
                }
                if (tempNode.data.gid < nodeId) {
                    tempNode = tempNode.rightChild;
                    continue;
                }
                tempNode = tempNode.leftChild;
                continue;
            }
            if (tempNode.data.getDocument().docId < doc.docId) {
                tempNode = tempNode.rightChild;
                continue;
            }
            tempNode = tempNode.leftChild;
        }
        return null;
    }

    public final boolean containsDoc(DocumentImpl doc) {
        if (this.root == null) {
            return false;
        }
        Node tempNode = this.root;
        while (tempNode != null) {
            if (tempNode.data.getDocument().docId == doc.docId) {
                return true;
            }
            if (tempNode.data.getDocument().docId < doc.docId) {
                tempNode = tempNode.rightChild;
                continue;
            }
            tempNode = tempNode.leftChild;
        }
        return false;
    }

    public final boolean contains(NodeProxy proxy) {
        return this.searchData(proxy) != null;
    }

    public final boolean contains(DocumentImpl doc, long nodeId) {
        return this.get(doc, nodeId) != null;
    }

    public void remove(NodeProxy node) {
        Node n = this.searchData(node);
        if (n == null) {
            System.out.println(node.gid + " not found");
            return;
        }
        this.removeNode(n);
    }

    public void removeNode(Node node) {
        --this.size;
        Node tempNode = node;
        while (tempNode.hasLeftChild() || tempNode.hasRightChild()) {
            if (tempNode.hasLeftChild()) {
                tempNode = tempNode.getLeftChild();
                while (tempNode.hasRightChild()) {
                    tempNode = tempNode.getRightChild();
                }
            } else {
                tempNode = tempNode.getRightChild();
                while (tempNode.hasLeftChild()) {
                    tempNode = tempNode.getLeftChild();
                }
            }
            node.setData(tempNode.getData());
        }
        if (tempNode == this.root) {
            this.root = null;
            return;
        }
        if (tempNode.isLeftChild()) {
            node = tempNode.parent;
            node.removeLeftChild();
            if (node.hasRightChild()) {
                this.balance(node.getRightChild());
            } else {
                this.balance(node);
            }
        } else {
            node = tempNode.parent;
            node.removeRightChild();
            if (node.hasLeftChild()) {
                this.balance(node.getLeftChild());
            } else {
                this.balance(node);
            }
        }
    }

    public Iterator iterator() {
        return new InorderTraversal();
    }

    private static final class Node {
        NodeProxy data;
        Node parent;
        Node leftChild;
        Node rightChild;
        int height;

        public Node(NodeProxy data) {
            this.data = data;
        }

        public void setData(NodeProxy data) {
            this.data = data;
        }

        public NodeProxy getData() {
            return this.data;
        }

        public boolean hasLeftChild() {
            return this.leftChild != null;
        }

        public boolean hasRightChild() {
            return this.rightChild != null;
        }

        public Node getLeftChild() {
            return this.leftChild;
        }

        public Node getRightChild() {
            return this.rightChild;
        }

        public boolean balanced() {
            return Math.abs(this.leftHeight() - this.rightHeight()) <= 1;
        }

        public Node addLeft(NodeProxy data) {
            Node tempNode;
            this.leftChild = tempNode = new Node(data);
            tempNode.parent = this;
            return tempNode;
        }

        public Node addLeftChild(Node node) {
            this.leftChild = node;
            if (node != null) {
                node.parent = this;
            }
            return node;
        }

        public Node addRight(NodeProxy data) {
            Node tempNode;
            this.rightChild = tempNode = new Node(data);
            tempNode.parent = this;
            return tempNode;
        }

        public Node addRightChild(Node node) {
            this.rightChild = node;
            if (node != null) {
                node.parent = this;
            }
            return node;
        }

        public Node removeLeftChild() {
            Node tempNode = this.leftChild;
            this.leftChild = null;
            return tempNode;
        }

        public Node removeRightChild() {
            Node tempNode = this.rightChild;
            this.rightChild = null;
            return tempNode;
        }

        public int degree() {
            int i = 0;
            if (this.leftChild != null) {
                ++i;
            }
            if (this.rightChild != null) {
                ++i;
            }
            return i;
        }

        public void setHeight() {
            this.height = Math.max(this.leftHeight(), this.rightHeight());
        }

        public boolean isLeftChild() {
            return this == this.parent.leftChild;
        }

        public boolean isRightChild() {
            return this == this.parent.rightChild;
        }

        public int leftHeight() {
            if (this.hasLeftChild()) {
                return 1 + this.leftChild.height;
            }
            return 0;
        }

        public int rightHeight() {
            if (this.hasRightChild()) {
                return 1 + this.rightChild.height;
            }
            return 0;
        }

        public int height() {
            return this.height;
        }
    }

    class InorderTraversal
    implements Iterator,
    SequenceIterator {
        private Stack nodes = new Stack();

        public InorderTraversal() {
            if (AVLTreeNodeSet.this.root != null) {
                Node tempNode = AVLTreeNodeSet.this.root;
                do {
                    this.nodes.push(tempNode);
                } while ((tempNode = tempNode.leftChild) != null);
            }
        }

        public boolean hasNext() {
            return this.nodes.size() != 0;
        }

        public Object next() {
            Node currentNode = (Node)this.nodes.peek();
            this.nodes.pop();
            if (currentNode.hasRightChild()) {
                Node tempNode = currentNode.rightChild;
                do {
                    this.nodes.push(tempNode);
                } while ((tempNode = tempNode.leftChild) != null);
            }
            return currentNode.getData();
        }

        public void remove() {
            throw new RuntimeException("Method remove is not implemented");
        }

        public Item nextItem() {
            Node currentNode = (Node)this.nodes.peek();
            this.nodes.pop();
            if (currentNode.hasRightChild()) {
                Node tempNode = currentNode.rightChild;
                do {
                    this.nodes.push(tempNode);
                } while ((tempNode = tempNode.leftChild) != null);
            }
            return currentNode.getData();
        }
    }
}

