/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.Trigger;
import org.exist.storage.DBBroker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionConfiguration {
    private static final String NAMESPACE = "http://exist-db.org/collection-config/1.0";
    private static final String ROOT_ELEMENT = "collection";
    private static final String TRIGGERS_ELEMENT = "triggers";
    private static final String EVENT_ATTRIBUTE = "event";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String PARAM_NAME_ATTRIBUTE = "name";
    private static final String PARAM_VALUE_ATTRIBUTE = "value";
    private Trigger[] triggers = new Trigger[3];

    public CollectionConfiguration(DBBroker broker, Collection parent, Document doc) throws CollectionConfigurationException {
        Element root = doc.getDocumentElement();
        if (!root.getNamespaceURI().equals(NAMESPACE) || !root.getLocalName().equals(ROOT_ELEMENT)) {
            throw new CollectionConfigurationException("Wrong document root for collection.xmap");
        }
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!node.getNamespaceURI().equals(NAMESPACE) || !node.getLocalName().equals(TRIGGERS_ELEMENT)) continue;
            NodeList triggers = node.getChildNodes();
            for (int j = 0; j < triggers.getLength(); ++j) {
                node = triggers.item(j);
                if (node.getNodeType() != 1) continue;
                this.createTrigger(broker, parent, (Element)node);
            }
        }
    }

    public Trigger getTrigger(int eventType) {
        return this.triggers[eventType];
    }

    private void createTrigger(DBBroker broker, Collection parent, Element node) throws CollectionConfigurationException {
        String eventAttr = node.getAttribute(EVENT_ATTRIBUTE);
        if (eventAttr == null) {
            throw new CollectionConfigurationException("trigger requires an attribute 'event'");
        }
        String classAttr = node.getAttribute(CLASS_ATTRIBUTE);
        if (classAttr == null) {
            throw new CollectionConfigurationException("trigger requires an attribute 'class'");
        }
        StringTokenizer tok = new StringTokenizer(eventAttr, ", ");
        while (tok.hasMoreTokens()) {
            String event = tok.nextToken();
            if (event.equalsIgnoreCase("store")) {
                this.triggers[0] = this.instantiate(broker, parent, node, classAttr);
                continue;
            }
            if (event.equalsIgnoreCase("update")) {
                this.triggers[1] = this.instantiate(broker, parent, node, classAttr);
                continue;
            }
            if (event.equalsIgnoreCase("remove")) {
                this.triggers[2] = this.instantiate(broker, parent, node, classAttr);
                continue;
            }
            throw new CollectionConfigurationException("unknown event type '" + event + "'");
        }
    }

    private Trigger instantiate(DBBroker broker, Collection parent, Element node, String classname) throws CollectionConfigurationException {
        try {
            Class<?> clazz = Class.forName(classname);
            if (!Trigger.class.isAssignableFrom(clazz)) {
                throw new CollectionConfigurationException("supplied class is not a subclass of org.exist.collections.Trigger");
            }
            Trigger trigger = (Trigger)clazz.newInstance();
            NodeList nodes = node.getChildNodes();
            HashMap<String, String> parameters = new HashMap<String, String>(5);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node next = nodes.item(i);
                if (next.getNodeType() != 1 || !next.getNamespaceURI().equals(NAMESPACE) || !next.getLocalName().equals(PARAMETER_ELEMENT)) continue;
                Element param = (Element)next;
                String name = param.getAttribute(PARAM_NAME_ATTRIBUTE);
                String value = param.getAttribute(PARAM_VALUE_ATTRIBUTE);
                if (name == null || value == null) {
                    throw new CollectionConfigurationException("element parameter requires attributes 'name' and 'value'");
                }
                parameters.put(name, value);
            }
            trigger.configure(broker, parent, parameters);
            return trigger;
        }
        catch (ClassNotFoundException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new CollectionConfigurationException(e.getMessage(), e);
        }
    }
}

