/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.exist.EXistException;
import org.exist.Indexer;
import org.exist.collections.CollectionCache;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.Trigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.DBBroker;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.store.CollectionStore;
import org.exist.util.Configuration;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.util.ReentrantReadWriteLock;
import org.exist.util.SyntaxException;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.util.serializer.DOMStreamer;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class Collection
extends Observable
implements Comparable,
EntityResolver,
Cacheable {
    private static final Logger LOG = Logger.getLogger((Class)Collection.class);
    private static final String COLLECTION_CONFIG_FILE = "collection.xconf";
    private static final int VALIDATION_ENABLED = 0;
    private static final int VALIDATION_AUTO = 1;
    private static final int VALIDATION_DISABLED = 2;
    private short collectionId = (short)-1;
    private Map documents = new TreeMap();
    private boolean reloadRequired = false;
    private String name;
    private Permission permissions = new Permission(493);
    private ObjectHashSet subcollections = new ObjectHashSet(19);
    private long address = -1L;
    private long created = 0L;
    private CatalogResolver resolver;
    private List observers = null;
    private CollectionConfiguration configuration = null;
    private boolean triggersEnabled = true;
    private int refCount = 0;
    private int timestamp = 0;
    private CollectionStore db;
    private Lock lock = null;
    private XMLReader userReader = null;

    public Collection(CollectionStore db, String name) {
        this.name = name;
        this.db = db;
        this.lock = new ReentrantReadWriteLock(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void addCollection(Collection child) {
        int p = child.name.lastIndexOf(47) + 1;
        String childName = child.name.substring(p);
        if (!this.subcollections.contains(childName)) {
            this.subcollections.add(childName);
        }
    }

    public boolean hasChildCollection(String name) {
        return this.subcollections.contains(name);
    }

    public void release() {
        this.lock.release();
    }

    public void update(Collection child) {
        int p = child.name.lastIndexOf(47) + 1;
        String childName = child.name.substring(p);
        this.subcollections.remove(childName);
        this.subcollections.add(childName);
    }

    public void addDocument(DBBroker broker, DocumentImpl doc) {
        if (doc.getDocId() < 0) {
            doc.setDocId(broker.getNextDocId(this));
        }
        this.documents.put(doc.getFileName(), doc);
    }

    public void addDocumentLink(DBBroker broker, DocumentImpl doc) {
        if (doc.getDocId() < 0) {
            doc.setDocId(broker.getNextDocId(this));
        }
        this.documents.put(doc.getFileName(), null);
        this.reloadRequired = true;
    }

    public void unlinkDocument(DocumentImpl doc) {
        this.documents.remove(doc.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator collectionIterator() {
        try {
            this.lock.acquire(0);
            Iterator iterator = this.subcollections.stableIterator();
            return iterator;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescendants(DBBroker broker, User user) {
        ArrayList<Collection> cl = new ArrayList<Collection>(this.subcollections.size());
        try {
            this.lock.acquire(0);
            Iterator i = this.subcollections.iterator();
            while (i.hasNext()) {
                String childName = (String)i.next();
                Collection child = broker.getCollection(this.name + '/' + childName);
                if (!this.permissions.validate(user, 4)) continue;
                cl.add(child);
                if (child.getChildCollectionCount() <= 0) continue;
                cl.addAll(child.getDescendants(broker, user));
            }
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.release();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentSet allDocs(DBBroker broker, DocumentSet docs, boolean recursive, boolean checkPermissions) {
        if (this.permissions.validate(broker.getUser(), 4)) {
            CollectionCache cache;
            CollectionCache collectionCache = cache = broker.getBrokerPool().getCollectionsCache();
            synchronized (collectionCache) {
                this.getDocuments(broker, docs, checkPermissions);
                if (recursive) {
                    this.allDocs(broker, docs, checkPermissions);
                }
            }
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentSet allDocs(DBBroker broker, DocumentSet docs, boolean checkPermissions) {
        try {
            this.lock.acquire(0);
            Iterator i = this.subcollections.iterator();
            while (i.hasNext()) {
                String childName = (String)i.next();
                Collection child = broker.getCollection(this.name + '/' + childName);
                if (child == null) {
                    LOG.warn((Object)("child collection " + childName + " not found. Skipping ..."));
                    continue;
                }
                if (!child.permissions.validate(broker.getUser(), 4)) continue;
                child.getDocuments(broker, docs, checkPermissions);
                if (child.getChildCollectionCount() <= 0) continue;
                child.allDocs(broker, docs, checkPermissions);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.release();
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentSet getDocuments(DBBroker broker, DocumentSet docs, boolean checkPermissions) {
        try {
            this.lock.acquire(0);
            if (this.reloadRequired) {
                broker.reloadCollection(this);
                this.reloadRequired = false;
            }
            docs.addCollection(this);
            docs.addAll(broker, this.documents.values(), checkPermissions);
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.release();
        }
        return docs;
    }

    public boolean allowUnload() {
        Iterator i = this.documents.values().iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            if (!doc.isLockedForWrite()) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object obj) {
        Collection other = (Collection)obj;
        if (this.collectionId == other.collectionId) {
            return 0;
        }
        if (this.collectionId < other.collectionId) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        return ((Collection)obj).collectionId == this.collectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCollectionCount() {
        try {
            this.lock.acquire(0);
            int n = this.subcollections.size();
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl getDocument(DBBroker broker, String name) {
        try {
            DocumentImpl doc;
            this.lock.acquire(0);
            if (this.reloadRequired) {
                broker.reloadCollection(this);
                this.reloadRequired = false;
            }
            if ((doc = (DocumentImpl)this.documents.get(name)) == null) {
                LOG.debug((Object)("Document " + name + " not found!"));
            }
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            DocumentImpl documentImpl = null;
            return documentImpl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl getDocumentWithLock(DBBroker broker, String name) throws LockException {
        try {
            DocumentImpl doc;
            this.lock.acquire(0);
            if (this.reloadRequired) {
                broker.reloadCollection(this);
                this.reloadRequired = false;
            }
            if ((doc = (DocumentImpl)this.documents.get(name)) == null) {
                DocumentImpl documentImpl = null;
                return documentImpl;
            }
            Lock updateLock = doc.getUpdateLock();
            updateLock.acquire(0);
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl getDocumentWithLock(DBBroker broker, String name, int lockMode) throws LockException {
        try {
            DocumentImpl doc;
            this.lock.acquire(0);
            if (this.reloadRequired) {
                broker.reloadCollection(this);
                this.reloadRequired = false;
            }
            if ((doc = (DocumentImpl)this.documents.get(name)) == null) {
                DocumentImpl documentImpl = null;
                return documentImpl;
            }
            Lock updateLock = doc.getUpdateLock();
            updateLock.acquire(lockMode);
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        finally {
            this.lock.release();
        }
    }

    public void releaseDocument(DocumentImpl doc) {
        if (doc != null) {
            doc.getUpdateLock().release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocumentCount() {
        try {
            this.lock.acquire(0);
            int n = this.documents.size();
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    public short getId() {
        return this.collectionId;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        if (this.name.equals("/db")) {
            return null;
        }
        String parent = this.name.lastIndexOf("/") < 1 ? "/db" : this.name.substring(0, this.name.lastIndexOf("/"));
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermissions() {
        try {
            this.lock.acquire(0);
            Permission permission = this.permissions;
            return permission;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            Permission permission = this.permissions;
            return permission;
        }
        finally {
            this.lock.release();
        }
    }

    public boolean hasDocument(String name) {
        return this.documents.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubcollection(String name) {
        try {
            this.lock.acquire(0);
            boolean bl = this.subcollections.contains(name);
            return bl;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            boolean bl = this.subcollections.contains(name);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    public Iterator iterator(DBBroker broker) {
        return this.getDocuments(broker, new DocumentSet(), false).iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void read(DBBroker broker, VariableByteInput istream) throws IOException {
        this.collectionId = istream.readShort();
        int collLen = istream.readInt();
        this.subcollections = new ObjectHashSet(collLen);
        for (int i = 0; i < collLen; ++i) {
            this.subcollections.add(istream.readUTF());
        }
        SecurityManager secman = broker.getBrokerPool().getSecurityManager();
        int uid = istream.readInt();
        int gid = istream.readInt();
        int perm = istream.readInt() & 0x1FF;
        if (secman == null) {
            this.permissions.setOwner("admin");
            this.permissions.setGroup("dba");
        } else {
            this.permissions.setOwner(secman.getUser(uid));
            this.permissions.setGroup(secman.getGroup(gid).getName());
        }
        this.permissions.setPermissions(perm);
        this.created = istream.readLong();
        try {
            while (istream.available() > 0) {
                void var9_9;
                byte resourceType = istream.readByte();
                switch (resourceType) {
                    case 0: {
                        DocumentImpl doc = new DocumentImpl(broker, this);
                        break;
                    }
                    case 1: {
                        DocumentImpl doc = new BinaryDocument(broker, this);
                        break;
                    }
                    case -1: {
                        return;
                    }
                    default: {
                        LOG.warn((Object)("unknown resource type: " + resourceType));
                        throw new IOException("unable to determine resource type while reading collection " + this.getName());
                    }
                }
                var9_9.read(istream);
                this.addDocument(broker, (DocumentImpl)var9_9);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(String name) throws LockException {
        try {
            this.lock.acquire(1);
            this.subcollections.remove(name);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(DBBroker broker, String docname) throws PermissionDeniedException, TriggerException, LockException {
        try {
            DocumentImpl doc;
            this.lock.acquire(0);
            Trigger trigger = null;
            if (!docname.equals(COLLECTION_CONFIG_FILE)) {
                CollectionConfiguration config;
                if (this.triggersEnabled && (config = this.getConfiguration(broker)) != null) {
                    trigger = config.getTrigger(2);
                }
            } else {
                this.configuration = null;
            }
            if ((doc = this.getDocument(broker, docname)) == null) {
                return;
            }
            if (doc.isLockedForWrite()) {
                throw new PermissionDeniedException("Document " + doc.getFileName() + " is locked for write");
            }
            if (!this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("Write access to collection denied; user=" + broker.getUser().getName());
            }
            if (!doc.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("Permission to remove document denied");
            }
            if (trigger != null && this.triggersEnabled) {
                trigger.prepare(2, broker, docname, doc);
            }
            broker.removeDocument(doc);
            this.documents.remove(docname);
            broker.saveCollection(this);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinaryResource(DBBroker broker, String docname) throws PermissionDeniedException, LockException {
        try {
            this.lock.acquire(1);
            DocumentImpl doc = this.getDocument(broker, docname);
            if (doc.isLockedForWrite()) {
                throw new PermissionDeniedException("Document " + doc.getFileName() + " is locked for write");
            }
            if (!this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("write access to collection denied; user=" + broker.getUser().getName());
            }
            if (!doc.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("permission to remove document denied");
            }
            this.removeBinaryResource(broker, doc);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBinaryResource(DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException {
        if (doc == null) {
            return;
        }
        if (doc.getResourceType() != 1) {
            throw new PermissionDeniedException("document " + doc.getFileName() + " is not a binary object");
        }
        if (doc.isLockedForWrite()) {
            throw new PermissionDeniedException("Document " + doc.getFileName() + " is locked for write");
        }
        if (!this.getPermissions().validate(broker.getUser(), 2)) {
            throw new PermissionDeniedException("write access to collection denied; user=" + broker.getUser().getName());
        }
        if (!doc.getPermissions().validate(broker.getUser(), 2)) {
            throw new PermissionDeniedException("permission to remove document denied");
        }
        try {
            this.lock.acquire(1);
            broker.removeBinaryResource((BinaryDocument)doc);
            this.documents.remove(doc.getFileName());
            broker.saveCollection(this);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInfo validate(DBBroker broker, String name, InputSource source) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        try {
            this.lock.acquire(1);
            XMLReader currentReader = this.getReader(broker);
            DocumentImpl oldDoc = (DocumentImpl)this.documents.get(name);
            DocumentImpl document = new DocumentImpl(broker, name, this);
            IndexInfo indexInfo = this.determineTreeStructure(broker, name, document, oldDoc, currentReader, source);
            return indexInfo;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(DBBroker broker, IndexInfo info, InputSource source, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        try {
            InputStream is = source.getByteStream();
            if (is != null) {
                is.reset();
            } else {
                Reader cs = source.getCharacterStream();
                if (cs != null) {
                    cs.reset();
                }
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"could not reset input source", (Throwable)e);
        }
        Indexer indexer = info.getIndexer();
        DocumentImpl document = indexer.getDocument();
        LOG.debug((Object)("storing document " + document.getDocId() + "; " + document.getFileName() + " ..."));
        try {
            try {
                info.getReader().parse(source);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            if (!this.hasDocument(document.getFileName())) {
                this.addDocument(broker, document);
                broker.addDocument(this, document);
            } else {
                broker.updateDocument(document);
            }
            broker.closeDocument();
            broker.flush();
            LOG.debug((Object)"document stored.");
            if (this.getName().equals("/db/system") && document.getFileName().equals("users.xml") && !privileged) {
                LOG.debug((Object)"users.xml changed");
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
            Object var9_9 = null;
            document.getUpdateLock().release(1);
            this.releaseReader(broker, info.getReader());
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            document.getUpdateLock().release(1);
            this.releaseReader(broker, info.getReader());
            throw throwable;
        }
        broker.deleteObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInfo validate(DBBroker broker, String name, String data) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        try {
            this.lock.acquire(1);
            InputSource source = new InputSource(new StringReader(data));
            XMLReader currentReader = this.getReader(broker);
            if (currentReader == null) {
                throw new EXistException("No reader!");
            }
            DocumentImpl oldDoc = (DocumentImpl)this.documents.get(name);
            DocumentImpl document = new DocumentImpl(broker, name, this);
            IndexInfo indexInfo = this.determineTreeStructure(broker, name, document, oldDoc, currentReader, source);
            return indexInfo;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(DBBroker broker, IndexInfo info, String data, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        InputSource source = new InputSource(new StringReader(data));
        Indexer indexer = info.getIndexer();
        DocumentImpl document = indexer.getDocument();
        LOG.debug((Object)("storing document " + document.getDocId() + " ..."));
        try {
            try {
                info.getReader().parse(source);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            if (!this.hasDocument(document.getFileName())) {
                this.addDocument(broker, document);
                broker.addDocument(this, document);
            } else {
                broker.updateDocument(document);
            }
            broker.closeDocument();
            broker.flush();
            LOG.debug((Object)"document stored.");
            if (this.getName().equals("/db/system") && document.getFileName().equals("users.xml") && !privileged) {
                LOG.debug((Object)"users.xml changed");
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
            Object var10_9 = null;
            document.getUpdateLock().release(1);
            this.releaseReader(broker, info.getReader());
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            document.getUpdateLock().release(1);
            this.releaseReader(broker, info.getReader());
            throw throwable;
        }
        broker.deleteObservers();
    }

    public IndexInfo validate(DBBroker broker, String name, Node node) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        DocumentImpl oldDoc = null;
        try {
            this.lock.acquire(1);
            oldDoc = this.getDocument(broker, name);
            DocumentImpl document = new DocumentImpl(broker, name, this);
            this.checkPermissions(broker, name, oldDoc);
            this.manageDocumentInformation(broker, name, oldDoc, document);
            Trigger trigger = this.setupTriggers(broker, name, oldDoc);
            Indexer indexer = new Indexer(broker);
            IndexInfo info = new IndexInfo(indexer);
            indexer.setDocument(document);
            this.addObserversToIndexer(broker, indexer);
            indexer.setValidating(true);
            DOMStreamer streamer = new DOMStreamer();
            info.setDOMStreamer(streamer);
            if (trigger != null && this.triggersEnabled) {
                streamer.setContentHandler(trigger.getInputHandler());
                streamer.setLexicalHandler(trigger.getLexicalInputHandler());
                trigger.setOutputHandler(indexer);
                trigger.setValidating(true);
                trigger.prepare(oldDoc == null ? 0 : 1, broker, name, oldDoc);
            } else {
                streamer.setContentHandler(indexer);
                streamer.setLexicalHandler(indexer);
            }
            LOG.debug((Object)("validating document " + name));
            streamer.serialize(node, true);
            document.setMaxDepth(document.getMaxDepth() + 1);
            document.calculateTreeLevelStartPoints();
            if (oldDoc != null) {
                LOG.debug((Object)("removing old document " + oldDoc.getFileName()));
                if (oldDoc.getResourceType() == 1) {
                    broker.removeBinaryResource((BinaryDocument)oldDoc);
                } else {
                    broker.removeDocument(oldDoc, false);
                }
                oldDoc.copyOf(document);
                indexer.setDocumentObject(oldDoc);
                document = oldDoc;
            } else {
                document.getUpdateLock().acquire(1);
                document.setDocId(broker.getNextDocId(this));
            }
            indexer.setValidating(false);
            if (trigger != null) {
                trigger.setValidating(false);
            }
            IndexInfo indexInfo = info;
            return indexInfo;
        }
        catch (EXistException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (SAXException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (PermissionDeniedException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (TriggerException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(DBBroker broker, IndexInfo info, Node node, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        Indexer indexer = info.getIndexer();
        DocumentImpl document = indexer.getDocument();
        LOG.debug((Object)("storing document " + document.getDocId() + " ..."));
        DOMStreamer streamer = info.getDOMStreamer();
        try {
            streamer.serialize(node, true);
            if (!this.hasDocument(document.getFileName())) {
                this.addDocument(broker, document);
                broker.addDocument(this, document);
            } else {
                broker.updateDocument(document);
            }
            broker.closeDocument();
            broker.flush();
            LOG.debug((Object)"document stored.");
            if (this.getName().equals("/db/system") && document.getFileName().equals("users.xml") && !privileged) {
                LOG.debug((Object)"users.xml changed");
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
            Object var9_8 = null;
            document.getUpdateLock().release(1);
            this.releaseReader(broker, info.getReader());
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            document.getUpdateLock().release(1);
            this.releaseReader(broker, info.getReader());
            throw throwable;
        }
        broker.deleteObservers();
    }

    public DocumentImpl addDocument(DBBroker broker, String name, String data) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        return this.addDocument(broker, name, data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl addDocument(DBBroker broker, String name, String data, boolean privileged) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        XMLReader reader;
        DocumentImpl document;
        InputSource source;
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        DocumentImpl oldDoc = null;
        try {
            this.lock.acquire(1);
            source = new InputSource(new StringReader(data));
            document = new DocumentImpl(broker, name, this);
            reader = this.getReader(broker);
            oldDoc = (DocumentImpl)this.documents.get(name);
            IndexInfo info = this.determineTreeStructure(broker, name, document, oldDoc, reader, source);
            document = info.getIndexer().getDocument();
        }
        finally {
            this.lock.release();
        }
        source = new InputSource(new StringReader(data));
        LOG.debug((Object)("storing document " + document.getDocId() + " ..."));
        try {
            try {
                reader.parse(source);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            if (oldDoc == null) {
                this.addDocument(broker, document);
                broker.addDocument(this, document);
            } else {
                broker.updateDocument(document);
            }
            broker.closeDocument();
            broker.flush();
            LOG.debug((Object)"document stored.");
            if (this.getName().equals("/db/system") && document.getFileName().equals("users.xml") && !privileged) {
                LOG.debug((Object)"users.xml changed");
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
        }
        finally {
            document.getUpdateLock().release(1);
        }
        broker.deleteObservers();
        return document;
    }

    private IndexInfo determineTreeStructure(DBBroker broker, String name, DocumentImpl document, DocumentImpl oldDoc, XMLReader reader, InputSource source) throws LockException, EXistException, SAXException, PermissionDeniedException, TriggerException {
        try {
            this.checkPermissions(broker, name, oldDoc);
            this.manageDocumentInformation(broker, name, oldDoc, document);
            Trigger trigger = this.setupTriggers(broker, name, oldDoc);
            Indexer indexer = new Indexer(broker);
            IndexInfo info = new IndexInfo(indexer);
            indexer.setDocument(document);
            this.addObserversToIndexer(broker, indexer);
            this.prepareSAXParser(broker, name, oldDoc, trigger, info, reader);
            LOG.debug((Object)("validating document " + name));
            try {
                reader.parse(source);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            document.setMaxDepth(document.getMaxDepth() + 1);
            document.calculateTreeLevelStartPoints();
            if (oldDoc != null) {
                LOG.debug((Object)("removing old document " + oldDoc.getFileName()));
                if (oldDoc.getResourceType() == 1) {
                    broker.removeBinaryResource((BinaryDocument)oldDoc);
                } else {
                    broker.removeDocument(oldDoc, false);
                }
                oldDoc.copyOf(document);
                indexer.setDocumentObject(oldDoc);
                document = oldDoc;
            } else {
                document.getUpdateLock().acquire(1);
                document.setDocId(broker.getNextDocId(this));
            }
            indexer.setValidating(false);
            if (trigger != null) {
                trigger.setValidating(false);
            }
            return info;
        }
        catch (EXistException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (SAXException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (PermissionDeniedException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (TriggerException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
    }

    private void prepareSAXParser(DBBroker broker, String name, DocumentImpl oldDoc, Trigger trigger, IndexInfo info, XMLReader reader) throws EXistException, SAXException, SAXNotRecognizedException, SAXNotSupportedException, TriggerException {
        Indexer indexer = info.getIndexer();
        indexer.setValidating(true);
        reader.setEntityResolver(this);
        if (trigger != null && this.triggersEnabled) {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", trigger.getLexicalInputHandler());
            reader.setContentHandler(trigger.getInputHandler());
            trigger.setOutputHandler(indexer);
            trigger.setLexicalOutputHandler(indexer);
            trigger.setValidating(true);
            trigger.prepare(oldDoc == null ? 0 : 1, broker, name, oldDoc);
        } else {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", indexer);
            reader.setContentHandler(indexer);
        }
        reader.setErrorHandler(indexer);
        info.setReader(reader);
    }

    private void addObserversToIndexer(DBBroker broker, Indexer indexer) {
        broker.deleteObservers();
        if (this.observers != null) {
            Iterator i = this.observers.iterator();
            while (i.hasNext()) {
                Observer observer = (Observer)i.next();
                indexer.addObserver(observer);
                broker.addObserver(observer);
            }
        }
    }

    private void manageDocumentInformation(DBBroker broker, String name, DocumentImpl oldDoc, DocumentImpl document) {
        if (oldDoc != null) {
            document.setCreated(oldDoc.getCreated());
            document.setLastModified(System.currentTimeMillis());
            document.setPermissions(oldDoc.getPermissions());
        } else {
            document.setCreated(System.currentTimeMillis());
            document.getPermissions().setOwner(broker.getUser());
            document.getPermissions().setGroup(broker.getUser().getPrimaryGroup());
        }
    }

    private void checkPermissions(DBBroker broker, String name, DocumentImpl oldDoc) throws LockException, PermissionDeniedException {
        if (oldDoc != null) {
            LOG.debug((Object)("Found old doc " + oldDoc.getDocId()));
            User lockUser = oldDoc.getUserLock();
            if (lockUser != null && !lockUser.equals(broker.getUser())) {
                throw new PermissionDeniedException("The document is locked by user " + lockUser.getName());
            }
            oldDoc.getUpdateLock().acquire(1);
            if (!oldDoc.getPermissions().validate(broker.getUser(), 1)) {
                throw new PermissionDeniedException("Document exists and update is not allowed");
            }
            if (!this.getPermissions().validate(broker.getUser(), 1) && !this.getPermissions().validate(broker.getUser(), 2)) {
                throw new PermissionDeniedException("Document exists and update is not allowed for the collection");
            }
        } else if (!this.getPermissions().validate(broker.getUser(), 2)) {
            throw new PermissionDeniedException("Not allowed to write to collection " + this.getName());
        }
    }

    public DocumentImpl addDocument(DBBroker broker, String name, InputSource source) throws EXistException, LockException, PermissionDeniedException, TriggerException, SAXException {
        return this.addDocument(broker, name, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl addDocument(DBBroker broker, String name, InputSource source, boolean privileged) throws EXistException, PermissionDeniedException, SAXException, TriggerException, LockException {
        XMLReader reader;
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        DocumentImpl document = null;
        DocumentImpl oldDoc = null;
        try {
            this.lock.acquire(1);
            oldDoc = this.getDocument(broker, name);
            document = new DocumentImpl(broker, name, this);
            reader = this.getReader(broker);
            IndexInfo info = this.determineTreeStructure(broker, name, document, oldDoc, reader, source);
            document = info.getIndexer().getDocument();
        }
        finally {
            this.lock.release();
        }
        try {
            InputStream is = source.getByteStream();
            if (is != null) {
                is.reset();
            } else {
                Reader cs = source.getCharacterStream();
                if (cs != null) {
                    cs.reset();
                }
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"could not reset input source", (Throwable)e);
        }
        LOG.debug((Object)"storing document ...");
        try {
            try {
                reader.parse(source);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            if (oldDoc == null) {
                this.addDocument(broker, document);
                broker.addDocument(this, document);
            } else {
                broker.updateDocument(document);
            }
            broker.closeDocument();
            broker.flush();
            if (this.getName().equals("/db/system") && document.getFileName().equals("users.xml") && !privileged) {
                LOG.debug((Object)"users.xml changed");
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
        }
        finally {
            document.getUpdateLock().release(1);
        }
        broker.deleteObservers();
        return document;
    }

    public DocumentImpl addDocument(DBBroker broker, String name, Node node) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        return this.addDocument(broker, name, node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentImpl addDocument(DBBroker broker, String name, Node node, boolean privileged) throws EXistException, LockException, PermissionDeniedException, TriggerException, SAXException {
        DOMStreamer streamer;
        DocumentImpl document;
        Indexer indexer = new Indexer(broker);
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        DocumentImpl oldDoc = null;
        try {
            this.lock.acquire(1);
            oldDoc = this.getDocument(broker, name);
            document = new DocumentImpl(broker, name, this);
            this.checkPermissions(broker, name, oldDoc);
            this.manageDocumentInformation(broker, name, oldDoc, document);
            Trigger trigger = this.setupTriggers(broker, name, oldDoc);
            indexer.setDocument(document);
            this.addObserversToIndexer(broker, indexer);
            indexer.setValidating(true);
            streamer = new DOMStreamer();
            if (trigger != null && this.triggersEnabled) {
                streamer.setContentHandler(trigger.getInputHandler());
                streamer.setLexicalHandler(trigger.getLexicalInputHandler());
                trigger.setOutputHandler(indexer);
                trigger.setValidating(true);
                trigger.prepare(oldDoc == null ? 0 : 1, broker, name, oldDoc);
            } else {
                streamer.setContentHandler(indexer);
                streamer.setLexicalHandler(indexer);
            }
            LOG.debug((Object)("validating document " + name));
            streamer.serialize(node, true);
            document.setMaxDepth(document.getMaxDepth() + 1);
            document.calculateTreeLevelStartPoints();
            if (oldDoc != null) {
                LOG.debug((Object)("removing old document " + oldDoc.getFileName()));
                if (oldDoc.getResourceType() == 1) {
                    broker.removeBinaryResource((BinaryDocument)oldDoc);
                } else {
                    broker.removeDocument(oldDoc, false);
                }
                oldDoc.copyOf(document);
                indexer.setDocumentObject(oldDoc);
                document = oldDoc;
            } else {
                document.getUpdateLock().acquire(1);
                document.setDocId(broker.getNextDocId(this));
            }
            indexer.setValidating(false);
            if (trigger != null) {
                trigger.setValidating(false);
            }
        }
        catch (EXistException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (SAXException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (PermissionDeniedException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        catch (TriggerException e) {
            if (oldDoc != null) {
                oldDoc.getUpdateLock().release(1);
            }
            throw e;
        }
        finally {
            this.lock.release();
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("storing document " + document.getFileName()));
            }
            streamer.serialize(node, true);
            if (oldDoc == null) {
                this.addDocument(broker, document);
                broker.addDocument(this, document);
            } else {
                broker.updateDocument(document);
            }
            broker.closeDocument();
            broker.flush();
            if (this.getName().equals("/db/system") && document.getFileName().equals("users.xml") && !privileged) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"users.xml changed");
                }
                broker.getBrokerPool().reloadSecurityManager(broker);
            }
        }
        finally {
            document.getUpdateLock().release(1);
        }
        broker.deleteObservers();
        return document;
    }

    private Trigger setupTriggers(DBBroker broker, String name, DocumentImpl oldDoc) {
        Trigger trigger = null;
        if (this.triggersEnabled && !name.equals(COLLECTION_CONFIG_FILE)) {
            CollectionConfiguration config;
            if (this.triggersEnabled && (config = this.getConfiguration(broker)) != null) {
                trigger = oldDoc == null ? config.getTrigger(0) : config.getTrigger(1);
            }
        } else {
            this.configuration = null;
        }
        return trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryDocument addBinaryResource(DBBroker broker, String name, byte[] data) throws EXistException, PermissionDeniedException, LockException {
        if (broker.isReadOnly()) {
            throw new PermissionDeniedException("Database is read-only");
        }
        BinaryDocument blob = null;
        DocumentImpl oldDoc = this.getDocument(broker, name);
        blob = new BinaryDocument(broker, name, this);
        try {
            this.lock.acquire(1);
            this.checkPermissions(broker, name, oldDoc);
            this.manageDocumentInformation(broker, name, oldDoc, blob);
            if (oldDoc != null) {
                LOG.debug((Object)("removing old document " + oldDoc.getFileName()));
                if (oldDoc instanceof BinaryDocument) {
                    broker.removeBinaryResource((BinaryDocument)oldDoc);
                } else {
                    broker.removeDocument(oldDoc);
                }
            }
            broker.storeBinaryResource(blob, data);
            this.addDocument(broker, blob);
            broker.addDocument(this, blob);
            broker.closeDocument();
            BinaryDocument binaryDocument = blob;
            return binaryDocument;
        }
        finally {
            this.lock.release();
        }
    }

    public void setId(short id) {
        this.collectionId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(int mode) throws LockException {
        try {
            this.lock.acquire(1);
            this.permissions.setPermissions(mode);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String mode) throws SyntaxException, LockException {
        try {
            this.lock.acquire(1);
            this.permissions.setPermissions(mode);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(Permission permissions) throws LockException {
        try {
            this.lock.acquire(1);
            this.permissions = permissions;
        }
        finally {
            this.lock.release();
        }
    }

    public void write(DBBroker broker, VariableByteOutputStream ostream) throws IOException {
        ostream.writeShort(this.collectionId);
        ostream.writeInt(this.subcollections.size());
        Iterator i = this.subcollections.iterator();
        while (i.hasNext()) {
            String childColl = (String)i.next();
            ostream.writeUTF(childColl);
        }
        SecurityManager secman = broker.getBrokerPool().getSecurityManager();
        if (secman == null) {
            ostream.writeInt(1);
            ostream.writeInt(1);
        } else {
            User user = secman.getUser(this.permissions.getOwner());
            Group group = secman.getGroup(this.permissions.getOwnerGroup());
            ostream.writeInt(user.getUID());
            ostream.writeInt(group.getId());
        }
        ostream.writeInt(this.permissions.getPermissions());
        ostream.writeLong(this.created);
        if (this.reloadRequired) {
            broker.reloadCollection(this);
            this.reloadRequired = false;
        }
        Iterator i2 = this.documents.values().iterator();
        while (i2.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i2.next();
            doc.write(ostream);
        }
    }

    private CollectionConfiguration getConfiguration(DBBroker broker) {
        if (this.configuration == null) {
            this.configuration = this.readCollectionConfiguration(broker);
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionConfiguration readCollectionConfiguration(DBBroker broker) {
        if (this.hasDocument(COLLECTION_CONFIG_FILE)) {
            DocumentImpl doc = this.getDocument(broker, COLLECTION_CONFIG_FILE);
            if (doc == null) {
                LOG.warn((Object)"collection.xconf exists but could not be loaded");
                return null;
            }
            LOG.debug((Object)"found collection.xconf");
            this.triggersEnabled = false;
            try {
                CollectionConfiguration collectionConfiguration = new CollectionConfiguration(broker, this, doc);
                return collectionConfiguration;
            }
            catch (CollectionConfigurationException e) {
                LOG.warn((Object)("Failed to load collection configuration " + e.getMessage()));
            }
            finally {
                this.triggersEnabled = true;
            }
        }
        return null;
    }

    public void setAddress(long addr) {
        this.address = addr;
    }

    public long getAddress() {
        return this.address;
    }

    public void setCreationTime(long ms) {
        this.created = ms;
    }

    public long getCreationTime() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggersEnabled(boolean enabled) {
        try {
            this.lock.acquire(1);
            this.triggersEnabled = enabled;
        }
        catch (LockException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            this.triggersEnabled = enabled;
        }
        finally {
            this.lock.release();
        }
    }

    public void setReader(XMLReader reader) {
        this.userReader = reader;
    }

    private XMLReader getReader(DBBroker broker) throws EXistException, SAXException {
        if (this.userReader != null) {
            return this.userReader;
        }
        Configuration config = broker.getConfiguration();
        this.resolver = (CatalogResolver)config.getProperty("resolver");
        return broker.getBrokerPool().getParserPool().borrowXMLReader();
    }

    private void releaseReader(DBBroker broker, XMLReader reader) {
        if (this.userReader != null) {
            return;
        }
        broker.getBrokerPool().getParserPool().returnXMLReader(reader);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource is = this.resolver.resolveEntity(publicId, systemId);
        if (is == null) {
            if (publicId != null) {
                return null;
            }
            URL url = new URL(systemId);
            if (url.getProtocol().equals("file")) {
                String path = url.getPath();
                File f = new File(path);
                if (!f.canRead()) {
                    return this.resolver.resolveEntity(null, f.getName());
                }
                return new InputSource(f.getAbsolutePath());
            }
            return new InputSource(url.openStream());
        }
        return is;
    }

    private void setFeature(SAXParserFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException e) {
            LOG.warn((Object)e);
        }
        catch (SAXNotSupportedException snse) {
            LOG.warn((Object)snse);
        }
        catch (ParserConfigurationException pce) {
            LOG.warn((Object)pce);
        }
    }

    public void addObserver(Observer o) {
        if (this.observers == null) {
            this.observers = new ArrayList(1);
        }
        if (!this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public void deleteObservers() {
        if (this.observers != null) {
            this.observers.clear();
        }
    }

    public long getKey() {
        return this.collectionId;
    }

    public int getReferenceCount() {
        return this.refCount;
    }

    public int incReferenceCount() {
        return ++this.refCount;
    }

    public int decReferenceCount() {
        return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
    }

    public void setReferenceCount(int count) {
        this.refCount = count;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public boolean sync() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.documents.keySet().iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String getParentPathGen(String col) {
        if (col.equals("/db")) {
            return null;
        }
        String col1 = col.lastIndexOf("/") < 1 ? "/db" : col.substring(0, col.lastIndexOf("/"));
        return col1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parentHasDoc(DBBroker broker, String col, String document) {
        CollectionCache cache;
        Collection collection = null;
        String col2 = "";
        String result = null;
        boolean test = true;
        CollectionCache collectionCache = cache = broker.getBrokerPool().getCollectionsCache();
        synchronized (collectionCache) {
            while (test) {
                if ((col = this.getParentPathGen(col)) == null) {
                    test = false;
                    continue;
                }
                collection = broker.getCollection(col);
                if (!collection.hasDocument(document)) continue;
                result = col;
                test = false;
            }
        }
        return result;
    }
}

