/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class ResourcePropertyDialog
extends JDialog {
    public static final int APPLY_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    Permission permissions;
    String resource;
    UserManagementService service;
    Date creationDate;
    Date modificationDate;
    JComboBox groups;
    JComboBox owners;
    JCheckBox[] worldPerms;
    JCheckBox[] groupPerms;
    JCheckBox[] userPerms;
    int result = -1;

    public ResourcePropertyDialog(Frame owner, UserManagementService mgt, String res, Permission perm, Date created, Date modified) throws HeadlessException, XMLDBException {
        super(owner, "Edit Properties", true);
        this.service = mgt;
        this.permissions = perm;
        this.creationDate = created;
        this.modificationDate = modified;
        this.resource = res;
        this.setupComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                ResourcePropertyDialog.this.cancelAction();
            }
        });
        this.pack();
    }

    public int getResult() {
        return this.result;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    private void setupComponents() throws XMLDBException {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel("Resource:");
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        label = new JLabel(this.resource);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        label = new JLabel("Created:");
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        String date = DateFormat.getDateTimeInstance().format(this.creationDate);
        label = new JLabel(date);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        label = new JLabel("Last modified:");
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        date = this.modificationDate != null ? DateFormat.getDateTimeInstance().format(this.modificationDate) : "not available";
        label = new JLabel(date);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        label = new JLabel("Owner");
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        Vector<String> ol = new Vector<String>();
        User[] users = this.service.getUsers();
        for (int i = 0; i < users.length; ++i) {
            ol.addElement(users[i].getName());
        }
        this.owners = new JComboBox(ol);
        this.owners.setSelectedItem(this.permissions.getOwner());
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.owners, c);
        this.getContentPane().add(this.owners);
        label = new JLabel("Group");
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        Vector<String> gl = new Vector<String>();
        String[] allGroups = this.service.getGroups();
        for (int i = 0; i < allGroups.length; ++i) {
            gl.addElement(allGroups[i]);
        }
        this.groups = new JComboBox(gl);
        this.groups.setSelectedItem(this.permissions.getOwnerGroup());
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.groups, c);
        this.getContentPane().add(this.groups);
        JComponent pc = this.setupPermissions();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(pc, c);
        this.getContentPane().add(pc);
        Box buttonBox = Box.createHorizontalBox();
        JButton button = new JButton("Apply");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourcePropertyDialog.this.applyAction();
            }
        });
        buttonBox.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResourcePropertyDialog.this.cancelAction();
            }
        });
        buttonBox.add(button);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(buttonBox, c);
        this.getContentPane().add(buttonBox);
    }

    private JComponent setupPermissions() {
        Box hbox = Box.createHorizontalBox();
        hbox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Permissions"));
        this.userPerms = new JCheckBox[3];
        JComponent c = this.getPermissionsBox("user", this.userPerms, this.permissions.getUserPermissions());
        hbox.add(c);
        this.groupPerms = new JCheckBox[3];
        c = this.getPermissionsBox("group", this.groupPerms, this.permissions.getGroupPermissions());
        hbox.add(c);
        this.worldPerms = new JCheckBox[3];
        c = this.getPermissionsBox("world", this.worldPerms, this.permissions.getPublicPermissions());
        hbox.add(c);
        return hbox;
    }

    private JComponent getPermissionsBox(String title, JCheckBox[] perms, int current) {
        Box vbox = Box.createVerticalBox();
        JLabel label = new JLabel(title);
        vbox.add(label);
        perms[0] = new JCheckBox("read", (current & 4) == 4);
        vbox.add(perms[0]);
        perms[1] = new JCheckBox("write", (current & 2) == 2);
        vbox.add(perms[1]);
        perms[2] = new JCheckBox("update", (current & 1) == 1);
        vbox.add(perms[2]);
        return vbox;
    }

    private int checkPermissions(JCheckBox[] cb) {
        int perm = 0;
        if (cb[0].isSelected()) {
            perm |= 4;
        }
        if (cb[1].isSelected()) {
            perm |= 2;
        }
        if (cb[2].isSelected()) {
            perm |= 1;
        }
        return perm;
    }

    private void cancelAction() {
        this.setVisible(false);
        this.result = 1;
    }

    private void applyAction() {
        this.permissions.setOwner((String)this.owners.getSelectedItem());
        this.permissions.setGroup((String)this.groups.getSelectedItem());
        int perms = this.checkPermissions(this.userPerms) << 6 | this.checkPermissions(this.groupPerms) << 3 | this.checkPermissions(this.worldPerms);
        this.permissions.setPermissions(perms);
        this.setVisible(false);
        this.result = 0;
    }
}

