/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.exist.client.ClientFrame;
import org.exist.client.ClientTextArea;
import org.exist.storage.ElementIndex;
import org.exist.storage.TextSearchEngine;
import org.exist.util.ProgressIndicator;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

class DocumentView
extends JFrame {
    protected Resource resource;
    protected Collection collection;
    protected boolean readOnly = false;
    protected ClientTextArea text;
    protected JButton saveButton;
    protected JTextField statusMessage;
    protected JProgressBar progress;
    protected JPopupMenu popup;
    protected Properties properties;

    public DocumentView(Collection collection, Resource resource, Properties properties) throws XMLDBException {
        super("View Document");
        this.collection = collection;
        this.resource = resource;
        this.properties = properties;
        this.getContentPane().setLayout(new BorderLayout());
        this.setupComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                DocumentView.this.close();
            }
        });
        this.pack();
    }

    public void setReadOnly() {
        this.text.setEditable(false);
        this.saveButton.setEnabled(false);
        this.readOnly = true;
    }

    private void close() {
        if (this.readOnly) {
            return;
        }
        try {
            UserManagementService service = (UserManagementService)this.collection.getService("UserManagementService", "1.0");
            service.unlockResource(this.resource);
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    private void setupComponents() throws XMLDBException {
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Save24.gif");
        this.saveButton = new JButton(new ImageIcon(url));
        this.saveButton.setToolTipText("Store the modified data back into the database.");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.save();
            }
        });
        toolbar.add(this.saveButton);
        url = this.getClass().getResource("icons/Export24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText("Export to file.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.export();
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Copy24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Copy selection.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.text.copy();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Cut24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Cut selection.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.text.cut();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Paste24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Paste selection.");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.text.paste();
            }
        });
        toolbar.add(button);
        this.getContentPane().add((Component)toolbar, "North");
        this.text = new ClientTextArea(true, "XML");
        this.getContentPane().add((Component)((Object)this.text), "Center");
        Box statusbar = Box.createHorizontalBox();
        statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.statusMessage = new JTextField(20);
        this.statusMessage.setEditable(false);
        this.statusMessage.setFocusable(false);
        this.statusMessage.setText("Loading " + this.resource.getId() + " ...");
        statusbar.add(this.statusMessage);
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(200, 30));
        this.progress.setVisible(false);
        statusbar.add(this.progress);
        this.getContentPane().add((Component)statusbar, "South");
    }

    private void save() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DocumentView.this.statusMessage.setText("Storing " + DocumentView.this.resource.getId());
                    if (DocumentView.this.collection instanceof Observable) {
                        ((Observable)DocumentView.this.collection).addObserver(new ProgressObserver());
                    }
                    DocumentView.this.progress.setIndeterminate(true);
                    DocumentView.this.progress.setVisible(true);
                    DocumentView.this.resource.setContent((Object)DocumentView.this.text.getText());
                    DocumentView.this.collection.storeResource(DocumentView.this.resource);
                    if (DocumentView.this.collection instanceof Observable) {
                        ((Observable)DocumentView.this.collection).deleteObservers();
                    }
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage("XMLDBException: " + e.getMessage(), e);
                }
                finally {
                    DocumentView.this.progress.setVisible(false);
                }
            }
        }.start();
    }

    private void export() {
        String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
        JFileChooser chooser = new JFileChooser(workDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        if (chooser.showDialog(this, "Select file for export") == 0) {
            File file = chooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Overwrite?", 0) == 1) {
                return;
            }
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName(this.properties.getProperty("encoding")));
                writer.write(this.text.getText());
                writer.close();
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage("XMLDBException: " + e.getMessage(), e);
            }
            File selectedDir = chooser.getCurrentDirectory();
            this.properties.setProperty("working-dir", selectedDir.getAbsolutePath());
        }
    }

    public void setText(String content) throws XMLDBException {
        this.text.setText("");
        this.text.setText(content);
        this.text.setCaretPosition(0);
        this.text.scrollToCaret();
        this.statusMessage.setText("Loaded " + this.resource.getId());
    }

    class ProgressObserver
    implements Observer {
        int mode = 0;

        ProgressObserver() {
        }

        public void update(Observable o, Object arg) {
            DocumentView.this.progress.setIndeterminate(false);
            ProgressIndicator ind = (ProgressIndicator)arg;
            DocumentView.this.progress.setValue(ind.getPercentage());
            if (o instanceof TextSearchEngine) {
                DocumentView.this.progress.setString("Storing words");
            } else if (o instanceof ElementIndex) {
                DocumentView.this.progress.setString("Storing elements");
            }
        }
    }
}

