/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jedit.syntax.DefaultInputHandler;
import org.jedit.syntax.InputHandler;
import org.jedit.syntax.JEditTextArea;
import org.jedit.syntax.SyntaxDocument;
import org.jedit.syntax.SyntaxStyle;
import org.jedit.syntax.TextAreaPainter;
import org.jedit.syntax.TokenMarker;
import org.jedit.syntax.XMLTokenMarker;

public class ClientTextArea
extends JEditTextArea
implements ActionListener {
    public static final String CUT = "Cut";
    public static final String COPY = "Copy";
    public static final String PASTE = "Paste";
    private CopyAction copy = new CopyAction();
    private CutAction cut = new CutAction();
    private PasteAction paste = new PasteAction();
    protected Font textFont = new Font("Monospaced", 0, 10);

    public ClientTextArea(boolean editable, String mode) {
        this.setFont(this.textFont);
        this.setEditable(editable);
        this.setPreferredSize(new Dimension(300, 200));
        SyntaxDocument doc = new SyntaxDocument();
        doc.putProperty((Object)"tabSize", (Object)new Integer(4));
        this.setDocument(doc);
        this.setElectricScroll(2);
        this.popup = new JPopupMenu("Edit Menu");
        this.popup.add(new JMenuItem(CUT)).addActionListener(this.cut);
        this.popup.add(new JMenuItem(COPY)).addActionListener(this.copy);
        this.popup.add(new JMenuItem(PASTE)).addActionListener(this.paste);
        if (mode.equals("XML")) {
            this.setTokenMarker((TokenMarker)new XMLTokenMarker());
        }
        TextAreaPainter painter = this.getPainter();
        SyntaxStyle[] styles = painter.getStyles();
        styles[6] = new SyntaxStyle(new Color(0, 102, 153), false, true);
        styles[7] = new SyntaxStyle(new Color(0, 153, 102), false, true);
        styles[8] = new SyntaxStyle(new Color(0, 153, 255), false, true);
        styles[3] = new SyntaxStyle(new Color(255, 0, 204), false, false);
        styles[4] = new SyntaxStyle(new Color(204, 0, 204), false, false);
        painter.setStyles(styles);
        painter.setEOLMarkersPainted(true);
        painter.setBracketHighlightEnabled(true);
        DefaultInputHandler inputHandler = new DefaultInputHandler();
        inputHandler.addDefaultKeyBindings();
        inputHandler.addKeyBinding("C+c", (ActionListener)this.copy);
        inputHandler.addKeyBinding("C+v", (ActionListener)this.paste);
        inputHandler.addKeyBinding("C+x", (ActionListener)this.cut);
        this.setInputHandler((InputHandler)inputHandler);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(CUT)) {
            this.cut();
        } else if (cmd.equals(COPY)) {
            this.copy();
        } else if (cmd.equals(PASTE)) {
            this.paste();
        } else {
            System.out.println("event: " + cmd);
        }
    }

    private class CutAction
    implements ActionListener {
        private CutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ClientTextArea.this.cut();
        }
    }

    private class PasteAction
    implements ActionListener {
        private PasteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ClientTextArea.this.paste();
        }
    }

    private class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ClientTextArea.this.copy();
        }
    }
}

