/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.exist.backup.Backup;
import org.exist.backup.CreateBackupDialog;
import org.exist.backup.Restore;
import org.exist.client.DocumentView;
import org.exist.client.InteractiveClient;
import org.exist.client.QueryDialog;
import org.exist.client.ResourcePropertyDialog;
import org.exist.client.UploadDialog;
import org.exist.client.UserDialog;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.UserManagementService;
import org.gnu.readline.Readline;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

public class ClientFrame
extends JFrame
implements WindowFocusListener,
KeyListener,
ActionListener,
MouseListener {
    public static final String CUT = "Cut";
    public static final String COPY = "Copy";
    public static final String PASTE = "Paste";
    public static final int MAX_DISPLAY_LENGTH = 512000;
    public static final int MAX_HISTORY = 50;
    private static final SimpleAttributeSet promptAttrs = new SimpleAttributeSet();
    private static final SimpleAttributeSet defaultAttrs = new SimpleAttributeSet();
    private int commandStart;
    private int currentHistory;
    private boolean gotUp;
    private DefaultStyledDocument doc;
    private JLabel statusbar;
    private JTable fileman;
    private ResourceTableModel resources;
    private JTextPane shell;
    private JPopupMenu shellPopup;
    private InteractiveClient client;
    private String path;
    private ProcessThread process;
    private Properties properties;

    public ClientFrame(InteractiveClient client, String path, Properties properties) throws HeadlessException {
        super("eXist Admin Client");
        StyleConstants.setForeground(promptAttrs, Color.blue);
        StyleConstants.setBold(promptAttrs, true);
        StyleConstants.setForeground(defaultAttrs, Color.black);
        this.commandStart = 0;
        this.currentHistory = 0;
        this.gotUp = false;
        this.resources = new ResourceTableModel();
        this.path = null;
        this.process = new ProcessThread();
        this.path = path;
        this.properties = properties;
        this.client = client;
        this.setupComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                ClientFrame.this.close();
            }
        });
        this.pack();
        this.currentHistory = Readline.getHistorySize();
        this.process.start();
        this.shell.requestFocus();
    }

    private void setupComponents() {
        this.setJMenuBar(this.createMenuBar());
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Up24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText("Go to parent collection");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.goUpAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Refresh24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Refresh collection view");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException xMLDBException) {
                    // empty catch block
                }
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/New24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Create new collection");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newCollectionAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Add24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Stores one or more files to the database");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.uploadAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Delete24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Delete selected files or collections");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.removeAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Preferences24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Edit owners/permissions for selected resource");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.setPermAction(e);
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Export24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Create backup");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.backupAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Import24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Restore files from backup");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.restoreAction(e);
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/keyring-small.png");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Manage users");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newUserAction(e);
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Find24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Query the database with XPath");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.findAction(e);
            }
        });
        toolbar.add(button);
        JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(0.5);
        this.fileman = new JTable();
        this.fileman.setModel(this.resources);
        this.fileman.addMouseListener(new TableMouseListener());
        ResourceTableCellRenderer renderer = new ResourceTableCellRenderer();
        this.fileman.setDefaultRenderer(Object.class, renderer);
        JScrollPane scroll = new JScrollPane(this.fileman);
        scroll.setMinimumSize(new Dimension(300, 150));
        split.setLeftComponent(scroll);
        this.shellPopup = new JPopupMenu("Console Menu");
        this.shellPopup.add(new JMenuItem(CUT)).addActionListener(this);
        this.shellPopup.add(new JMenuItem(COPY)).addActionListener(this);
        this.shellPopup.add(new JMenuItem(PASTE)).addActionListener(this);
        this.doc = new DefaultStyledDocument();
        this.shell = new JTextPane(this.doc);
        this.shell.setContentType("text/plain; charset=UTF-8");
        this.shell.setFont(new Font("Monospaced", 0, 12));
        this.shell.setMargin(new Insets(7, 5, 7, 5));
        this.shell.addKeyListener(this);
        this.shell.addMouseListener(this);
        scroll = new JScrollPane(this.shell);
        split.setRightComponent(scroll);
        this.statusbar = new JLabel();
        this.statusbar.setMinimumSize(new Dimension(400, 15));
        this.statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)split, "Center");
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.statusbar, "South");
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menubar.add(fileMenu);
        JMenuItem item = new JMenuItem("Store files/directories", 83);
        item.setAccelerator(KeyStroke.getKeyStroke("control S"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.uploadAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Create collection", 78);
        item.setAccelerator(KeyStroke.getKeyStroke("control N"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newCollectionAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Create blank document", 66);
        item.setAccelerator(KeyStroke.getKeyStroke("control B"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Collection collection = ((ClientFrame)ClientFrame.this).client.current;
                XMLResource result = null;
                String nameres = JOptionPane.showInputDialog(null, (Object)"Name of the XML resource (extension incluse)");
                if (nameres != null) {
                    try {
                        result = (XMLResource)collection.createResource(nameres, "XMLResource");
                        result.setContent((Object)"<template></template>");
                        collection.storeResource((Resource)result);
                        collection.close();
                        ClientFrame.this.client.reloadCollection();
                    }
                    catch (XMLDBException ev) {
                        ClientFrame.showErrorMessage(ev.getMessage(), ev);
                    }
                }
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem("Remove");
        item.setAccelerator(KeyStroke.getKeyStroke("control D"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.removeAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem(COPY, 67);
        item.setAccelerator(KeyStroke.getKeyStroke("control C"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.copyAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Move", 77);
        item.setAccelerator(KeyStroke.getKeyStroke("control M"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.moveAction(e);
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem("Reindex collection", 82);
        item.setAccelerator(KeyStroke.getKeyStroke("control R"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.reindexAction(e);
            }
        });
        fileMenu.add(item);
        item = new JMenuItem("Resource properties");
        item.setAccelerator(KeyStroke.getKeyStroke("control P"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.setPermAction(e);
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem("Quit", 81);
        item.setAccelerator(KeyStroke.getKeyStroke("control Q"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.close();
            }
        });
        fileMenu.add(item);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        menubar.add(toolsMenu);
        item = new JMenuItem("Find", 70);
        item.setAccelerator(KeyStroke.getKeyStroke("control F"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.findAction(e);
            }
        });
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem("Edit users", 70);
        item.setAccelerator(KeyStroke.getKeyStroke("control U"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newUserAction(e);
            }
        });
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem("Backup", 66);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.backupAction(e);
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem("Restore", 82);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.restoreAction(e);
            }
        });
        toolsMenu.add(item);
        JMenu dbMenu = new JMenu("Database");
        dbMenu.setMnemonic(68);
        menubar.add(dbMenu);
        item = new JMenuItem("Shutdown", 83);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.display("shutdown\n");
                ClientFrame.this.process.setAction("shutdown");
            }
        });
        dbMenu.add(item);
        dbMenu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        item = new JRadioButtonMenuItem(this.properties.getProperty("uri"), true);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newServerURIAction(ClientFrame.this.properties.getProperty("uri"));
            }
        });
        dbMenu.add(item);
        group.add(item);
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String uri;
            String next = (String)e.nextElement();
            if (!next.startsWith("alternate_uri_") || (uri = this.properties.getProperty(next)).equals(this.properties.getProperty("uri"))) continue;
            item = new JRadioButtonMenuItem(uri, false);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClientFrame.this.newServerURIAction(uri);
                }
            });
            dbMenu.add(item);
            group.add(item);
        }
        dbMenu.addSeparator();
        item = new JMenuItem("Connect to alternate URI", 67);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.newServerURIAction(null);
            }
        });
        dbMenu.add(item);
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        menubar.add(optionsMenu);
        JCheckBoxMenuItem check = new JCheckBoxMenuItem("Indent", this.properties.getProperty("indent").equals("yes"));
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.properties.setProperty("indent", ((JCheckBoxMenuItem)e.getSource()).isSelected() ? "yes" : "no");
                try {
                    ClientFrame.this.client.getResources();
                }
                catch (XMLDBException xMLDBException) {
                    // empty catch block
                }
            }
        });
        optionsMenu.add(check);
        check = new JCheckBoxMenuItem("Expand-XIncludes", this.properties.getProperty("expand-xincludes").equals("yes"));
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.properties.setProperty("expand-xincludes", ((JCheckBoxMenuItem)e.getSource()).isSelected() ? "yes" : "no");
                try {
                    ClientFrame.this.client.getResources();
                }
                catch (XMLDBException xMLDBException) {
                    // empty catch block
                }
            }
        });
        optionsMenu.add(check);
        optionsMenu.addSeparator();
        item = new JMenuItem("Change User-Identity", 85);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] loginData = ClientFrame.getLoginData(ClientFrame.this.properties.getProperty("user"), ClientFrame.this.properties.getProperty("uri"));
                if (loginData == null) {
                    return;
                }
                ClientFrame.this.properties.setProperty("user", loginData[0]);
                ClientFrame.this.properties.setProperty("password", loginData[1]);
                ClientFrame.this.properties.setProperty("uri", loginData[2]);
                try {
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException e1) {
                    ClientFrame.showErrorMessage("Login failed!", e1);
                }
            }
        });
        optionsMenu.add(item);
        JMenu HelpMenu = new JMenu("Help");
        HelpMenu.setMnemonic(72);
        menubar.add(HelpMenu);
        item = new JMenuItem("About", 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.AboutAction();
            }
        });
        HelpMenu.add(item);
        return menubar;
    }

    public void setPath(String currentPath) {
        this.path = currentPath;
    }

    protected void displayPrompt() {
        try {
            this.commandStart = this.doc.getLength();
            this.doc.insertString(this.commandStart, "exist:", promptAttrs);
            this.commandStart += 6;
            this.doc.insertString(this.commandStart, this.path + '>', promptAttrs);
            this.commandStart += this.path.length() + 1;
            this.doc.insertString(this.commandStart++, " ", defaultAttrs);
            this.shell.setCaretPosition(this.commandStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void display(String message) {
        try {
            this.commandStart = this.doc.getLength();
            if (this.commandStart > 512000) {
                this.doc.remove(0, 512000);
                this.commandStart = this.doc.getLength();
            }
            this.doc.insertString(this.commandStart, message, defaultAttrs);
            this.commandStart = this.doc.getLength();
            this.shell.setCaretPosition(this.commandStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void setResources(Object[][] rows) {
        this.resources.setData(rows);
    }

    protected void setStatus(String message) {
        this.statusbar.setText(message);
    }

    protected void setEditable(boolean enabled) {
        this.shell.setEditable(enabled);
        this.shell.setVisible(enabled);
    }

    public void keyPressed(KeyEvent e) {
        this.type(e);
        this.gotUp = false;
    }

    public void keyReleased(KeyEvent e) {
        this.gotUp = true;
        this.type(e);
    }

    public void keyTyped(KeyEvent e) {
        this.type(e);
    }

    private synchronized void type(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                if (e.getID() == 401 && this.gotUp) {
                    this.enter();
                }
                e.consume();
                break;
            }
            case 36: {
                this.shell.setCaretPosition(this.commandStart);
                e.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.shell.getCaretPosition() > this.commandStart) break;
                e.consume();
                break;
            }
            case 38: {
                if (e.getID() == 401) {
                    this.historyBack();
                }
                e.consume();
                break;
            }
            case 40: {
                if (e.getID() == 401) {
                    this.historyForward();
                }
                e.consume();
                break;
            }
            default: {
                if ((e.getModifiers() & 0xE) == 0 && this.shell.getCaretPosition() < this.commandStart) {
                    this.shell.setCaretPosition(this.doc.getLength());
                }
                if (e.paramString().indexOf("Backspace") <= -1 || this.shell.getCaretPosition() > this.commandStart) break;
                e.consume();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(CUT)) {
            this.shell.cut();
        } else if (cmd.equals(COPY)) {
            this.shell.copy();
        } else if (cmd.equals(PASTE)) {
            this.shell.paste();
        }
    }

    private void goUpAction(ActionEvent ev) {
        this.display("cd ..\n");
        this.process.setAction("cd ..");
    }

    private void newCollectionAction(ActionEvent ev) {
        String newCol = JOptionPane.showInputDialog(this, (Object)"Please enter name of new collection");
        if (newCol != null) {
            String command = "mkcol \"" + newCol + '\"';
            this.display(command + "\n");
            this.process.setAction(command);
        }
    }

    private void newServerURIAction(String newURI) {
        if (newURI == null) {
            newURI = JOptionPane.showInputDialog(this, (Object)"Please enter a valid XML:DB base URI (without collection path)");
        }
        if (newURI != null) {
            this.properties.setProperty("uri", newURI);
            try {
                this.client.shutdown(false);
                this.client.connect();
            }
            catch (Exception e) {
                ClientFrame.showErrorMessage("Connection to " + newURI + " failed!", e);
            }
        }
    }

    private void removeAction(ActionEvent ev) {
        final int[] rows = this.fileman.getSelectedRows();
        final Object[] res = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            res[i] = this.resources.getValueAt(rows[i], 3);
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the selected resources?", "Confirm deletion", 0) == 0) {
            Runnable removeTask = new Runnable(){

                public void run() {
                    ProgressMonitor monitor = new ProgressMonitor(ClientFrame.this, "Remove Progress", "", 1, rows.length);
                    monitor.setMillisToDecideToPopup(500);
                    monitor.setMillisToPopup(500);
                    for (int i = 0; i < rows.length; ++i) {
                        Object resource = res[i];
                        if (resource instanceof InteractiveClient.CollectionName) {
                            try {
                                CollectionManagementService mgtService = (CollectionManagementService)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                                mgtService.removeCollection(resource.toString());
                            }
                            catch (XMLDBException e) {
                                ClientFrame.showErrorMessage(e.getMessage(), e);
                            }
                        } else {
                            try {
                                Resource res2 = ((ClientFrame)ClientFrame.this).client.current.getResource(resource.toString());
                                ((ClientFrame)ClientFrame.this).client.current.removeResource(res2);
                            }
                            catch (XMLDBException e) {
                                ClientFrame.showErrorMessage(e.getMessage(), e);
                            }
                        }
                        monitor.setProgress(i + 1);
                        if (!monitor.isCanceled()) continue;
                        return;
                    }
                    try {
                        ClientFrame.this.client.getResources();
                    }
                    catch (XMLDBException e) {
                        ClientFrame.showErrorMessage(e.getMessage(), e);
                    }
                }
            };
            new Thread(removeTask).start();
        }
    }

    private void moveAction(ActionEvent ev) {
        int[] rows = this.fileman.getSelectedRows();
        final Object[] res = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            res[i] = this.resources.getValueAt(rows[i], 3);
        }
        Object[] collections = null;
        try {
            Collection root = this.client.getCollection("/db");
            Vector collectionsVec = this.getCollections(root, new Vector());
            collections = new String[collectionsVec.size()];
            collectionsVec.toArray(collections);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(e.getMessage(), e);
            return;
        }
        Object val = JOptionPane.showInputDialog(this, "Select target collection", "Move", 3, null, collections, collections[0]);
        if (val == null) {
            return;
        }
        final String destinationPath = (String)val;
        Runnable moveTask = new Runnable(){

            public void run() {
                try {
                    CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                    for (int i = 0; i < res.length; ++i) {
                        ClientFrame.this.setStatus("Moving " + res[i].toString() + " to " + destinationPath + "...");
                        if (res[i] instanceof InteractiveClient.CollectionName) {
                            service.move(res[i].toString(), destinationPath, null);
                            continue;
                        }
                        service.moveResource(res[i].toString(), destinationPath, null);
                    }
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                ClientFrame.this.setStatus("Move completed.");
            }
        };
        new Thread(moveTask).start();
    }

    private void copyAction(ActionEvent ev) {
        int[] rows = this.fileman.getSelectedRows();
        final Object[] res = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            res[i] = this.resources.getValueAt(rows[i], 3);
        }
        Object[] collections = null;
        try {
            Collection root = this.client.getCollection("/db");
            Vector collectionsVec = this.getCollections(root, new Vector());
            collections = new String[collectionsVec.size()];
            collectionsVec.toArray(collections);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(e.getMessage(), e);
            return;
        }
        Object val = JOptionPane.showInputDialog(this, "Select target collection", "Move", 3, null, collections, collections[0]);
        if (val == null) {
            return;
        }
        final String destinationPath = (String)val;
        Runnable moveTask = new Runnable(){

            public void run() {
                try {
                    CollectionManagementServiceImpl service = (CollectionManagementServiceImpl)((ClientFrame)ClientFrame.this).client.current.getService("CollectionManagementService", "1.0");
                    for (int i = 0; i < res.length; ++i) {
                        ClientFrame.this.setStatus("Copying " + res[i].toString() + " to " + destinationPath + "...");
                        if (res[i] instanceof InteractiveClient.CollectionName) {
                            service.copy(res[i].toString(), destinationPath, null);
                            continue;
                        }
                        service.copyResource(res[i].toString(), destinationPath, null);
                    }
                    ClientFrame.this.client.reloadCollection();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                ClientFrame.this.setStatus("Move completed.");
            }
        };
        new Thread(moveTask).start();
    }

    private Vector getCollections(Collection root, Vector collectionsList) throws XMLDBException {
        collectionsList.addElement(root.getName());
        String[] childCollections = root.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child = root.getChildCollection(childCollections[i]);
            this.getCollections(child, collectionsList);
        }
        return collectionsList;
    }

    private void reindexAction(ActionEvent ev) {
        Object[] res;
        int[] rows = this.fileman.getSelectedRows();
        if (rows.length == 0) {
            res = new Object[]{new InteractiveClient.CollectionName(this.client.path)};
        } else {
            res = new Object[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                res[i] = this.resources.getValueAt(rows[i], 3);
                if (res[i] instanceof InteractiveClient.CollectionName) continue;
                JOptionPane.showMessageDialog(this, "Only collections can be reindexed.", "Error", 0);
                return;
            }
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to reindex the selected collections \nand all resources below them?", "Confirm reindex", 0) == 0) {
            final Object[] collections = res;
            Runnable reindexThread = new Runnable(){

                public void run() {
                    ClientFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        IndexQueryService service = (IndexQueryService)((ClientFrame)ClientFrame.this).client.current.getService("IndexQueryService", "1.0");
                        for (int i = 0; i < collections.length; ++i) {
                            InteractiveClient.CollectionName next = (InteractiveClient.CollectionName)collections[i];
                            ClientFrame.this.setStatus("Reindexing collection " + next + "...");
                            service.reindexCollection(next.toString());
                        }
                        ClientFrame.this.setStatus("Reindex completed.");
                    }
                    catch (XMLDBException e) {
                        ClientFrame.showErrorMessage(e.getMessage(), e);
                    }
                    ClientFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            };
            new Thread(reindexThread).start();
        }
    }

    private void uploadAction(ActionEvent ev) {
        String dir = this.properties.getProperty("working-dir", System.getProperty("exist.home"));
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new BinaryFileFilter());
        chooser.addChoosableFileFilter(new XMLFileFilter());
        if (chooser.showDialog(this, "Select files or directories to store") == 0) {
            final File[] files = chooser.getSelectedFiles();
            if (files.length > 0) {
                new Thread(){

                    public void run() {
                        UploadDialog upload = new UploadDialog();
                        try {
                            ClientFrame.this.client.parse(files, upload);
                            ClientFrame.this.client.getResources();
                        }
                        catch (XMLDBException e) {
                            ClientFrame.showErrorMessage("XMLDBException: " + e.getMessage(), e);
                        }
                        upload.setVisible(false);
                    }
                }.start();
            }
            File selectedDir = chooser.getCurrentDirectory();
            this.properties.setProperty("working-dir", selectedDir.getAbsolutePath());
        }
    }

    private void backupAction(ActionEvent ev) {
        CreateBackupDialog dialog = new CreateBackupDialog(this.properties.getProperty("uri", "xmldb:exist://"), this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), this.properties.getProperty("backup-dir", System.getProperty("user.home") + File.separatorChar + "backup"));
        if (JOptionPane.showOptionDialog(this, dialog, "Create Backup", 2, 3, null, null, null) == 0) {
            String collection = dialog.getCollection();
            String dir = dialog.getBackupDir();
            Backup backup = new Backup(this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), dir, this.properties.getProperty("uri", "xmldb:exist://") + '/' + collection);
            try {
                backup.backup(true, this);
            }
            catch (XMLDBException e) {
                ClientFrame.showErrorMessage("XMLDBException: " + e.getMessage(), e);
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage("IOException: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                ClientFrame.showErrorMessage("SAXException: " + e.getMessage(), e);
            }
        }
    }

    private void restoreAction(ActionEvent ev) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().equals("__contents__.xml");
            }

            public String getDescription() {
                return "__contents__.xml files";
            }
        });
        if (chooser.showDialog(null, "Select backup file for restore") == 0) {
            File f = chooser.getSelectedFile();
            String restoreFile = f.getAbsolutePath();
            try {
                Restore restore = new Restore(this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), new File(restoreFile), this.properties.getProperty("uri", "xmldb:exist://"));
                restore.restore(true, this);
                this.client.reloadCollection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void newUserAction(ActionEvent ev) {
        try {
            Collection collection = this.client.getCollection();
            UserManagementService service = (UserManagementService)collection.getService("UserManagementService", "1.0");
            UserDialog dialog = new UserDialog(service, "Edit Users", this.client);
            dialog.setVisible(true);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage("Failed to retrieve UserManagementService", e);
            e.printStackTrace();
        }
    }

    private void findAction(ActionEvent ev) {
        Collection collection = this.client.getCollection();
        QueryDialog dialog = new QueryDialog(this.client, collection, this.properties);
        dialog.setVisible(true);
    }

    private void setPermAction(ActionEvent ev) {
        if (this.fileman.getSelectedRowCount() == 0) {
            return;
        }
        try {
            String name;
            Collection collection = this.client.getCollection();
            UserManagementService service = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Permission perm = null;
            Date created = new Date();
            Date modified = null;
            if (this.fileman.getSelectedRowCount() == 1) {
                int row = this.fileman.getSelectedRow();
                Object obj = this.resources.getValueAt(row, 3);
                if (obj instanceof InteractiveClient.CollectionName) {
                    name = obj.toString();
                    Collection coll = collection.getChildCollection(name);
                    created = ((CollectionImpl)coll).getCreationTime();
                    perm = service.getPermissions(coll);
                } else {
                    name = (String)obj;
                    Resource res = collection.getResource(name);
                    created = ((EXistResource)res).getCreationTime();
                    modified = ((EXistResource)res).getLastModificationTime();
                    perm = service.getPermissions(res);
                }
            } else {
                name = "...";
                perm = new Permission("", "");
            }
            ResourcePropertyDialog dialog = new ResourcePropertyDialog(this, service, name, perm, created, modified);
            dialog.setVisible(true);
            if (dialog.getResult() == 0) {
                int[] rows = this.fileman.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    Object obj = this.resources.getValueAt(rows[i], 3);
                    if (obj instanceof InteractiveClient.CollectionName) {
                        Collection coll = collection.getChildCollection(obj.toString());
                        service.setPermissions(coll, dialog.permissions);
                        continue;
                    }
                    Resource res = collection.getResource((String)obj);
                    service.setPermissions(res, dialog.permissions);
                }
                this.client.reloadCollection();
            }
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage("XMLDB Exception: " + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void enter() {
        int end = this.doc.getLength();
        if (end - this.commandStart == 0) {
            return;
        }
        try {
            String command = this.doc.getText(this.commandStart, end - this.commandStart);
            this.commandStart = end;
            this.doc.insertString(this.commandStart++, "\n", defaultAttrs);
            if (command != null) {
                this.process.setAction(command);
                Readline.addToHistory((String)command);
                this.currentHistory = Readline.getHistorySize();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void historyBack() {
        String item;
        if (this.currentHistory == 0) {
            return;
        }
        if ((item = Readline.getHistoryLine((int)(--this.currentHistory))) == null) {
            return;
        }
        try {
            if (this.shell.getCaretPosition() > this.commandStart) {
                this.doc.remove(this.commandStart, this.doc.getLength() - this.commandStart);
            }
            this.doc.insertString(this.commandStart, item, defaultAttrs);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void historyForward() {
        if (this.currentHistory + 1 == Readline.getHistorySize()) {
            return;
        }
        String item = Readline.getHistoryLine((int)(++this.currentHistory));
        try {
            if (this.shell.getCaretPosition() > this.commandStart) {
                this.doc.remove(this.commandStart, this.doc.getLength() - this.commandStart);
            }
            this.doc.insertString(this.commandStart, item, defaultAttrs);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.process.terminate();
        System.exit(0);
    }

    private void actionFinished() {
        if (!this.process.getStatus()) {
            this.close();
        }
        this.displayPrompt();
    }

    private void AboutAction() {
        JOptionPane.showMessageDialog(this, "eXist version 1.0, Copyright (C) 2004 Wolfgang Meier\neXist comes with ABSOLUTELY NO WARRANTY.\nThis is free software, and you are welcome to\nredistribute it under certain conditions;\nfor details read the license file.");
    }

    protected static String[] getLoginData(String defaultUser, String uri) {
        LoginPanel login = new LoginPanel(defaultUser, uri);
        if (JOptionPane.showOptionDialog(null, login, "eXist Database Login", 2, 3, null, null, null) == 0) {
            String[] ret = new String[]{login.getUsername(), login.getPassword(), login.getUri()};
            return ret;
        }
        return null;
    }

    public static void showErrorMessage(String message, Throwable t) {
        JScrollPane scroll = null;
        JTextArea msgArea = new JTextArea(message);
        msgArea.setBorder(BorderFactory.createTitledBorder("Message:"));
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        if (t != null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            t.printStackTrace(writer);
            JTextArea stacktrace = new JTextArea(out.toString(), 20, 50);
            stacktrace.setBackground(null);
            stacktrace.setEditable(false);
            scroll = new JScrollPane(stacktrace);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setBorder(BorderFactory.createTitledBorder("Exception Stacktrace:"));
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{msgArea, scroll});
        optionPane.setMessageType(0);
        JDialog dialog = optionPane.createDialog(null, "Error");
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void windowGainedFocus(WindowEvent e) {
        this.toFront();
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.shellPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.shellPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        public String getDescription() {
            return "XML files";
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int p = name.lastIndexOf(46);
            if (p < 0 || p + 1 == name.length()) {
                return false;
            }
            return Arrays.binarySearch(((ClientFrame)ClientFrame.this).client.xmlSuffixes, name = name.substring(p + 1)) > -1;
        }
    }

    class BinaryFileFilter
    extends FileFilter {
        BinaryFileFilter() {
        }

        public String getDescription() {
            return "Binary resources";
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int p = name.lastIndexOf(46);
            if (p < 0 || p + 1 == name.length()) {
                return false;
            }
            return Arrays.binarySearch(((ClientFrame)ClientFrame.this).client.binarySuffixes, name = name.substring(p + 1)) > -1;
        }
    }

    static class ResourceTableCellRenderer
    implements TableCellRenderer {
        public static final Color collectionBackground = new Color(225, 235, 224);
        public static final Color collectionForeground = Color.black;
        public static final Color highBackground = new Color(115, 130, 189);
        public static final Color highForeground = Color.white;
        public static final Color altBackground = new Color(235, 235, 235);
        public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

        ResourceTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background;
            Color foreground;
            Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)renderer).setOpaque(true);
            if (isSelected) {
                foreground = highForeground;
                background = highBackground;
            } else if (table.getValueAt(row, 3) instanceof InteractiveClient.CollectionName) {
                foreground = collectionForeground;
                background = collectionBackground;
            } else if (row % 2 == 0) {
                background = altBackground;
                foreground = Color.black;
            } else {
                foreground = Color.black;
                background = Color.white;
            }
            renderer.setForeground(foreground);
            renderer.setBackground(background);
            return renderer;
        }
    }

    static class LoginPanel
    extends JPanel {
        JTextField username;
        JPasswordField password;
        JTextField cur_url;

        public LoginPanel(String defaultUser, String uri) {
            super(false);
            this.setupComponents(defaultUser, uri);
        }

        private void setupComponents(String defaultUser, String uri) {
            GridBagLayout grid = new GridBagLayout();
            this.setLayout(grid);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 5, 5, 5);
            JLabel label = new JLabel("Username");
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 0;
            grid.setConstraints(label, c);
            this.add(label);
            this.username = new JTextField(defaultUser, 12);
            c.gridx = 1;
            c.gridy = 0;
            c.anchor = 13;
            c.fill = 2;
            grid.setConstraints(this.username, c);
            this.add(this.username);
            label = new JLabel("Password");
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            grid.setConstraints(label, c);
            this.add(label);
            this.password = new JPasswordField(12);
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 13;
            c.fill = 2;
            grid.setConstraints(this.password, c);
            this.add(this.password);
            label = new JLabel("URL");
            c.gridx = 0;
            c.gridy = 2;
            c.anchor = 17;
            c.fill = 0;
            grid.setConstraints(label, c);
            this.add(label);
            this.cur_url = new JTextField(uri, 20);
            c.gridx = 1;
            c.gridy = 2;
            c.anchor = 13;
            c.fill = 2;
            grid.setConstraints(this.cur_url, c);
            this.add(this.cur_url);
        }

        public String getUsername() {
            return this.username.getText();
        }

        public String getPassword() {
            return new String(this.password.getPassword());
        }

        public String getUri() {
            return this.cur_url.getText();
        }
    }

    class ResourceTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Permissions", "Owner", "Group", "Resource"};
        private Object[][] rows = null;

        ResourceTableModel() {
        }

        public void setData(Object[][] rows) {
            this.rows = rows;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return this.rows == null ? 0 : this.rows.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows[rowIndex][columnIndex];
        }
    }

    class ProcessThread
    extends Thread {
        private String action = null;
        private boolean terminate = false;
        private boolean status = false;

        public synchronized void setAction(String action) {
            while (this.action != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.action = action;
            this.notify();
        }

        public synchronized void terminate() {
            this.terminate = true;
            this.notify();
        }

        public synchronized boolean getStatus() {
            return this.status;
        }

        public boolean isReady() {
            return this.action == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.terminate) {
                ProcessThread processThread;
                while (this.action == null) {
                    try {
                        processThread = this;
                        synchronized (processThread) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.status = ClientFrame.this.client.process(this.action);
                processThread = this;
                synchronized (processThread) {
                    this.action = null;
                    ClientFrame.this.actionFinished();
                    this.notify();
                }
            }
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = ClientFrame.this.fileman.getSelectedRow();
                Object resource = ClientFrame.this.resources.getValueAt(row, 3);
                if (resource instanceof InteractiveClient.CollectionName) {
                    String command = "cd \"" + resource + '\"';
                    ClientFrame.this.display(command + "\n");
                    ClientFrame.this.process.setAction(command);
                } else {
                    ClientFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Resource res = ClientFrame.this.client.retrieve(resource.toString(), ClientFrame.this.properties.getProperty("indent", "yes"));
                        DocumentView view = new DocumentView(ClientFrame.this.client.getCollection(), res, ClientFrame.this.properties);
                        view.setSize(new Dimension(640, 400));
                        if (res.getResourceType().equals("XMLResource")) {
                            view.setText((String)res.getContent());
                        } else {
                            view.setText(new String((byte[])res.getContent()));
                        }
                        UserManagementService service = (UserManagementService)((ClientFrame)ClientFrame.this).client.current.getService("UserManagementService", "1.0");
                        User user = service.getUser(ClientFrame.this.properties.getProperty("user"));
                        String lockOwner = service.hasUserLock(res);
                        if (lockOwner != null && JOptionPane.showConfirmDialog(ClientFrame.this, "Resource is already locked by user " + lockOwner + ". Should I try to relock it?", "Resource locked", 0) != 0) {
                            view.dispose();
                            ClientFrame.this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        try {
                            service.lockResource(res, user);
                        }
                        catch (XMLDBException ex) {
                            System.out.println(ex.getMessage());
                            JOptionPane.showMessageDialog(ClientFrame.this, "Resource cannot be locked. Opening read-only.");
                            view.setReadOnly();
                        }
                        view.setVisible(true);
                    }
                    catch (IllegalArgumentException ex) {
                        ClientFrame.showErrorMessage("Illegal argument: " + ex.getMessage(), ex);
                    }
                    catch (XMLDBException ex) {
                        ClientFrame.showErrorMessage("XMLDB error: " + ex.getMessage(), ex);
                    }
                    ClientFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

