/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Observable;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.backup.RestoreDialog;
import org.exist.security.User;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.UserManagementService;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class Restore
extends DefaultHandler {
    private File contents;
    private String uri;
    private String username;
    private String pass;
    private XMLReader reader;
    private CollectionImpl current;
    private Stack stack = new Stack();
    private RestoreDialog dialog = null;
    public static final String NS = "http://exist.sourceforge.net/NS/exist";

    public Restore(String user, String pass, File contents, String uri) throws ParserConfigurationException, SAXException {
        File sys;
        this.username = user;
        this.pass = pass;
        this.uri = uri;
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        SAXParser sax = saxFactory.newSAXParser();
        this.reader = sax.getXMLReader();
        this.reader.setContentHandler(this);
        this.stack.push(contents);
        File dir = contents.getParentFile();
        if (dir.isDirectory() && dir.getName().equals("db") && (sys = new File(dir.getAbsolutePath() + File.separatorChar + "system" + File.separatorChar + "__contents__.xml")).canRead()) {
            System.out.println("found /db/system. It will be processed first.");
            this.stack.push(sys);
        }
    }

    public Restore(String user, String pass, File contents) throws ParserConfigurationException, SAXException {
        this(user, pass, contents, "xmldb:exist://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(boolean showGUI, JFrame parent) throws XMLDBException, FileNotFoundException, IOException, SAXException {
        block8: {
            block7: {
                if (!showGUI) break block7;
                this.dialog = new RestoreDialog(parent, "Restoring data ...", false);
                this.dialog.setVisible(true);
                Thread restoreThread = new Thread(){

                    public void run() {
                        while (!Restore.this.stack.isEmpty()) {
                            try {
                                Restore.this.contents = (File)Restore.this.stack.pop();
                                Restore.this.reader.parse(new InputSource(new FileInputStream(Restore.this.contents)));
                            }
                            catch (FileNotFoundException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                            catch (IOException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                            catch (SAXException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                        }
                        Restore.this.dialog.setVisible(false);
                    }
                };
                restoreThread.start();
                if (parent != null) break block8;
                while (restoreThread.isAlive()) {
                    Restore restore = this;
                    synchronized (restore) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                break block8;
            }
            while (!this.stack.isEmpty()) {
                this.contents = (File)this.stack.pop();
                String sysId = this.contents.toURI().toASCIIString();
                InputSource is = new InputSource(sysId);
                is.setEncoding("UTF-8");
                System.out.println("restoring " + sysId);
                this.reader.parse(is);
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI.equals(NS)) {
            if (localName.equals("collection")) {
                String name = atts.getValue("name");
                String owner = atts.getValue("owner");
                String group = atts.getValue("group");
                String mode = atts.getValue("mode");
                if (name == null) {
                    throw new SAXException("collection requires a name attribute");
                }
                try {
                    if (this.dialog != null) {
                        this.dialog.displayMessage("creating collection " + name);
                    }
                    this.current = this.mkcol(name);
                    UserManagementService service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                    User u = new User(owner, null, group);
                    service.chown(u, group);
                    service.chmod(Integer.parseInt(mode, 8));
                }
                catch (XMLDBException e) {
                    throw new SAXException(e.getMessage(), (Exception)((Object)e));
                }
                if (this.dialog != null) {
                    this.dialog.setCollection(name);
                }
            } else if (localName.equals("subcollection")) {
                String name = atts.getValue("name");
                String fname = this.contents.getParentFile().getAbsolutePath() + File.separatorChar + name + File.separatorChar + "__contents__.xml";
                File f = new File(fname);
                if (f.exists() && f.canRead()) {
                    this.stack.push(f);
                } else {
                    System.err.println(f.getAbsolutePath() + " does not exist or is not readable.");
                }
            } else if (localName.equals("resource")) {
                String type = atts.getValue("type");
                if (type == null) {
                    type = "XMLResource";
                }
                String name = atts.getValue("name");
                String owner = atts.getValue("owner");
                String group = atts.getValue("group");
                String perms = atts.getValue("mode");
                if (name == null) {
                    throw new SAXException("collection requires a name attribute");
                }
                File f = new File(this.contents.getParentFile().getAbsolutePath() + File.separatorChar + name);
                try {
                    if (this.dialog != null && this.current instanceof Observable) {
                        ((Observable)((Object)this.current)).addObserver(this.dialog.getObserver());
                    }
                    if (this.dialog != null) {
                        this.dialog.setResource(name);
                    }
                    Resource res = this.current.createResource(name, type);
                    res.setContent((Object)f);
                    if (this.dialog == null) {
                        System.out.println("restoring " + name);
                    }
                    this.current.storeResource(res);
                    UserManagementService service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                    User u = new User(owner, null, group);
                    service.chown(res, u, group);
                    service.chmod(res, Integer.parseInt(perms, 8));
                    if (this.dialog != null) {
                        this.dialog.displayMessage("restored " + name);
                    }
                }
                catch (XMLDBException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
        }
    }

    private final CollectionImpl mkcol(String collPath) throws XMLDBException {
        if (collPath.startsWith("/db")) {
            collPath = collPath.substring("/db".length());
        }
        Collection current = DatabaseManager.getCollection((String)(this.uri + "/db"), (String)this.username, (String)this.pass);
        String p = "/db";
        StringTokenizer tok = new StringTokenizer(collPath, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            p = p + '/' + token;
            Collection c = DatabaseManager.getCollection((String)(this.uri + p), (String)this.username, (String)this.pass);
            if (c == null) {
                CollectionManagementService mgtService = (CollectionManagementService)current.getService("CollectionManagementService", "1.0");
                current = mgtService.createCollection(token);
                continue;
            }
            current = c;
        }
        return (CollectionImpl)current;
    }
}

