/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.util.Vector;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.exist.xmldb.DatabaseInstanceManager;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class ServerShutdown {
    private static final int HELP_OPT = 104;
    private static final int URI_OPT = 108;
    private static final int USER_OPT = 117;
    private static final int PASSWORD_OPT = 112;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("user", 2, 117, "specify username (has to be a member of group dba)."), new CLOptionDescriptor("password", 2, 112, "specify password for the user."), new CLOptionDescriptor("uri", 2, 108, "the XML:DB URI of the database instance to be shut down.")};

    public static void main(String[] args) {
        CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return;
        }
        String user = "admin";
        String passwd = "";
        String uri = "xmldb:exist://localhost:8080/exist/xmlrpc";
        Vector opt = optParser.getArguments();
        int size = opt.size();
        block9: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    System.out.println("Usage: java " + ServerShutdown.class.getName() + " [options]");
                    System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
                    return;
                }
                case 117: {
                    user = option.getArgument();
                    continue block9;
                }
                case 112: {
                    passwd = option.getArgument();
                    continue block9;
                }
                case 108: {
                    uri = option.getArgument();
                }
            }
        }
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            DatabaseManager.registerDatabase((Database)database);
            if (!uri.endsWith("/db")) {
                uri = uri + "/db";
            }
            Collection root = DatabaseManager.getCollection((String)uri, (String)user, (String)passwd);
            DatabaseInstanceManager manager = (DatabaseInstanceManager)root.getService("DatabaseInstanceManager", "1.0");
            System.out.println("Shutting down database instance at ");
            System.out.println('\t' + uri);
            manager.shutdown();
        }
        catch (XMLDBException e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

