/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.avalon.excalibur.cli.CLArgsParser;
import org.apache.avalon.excalibur.cli.CLOption;
import org.apache.avalon.excalibur.cli.CLOptionDescriptor;
import org.apache.avalon.excalibur.cli.CLUtil;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.exist.http.HttpServer;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.xmldb.ShutdownListener;
import org.exist.xmlrpc.AuthenticatedHandler;

public class Server {
    private static final int HELP_OPT = 104;
    private static final int DEBUG_OPT = 100;
    private static final int HTTP_PORT_OPT = 112;
    private static final int XMLRPC_PORT_OPT = 120;
    private static final int THREADS_OPT = 116;
    private static WebServer webServer;
    private static HttpServer http;
    private static final CLOptionDescriptor[] OPTIONS;

    public static void main(String[] args) throws Exception {
        Server.printNotice();
        CLArgsParser optParser = new CLArgsParser(args, OPTIONS);
        if (optParser.getErrorString() != null) {
            System.err.println("ERROR: " + optParser.getErrorString());
            return;
        }
        Vector opt = optParser.getArguments();
        int size = opt.size();
        int httpPort = 8088;
        int rpcPort = 8081;
        int threads = 5;
        block13: for (int i = 0; i < size; ++i) {
            CLOption option = (CLOption)opt.get(i);
            switch (option.getId()) {
                case 104: {
                    Server.printHelp();
                    return;
                }
                case 100: {
                    XmlRpc.setDebug((boolean)true);
                    continue block13;
                }
                case 112: {
                    try {
                        httpPort = Integer.parseInt(option.getArgument());
                        continue block13;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -p requires a numeric argument");
                        return;
                    }
                }
                case 120: {
                    try {
                        rpcPort = Integer.parseInt(option.getArgument());
                        continue block13;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -x requires a numeric argument");
                        return;
                    }
                }
                case 116: {
                    try {
                        threads = Integer.parseInt(option.getArgument());
                        continue block13;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("option -t requires a numeric argument");
                        return;
                    }
                }
            }
        }
        String pathSep = System.getProperty("file.separator", "/");
        String home = System.getProperty("exist.home");
        if (home == null) {
            home = System.getProperty("user.dir");
        }
        System.out.println("loading configuration from " + home + pathSep + "conf.xml");
        Configuration config = new Configuration("conf.xml", home);
        BrokerPool.configure(1, threads, config);
        BrokerPool.getInstance().registerShutdownListener(new ShutdownListenerImpl());
        System.out.println("starting HTTP listener at port " + httpPort);
        http = new HttpServer(config, httpPort, 1, threads);
        http.start();
        System.out.println("starting XMLRPC listener at port " + rpcPort);
        XmlRpc.setEncoding((String)"UTF-8");
        webServer = new WebServer(rpcPort);
        AuthenticatedHandler handler = new AuthenticatedHandler(config);
        webServer.addHandler("$default", (Object)handler);
        webServer.start();
        System.err.println("waiting for connections ...");
    }

    public static void shutdown() {
        System.err.println("Shutdown ...");
        webServer.shutdown();
        http.shutdown();
        try {
            http.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void printHelp() {
        System.out.println("Usage: java " + Server.class.getName() + " [options]");
        System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString());
    }

    public static void printNotice() {
        System.out.println("eXist version 1.0, Copyright (C) 2004 Wolfgang Meier");
        System.out.println("eXist comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to redistribute it\nunder certain conditions; for details read the license file.\n");
    }

    static /* synthetic */ HttpServer access$000() {
        return http;
    }

    static /* synthetic */ WebServer access$100() {
        return webServer;
    }

    static {
        OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print help on command line options and exit."), new CLOptionDescriptor("debug", 8, 100, "debug XMLRPC calls."), new CLOptionDescriptor("http-port", 2, 112, "set HTTP port."), new CLOptionDescriptor("xmlrpc-port", 2, 120, "set XMLRPC port."), new CLOptionDescriptor("threads", 2, 116, "set max. number of parallel threads allowed by the db.")};
    }

    static class ShutdownListenerImpl
    implements ShutdownListener {
        ShutdownListenerImpl() {
        }

        public void shutdown(String dbname, int remainingInstances) {
            if (remainingInstances == 0) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(this){
                    private final /* synthetic */ ShutdownListenerImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        System.out.println("killing threads ...");
                        Server.access$000().shutdown();
                        Server.access$000().interrupt();
                        Server.access$100().shutdown();
                        System.exit(0);
                    }
                }, 1000L);
            }
        }
    }
}

